/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.keystore;

import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.GenKeyAttribute;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.keystore.KeyEntry;
import cn.com.jit.ida.util.pki.pkcs.P7B;
import cn.com.jit.ida.util.pki.pkcs.PKCS10;
import cn.com.jit.ida.util.pki.pkcs.PKCS12;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Enumeration;

public class KeyStoreManager {
    public static final String TRUST_CERT_ID = "trustcertid";
    private String sType = "JKS";
    public static final String tmpCertStr = "MIIC5DCCAk2gAwIBAgIQa6gl/TivVSqXP8dPnZucXDANBgkqhkiG9w0BAQUFADBFMQswCQYDVQQGEwJDTjEMMAoGA1UEChMDSklUMRcwFQYDVQQLEw53d3cuaml0LmNvbS5jbjEPMA0GA1UEAxMGSklUIENBMB4XDTA1MDgxOTA4MTgxOFoXDTI1MDgxNDA4MTgxOFowRTELMAkGA1UEBhMCQ04xDDAKBgNVBAoTA0pJVDEXMBUGA1UECxMOd3d3LmppdC5jb20uY24xDzANBgNVBAMTBkpJVCBDQTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApoZCiaMfa8RFFVKZrUP+9QWHNk8c/clRiJIKl2WrUYYnUrL4KVYt7rA8NJdUAA63OM6w4Bd6uVuudGz949p3AkjiY0tOQNMsdsQfZoCdCykvsOazzboY2zTSAzwFZUt33+4nCCsxrxLbqvVSVwuN2x9+VKa327u8+hbYXOq+/JkCAwEAAaOB1DCB0TAfBgNVHSMEGDAWgBTPVrW0/9er9lukYtIum4uhHyzQBzAMBgNVHRMEBTADAQH/MHQGA1UdHwRtMGswQKA+oDykOjA4MQswCQYDVQQGEwJDTjEMMAoGA1UEChMDSklUMQwwCgYDVQQLEwNDUkwxDTALBgNVBAMTBENSTDEwJ6AloCOGIWh0dHA6Ly9qaXRjcmwuaml0LmNvbS5jbi9jcmwxLmNybDALBgNVHQ8EBAMCAf4wHQYDVR0OBBYEFM9WtbT/16v2W6Ri0i6bi6EfLNAHMA0GCSqGSIb3DQEBBQUAA4GBAH3FBD56Hebdyp1dh85vOmbxF/AVckS5aXUSkGlKzXJDOIGtr3mPb0r4m6NSJowDwrYpT+RcezFDacg9o+uLuU/q/9LaI4qmFVP1xISx+LG0liUDNoiySMa4TbV45RpkNOxUasLmhlx6oWXRMxTKuiv357yf0M6zGCuiseqNv6P3";

    private String genP10Request(String deviceType, int hardKeyId, String keyStorePath, String keyStorePassword, String subject, String keyType, int keySize) throws Exception {
        Session session = this.openSession(deviceType);
        Mechanism genKeyM = null;
        String signAlg = null;
        if (keyType.equalsIgnoreCase("RSA")) {
            genKeyM = new Mechanism("RSA");
            signAlg = "SHA1withRSAEncryption";
        } else if (keyType.equalsIgnoreCase("DSA")) {
            genKeyM = new Mechanism("DSA");
            signAlg = "SHA1withDSA";
        } else if (keyType.equalsIgnoreCase("SM2")) {
            genKeyM = new Mechanism("SM2");
            signAlg = "SM3withSM2Encryption";
        } else {
            genKeyM = new Mechanism("ECDSA");
            signAlg = "SHA1withECDSA";
        }
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        if (deviceType.equalsIgnoreCase("JSJY05B_LIB")) {
            GenKeyAttribute attr = new GenKeyAttribute();
            attr.setKeyNum(hardKeyId);
            attr.setIsExport(false);
            genKeyM.setParam(attr);
        }
        JKeyPair keyPair = session.generateKeyPair(genKeyM, keySize);
        JKey pubKey = keyPair.getPublicKey();
        JKey prvKey = keyPair.getPrivateKey();
        PKCS10 p10Gen = new PKCS10(session);
        byte[] p10Request = p10Gen.generateCertificationRequestData_B64(signAlg, subject, pubKey, null, prvKey);
        File file = new File(keyStorePath);
        if (!file.exists() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        KeyStore keyStore = KeyStore.getInstance(this.sType);
        keyStore.load(null, null);
        CertificateFactory certFac = CertificateFactory.getInstance("X.509", "BC");
        byte[] tmpCertData = Base64.decode(tmpCertStr.getBytes());
        Certificate tmpCert = certFac.generateCertificate(new ByteArrayInputStream(tmpCertData));
        if (deviceType.equalsIgnoreCase("JSOFT_LIB")) {
            PrivateKey key = Parser.convertPrivateKey(prvKey);
            String alias = this.getAlias(pubKey);
            keyStore.setKeyEntry(alias, key, keyStorePassword.toCharArray(), new Certificate[]{tmpCert});
        } else {
            keyStore.setCertificateEntry(subject.toLowerCase(), tmpCert);
        }
        FileOutputStream fous = new FileOutputStream(file);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
        return new String(p10Request);
    }

    public String genP10RequestWithSoftLib(String keyStorePath, String keyStorePassword, String subject, String keyType, int keySize) throws Exception {
        return this.genP10Request("JSOFT_LIB", 0, keyStorePath, keyStorePassword, subject, keyType, keySize);
    }

    public String genP10RequestWithHardLib(int hardKeyId, String keyStorePath, String keyStorePassword, String subject, String keyType, int keySize) throws Exception {
        return this.genP10Request("JSJY05B_LIB", hardKeyId, keyStorePath, keyStorePassword, subject, keyType, keySize);
    }

    public String genP10Request4UpdateWithHardLib(int hardKeyId, String keyStorePath, String keyStorePassword, String subject, String keyType, int keySize) throws Exception {
        return this.genP10Request4Update("JSJY05B_LIB", hardKeyId, keyStorePath, keyStorePassword, keyType, keySize, subject);
    }

    public String genP10Request4UpdateWithSoftLib(String keyStorePath, String keyStorePassword, String subject, String keyType, int keySize) throws Exception {
        return this.genP10Request4Update("JSOFT_LIB", 0, keyStorePath, keyStorePassword, keyType, keySize, subject);
    }

    private String genP10Request4Update(String deviceType, int hardKeyId, String keyStorePath, String keyStorePassword, String keyType, int keySize, String subject) throws Exception {
        Session session = this.openSession(deviceType);
        Mechanism genKeyM = null;
        String signAlg = null;
        if (keyType.equalsIgnoreCase("RSA")) {
            genKeyM = new Mechanism("RSA");
            signAlg = "SHA1withRSAEncryption";
        } else if (keyType.equalsIgnoreCase("DSA")) {
            genKeyM = new Mechanism("DSA");
            signAlg = "SHA1withDSA";
        } else if (keyType.equalsIgnoreCase("SM2")) {
            genKeyM = new Mechanism("SM2");
            signAlg = "SM3withSM2Encryption";
        } else {
            genKeyM = new Mechanism("ECDSA");
            signAlg = "SHA1withECDSA";
        }
        if (deviceType.equalsIgnoreCase("JSJY05B_LIB")) {
            GenKeyAttribute attr = new GenKeyAttribute();
            attr.setKeyNum(hardKeyId);
            attr.setIsExport(false);
            genKeyM.setParam(attr);
        }
        JKeyPair keyPair = session.generateKeyPair(genKeyM, keySize);
        JKey pubKey = keyPair.getPublicKey();
        JKey prvKey = keyPair.getPrivateKey();
        PKCS10 p10Gen = new PKCS10(session);
        byte[] p10Request = p10Gen.generateCertificationRequestData_B64(signAlg, subject, pubKey, null, prvKey);
        File file = new File(keyStorePath);
        if (!file.getParentFile().exists()) {
            throw new Exception("keyStore file [" + keyStorePath + "] doesn't exists. please select a correct keyStore file to execute update.");
        }
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        Enumeration<String> emuAlias = keyStore.aliases();
        while (emuAlias.hasMoreElements()) {
            String alias = emuAlias.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            keyStore.deleteEntry(alias);
        }
        if (deviceType.equalsIgnoreCase("JSOFT_LIB")) {
            PrivateKey key = Parser.convertPrivateKey(prvKey);
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            byte[] tmpCertData = Base64.decode(tmpCertStr.getBytes());
            Certificate tmpCert = certFac.generateCertificate(new ByteArrayInputStream(tmpCertData));
            X509Cert keyCert = null;
            keyCert = new X509Cert(tmpCertData);
            String alias = this.getAlias(keyCert);
            keyStore.setKeyEntry(alias, key, keyStorePassword.toCharArray(), new Certificate[]{tmpCert});
        }
        FileOutputStream fous = new FileOutputStream(file);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
        return new String(p10Request);
    }

    private void setKeyCertWithPfx(String keyStorePath, String keyStorePassword, JKey prvKey, X509Cert[] certs) throws Exception {
        X509Cert[] trustCerts = null;
        X509Cert keyCert = null;
        if (certs != null) {
            if (certs.length >= 2) {
                trustCerts = new X509Cert[certs.length - 1];
                Session session = this.openSession("JSOFT_LIB");
                int m = 0;
                int i = 0;
                while (i < certs.length) {
                    byte[] signedData;
                    byte[] sourceData;
                    JKey pubKey = certs[i].getPublicKey();
                    Mechanism signM = null;
                    signM = pubKey.getKeyType().equals("RSA_Public") ? new Mechanism("SHA1withRSAEncryption") : new Mechanism("SHA1withECDSA");
                    boolean f = session.verifySign(signM, pubKey, sourceData = "JIT".getBytes(), signedData = session.sign(signM, prvKey, sourceData));
                    if (f) {
                        keyCert = certs[i];
                    } else {
                        trustCerts[m] = certs[i];
                        ++m;
                    }
                    ++i;
                }
            } else {
                keyCert = certs[0];
            }
        }
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        Enumeration<String> emuAlias = keyStore.aliases();
        while (emuAlias.hasMoreElements()) {
            String alias = emuAlias.nextElement();
            keyStore.deleteEntry(alias);
        }
        String subject = keyCert.getSubject().toLowerCase();
        PrivateKey key = Parser.convertPrivateKey(prvKey);
        Certificate javaCert = this.convert2JavaCert(keyCert);
        String alias = this.getAlias(keyCert);
        keyStore.setKeyEntry(alias, key, keyStorePassword.toCharArray(), new Certificate[]{javaCert});
        FileOutputStream fous = new FileOutputStream(keyStorePath);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
        if (trustCerts != null) {
            this.setTrustCerts(keyStorePath, keyStorePassword, trustCerts);
        }
    }

    public void genKeyStoreWithPfx(String keyStorePath, String keyStorePassword, String fileName, char[] pfxPassword) throws Exception {
        Session session = this.openSession("JSOFT_LIB");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.load(fileName);
        pKCS12.decrypt(pfxPassword);
        JKey prvKey = pKCS12.getPrivateKey();
        X509Cert[] certs = pKCS12.getCerts();
        this.setKeyCertWithPfx(keyStorePath, keyStorePassword, prvKey, certs);
    }

    public void genKeyStoreWithPfx(String keyStorePath, String keyStorePassword, byte[] pfxData, char[] pfxPassword) throws Exception {
        Session session = this.openSession("JSOFT_LIB");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.load(pfxData);
        pKCS12.decrypt(pfxPassword);
        JKey prvKey = pKCS12.getPrivateKey();
        X509Cert[] certs = pKCS12.getCerts();
        this.setKeyCertWithPfx(keyStorePath, keyStorePassword, prvKey, certs);
    }

    public void genKeyStoreWithPfx(String keyStorePath, String keyStorePassword, InputStream ins, char[] pfxPassword) throws Exception {
        Session session = this.openSession("JSOFT_LIB");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.load(ins);
        pKCS12.decrypt(pfxPassword);
        JKey prvKey = pKCS12.getPrivateKey();
        X509Cert[] certs = pKCS12.getCerts();
        this.setKeyCertWithPfx(keyStorePath, keyStorePassword, prvKey, certs);
    }

    public void setKeyCertWithSoftLib(String keyStorePath, String keyStorePassword, X509Cert keyCert) throws Exception {
        byte[] signedData;
        String alias;
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        Key key = keyStore.getKey(alias = this.getAlias(keyCert), keyStorePassword.toCharArray());
        if (key == null) {
            throw new Exception("KeyStore doesn't contain key enry named [" + alias + "]");
        }
        JKey prvKey = new JKey("RSA_Private", key.getEncoded());
        JKey pubKey = keyCert.getPublicKey();
        Mechanism signM = null;
        signM = pubKey.getKeyType().equals("RSA_Public") ? new Mechanism("SHA1withRSAEncryption") : (pubKey.getKeyType().equals("SM2_Public") ? new Mechanism("SM3withSM2Encryption") : new Mechanism("SHA1withECDSA"));
        byte[] data = "JIT".getBytes();
        Session session = this.openSession("JSOFT_LIB");
        boolean f = session.verifySign(signM, pubKey, data, signedData = session.sign(signM, prvKey, data));
        if (!f) {
            throw new Exception("verify certificate public key failure.");
        }
        keyStore.deleteEntry(alias);
        Certificate javaCert = this.convert2JavaCert(keyCert);
        keyStore.setKeyEntry(alias, key, keyStorePassword.toCharArray(), new Certificate[]{javaCert});
        FileOutputStream fous = new FileOutputStream(keyStorePath);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
    }

    public void setKeyCertWithHardLib(int hardKeyId, String keyStorePath, String keyStorePassword, X509Cert keyCert) throws Exception {
        Session session = this.openSession("JSJY05B_LIB");
        GenKeyAttribute attr = new GenKeyAttribute();
        attr.setKeyNum(hardKeyId);
        attr.setIsExport(false);
        JKey certPubKey = keyCert.getPublicKey();
        Mechanism genKeyM = null;
        genKeyM = certPubKey.getKeyType().equals("RSA_Public") ? new Mechanism("RSA") : new Mechanism("ECDSA");
        genKeyM.setParam(attr);
        JKeyPair keyPair = session.generateKeyPair(genKeyM, 1024);
        JKey pubKey = keyPair.getPublicKey();
        if (!Arrays.equals(pubKey.getKey(), certPubKey.getKey())) {
            throw new Exception("verify certificate public key failure.");
        }
        session.destroyCertObject(null, session.getCfgTag().getNoExportRSAKey(hardKeyId).getBytes());
        session.createCertObject(keyCert.getSubject().getBytes(), keyCert.getEncoded(), session.getCfgTag().getNoExportRSAKey(hardKeyId).getBytes());
        this.setTrustCert(keyStorePath, keyStorePassword, keyCert);
    }

    public void setKeyCertWithHardLib(int hardKeyId, String keyStorePath, String keyStorePassword, X509Cert keyCert, String cfgName) throws Exception {
        JCrypto jcrypto = JCrypto.getInstance();
        Session session = jcrypto.openSession("JSJY05B_LIB", cfgName);
        GenKeyAttribute attr = new GenKeyAttribute();
        attr.setKeyNum(hardKeyId);
        attr.setIsExport(false);
        JKey certPubKey = keyCert.getPublicKey();
        Mechanism genKeyM = null;
        genKeyM = certPubKey.getKeyType().equals("RSA_Public") ? new Mechanism("RSA") : new Mechanism("ECDSA");
        genKeyM.setParam(attr);
        JKeyPair keyPair = session.generateKeyPair(genKeyM, 1024);
        JKey pubKey = keyPair.getPublicKey();
        if (!Arrays.equals(pubKey.getKey(), certPubKey.getKey())) {
            throw new Exception("verify certificate public key failure.");
        }
        session.destroyCertObject(null, session.getCfgTag().getNoExportRSAKey(hardKeyId).getBytes());
        session.createCertObject(keyCert.getSubject().getBytes(), keyCert.getEncoded(), session.getCfgTag().getNoExportRSAKey(hardKeyId).getBytes());
        this.setTrustCert(keyStorePath, keyStorePassword, keyCert);
    }

    public void setTrustCertWithP7B(String keyStorePath, String keyStorePassword, String fileName) throws Exception {
        P7B p7b = new P7B();
        X509Cert[] keyCerts = p7b.parseP7b(fileName);
        this.setTrustCerts(keyStorePath, keyStorePassword, keyCerts);
    }

    public void setTrustCertWithP7B(String keyStorePath, String keyStorePassword, byte[] p7bData) throws Exception {
        P7B p7b = new P7B();
        X509Cert[] keyCerts = p7b.parseP7b(p7bData);
        this.setTrustCerts(keyStorePath, keyStorePassword, keyCerts);
    }

    public void setTrustCert(String keyStorePath, String keyStorePassword, X509Cert cert) throws Exception {
        String alias;
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        if (keyStore.containsAlias(alias = this.getAlias(cert))) {
            keyStore.deleteEntry(alias);
        }
        Certificate javaCert = this.convert2JavaCert(cert);
        keyStore.setCertificateEntry(alias, javaCert);
        FileOutputStream fous = new FileOutputStream(keyStorePath);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
    }

    public void setTrustCerts(String keyStorePath, String keyStorePassword, X509Cert[] certs) throws Exception {
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        int i = 0;
        while (i < certs.length) {
            String alias = this.getAlias(certs[i]);
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
            }
            Certificate javaCert = this.convert2JavaCert(certs[i]);
            keyStore.setCertificateEntry(alias, javaCert);
            ++i;
        }
        FileOutputStream fous = new FileOutputStream(keyStorePath);
        keyStore.store(fous, keyStorePassword.toCharArray());
        fous.flush();
        fous.close();
    }

    public Enumeration alias(String keyStorePath, String keyStorePassword) throws Exception {
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        return keyStore.aliases();
    }

    public X509Cert getCertEntry(String keyStorePath, String keyStorePassword, String alias) throws Exception {
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        X509Cert cert = null;
        Certificate javaCert = keyStore.getCertificate(alias.toLowerCase());
        if (javaCert != null) {
            cert = new X509Cert(javaCert.getEncoded());
        }
        return cert;
    }

    public KeyEntry getKeyEntry(String keyStorePath, String keyStorePassword) throws Exception {
        KeyEntry keyEntry = new KeyEntry();
        KeyStore keyStore = this.openKeyStore(keyStorePath, keyStorePassword);
        Enumeration<String> emuAlias = keyStore.aliases();
        while (emuAlias.hasMoreElements()) {
            String alias = emuAlias.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            Key javaKey = keyStore.getKey(alias, keyStorePassword.toCharArray());
            ASN1Sequence seq = (ASN1Sequence)Parser.writeBytes2DERObj(javaKey.getEncoded());
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
            JKey key = null;
            key = alg.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) ? new JKey("RSA_Private", javaKey.getEncoded()) : new JKey("ECDSA_Private", javaKey.getEncoded());
            Certificate javaCert = keyStore.getCertificate(alias);
            X509Cert cert = new X509Cert(javaCert.getEncoded());
            keyEntry.setAilas(alias);
            keyEntry.setCert(cert);
            keyEntry.setKey(key);
        }
        return keyEntry;
    }

    private Certificate convert2JavaCert(X509Cert jitCert) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jitCert.getEncoded());
        CertificateFactory certFac = CertificateFactory.getInstance("X.509", "BC");
        Certificate javaCert = certFac.generateCertificate(inputStream);
        return javaCert;
    }

    private Session openSession(String deviceType) throws Exception {
        JCrypto jcrypto = JCrypto.getInstance();
        jcrypto.initialize(deviceType, null);
        Session session = jcrypto.openSession(deviceType);
        return session;
    }

    private KeyStore openKeyStore(String keyStorePath, String keyStorePassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(this.sType);
        File file = new File(keyStorePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
            keyStore.load(null, null);
        } else {
            FileInputStream fin = new FileInputStream(keyStorePath);
            keyStore.load(fin, keyStorePassword.toCharArray());
            fin.close();
        }
        return keyStore;
    }

    public String getAlias(X509Cert keyCert) throws Exception {
        return this.getAlias(keyCert.getPublicKey());
    }

    public String getAlias(JKey key) throws Exception {
        Session session = this.openSession("JSOFT_LIB");
        Mechanism mech = new Mechanism("MD5");
        byte[] dig = session.digest(mech, key.getKey());
        String alias = new String(Base64.encode(dig));
        return alias;
    }

    public void setStoreType(String type) throws Exception {
        this.sType = type;
    }
}

