/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.x509.JITTaxationNumeber;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class TaxationNumberExt
extends AbstractStandardExtension {
    private String taxationnumber = null;

    public TaxationNumberExt() {
        this.OID = X509Extensions.JIT_TaxationNumber.getId();
        this.critical = false;
    }

    public TaxationNumberExt(DERPrintableString obj) {
        this.taxationnumber = obj.getString();
    }

    public TaxationNumberExt(String value) {
        this.OID = X509Extensions.JIT_TaxationNumber.getId();
        this.critical = false;
        this.taxationnumber = value;
    }

    public void SetTaxationNumber(String value) {
        this.taxationnumber = value;
    }

    public String GetTaxationNumber() {
        return this.taxationnumber;
    }

    public byte[] encode() throws PKIException {
        if (this.taxationnumber == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new JITTaxationNumeber(this.taxationnumber).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

