/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectKeyIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class SubjectKeyIdentifierExt
extends AbstractStandardExtension {
    private JKey subjectPublicKey = null;
    private SubjectKeyIdentifier ski = null;

    public SubjectKeyIdentifierExt(JKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
        this.OID = X509Extensions.SubjectKeyIdentifier.getId();
        this.critical = false;
    }

    public SubjectKeyIdentifierExt(DEROctetString obj) {
        this.ski = new SubjectKeyIdentifier(obj.getOctets());
    }

    public byte[] getSubKeyIdentifier() {
        if (this.ski != null) {
            return this.ski.getKeyIdentifier();
        }
        return null;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public JKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public byte[] encode() throws PKIException {
        SubjectPublicKeyInfo spki = null;
        spki = Parser.key2SPKI(this.subjectPublicKey);
        SubjectKeyIdentifier subjectKeyID = new SubjectKeyIdentifier(spki);
        DEROctetString octetValue = new DEROctetString(subjectKeyID.getDERObject());
        return octetValue.getOctets();
    }
}

