/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.JITStationCode;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class StationCodeExt
extends AbstractStandardExtension {
    private String stationcode = null;

    public StationCodeExt() {
        this.OID = X509Extensions.JIT_StationCode.getId();
        this.critical = false;
    }

    public StationCodeExt(String value) {
        this.OID = X509Extensions.JIT_StationCode.getId();
        this.critical = false;
        this.stationcode = value;
    }

    public void SetStationCode(String value) {
        this.stationcode = value;
    }

    public byte[] encode() throws PKIException {
        if (this.stationcode == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new JITStationCode(this.stationcode).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

