/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.extension.AbstractSelfDefExtension;
import java.math.BigInteger;

public class SelfDefExtension
extends AbstractSelfDefExtension {
    private String encoding = null;
    private String extensionValue = null;
    private String encType = null;
    private byte[] extensionBytes = null;

    public SelfDefExtension() {
        this.critical = false;
    }

    public SelfDefExtension(DERObject obj, String type) {
        if (type == null) {
            this.extensionValue = null;
            return;
        }
        byte[] value = null;
        if (type.equals("Boolean")) {
            this.extensionValue = ((DERBoolean)obj).isTrue() ? "true" : "false";
        } else if (type.equals("IA5 String")) {
            this.extensionValue = ((DERIA5String)obj).getString();
            this.extensionBytes = ((DERIA5String)obj).getOctets();
        } else if (type.equals("Integer")) {
            this.extensionValue = String.valueOf(((DERInteger)obj).getValue().longValue());
            this.extensionBytes = ((DERInteger)obj).getValue().toByteArray();
        } else if (type.equals("Printable String")) {
            this.extensionValue = ((DERPrintableString)obj).getString();
            this.extensionBytes = ((DERPrintableString)obj).getOctets();
        } else if (type.equals("User Defined")) {
            this.extensionValue = new String(((DEROctetString)obj).getOctets());
            this.extensionBytes = ((DEROctetString)obj).getOctets();
        } else if (type.equals("UTF-8 String")) {
            this.extensionValue = ((DERUTF8String)obj).getString();
            this.extensionBytes = ((DERUTF8String)obj).getString().getBytes();
        } else {
            this.extensionValue = null;
            return;
        }
        this.encType = type;
    }

    public void setEncoding(String encoding) throws PKIException {
        if (encoding == null || encoding.equals("")) {
            throw new PKIException("8189", "\u65b9\u6cd5\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setOID(String oid) throws PKIException {
        if (oid == null || oid.equals("")) {
            throw new PKIException("8189", "\u65b9\u6cd5\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        this.OID = oid;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public void setExtensionValue(String value) throws PKIException {
        if (value == null || value.equals("")) {
            throw new PKIException("8189", "\u65b9\u6cd5\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        this.extensionValue = value;
    }

    public String getExtensionValue() {
        return this.extensionValue;
    }

    public byte[] encode() throws PKIException {
        if (this.encoding == null) {
            throw new PKIException("8180", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e3a\u7a7a");
        }
        byte[] value = null;
        if (this.encoding.equals("Boolean")) {
            DERBoolean derBoolean = new DERBoolean(Boolean.valueOf(this.extensionValue));
            DEROctetString octetValue = new DEROctetString(derBoolean.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("IA5 String")) {
            DERIA5String ia5String = new DERIA5String(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(ia5String.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("Integer")) {
            DERInteger derInteger = new DERInteger(new BigInteger(this.extensionValue));
            DEROctetString octetValue = new DEROctetString(derInteger.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("Printable String")) {
            DERPrintableString derPrintString = new DERPrintableString(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(derPrintString.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("User Defined")) {
            DEROctetString octetValue = new DEROctetString(this.extensionValue.getBytes());
            value = octetValue.getOctets();
            return value;
        }
        if (this.encoding.equals("UTF-8 String")) {
            DERUTF8String derUTF8String = new DERUTF8String(this.extensionValue);
            DEROctetString octetValue = new DEROctetString(derUTF8String.getDERObject());
            value = octetValue.getOctets();
            return value;
        }
        throw new PKIException("8181", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e0d\u652f\u6301");
    }

    public String getEncType() {
        return this.encType;
    }

    public byte[] getExtensionBytes() {
        return this.extensionBytes;
    }

    public static void main(String[] args) throws PKIException {
        SelfDefExtension aaa = new SelfDefExtension();
        try {
            String data = "\u58eb\u5927\u592b".toString();
            aaa.setExtensionValue(data);
            aaa.setEncoding("User Defined");
            byte[] value = aaa.encode();
            System.out.println("encode data is:");
            System.out.println(value);
            SelfDefExtension bbb = new SelfDefExtension(new DEROctetString(value), "User Defined".toString());
            String newvalue = bbb.getExtensionValue();
            byte[] bytValue = bbb.getExtensionBytes();
            System.out.println("decode data is:");
            System.out.println(newvalue);
            System.out.println(bytValue);
        }
        catch (Exception e) {
            throw new PKIException("8516", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }
}

