/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.PolicyConstraints;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class PolicyConstraintsExt
extends AbstractStandardExtension {
    private int requireExplicitPolicy = -1;
    private int inhibitPolicyMapping = -1;

    public PolicyConstraintsExt(int requireExplicitPolicy, int inhibitPolicyMapping) {
        this.OID = X509Extensions.PolicyConstraints.getId();
        this.critical = false;
        this.requireExplicitPolicy = requireExplicitPolicy;
        this.inhibitPolicyMapping = inhibitPolicyMapping;
    }

    public PolicyConstraintsExt(ASN1Sequence seq) {
        int i = 0;
        while (i < seq.size()) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (obj.getTagNo()) {
                case 0: {
                    this.requireExplicitPolicy = DERInteger.getInstance(obj, false).getValue().intValue();
                    break;
                }
                case 1: {
                    this.inhibitPolicyMapping = DERInteger.getInstance(obj, false).getValue().intValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal tag");
                }
            }
            ++i;
        }
    }

    public int getRequireExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public int getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        DERInteger require = null;
        if (this.requireExplicitPolicy >= 0) {
            require = new DERInteger(this.requireExplicitPolicy);
        }
        DERInteger inhibit = null;
        if (this.inhibitPolicyMapping >= 0) {
            inhibit = new DERInteger(this.inhibitPolicyMapping);
        }
        PolicyConstraints policyConstraints = new PolicyConstraints(require, inhibit);
        DEROctetString octetValue = new DEROctetString(policyConstraints.getDERObject());
        return octetValue.getOctets();
    }
}

