/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.KeyUsage;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;
import java.util.Vector;

public class KeyUsageExt
extends AbstractStandardExtension {
    public static final String DIGITAL_SIGNATURE = "digitalSignature";
    public static final String NON_REPUDIATION = "nonRepudiation";
    public static final String KEY_ENCIPHERMENT = "keyEncipherment";
    public static final String DATA_ENCIPHERMENT = "dataEncipherment";
    public static final String KEY_AGREEMENT = "keyAgreement";
    public static final String KEY_CERT_SIGN = "keyCertSign";
    public static final String CRL_SIGN = "cRLSign";
    public static final String ENCIPHER_ONLY = "encipherOnly";
    public static final String DECIPHER_ONLY = "decipherOnly";
    private int iKeyUsage = 0;
    private Vector keyUsageVector = null;
    private KeyUsage keyUsage = null;

    public KeyUsageExt() {
        this.iKeyUsage = 0;
        this.keyUsageVector = new Vector();
        this.critical = false;
        this.OID = X509Extensions.KeyUsage.getId();
    }

    public KeyUsageExt(DERBitString derBitString) {
        this.keyUsage = new KeyUsage(derBitString);
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void addKeyUsage(String keyUsageItem) {
        this.keyUsageVector.add(keyUsageItem);
    }

    public void setKeyUsage(Vector keyUsageVector) {
        int i = 0;
        while (i < keyUsageVector.size()) {
            this.keyUsageVector.add((String)keyUsageVector.get(i));
            ++i;
        }
    }

    public Vector getKeyUsage() {
        return this.keyUsageVector;
    }

    public byte[] encode() {
        if (this.keyUsageVector.contains(DIGITAL_SIGNATURE)) {
            this.iKeyUsage |= 0x80;
        }
        if (this.keyUsageVector.contains(NON_REPUDIATION)) {
            this.iKeyUsage |= 0x40;
        }
        if (this.keyUsageVector.contains(KEY_ENCIPHERMENT)) {
            this.iKeyUsage |= 0x20;
        }
        if (this.keyUsageVector.contains(DATA_ENCIPHERMENT)) {
            this.iKeyUsage |= 0x10;
        }
        if (this.keyUsageVector.contains(KEY_AGREEMENT)) {
            this.iKeyUsage |= 8;
        }
        if (this.keyUsageVector.contains(KEY_CERT_SIGN)) {
            this.iKeyUsage |= 4;
        }
        if (this.keyUsageVector.contains(CRL_SIGN)) {
            this.iKeyUsage |= 2;
        }
        if (this.keyUsageVector.contains(ENCIPHER_ONLY)) {
            this.iKeyUsage |= 1;
        }
        if (this.keyUsageVector.contains(DECIPHER_ONLY)) {
            this.iKeyUsage |= 0x8000;
        }
        KeyUsage keyUsage = new KeyUsage(this.iKeyUsage);
        DEROctetString octetValue = new DEROctetString(keyUsage.getDERObject());
        return octetValue.getOctets();
    }

    public boolean[] getKeyUsageForBoolean() {
        if (this.keyUsage == null) {
            return null;
        }
        return this.keyUsage.getKeyUsage();
    }

    public boolean getKeyUsageByName(String name) {
        String tempName = name.trim();
        boolean result = false;
        boolean[] array = this.getKeyUsageForBoolean();
        if (array == null) {
            result = false;
        } else if (DIGITAL_SIGNATURE.equalsIgnoreCase(tempName)) {
            result = array[0];
        } else if (NON_REPUDIATION.equalsIgnoreCase(tempName)) {
            result = array[1];
        } else if (KEY_ENCIPHERMENT.equalsIgnoreCase(tempName)) {
            result = array[2];
        } else if (DATA_ENCIPHERMENT.equalsIgnoreCase(tempName)) {
            result = array[3];
        } else if (KEY_AGREEMENT.equalsIgnoreCase(tempName)) {
            result = array[4];
        } else if (KEY_CERT_SIGN.equalsIgnoreCase(tempName)) {
            result = array[5];
        } else if (CRL_SIGN.equalsIgnoreCase(tempName)) {
            result = array[6];
        } else if (ENCIPHER_ONLY.equalsIgnoreCase(tempName)) {
            result = array[7];
        } else if (DECIPHER_ONLY.equalsIgnoreCase(tempName)) {
            result = array[8];
        }
        return result;
    }
}

