/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.x509.JITIdentifyCode;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class IdentifyCodeExt
extends AbstractStandardExtension {
    private String residenterCardNumber = null;
    private String militaryOfficerCardNumber = null;
    private String passportNumber = null;
    private JITIdentifyCode jitIdentifyCode = null;

    public IdentifyCodeExt() {
        this.OID = X509Extensions.JIT_IdentifyCode.getId();
        this.critical = false;
    }

    public IdentifyCodeExt(ASN1Set obj) {
        this.jitIdentifyCode = new JITIdentifyCode(obj);
    }

    public IdentifyCodeExt(String residenterCardNumber, String militaryOfficerCardNumber, String passportNumber) {
        this.OID = X509Extensions.JIT_IdentifyCode.getId();
        this.critical = false;
        this.residenterCardNumber = residenterCardNumber;
        this.militaryOfficerCardNumber = militaryOfficerCardNumber;
        this.passportNumber = passportNumber;
    }

    public String getResidenterCardNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        if (this.jitIdentifyCode.getResidenterCardNumber() == null) {
            return null;
        }
        return this.jitIdentifyCode.getResidenterCardNumber().getString();
    }

    public String getMilitaryOfficerCardNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        if (this.jitIdentifyCode.getMilitaryOfficerCardNumber() == null) {
            return null;
        }
        return this.jitIdentifyCode.getMilitaryOfficerCardNumber().getString();
    }

    public String getPassportNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        if (this.jitIdentifyCode.getPassportNumber() == null) {
            return null;
        }
        return this.jitIdentifyCode.getPassportNumber().getString();
    }

    public void setResidenterCardNumber(String value) {
        this.residenterCardNumber = value;
    }

    public void setMilitaryOfficerCardNumber(String value) {
        this.militaryOfficerCardNumber = value;
    }

    public void setPassportNumber(String value) {
        this.passportNumber = value;
    }

    public byte[] encode() throws PKIException {
        if (this.residenterCardNumber == null && this.militaryOfficerCardNumber == null && this.passportNumber == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new JITIdentifyCode(new DERPrintableString(this.residenterCardNumber), new DERUTF8String(this.militaryOfficerCardNumber), new DERPrintableString(this.passportNumber)).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

