/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBMPString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERT61String;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.DERUniversalString;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.OtherName;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.encoders.Hex;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class GeneralNamesExt
extends AbstractStandardExtension {
    public static final int TYPE_NONE = -1;
    public static final int RFC822NAME = 1;
    public static final int DNSNAME = 2;
    public static final int X400ADDRESS = 3;
    public static final int DIRECTORYNAME = 4;
    public static final int EDIPARTYNAME = 5;
    public static final int UNIFORMRESOURCEIDENTIFIER = 6;
    public static final int IPADDRESS = 7;
    public static final int REGISTEREDID = 8;
    public static final int OTHERNAME_UPN = 100;
    public static final String OTHER_NAME_UPN_OID = "1.3.6.1.4.1.311.20.2.3";
    public static final int OTHERNAME_GUID = 101;
    public static final String OTHER_NAME_GUID_OID = "1.23.456.789";
    public static final int EDIPARTYNAME_TELETEXSTRING = 200;
    public static final int EDIPARTYNAME_PRINTABLESTRING = 201;
    public static final int EDIPARTYNAME_UNIVERSALSTRING = 202;
    public static final int EDIPARTYNAME_UTF8STRING = 203;
    public static final int EDIPARTYNAME_BMPSTRING = 204;
    private ASN1EncodableVector GeneralNames = null;
    private ASN1Sequence seqGeneralNames = null;

    public GeneralNamesExt() {
        this.critical = false;
    }

    public GeneralNamesExt(ASN1Sequence asn1Sequence) {
        this.seqGeneralNames = asn1Sequence;
    }

    public int getGeneralNameCount() {
        return this.seqGeneralNames.size();
    }

    public int getGeneralNameType(int index) {
        int type = ((ASN1TaggedObject)this.seqGeneralNames.getObjectAt(index)).getTagNo();
        if (type == 0) {
            type = OTHER_NAME_UPN_OID.equals(OtherName.getInstance(((ASN1TaggedObject)this.seqGeneralNames.getObjectAt(index)).getObject()).getTypeID().getId()) ? 100 : 101;
        }
        return type;
    }

    public String getGeneralName(int index) {
        return this.GeneralNameToString((ASN1TaggedObject)this.seqGeneralNames.getObjectAt(index));
    }

    public String getEDIPartyNameToNameAsSigner(int index) {
        String ret_String = null;
        try {
            ASN1Sequence tempseq = (ASN1Sequence)((ASN1TaggedObject)this.seqGeneralNames.getObjectAt(index)).getObject();
            int i = 0;
            while (i < tempseq.size()) {
                ASN1TaggedObject tempTagObj = (ASN1TaggedObject)tempseq.getObjectAt(i);
                if (tempTagObj.getTagNo() == 0) {
                    DERObject obj = tempTagObj.getObject();
                    if (obj instanceof DERT61String) {
                        ret_String = DERT61String.getInstance(obj).getString();
                    } else if (obj instanceof DERPrintableString) {
                        ret_String = DERPrintableString.getInstance(obj).getString();
                    } else if (obj instanceof DERUTF8String) {
                        ret_String = DERUTF8String.getInstance(obj).getString();
                    } else if (obj instanceof DERBMPString) {
                        ret_String = DERBMPString.getInstance(obj).getString();
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret_String;
    }

    public String getEDIPartyNameToPartyName(int index) {
        String ret_String = null;
        try {
            ASN1Sequence tempseq = (ASN1Sequence)((ASN1TaggedObject)this.seqGeneralNames.getObjectAt(index)).getObject();
            int i = 0;
            while (i < tempseq.size()) {
                ASN1TaggedObject tempTagObj = (ASN1TaggedObject)tempseq.getObjectAt(i);
                if (tempTagObj.getTagNo() == 1) {
                    DERObject obj = tempTagObj.getObject();
                    if (obj instanceof DERT61String) {
                        ret_String = DERT61String.getInstance(obj).getString();
                    } else if (obj instanceof DERPrintableString) {
                        ret_String = DERPrintableString.getInstance(obj).getString();
                    } else if (obj instanceof DERUTF8String) {
                        ret_String = DERUTF8String.getInstance(obj).getString();
                    } else if (obj instanceof DERBMPString) {
                        ret_String = DERBMPString.getInstance(obj).getString();
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret_String;
    }

    private String GeneralNameToString(ASN1TaggedObject tempGeneralName) {
        String retString = null;
        switch (tempGeneralName.getTagNo()) {
            case 0: {
                if (OTHER_NAME_UPN_OID.equals(OtherName.getInstance(tempGeneralName.getObject()).getTypeID().getId())) {
                    retString = ((DERUTF8String)OtherName.getInstance(tempGeneralName.getObject()).getValue()).getString();
                    break;
                }
                retString = new String(Hex.encode(((DEROctetString)OtherName.getInstance(tempGeneralName.getObject()).getValue().getDERObject()).getOctets()));
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                retString = DERIA5String.getInstance(tempGeneralName.getObject()).getString();
                break;
            }
            case 7: {
                StringBuffer tempSB = new StringBuffer();
                byte[] tempByte = ((DEROctetString)tempGeneralName.getObject()).getOctets();
                int tempInt = 0;
                int i = 0;
                while (i < 4) {
                    tempInt = tempByte[i];
                    if (tempInt < 0) {
                        tempInt += 256;
                    }
                    tempSB.append(String.valueOf(tempInt));
                    if (i < 3) {
                        tempSB.append(".");
                    }
                    ++i;
                }
                if (tempByte.length > 4) {
                    tempSB.append("/");
                    i = 4;
                    while (i < tempByte.length) {
                        tempInt = tempByte[i];
                        if (tempInt < 0) {
                            tempInt += 256;
                        }
                        tempSB.append(String.valueOf(tempInt));
                        if (i < tempByte.length - 1) {
                            tempSB.append(".");
                        }
                        ++i;
                    }
                }
                retString = tempSB.toString();
                break;
            }
            case 8: {
                retString = DERObjectIdentifier.getInstance(tempGeneralName.getObject()).getId();
                break;
            }
            case 4: {
                retString = X509Name.getInstance(tempGeneralName.getObject()).toString();
            }
        }
        return retString;
    }

    public void addRFC822Name(String value) throws PKIException {
        this.addGeneralName(1, value);
    }

    public void addDNSName(String value) throws PKIException {
        this.addGeneralName(2, value);
    }

    public void addDirectoryName(String value) throws PKIException {
        this.addGeneralName(4, value);
    }

    public void addUniformResourceIdentifier(String value) throws PKIException {
        this.addGeneralName(6, value);
    }

    public void addIPAddress(String value) throws PKIException {
        this.addGeneralName(7, value);
    }

    public void addRegisteredID(String value) throws PKIException {
        this.addGeneralName(8, value);
    }

    public void addOtherName_UPN(String value) throws PKIException {
        this.addGeneralName(100, value);
    }

    public void addOtherName_GUID(String value) throws PKIException {
        this.addGeneralName(101, value);
    }

    public void addEDIPartyName(int partyNameType, String partyName, int nameAssignerType, String nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.GeneralNames.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, byte[] partyName, int nameAssignerType, byte[] nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.GeneralNames.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, String partyName, int nameAssignerType, byte[] nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.GeneralNames.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, byte[] partyName, int nameAssignerType, String nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.GeneralNames.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addGeneralName(int dataType, String value) throws PKIException {
        if (this.GeneralNames == null) {
            this.GeneralNames = new ASN1EncodableVector();
        }
        if (dataType == 100 || dataType == 101) {
            this.GeneralNames.add(new GeneralName(this.TypeConversion(dataType, value), 0));
        } else {
            this.GeneralNames.add(new GeneralName(this.TypeConversion(dataType, value), dataType));
        }
    }

    public byte[] encode() throws PKIException {
        if (this.GeneralNames == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new GeneralNames(new DERSequence(this.GeneralNames)).getDERObject()).getOctets();
    }

    public DERObject getDERObject() throws PKIException {
        if (this.GeneralNames == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new GeneralNames(new DERSequence(this.GeneralNames)).getDERObject();
    }

    public DERObject getASN1Object() {
        if (this.GeneralNames == null) {
            return new DERSequence();
        }
        return new DERSequence(this.GeneralNames);
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    private DEREncodable TypeToDEREncodable(int valueType, String value) throws PKIException {
        DERObject derencodable = null;
        switch (valueType) {
            case 200: {
                derencodable = new DERT61String(value);
                break;
            }
            case 201: {
                derencodable = new DERPrintableString(value);
                break;
            }
            case 203: {
                derencodable = new DERUTF8String(value);
                break;
            }
            case 204: {
                derencodable = new DERBMPString(value);
                break;
            }
            case 202: {
                throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
        }
        return derencodable;
    }

    private DEREncodable TypeToDEREncodable(int valueType, byte[] value) throws PKIException {
        DERObject derencodable = null;
        switch (valueType) {
            case 200: {
                derencodable = new DERT61String(value);
                break;
            }
            case 201: {
                derencodable = new DERPrintableString(value);
                break;
            }
            case 203: {
                derencodable = new DERUTF8String(new String(value));
                break;
            }
            case 204: {
                derencodable = new DERBMPString(value);
                break;
            }
            case 202: {
                derencodable = new DERUniversalString(value);
            }
        }
        return derencodable;
    }

    private DERObject TypeConversion(int valueType, String value) throws PKIException {
        DERObject derencodable = null;
        try {
            derencodable = null;
            switch (valueType) {
                case 1: 
                case 2: 
                case 6: {
                    derencodable = new DERIA5String(value).getDERObject();
                    break;
                }
                case 7: {
                    derencodable = new DEROctetString(this.IP4Address(value)).getDERObject();
                    break;
                }
                case 3: {
                    throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
                }
                case 4: {
                    derencodable = new X509Name(value).getDERObject();
                    break;
                }
                case 8: {
                    derencodable = new DERObjectIdentifier(value).getDERObject();
                    break;
                }
                case 100: {
                    derencodable = new OtherName(new DERObjectIdentifier(OTHER_NAME_UPN_OID), new DERTaggedObject(true, 0, new DERUTF8String(value))).getDERObject();
                    break;
                }
                case 101: {
                    derencodable = new OtherName(new DERObjectIdentifier(OTHER_NAME_GUID_OID), new DERTaggedObject(true, 0, new DEROctetString(Hex.decode(value)))).getDERObject();
                }
            }
            if (derencodable == null) {
                throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
        }
        catch (Exception ex) {
            throw new PKIException("8185", "GeneralNames\u7f16\u7801\u65f6\u51fa\u9519", ex);
        }
        return derencodable;
    }

    private byte[] IP4Address(String value) {
        String[] allip = value.split("/");
        byte[] ip4_byte = null;
        if (allip.length == 2) {
            ip4_byte = new byte[8];
            this.GenIP4Address(ip4_byte, allip[0]);
            byte[] ip4_mask = new byte[4];
            this.GenIP4Address(ip4_mask, allip[1]);
            System.arraycopy(ip4_mask, 0, ip4_byte, 4, 4);
        } else if (allip.length == 1) {
            ip4_byte = new byte[4];
            this.GenIP4Address(ip4_byte, value);
        }
        return ip4_byte;
    }

    private void GenIP4Address(byte[] ip4_byte, String value) {
        int pos = 0;
        int i = 0;
        while (i < 4) {
            pos = value.indexOf(".");
            ip4_byte[i] = pos == -1 ? Integer.valueOf(value).byteValue() : Integer.valueOf(value.substring(0, pos)).byteValue();
            value = value.substring(pos + 1, value.length());
            ++i;
        }
    }
}

