/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.DistributionPoint;
import cn.com.jit.ida.util.pki.asn1.x509.DistributionPointName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.ReasonFlags;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import java.util.Vector;

public class DistributionPointExt {
    public static final String REASON_UNUSED = "unUsed";
    public static final String REASON_KEY_COMPROMISE = "keyCompromise";
    public static final String REASON_CA_COMPROMISE = "caCompromise";
    public static final String REASON_AFFILIATION_CHANGED = "affiliationChanged";
    public static final String REASON_SUPERSEDED = "superSeded";
    public static final String REASON_CESSATION_OF_OPERATION = "cessationOfOperation";
    public static final String REASON_CERTIFICATE_HOLD = "certificateHold";
    public static final String REASON_PRIVILEGE_WITHDRAWN = "privilegeWithDrawn";
    public static final String REASON_AA_COMPROMISE = "aaCompromise";
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;
    private String dpName = null;
    private int nameType = -1;
    private Vector reasonVector = new Vector();
    private String cRLIssuer = null;
    private int reason = 0;

    public void setDistributionPointName(int nameType, String distributionPointName) {
        this.nameType = nameType;
        this.dpName = distributionPointName;
    }

    public String getDistributionPointName() {
        return this.dpName;
    }

    public void addReasonFlags(String reasonFlags) {
        this.reasonVector.add(reasonFlags);
    }

    public void setReasonFlags(Vector reasonFlags) {
        int i = 0;
        while (i < reasonFlags.size()) {
            this.reasonVector.add((String)reasonFlags.get(i));
            ++i;
        }
    }

    public Vector getReasonFlags() {
        return this.reasonVector;
    }

    public void setCRLIssuer(String cRLIssuer) {
        this.cRLIssuer = cRLIssuer;
    }

    public String getCRLIssuer() {
        return this.cRLIssuer;
    }

    private void generateReason() {
        if (this.reasonVector.contains(REASON_UNUSED)) {
            this.reason |= 0x80;
        }
        if (this.reasonVector.contains(REASON_KEY_COMPROMISE)) {
            this.reason |= 0x40;
        }
        if (this.reasonVector.contains(REASON_CA_COMPROMISE)) {
            this.reason |= 0x20;
        }
        if (this.reasonVector.contains(REASON_AFFILIATION_CHANGED)) {
            this.reason |= 0x10;
        }
        if (this.reasonVector.contains(REASON_SUPERSEDED)) {
            this.reason |= 8;
        }
        if (this.reasonVector.contains(REASON_CESSATION_OF_OPERATION)) {
            this.reason |= 4;
        }
        if (this.reasonVector.contains(REASON_CERTIFICATE_HOLD)) {
            this.reason |= 2;
        }
        if (this.reasonVector.contains(REASON_PRIVILEGE_WITHDRAWN)) {
            this.reason |= 1;
        }
        if (this.reasonVector.contains(REASON_AA_COMPROMISE)) {
            this.reason |= 0x8000;
        }
    }

    DistributionPoint encode() {
        DistributionPointName distPoiontName = null;
        if (this.dpName != null && !this.dpName.equals("")) {
            GeneralNames genNames = null;
            if (this.nameType == 6) {
                byte[] bDPName = this.dpName.getBytes();
                DERIA5String ia5DPName = new DERIA5String(bDPName);
                GeneralName generalName = new GeneralName(ia5DPName, 6);
                genNames = new GeneralNames(new DERSequence(generalName));
            } else if (this.nameType == 4) {
                X509Name x509DPName = new X509Name(this.dpName);
                GeneralName genName = new GeneralName(x509DPName);
                genNames = new GeneralNames(new DERSequence(genName));
            }
            distPoiontName = new DistributionPointName(0, genNames);
        }
        ReasonFlags reasonFlags = null;
        this.generateReason();
        if (this.reason != 0) {
            reasonFlags = new ReasonFlags(this.reason);
        }
        GeneralNames crlIssuerName = null;
        if (this.cRLIssuer != null && !this.cRLIssuer.equals("")) {
            X509Name issuerName = new X509Name(this.cRLIssuer);
            GeneralName genName = new GeneralName(issuerName);
            crlIssuerName = new GeneralNames(new DERSequence(genName));
        }
        DistributionPoint dp = new DistributionPoint(distPoiontName, reasonFlags, crlIssuerName);
        return dp;
    }
}

