/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.JITCasteCode;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;

public class CasteCodeExt
extends AbstractStandardExtension {
    private String castecode = null;

    public CasteCodeExt() {
        this.OID = X509Extensions.JIT_CasteCode.getId();
        this.critical = false;
    }

    public CasteCodeExt(String value) {
        this.OID = X509Extensions.JIT_CasteCode.getId();
        this.critical = false;
        this.castecode = value;
    }

    public void SetCasteCode(String value) {
        this.castecode = value;
    }

    public byte[] encode() throws PKIException {
        if (this.castecode == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new JITCasteCode(this.castecode).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

