/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AuthorityKeyIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;
import java.math.BigInteger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AuthorityKeyIdentifierExt
extends AbstractStandardExtension {
    private JKey pubKey = null;
    private String certIssuer = null;
    private AuthorityKeyIdentifier spki = null;
    private BigInteger certSerialNumber = null;

    public AuthorityKeyIdentifierExt(JKey pubKey) {
        this.pubKey = pubKey;
        this.critical = false;
        this.OID = X509Extensions.AuthorityKeyIdentifier.getId();
    }

    public AuthorityKeyIdentifierExt(Node nl) throws PKIException {
        this.critical = false;
        this.OID = X509Extensions.AuthorityKeyIdentifier.getId();
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AuthorityKeyIdentifierExt.AuthorityKeyIdentifierExt(),AuthorityKeyIdentifierExtension\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            Text txt;
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("keyIdentifier")) {
                String strim;
                txt = (Text)cnode.getFirstChild();
                String str = txt.getData();
                this.OID = strim = str.trim();
            }
            if (sname.equals("AuthorityCertIssuer")) {
                this.certIssuer = this.generalAuthorityCertIssuer(cnode);
            }
            if (sname.equals("AuthorityCertSerialNumber")) {
                txt = (Text)nl.getFirstChild();
                String sint = txt.getData();
                this.certSerialNumber = new BigInteger(sint.trim(), 16);
            }
            ++i;
        }
    }

    public AuthorityKeyIdentifierExt(ASN1Sequence asn1Sequence) {
        if (asn1Sequence.size() == 0) {
            return;
        }
        this.spki = new AuthorityKeyIdentifier(asn1Sequence);
        GeneralNames issuer = this.spki.getGeneralNames();
        if (issuer != null) {
            this.certIssuer = issuer.toString();
        }
        if (this.spki.getCertserno() != null) {
            this.certSerialNumber = this.spki.getCertserno().getValue();
        }
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.spki.getKeyIdentifier();
    }

    public String generalAuthorityCertIssuer(Node nl) throws PKIException {
        String value = null;
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AuthorityKeyIdentifierExt.generalAuthorityCertIssuer(),AuthorityCertIssuer\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        NamedNodeMap attributes = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String nodename = cnode.getNodeName();
            if (nodename.equals("GeneralName")) {
                attributes = cnode.getAttributes();
                Text txt = (Text)cnode.getFirstChild();
                String sname = txt.getData();
                value = value == null ? sname.trim() : String.valueOf(value) + ";" + sname.trim();
            }
            ++i;
        }
        return value;
    }

    public JKey getAuthorityPublicKey() {
        return this.pubKey;
    }

    public void setAuthorityCertIssuer(String authorityCertIssuer) {
        this.certIssuer = authorityCertIssuer;
    }

    public String getAuthorityCertIssuer() {
        return this.certIssuer;
    }

    public void setAuthorityCertSerialNumber(BigInteger authorityCertSerialNumber) {
        this.certSerialNumber = authorityCertSerialNumber;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.certSerialNumber;
    }

    public void setAuthorityCertSerialNumber(int authorityCertSerialNumber) {
        this.certSerialNumber = new BigInteger(String.valueOf(authorityCertSerialNumber));
    }

    public void setAuthorityCertSerialNumber(String authorityCertSerialNumber) {
        this.certSerialNumber = new BigInteger(authorityCertSerialNumber);
    }

    public String getAuthorityCertSerialNumberStringType() {
        return this.certSerialNumber.toString();
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        SubjectPublicKeyInfo spki = null;
        spki = Parser.key2SPKI(this.pubKey);
        AuthorityKeyIdentifier authKeyID = null;
        GeneralNames name = null;
        if (this.certIssuer != null && !this.certIssuer.equals("")) {
            X509Name x509Name = new X509Name(this.certIssuer);
            GeneralName genName = new GeneralName(x509Name);
            name = new GeneralNames(new DERSequence(genName));
        }
        authKeyID = name == null && this.certSerialNumber == null ? new AuthorityKeyIdentifier(spki) : (name == null ? new AuthorityKeyIdentifier(spki, this.certSerialNumber) : (this.certSerialNumber == null ? new AuthorityKeyIdentifier(spki, name) : new AuthorityKeyIdentifier(spki, name, this.certSerialNumber)));
        DEROctetString octetValue = new DEROctetString(authKeyID.getDERObject());
        return octetValue.getOctets();
    }
}

