/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.AccessDescription;
import cn.com.jit.ida.util.pki.asn1.x509.AuthorityInformationAccess;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;
import cn.com.jit.ida.util.pki.extension.AccessDescriptionExt;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AuthorityInformationAccessExt
extends AbstractStandardExtension {
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;
    private int nameType = -1;
    private String accessMethod = null;
    private String accessLocation = null;
    private Vector accessDescriptionExts = null;
    private AccessDescriptionExt accessDescriptionExt = null;

    public AuthorityInformationAccessExt() {
        this.OID = X509Extensions.AuthorityInfoAccess.getId();
        this.critical = false;
        this.accessDescriptionExts = new Vector();
        this.accessDescriptionExt = new AccessDescriptionExt();
    }

    public AuthorityInformationAccessExt(ASN1Sequence asn1Sequence) {
        this.accessDescriptionExts = new Vector();
        int size = asn1Sequence.size();
        int i = 0;
        while (i < size) {
            ASN1Sequence seq = (ASN1Sequence)asn1Sequence.getObjectAt(i);
            DERObjectIdentifier method = (DERObjectIdentifier)seq.getObjectAt(0);
            AccessDescriptionExt accessDescription = new AccessDescriptionExt();
            accessDescription.setAccessMethod(method.getId());
            ASN1TaggedObject tagObj = (ASN1TaggedObject)seq.getObjectAt(1);
            String location = GeneralName.GeneralNameToString(tagObj);
            accessDescription.setAccessLocation(location);
            this.accessDescriptionExts.add(accessDescription);
            ++i;
        }
    }

    public AuthorityInformationAccessExt(Node nl) throws PKIException {
        this.OID = X509Extensions.AuthorityInfoAccess.getId();
        this.critical = false;
        this.accessDescriptionExts = new Vector();
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AuthorityInformationAccessExt.AuthorityInformationAccessExt(),AuthorityInfoAccess\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            String oid = null;
            String gname = null;
            if (sname.equals("AccessDescription")) {
                NodeList nodelist1 = cnode.getChildNodes();
                int j = 0;
                while (j < nodelist1.getLength()) {
                    Node nodeauth = nodelist1.item(j);
                    String cname = nodeauth.getNodeName();
                    if (cname.equals("accessMethod")) {
                        Text txt = (Text)nodeauth.getFirstChild();
                        String str = txt.getData();
                        oid = str.trim();
                    }
                    if (cname.equals("accessLocation")) {
                        NamedNodeMap attributes = nodeauth.getAttributes();
                        String type = attributes.item(0).getNodeValue();
                        try {
                            Text txt = (Text)nodeauth.getFirstChild();
                            String sgroup = txt.getData();
                            gname = sgroup.trim();
                        }
                        catch (IllegalArgumentException e) {
                            throw new PKIException("IllegalArgumentException,AuthorityInformationAccessExt.AuthorityInformationAccessExt(),\u6784\u9020accessLocation\u65f6\u51fa\u9519", e);
                        }
                    }
                    ++j;
                }
                this.accessDescriptionExt = new AccessDescriptionExt();
                try {
                    this.accessDescriptionExt.setAccessLocation(gname);
                    this.accessDescriptionExt.setAccessMethod(oid);
                }
                catch (IllegalArgumentException e) {
                    throw new PKIException("IllegalArgumentException,AuthorityInformationAccessExt.AuthorityInformationAccessExt(),\u6784\u9020AccessDescription\u65f6\u51fa\u9519", e);
                }
                this.accessDescriptionExts.add(this.accessDescriptionExt);
            }
            ++i;
        }
    }

    public void addAccessDescription(AccessDescriptionExt accessDescription) {
        this.accessDescriptionExts.add(accessDescription);
    }

    public AccessDescriptionExt[] getAccessDescription() {
        AccessDescriptionExt[] accessDescriptions = new AccessDescriptionExt[this.accessDescriptionExts.size()];
        return this.accessDescriptionExts.toArray(accessDescriptions);
    }

    public void setAccessMethod(String accessMethod) {
        this.accessDescriptionExt.setAccessMethod(accessMethod);
    }

    public void setAccessLocation(int nameType, String accessLocation) {
        this.accessDescriptionExt.setAccessLocationType(nameType);
        this.accessDescriptionExt.setAccessLocation(accessLocation);
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getAccessMethod() {
        return this.accessMethod;
    }

    public String getAccessLocation() {
        return this.accessLocation;
    }

    public AccessDescriptionExt getAccessDescriptionExt() {
        return this.accessDescriptionExt;
    }

    public void setAccessDescriptionExt(AccessDescriptionExt accessDescriptionExt) {
        this.accessDescriptionExt = accessDescriptionExt;
    }

    public byte[] encode() throws PKIException {
        Vector<AccessDescription> vAccessDesExt = new Vector<AccessDescription>();
        int i = 0;
        while (i < this.accessDescriptionExts.size()) {
            AccessDescriptionExt accessDesExt = (AccessDescriptionExt)this.accessDescriptionExts.get(i);
            DERObjectIdentifier idAccessMethod = new DERObjectIdentifier(accessDesExt.getAccessMethod());
            GeneralName nameAccessLocation = null;
            if (accessDesExt.getAccessLocationType() == 6) {
                DERIA5String ia5DPName = new DERIA5String(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ia5DPName, 6);
            } else if (accessDesExt.getAccessLocationType() == 4) {
                nameAccessLocation = new GeneralName(new X509Name(accessDesExt.getAccessLocation()));
            }
            AccessDescription accessDes = new AccessDescription();
            accessDes.setAccessMethod(idAccessMethod);
            accessDes.setAccessLocation(nameAccessLocation);
            vAccessDesExt.add(accessDes);
            ++i;
        }
        AuthorityInformationAccess authInfoAccess = new AuthorityInformationAccess(vAccessDesExt);
        DEROctetString octetValue = new DEROctetString(authInfoAccess.getDERObject());
        return octetValue.getOctets();
    }
}

