/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.extension;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERBMPString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERT61String;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;

public class AttributeTypeAndValueExt {
    public static final int TELETEXSTRING = 300;
    public static final int PRINTABLESTRING = 301;
    public static final int UNIVERSALSTRING = 302;
    public static final int UTF8STRING = 303;
    public static final int BMPSTRING = 304;
    private DEREncodableVector seqTypeAndValue = new DEREncodableVector();

    public AttributeTypeAndValueExt() {
    }

    public AttributeTypeAndValueExt(ASN1Sequence seq) {
        int i = 0;
        while (i < seq.size()) {
            this.seqTypeAndValue.add(seq.getObjectAt(i));
            ++i;
        }
    }

    public ASN1Sequence getObject() {
        return new DERSequence(this.seqTypeAndValue);
    }

    public void setAttributeType(String OID) {
        this.seqTypeAndValue.add(new DERObjectIdentifier(OID));
    }

    public String getAttributeType() {
        return ((DERObjectIdentifier)this.seqTypeAndValue.get(0)).getId();
    }

    public void setAttributeValue(int type, String value) throws PKIException {
        this.seqTypeAndValue.add(this.TypeToDEREncodable(type, value));
    }

    public String getAttributeValue() {
        DEREncodable obj = this.seqTypeAndValue.get(1);
        String ret_String = null;
        if (obj instanceof DERT61String) {
            ret_String = DERT61String.getInstance(obj).getString();
        } else if (obj instanceof DERPrintableString) {
            ret_String = DERPrintableString.getInstance(obj).getString();
        } else if (obj instanceof DERUTF8String) {
            ret_String = DERUTF8String.getInstance(obj).getString();
        } else if (obj instanceof DERBMPString) {
            ret_String = DERBMPString.getInstance(obj).getString();
        }
        return ret_String;
    }

    private DEREncodable TypeToDEREncodable(int valueType, String value) throws PKIException {
        DERObject derencodable = null;
        switch (valueType) {
            case 300: {
                derencodable = new DERT61String(value);
                break;
            }
            case 301: {
                derencodable = new DERPrintableString(value);
                break;
            }
            case 303: {
                derencodable = new DERUTF8String(value);
                break;
            }
            case 304: {
                derencodable = new DERBMPString(value);
                break;
            }
            case 302: {
                throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
        }
        return derencodable;
    }
}

