/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.crl;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERUTCTime;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class X509CRLParser {
    private InputStream ins;
    private Set revokedCerts = new HashSet();
    private int tbsCertDataIndex;
    private int tbsCertDataLen;
    private byte[] tbsCertData;
    private int signDataIndex;
    private int signDataLen;
    private byte[] signData;
    private DERObjectIdentifier signAlgOid;
    private String issuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private final String head = "-----BEGIN X509CRL-----";
    private final String end = "-----END X509CRL-----";

    public X509CRLParser(byte[] derCRL) throws PKIException {
        byte[] crlData = this.parseCrlData(derCRL);
        this.ins = new ByteArrayInputStream(crlData);
        this.parseCRL();
    }

    public X509CRLParser(InputStream is) throws PKIException {
        byte[] bIS = null;
        try {
            int length = is.available();
            bIS = new byte[length];
            int readLen = is.read(bIS);
            while (readLen < length) {
                byte[] temp = new byte[length - readLen];
                int i = is.read(temp);
                System.arraycopy(temp, 0, bIS, readLen, i);
                readLen += i;
            }
            is.close();
        }
        catch (IOException ex) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        byte[] crlData = this.parseCrlData(bIS);
        this.ins = new ByteArrayInputStream(crlData);
        this.parseCRL();
    }

    public X509CRLParser(byte[] derCRL, JKey pubKey, Session session) throws PKIException {
        this(derCRL);
        if (!this.verify(pubKey, session)) {
            throw new PKIException("6", "verify crl failed...");
        }
    }

    public X509CRLParser(InputStream is, JKey pubKey, Session session) throws PKIException {
        this(is);
        if (!this.verify(pubKey, session)) {
            throw new PKIException("6", "verify crl failed...");
        }
    }

    public Set getRevokedCerts() {
        return this.revokedCerts;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public byte[] getSignature() {
        return this.signData;
    }

    public String getSignatureAlgOID() {
        return this.signAlgOid.getId();
    }

    public String getSignatureAlgName() {
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(this.signAlgOid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(this.signAlgOid);
        return sigAlgName;
    }

    public boolean isRevoke(String certSerialNumber) {
        BigInteger sn = new BigInteger(certSerialNumber, 16);
        return this.isRevoke(sn);
    }

    public boolean isRevoke(BigInteger certSerialNumber) {
        if (this.revokedCerts == null) {
            return false;
        }
        return this.revokedCerts.contains(certSerialNumber);
    }

    public boolean isRevoke(X509Cert cert) {
        BigInteger sn = cert.getSerialNumber();
        return this.isRevoke(sn);
    }

    private boolean verify(JKey pubKey, Session session) throws PKIException {
        if (this.tbsCertData == null) {
            throw new PKIException("TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", "crl has already verfied, tbsCertData is null.");
        }
        Mechanism mechanism = null;
        if (this.signAlgOid.equals(PKCSObjectIdentifiers.md2WithRSAEncryption)) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (this.signAlgOid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (this.signAlgOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || this.signAlgOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption_v1)) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (this.signAlgOid.equals(PKCSObjectIdentifiers.sha1WithECEncryption)) {
            mechanism = new Mechanism("SHA1withECDSA");
        } else if (this.signAlgOid.equals(PKCSObjectIdentifiers.sha1WithDSA)) {
            mechanism = new Mechanism("SHA1withDSA");
        } else if (this.signAlgOid.equals(PKCSObjectIdentifiers.sm2_with_sm3)) {
            mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + this.signAlgOid.getId());
        }
        boolean f = session.verifySign(mechanism, pubKey, this.tbsCertData, this.signData);
        this.tbsCertData = null;
        return f;
    }

    private void parseCRL() throws PKIException {
        this.init();
        try {
            this.readTbsCertList();
            this.readSignatureAlgorithm();
            this.readSignatureValue();
        }
        catch (Exception e) {
            throw new PKIException("8168", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", e);
        }
    }

    private void init() throws PKIException {
        try {
            int tag = this.readTag();
            Length length = this.readLength();
            this.tbsCertDataIndex += 1 + length.getByteSize();
        }
        catch (Exception e) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", e);
        }
    }

    private void readTbsCertList() throws Exception {
        int left;
        int tag = this.readTag();
        Length tbsCertListLength = this.readLength();
        int tbsCertListLen = tbsCertListLength.getValue();
        this.tbsCertDataLen = 1 + tbsCertListLength.getByteSize() + tbsCertListLen;
        int tbsReaded = 0;
        this.tbsCertData = new byte[this.tbsCertDataLen];
        this.tbsCertData[tbsReaded++] = (byte)tag;
        System.arraycopy(tbsCertListLength.getDataReaded(), 0, this.tbsCertData, tbsReaded, tbsCertListLength.getDataReaded().length);
        tbsReaded += tbsCertListLength.getDataReaded().length;
        tag = this.readTag();
        Length length = this.readLength();
        if (2 == tag) {
            tbsReaded = this.SetTbscertData(tag, length, tbsReaded);
            tag = this.readTag();
            length = this.readLength();
        }
        tbsReaded = this.SetTbscertData(tag, length, tbsReaded);
        tag = this.readTag();
        length = this.readLength();
        DERSequence sequence = (DERSequence)this.readDerData(tag, length);
        X509Name issuerName = new X509Name(sequence);
        this.issuer = issuerName.toString();
        byte[] issuerder = Parser.writeDERObj2Bytes(sequence);
        System.arraycopy(issuerder, 0, this.tbsCertData, tbsReaded, issuerder.length);
        tbsReaded += issuerder.length;
        tag = this.readTag();
        length = this.readLength();
        DERUTCTime thisUpdateTime = (DERUTCTime)this.readDerData(tag, length);
        this.thisUpdate = this.getDate(thisUpdateTime);
        byte[] thisder = Parser.writeDERObj2Bytes(thisUpdateTime);
        System.arraycopy(thisder, 0, this.tbsCertData, tbsReaded, thisder.length);
        int leftdata = tbsCertListLen - ((tbsReaded += thisder.length) - 1 - tbsCertListLength.getDataReaded().length);
        if (leftdata == 0) {
            return;
        }
        tag = this.readTag();
        length = this.readLength();
        if (23 == tag) {
            DERUTCTime nextUpdateTime = (DERUTCTime)this.readDerData(tag, length);
            this.nextUpdate = this.getDate(nextUpdateTime);
            byte[] nextder = Parser.writeDERObj2Bytes(nextUpdateTime);
            System.arraycopy(nextder, 0, this.tbsCertData, tbsReaded, nextder.length);
            if ((tbsReaded += nextder.length) >= this.tbsCertData.length) {
                return;
            }
            leftdata = tbsCertListLen - (tbsReaded - 1 - tbsCertListLength.getDataReaded().length);
            if (leftdata == 0) {
                return;
            }
            tag = this.readTag();
            length = this.readLength();
        }
        this.tbsCertData[tbsReaded++] = (byte)tag;
        System.arraycopy(length.dataReaded, 0, this.tbsCertData, tbsReaded, length.dataReaded.length);
        tbsReaded += length.byteSize;
        if (48 == tag) {
            int revokedCertReaded = 0;
            int count = 0;
            while (revokedCertReaded < length.getValue()) {
                int entryTag = this.readTag();
                Length entryLength = this.readLength();
                this.tbsCertData[tbsReaded++] = (byte)entryTag;
                System.arraycopy(entryLength.getLenData(), 0, this.tbsCertData, tbsReaded, entryLength.getLenData().length);
                tbsReaded += entryLength.getLenData().length;
                int entryReaded = 0;
                int snTag = this.readTag();
                if (2 != snTag) {
                    this.tbsCertData[tbsReaded++] = (byte)snTag;
                    byte[] leftData = new byte[length.getValue() - 1 - 1 - entryLength.getLenData().length];
                    this.readFully(leftData);
                    System.arraycopy(leftData, 0, this.tbsCertData, tbsReaded, leftData.length);
                    tbsReaded += leftData.length;
                    return;
                }
                Length snLength = this.readLength();
                byte[] snData = new byte[snLength.getValue()];
                this.readFully(snData);
                this.tbsCertData[tbsReaded++] = (byte)snTag;
                System.arraycopy(snLength.getLenData(), 0, this.tbsCertData, tbsReaded, snLength.getLenData().length);
                System.arraycopy(snData, 0, this.tbsCertData, tbsReaded += snLength.getLenData().length, snData.length);
                tbsReaded += snData.length;
                BigInteger sn = new BigInteger(snData);
                this.revokedCerts.add(sn);
                ++count;
                int left2 = entryLength.getValue() - (entryReaded += 1 + snLength.getByteSize() + snLength.getValue());
                if (left2 > 0) {
                    byte[] leftData = new byte[left2];
                    this.readFully(leftData);
                    System.arraycopy(leftData, 0, this.tbsCertData, tbsReaded, leftData.length);
                    tbsReaded += leftData.length;
                }
                revokedCertReaded += 1 + entryLength.getByteSize() + entryLength.getValue();
            }
        }
        if ((left = tbsCertListLen - (tbsReaded - 1 - tbsCertListLength.getDataReaded().length)) > 0) {
            byte[] leftData = new byte[left];
            this.readFully(leftData);
            System.arraycopy(leftData, 0, this.tbsCertData, tbsReaded, leftData.length);
            tbsReaded += leftData.length;
        }
    }

    private Date getDate(DERUTCTime utcTime) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        return dateF.parse(utcTime.getAdjustedTime(), new ParsePosition(0));
    }

    private DERObject readDerData(int tag, Length length) throws Exception {
        byte[] data = new byte[1 + length.getByteSize() + length.getValue()];
        byte[] tmp = new byte[length.getValue()];
        this.ins.read(tmp);
        data[0] = (byte)tag;
        System.arraycopy(length.dataReaded, 0, data, 1, length.dataReaded.length);
        System.arraycopy(tmp, 0, data, 1 + length.getByteSize(), tmp.length);
        return Parser.writeBytes2DERObj(data);
    }

    private void readSignatureAlgorithm() throws Exception {
        int tag = this.readTag();
        Length length = this.readLength();
        tag = this.readTag();
        length = this.readLength();
        int oidAlgDataIndex = this.tbsCertDataIndex + this.tbsCertDataLen + 1 + length.getByteSize();
        this.signAlgOid = (DERObjectIdentifier)this.readDerData(tag, length);
        this.signDataIndex += this.tbsCertDataIndex + this.tbsCertDataLen + 1 + length.getByteSize() + length.getValue();
    }

    private void readSignatureValue() throws Exception {
        byte[] tmp;
        int tag = this.readTag();
        Length length = this.readLength();
        this.signDataLen = length.getValue();
        if (3 != tag) {
            tmp = new byte[this.signDataLen];
            this.ins.read(tmp);
            tag = this.readTag();
            length = this.readLength();
            this.signDataLen = length.getValue();
        }
        if (this.signDataLen < 1) {
            throw new PKIException("8168", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25:get crl signData");
        }
        tmp = new byte[this.signDataLen];
        this.signData = new byte[this.signDataLen - 1];
        this.ins.read(tmp);
        System.arraycopy(tmp, 1, this.signData, 0, this.signDataLen - 1);
        --this.signDataLen;
        this.ins.close();
    }

    private int readTag() throws Exception {
        int tag = this.ins.read();
        if (tag == -1) {
            throw new EOFException();
        }
        return tag;
    }

    private Length readLength() throws IOException {
        int length = this.ins.read();
        int byteSize = 1;
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return new Length(-1, 1);
        }
        Length ret = null;
        if (length > 127) {
            int size = length & 0x7F;
            int tag = length;
            length = 0;
            byte[] lenData = new byte[size];
            int i = 0;
            while (i < size) {
                int next = this.ins.read();
                lenData[i] = (byte)next;
                ++byteSize;
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
                ++i;
            }
            ret = new Length(length, byteSize);
            ret.setLenData(lenData);
            byte[] dataReaded = new byte[byteSize];
            dataReaded[0] = (byte)tag;
            System.arraycopy(lenData, 0, dataReaded, 1, lenData.length);
            ret.setDataReaded(dataReaded);
        } else {
            ret = new Length(length, byteSize);
            byte[] lenData = new byte[]{(byte)length};
            byte[] readed = new byte[]{(byte)length};
            ret.setLenData(lenData);
            ret.setDataReaded(lenData);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private void readFully(byte[] bytes) throws IOException {
        left = bytes.length;
        if (left != 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            l = this.ins.read(bytes, bytes.length - left, left);
            if (l < 0) {
                throw new EOFException("unexpected end of stream");
            }
            left -= l;
lbl8:
            // 2 sources

            ** while (left > 0)
        }
lbl9:
        // 1 sources

    }

    private void skip(int length) throws Exception {
        this.ins.skip(length);
    }

    private int SetTbscertData(int tag, Length lens, int index) throws Exception {
        this.tbsCertData[index++] = (byte)tag;
        byte[] data = new byte[lens.getValue()];
        System.arraycopy(lens.getLenData(), 0, this.tbsCertData, index, lens.getLenData().length);
        int tmplen = this.ins.read(data);
        System.arraycopy(data, 0, this.tbsCertData, index += lens.getLenData().length, tmplen);
        return index += tmplen;
    }

    private byte[] parseCrlData(byte[] crlData) throws PKIException {
        try {
            byte[] tempHead = new byte["-----BEGIN X509CRL-----".length()];
            System.arraycopy(crlData, 0, tempHead, 0, tempHead.length);
            if (Parser.isBase64Encode(crlData)) {
                crlData = Parser.convertBase64(crlData);
                return Base64.decode(crlData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN X509CRL-----".getBytes())) {
                int length = crlData.length;
                byte[] withoutHead = new byte[length - "-----BEGIN X509CRL-----".length()];
                System.arraycopy(crlData, "-----BEGIN X509CRL-----".length(), withoutHead, 0, withoutHead.length);
                byte[] withoutEnd = new byte[withoutHead.length - ("-----END X509CRL-----".length() + 2)];
                System.arraycopy(withoutHead, 0, withoutEnd, 0, withoutEnd.length);
                byte[] withoutEnter = Parser.convertBase64(withoutEnd);
                return Base64.decode(withoutEnter);
            }
            return crlData;
        }
        catch (Exception ex) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream fin = new FileInputStream("./crl/\u65e0\u4e0b\u6b21\u66f4\u65b0\u65f6\u95f4,\u65e0\u6ce8\u9500\u5217\u8868,\u65e0\u6269\u5c55.crl");
            FileInputStream fis = new FileInputStream("./crl/crlroot.cer");
            X509CRLParser crl = new X509CRLParser(fin);
            System.out.println("read crl success...");
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB", "PKITOOL");
            X509Certificate cert = null;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)certFactory.generateCertificate(fis);
            fis.close();
            X509Cert x509 = new X509Cert(cert.getEncoded());
            Iterator it = crl.getRevokedCerts().iterator();
            int i = 0;
            while (it.hasNext()) {
                BigInteger sn = (BigInteger)it.next();
                System.out.println("crl sn " + i++ + ":" + sn.toString(16));
            }
            System.out.println("crl Issuer:" + crl.getIssuer());
            System.out.println("crl SignatureAlgName:" + crl.getSignatureAlgName());
            System.out.println("crl SignatureAlgOID:" + crl.getSignatureAlgOID());
            if (crl.getNextUpdate() != null) {
                System.out.println("crl NextUpdate:" + crl.getNextUpdate().toGMTString());
            }
            System.out.println("crl ThisUpdate:" + crl.getThisUpdate().toGMTString());
            boolean isRevoke = crl.isRevoke("236ebed8ebb7d2ce");
            if (isRevoke) {
                System.out.println("sn 236ebed8ebb7d2ceis revoked...");
            } else {
                System.out.println("sn 236ebed8ebb7d2ceis not revoked...");
            }
            boolean verify = crl.verify(x509.getPublicKey(), session);
            if (verify) {
                System.out.println("to verify crl success...");
            } else {
                System.out.println("to verify crl failed...");
            }
            System.out.println("X509CRLParser test is over...");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("to test error..." + e.getMessage());
        }
    }

    class Length {
        private int value;
        private int byteSize;
        private byte[] lenData;
        private byte[] dataReaded;

        public Length(int value, int byteSize) {
            this.value = value;
            this.byteSize = byteSize;
        }

        public byte[] getDataReaded() {
            return this.dataReaded;
        }

        public void setDataReaded(byte[] dataReaded) {
            this.dataReaded = dataReaded;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getByteSize() {
            return this.byteSize;
        }

        public void setByteSize(int byteSize) {
            this.byteSize = byteSize;
        }

        public void setLenData(byte[] data) {
            this.lenData = data;
        }

        public byte[] getLenData() {
            return this.lenData;
        }
    }
}

