/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.crl;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertList;
import cn.com.jit.ida.util.pki.asn1.x509.Time;
import cn.com.jit.ida.util.pki.asn1.x509.V2TBSCertListGenerator;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extension;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.extension.Extension;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class X509CRLGenerator {
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private Mechanism mechanism = null;
    private V2TBSCertListGenerator tbsCRLGen = new V2TBSCertListGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private TBSCertList tbsCRL = null;
    private DERBitString signature = null;
    private String issuerName = null;
    private Date thisUpdate = null;
    private Hashtable extensionSet = new Hashtable();
    private HashMap dnrules = null;

    public void addRevokeCert(String certSerialNumber, Date revokeTime) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new DERInteger(bigIntSN), new Time(revokeTime), 0);
    }

    public void addRevokeCert(String certSerialNumber, Date revokeTime, int reason) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new DERInteger(bigIntSN), new Time(revokeTime), reason);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime) {
        this.tbsCRLGen.addCRLEntry(new DERInteger(certSerialNumber), new Time(revokeTime), 0);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime, int reason) {
        this.tbsCRLGen.addCRLEntry(new DERInteger(certSerialNumber), new Time(revokeTime), reason);
    }

    public void setIssuer(String issuerName) {
        this.issuerName = issuerName;
        X509Name x509Issuer = new X509Name(issuerName);
        if (this.dnrules != null) {
            x509Issuer.setRules(this.dnrules);
        }
        this.tbsCRLGen.setIssuer(x509Issuer);
    }

    public void setIssuer(X509Name x509IssuerName) {
        this.issuerName = x509IssuerName.toString();
        this.tbsCRLGen.setIssuer(x509IssuerName);
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
        this.tbsCRLGen.setThisUpdate(new Time(thisUpdate));
    }

    public void setNextUpdate(Date nextUpdate) {
        this.tbsCRLGen.setNextUpdate(new Time(nextUpdate));
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("8154", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (signatureAlgorithm.equals("MD2withRSAEncryption")) {
            this.mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signatureAlgorithm.equals("MD5withRSAEncryption")) {
            this.mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA1withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA224withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA224withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA256withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA256withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA384withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA384withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA512withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA512withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA224withECDSA")) {
            this.mechanism = new Mechanism("SHA224withECDSA");
        } else if (signatureAlgorithm.equals("SHA256withECDSA")) {
            this.mechanism = new Mechanism("SHA256withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withECDSA")) {
            this.mechanism = new Mechanism("SHA1withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withDSA")) {
            this.mechanism = new Mechanism("SHA1withDSA");
        } else if (signatureAlgorithm.endsWith("SM3withSM2Encryption")) {
            this.mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        this.sigAlg = signatureAlgorithm.equals("SHA224withRSAEncryption") || signatureAlgorithm.equals("SHA256withRSAEncryption") || signatureAlgorithm.equals("SHA384withRSAEncryption") || signatureAlgorithm.equals("SHA512withRSAEncryption") ? new AlgorithmIdentifier(oid, new DERNull()) : new AlgorithmIdentifier(oid);
        this.tbsCRLGen.setSignature(this.sigAlg);
    }

    public void setExtension(Vector extensions) throws PKIException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            Extension extension = (Extension)extensions.get(i);
            DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
            boolean critical = extension.getCritical();
            byte[] extensionValue = null;
            try {
                extensionValue = extension.encode();
            }
            catch (PKIException ex) {
                throw new PKIException("8160", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
            }
            DEROctetString derOctet = new DEROctetString(extensionValue);
            this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
            ++i;
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
        boolean critical = extension.getCritical();
        byte[] extensionValue = null;
        try {
            extensionValue = extension.encode();
        }
        catch (PKIException ex) {
            throw new PKIException("8160", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
        }
        DEROctetString derOctet = new DEROctetString(extensionValue);
        this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
    }

    public byte[] generateCRL(JKey priKey, Session session) throws PKIException {
        if (this.issuerName == null || this.issuerName.equals("")) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.thisUpdate == null) {
            throw new PKIException("8163", "CRL\u672c\u6b21\u66f4\u65b0\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sigAlg == null) {
            throw new PKIException("8154", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateSignature(priKey, session);
        return this.constructCRL();
    }

    private void generateSignature(JKey priKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCRLGen.setExtensions(new X509Extensions(this.extensionSet));
        }
        this.tbsCRL = this.tbsCRLGen.generateTBSCertList();
        byte[] bTBSCRL = null;
        try {
            bTBSCRL = Parser.writeDERObj2Bytes(this.tbsCRL.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8165", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCRL);
        }
        catch (Exception ex) {
            throw new PKIException("5", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCRL() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCRL);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = Parser.writeDERObj2Bytes(derSeq.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8164", "CRL\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return certData;
    }

    public void SetDnRules(Map rules) {
        this.dnrules = (HashMap)rules;
    }
}

