/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.crl;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.CertificateList;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertList;
import cn.com.jit.ida.util.pki.asn1.x509.Time;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;

public class X509CRL {
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;
    private final String head = "-----BEGIN X509CRL-----";
    private final String end = "-----END X509CRL-----";

    public X509CRL(byte[] derCRL) throws PKIException {
        this.initCRL(derCRL);
    }

    private void initCRL(byte[] derCRL) throws PKIException {
        try {
            byte[] derData = this.parseCrlData(derCRL);
            ByteArrayInputStream bis = new ByteArrayInputStream(derData);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
    }

    public X509CRL(CertificateList certList) {
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(InputStream is) throws PKIException {
        byte[] bIS = null;
        try {
            int length = is.available();
            bIS = new byte[length];
            int readLen = is.read(bIS);
            while (readLen < length) {
                byte[] temp = new byte[length - readLen];
                int i = is.read(temp);
                System.arraycopy(temp, 0, bIS, readLen, i);
                readLen += i;
            }
            is.close();
        }
        catch (IOException ex) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        this.initCRL(bIS);
    }

    public CertificateList getCertificateList() {
        return this.certList;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = Parser.writeDERObj2Bytes(this.certList);
        }
        catch (Exception ex) {
            throw new PKIException("8168", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public int getVersion() {
        return this.certList.getVersion();
    }

    public String getIssuer() {
        X509Name x509Issuer = this.certList.getIssuer();
        return x509Issuer.toString().trim();
    }

    public X509Name getX509NameIssuer() {
        X509Name x509Issuer = this.certList.getIssuer();
        return x509Issuer;
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public Date getThisUpdate() {
        Time thisUpdate = this.certList.getThisUpdate();
        return thisUpdate.getDate();
    }

    public Date getNextUpdate() {
        Time nextUpdate = this.certList.getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        return nextUpdate.getDate();
    }

    public byte[] getSignature() {
        DERBitString derBit = this.certList.getSignature();
        return derBit.getBytes();
    }

    public byte[] getTBSCertList() throws PKIException {
        byte[] bTBSCertList = null;
        try {
            bTBSCertList = Parser.writeDERObj2Bytes(this.certList.getTBSCertList().getDERObject());
        }
        catch (Exception e) {
            throw new PKIException("8165", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", e);
        }
        return bTBSCertList;
    }

    public boolean isRevoke(String certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = new BigInteger(certSerialNumber, 16);
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (sn.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRevoke(BigInteger certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (certSerialNumber.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRevoke(X509Cert cert) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = cert.getSerialNumber();
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (sn.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean verify(JKey pubKey, Session session) throws PKIException {
        DERObjectIdentifier oid = this.certList.getSignatureAlgorithm().getObjectId();
        Mechanism mechanism = null;
        if (oid.equals(PKCSObjectIdentifiers.md2WithRSAEncryption)) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption_v1)) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithECEncryption)) {
            mechanism = new Mechanism("SHA1withECDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithDSA)) {
            mechanism = new Mechanism("SHA1withDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sm2_with_sm3)) {
            mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        byte[] tbsData = this.getTBSCertList();
        boolean verify = false;
        try {
            verify = session.verifySign(mechanism, pubKey, tbsData, this.getSignature());
        }
        catch (Exception ex) {
            throw new PKIException("6", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return verify;
    }

    private byte[] parseCrlData(byte[] crlData) throws PKIException {
        try {
            byte[] tempHead = new byte["-----BEGIN X509CRL-----".length()];
            System.arraycopy(crlData, 0, tempHead, 0, tempHead.length);
            if (Parser.isBase64Encode(crlData)) {
                crlData = Parser.convertBase64(crlData);
                return Base64.decode(crlData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN X509CRL-----".getBytes())) {
                int length = crlData.length;
                byte[] withoutHead = new byte[length - "-----BEGIN X509CRL-----".length()];
                System.arraycopy(crlData, "-----BEGIN X509CRL-----".length(), withoutHead, 0, withoutHead.length);
                byte[] withoutEnd = new byte[withoutHead.length - ("-----END X509CRL-----".length() + 2)];
                System.arraycopy(withoutHead, 0, withoutEnd, 0, withoutEnd.length);
                byte[] withoutEnter = Parser.convertBase64(withoutEnd);
                return Base64.decode(withoutEnter);
            }
            return crlData;
        }
        catch (Exception ex) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("8167", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream fin = new FileInputStream("D:/sm2test.crl");
            byte[] crldata = null;
            crldata = new byte[fin.available()];
            fin.read(crldata);
            fin.close();
            X509CRL crl = new X509CRL(crldata);
            System.out.println("to read crl success...");
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            jcrypto.initialize("JSJY05B_LIB", "PKITOOL");
            Session session = jcrypto.openSession("JSJY05B_LIB", "PKITOOL");
            X509Certificate cert = null;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            FileInputStream fis = new FileInputStream("d:\\rootgfa.cer");
            cert = (X509Certificate)certFactory.generateCertificate(fis);
            fis.close();
            X509Cert x509 = new X509Cert(cert.getEncoded());
            String issuer = crl.getIssuer();
            System.out.println("crl issuer:" + issuer);
            String signatureAlgName = crl.getSignatureAlgName();
            System.out.println("crl signatureAlgName:" + signatureAlgName);
            Date thisUpdate = crl.getThisUpdate();
            System.out.println("crl thisUpdate:" + thisUpdate.toGMTString());
            boolean verfiy = crl.verify(x509.getPublicKey(), session);
            if (verfiy) {
                System.out.println("crl verify success");
            } else {
                System.out.println("crl verify failed");
            }
            fin = new FileInputStream("D:/crl/crl112.crl");
            crl = new X509CRL(fin);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("to test error..." + e.getMessage());
        }
    }
}

