/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cms;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cms.CMSSignedGenerator;
import cn.com.jit.ida.util.pki.cms.CMSSignedHelper;
import cn.com.jit.ida.util.pki.cms.CMSUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class JITCMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();
    Session session;

    public JITCMSSignedDataGenerator(Session session) {
        this.session = session;
    }

    public JITCMSSignedDataGenerator(SecureRandom rand, Session session) {
        super(rand);
        this.session = session;
    }

    public void addSigner(JKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException, PKIException {
        this.addSigner(key, cert, this.getEncOID(Parser.convertPrivateKey(key), digestOID), digestOID);
    }

    public void addSigner(JKey key, X509Certificate cert, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(cert), digestOID, encryptionOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String digestOID) throws IllegalArgumentException, PKIException {
        this.addSigner(key, subjectKeyID, this.getEncOID(Parser.convertPrivateKey(key), digestOID), digestOID);
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), digestOID, encryptionOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(JKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException, PKIException {
        this.addSigner(key, cert, this.getEncOID(Parser.convertPrivateKey(key), digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(JKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(cert), digestOID, encryptionOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException, PKIException {
        this.addSigner(key, subjectKeyID, digestOID, this.getEncOID(Parser.convertPrivateKey(key), digestOID), (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr));
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), digestOID, encryptionOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(JKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException, PKIException {
        this.addSigner(key, cert, this.getEncOID(Parser.convertPrivateKey(key), digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(JKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(cert), digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, null));
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException, PKIException {
        this.addSigner(key, subjectKeyID, digestOID, this.getEncOID(Parser.convertPrivateKey(key), digestOID), signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(JKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, JITCMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, null));
    }

    public CMSSignedData generate(CMSProcessable content, Session session) throws NoSuchAlgorithmException, CMSException, PKIException {
        return this.generate(content, false, session);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Session session) throws NoSuchAlgorithmException, CMSException, PKIException {
        return this.generate(eContentType, content, encapsulate, session, true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Session session, boolean addDefaultAttributes) throws NoSuchAlgorithmException, CMSException, PKIException {
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this._digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(new AlgorithmIdentifier(signer.getDigestAlgOID())));
            signerInfos.add((DEREncodable)signer.toSignerInfo());
        }
        boolean isCounterSignature = eContentType == null;
        DERObjectIdentifier contentTypeOID = isCounterSignature ? CMSObjectIdentifiers.data : new DERObjectIdentifier(eContentType);
        for (SignerInf signer : this.signerInfs) {
            try {
                digestAlgs.add((DEREncodable)signer.getDigestAlgorithmID());
                signerInfos.add((DEREncodable)signer.toSignerInfo(contentTypeOID, content, this.rand, session, addDefaultAttributes, isCounterSignature));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", (Exception)e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", (Exception)e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", (Exception)e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", (Exception)e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this._crls);
        }
        BERConstructedOctetString octs = null;
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (content != null) {
                try {
                    content.write((OutputStream)bOut);
                }
                catch (IOException e) {
                    throw new CMSException("encapsulation error.", (Exception)e);
                }
            }
            octs = new BERConstructedOctetString(bOut.toByteArray());
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData((ASN1Set)new DERSet((DEREncodableVector)digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet((DEREncodableVector)signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, Session session) throws NoSuchAlgorithmException, CMSException, PKIException {
        return this.generate(DATA, content, encapsulate, session);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, Session session) throws NoSuchAlgorithmException, CMSException, PKIException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, session).getSignerInfos();
    }

    private class SignerInf {
        private final SignerIdentifier signerIdentifier;
        private final String digestOID;
        private final String encOID;
        private final CMSAttributeTableGenerator sAttr;
        private final CMSAttributeTableGenerator unsAttr;
        private final AttributeTable baseSignedTable;
        private JKey prvkey;

        SignerInf(JKey key, SignerIdentifier signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.signerIdentifier = signerIdentifier;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSignedTable;
            this.prvkey = key;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)new DERNull());
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, SecureRandom random, Session session, boolean addDefaultAttributes, boolean isCounterSignature) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException, PKIException {
            byte[] tmp;
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = this.getDigestAlgorithmID();
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = String.valueOf(digestName) + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Mechanism digmech = new Mechanism(digestName);
            byte[] hash = session.digest(digmech, (byte[])content.getContent());
            JITCMSSignedDataGenerator.this._digests.put(this.digestOID, hash.clone());
            if (addDefaultAttributes) {
                Map parameters = JITCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            ASN1Set signedAttr = null;
            if (signed != null) {
                if (isCounterSignature) {
                    Hashtable tmpSigned = signed.toHashtable();
                    tmpSigned.remove(CMSAttributes.contentType);
                    signed = new AttributeTable(tmpSigned);
                }
                signedAttr = JITCMSSignedDataGenerator.this.getAttributeSet(signed);
                tmp = signedAttr.getEncoded("DER");
            } else {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                if (content != null) {
                    content.write((OutputStream)bOut);
                }
                tmp = bOut.toByteArray();
            }
            Mechanism mechanism = new Mechanism(this.GetSignMech(digestName, signatureName));
            byte[] sigBytes = session.sign(mechanism, this.prvkey, tmp);
            ASN1Set unsignedAttr = null;
            if (this.unsAttr != null) {
                Map parameters = JITCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                parameters.put("encryptedDigest", sigBytes.clone());
                AttributeTable unsigned = this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters));
                unsignedAttr = JITCMSSignedDataGenerator.this.getAttributeSet(unsigned);
            }
            AlgorithmIdentifier signAlgId = JITCMSSignedDataGenerator.this.getSignAlgorithmIdentifier(this.encOID, this.digestOID);
            return new SignerInfo(this.signerIdentifier, digAlgId, signedAttr, signAlgId, (ASN1OctetString)new DEROctetString(sigBytes), unsignedAttr);
        }

        String GetSignMech(String dig, String signame) {
            String mech = null;
            String tmp = String.valueOf(dig) + "with";
            String encmech = signame.substring(tmp.length());
            if ("RSA".equals(encmech)) {
                mech = new String(String.valueOf(tmp) + "RSAEncryption");
            } else if ("DSA".equals(encmech)) {
                mech = new String(String.valueOf(tmp) + "DSA");
            } else if ("ECDSA".equals(encmech)) {
                mech = new String(String.valueOf(tmp) + "ECDSA");
            } else if ("SM2".equals(encmech)) {
                mech = "SM3withSM2Encryption";
            }
            return mech;
        }
    }
}

