/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cms;

import cn.com.jit.ida.util.pki.cms.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;

class CMSUtils {
    private static final Runtime RUNTIME = Runtime.getRuntime();

    CMSUtils() {
    }

    static int getMaximumMemory() {
        long maxMem = RUNTIME.maxMemory();
        if (maxMem > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxMem;
    }

    static ContentInfo readContentInfo(byte[] input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static ContentInfo readContentInfo(InputStream input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input, CMSUtils.getMaximumMemory()));
    }

    static List getCertificatesFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<X509CertificateStructure> certs = new ArrayList<X509CertificateStructure>();
        try {
            for (X509Certificate x509Certificate : certStore.getCertificates(null)) {
                certs.add(X509CertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])x509Certificate.getEncoded())));
            }
            return certs;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing certs", (Exception)e);
        }
        catch (IOException e) {
            throw new CMSException("error processing certs", (Exception)e);
        }
        catch (CertificateEncodingException e) {
            throw new CMSException("error encoding certs", (Exception)e);
        }
    }

    static List getCRLsFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<CertificateList> crls = new ArrayList<CertificateList>();
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                crls.add(CertificateList.getInstance((Object)ASN1Object.fromByteArray((byte[])x509CRL.getEncoded())));
            }
            return crls;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing crls", (Exception)e);
        }
        catch (IOException e) {
            throw new CMSException("error processing crls", (Exception)e);
        }
        catch (CRLException e) {
            throw new CMSException("error encoding crls", (Exception)e);
        }
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((DEREncodable)it.next());
        }
        return new BERSet((DEREncodableVector)v);
    }

    static ASN1Set createDerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((DEREncodable)it.next());
        }
        return new DERSet((DEREncodableVector)v);
    }

    static OutputStream createBEROctetOutputStream(OutputStream s, int tagNo, boolean isExplicit, int bufferSize) throws IOException {
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(s, tagNo, isExplicit);
        if (bufferSize != 0) {
            return octGen.getOctetOutputStream(new byte[bufferSize]);
        }
        return octGen.getOctetOutputStream();
    }

    static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) throws CertificateEncodingException {
        try {
            return TBSCertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])cert.getTBSCertificate()));
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    private static ContentInfo readContentInfo(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance((Object)in.readObject());
        }
        catch (IOException e) {
            throw new CMSException("IOException reading content.", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", (Exception)e);
        }
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        return Streams.readAll(in);
    }

    public static byte[] streamToByteArray(InputStream in, int limit) throws IOException {
        return Streams.readAllLimited(in, limit);
    }
}

