/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cms;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1OutputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.BERConstructedOctetString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.DERUTCTime;
import cn.com.jit.ida.util.pki.asn1.cms.Attribute;
import cn.com.jit.ida.util.pki.asn1.cms.AttributeTable;
import cn.com.jit.ida.util.pki.asn1.cms.CMSAttributes;
import cn.com.jit.ida.util.pki.asn1.cms.ContentInfo;
import cn.com.jit.ida.util.pki.asn1.cms.IssuerAndSerialNumber;
import cn.com.jit.ida.util.pki.asn1.cms.SignedData;
import cn.com.jit.ida.util.pki.asn1.cms.SignerIdentifier;
import cn.com.jit.ida.util.pki.asn1.cms.SignerInfo;
import cn.com.jit.ida.util.pki.asn1.cms.Time;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectKeyIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.crl.X509CRL;
import cn.com.jit.ida.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class CMSSignedData {
    private ASN1EncodableVector certs = new ASN1EncodableVector();
    private ASN1EncodableVector clss = new ASN1EncodableVector();
    private ArrayList signers = new ArrayList();
    private Session session = null;
    private SignedData signedData = null;
    private byte[] msg = null;

    private CMSSignedData() {
    }

    public CMSSignedData(Session value) {
        this.session = value;
    }

    public void AddCert(X509Cert value) throws PKIException {
        this.certs.add(Parser.convertJITCertStruct2BCCertStruct(value.getCertStructure()));
    }

    public void AddCRL(X509CRL value) throws PKIException {
        this.clss.add(Parser.convertJITCertList2BCCertList(value.getCertificateList()));
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism));
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism, sAttr, unsAttr));
    }

    public byte[] GetSignedDataForByte() throws PKIException, IOException {
        if (this.signedData == null) {
            return null;
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, this.signedData);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(contentInfo);
        byte[] ret_byte = bOut.toByteArray();
        dOut.flush();
        dOut.close();
        bOut.flush();
        bOut.close();
        return ret_byte;
    }

    public InputStream GetSignedDataForInputStream() throws PKIException, IOException {
        return new ByteArrayInputStream(this.GetSignedDataForByte());
    }

    public SignedData GetSignedData() throws PKIException {
        return this.signedData;
    }

    public void GetSignedDataForFile(String FileName) throws PKIException, IOException {
        FileOutputStream fos = new FileOutputStream(FileName);
        ((OutputStream)fos).write(this.GetSignedDataForByte());
        fos.flush();
        ((OutputStream)fos).close();
    }

    public void Generate(byte[] content, boolean encapsulate, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(PKCSObjectIdentifiers.data.getId(), content, encapsulate, setIssuerAndSN);
    }

    public void Generate(byte[] content, boolean encapsulate, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(PKCSObjectIdentifiers.data.getId(), content, encapsulate, addDefaultAttributes, setIssuerAndSN);
    }

    public void Generate(String signedContentType, byte[] content, boolean encapsulate, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(signedContentType, content, encapsulate, true, setIssuerAndSN);
    }

    public void Generate(String signedContentType, byte[] content, boolean encapsulate, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
        ContentInfo encInfo;
        if (this.msg != null && this.signedData != null) {
            return;
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        Iterator it = this.signers.iterator();
        Signer signer = null;
        while (it.hasNext()) {
            signer = (Signer)it.next();
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(signer.GetDigestTypeOID()), new DERNull());
            digestAlgs.add(digAlgId);
            signerInfos.add(signer.toSignerInfo(contentTypeOID, content, addDefaultAttributes, setIssuerAndSN));
        }
        DERSet certificates = new DERSet(this.certs);
        DERSet certrevlist = new DERSet(this.clss);
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            bOut.write(content);
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
            bOut.flush();
            bOut.close();
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        this.signedData = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        this.msg = content;
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(ais.readObject());
            this.signedData = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
            this.msg = null;
        }
        catch (Exception ex) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
    }

    public void load(SignedData signedData) throws PKIException {
        this.signedData = signedData;
        this.msg = null;
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.load(data);
    }

    public byte[] getContent() throws PKIException {
        if (this.msg == null && this.signedData == null) {
            return null;
        }
        if (this.msg == null && this.signedData != null) {
            ContentInfo contentInfo = this.signedData.getEncapContentInfo();
            if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                if (contentInfo.getContent() == null) {
                    throw new PKIException("8175", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25 \u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", new Exception("no sourceData to be verify."));
                }
                this.msg = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            } else {
                this.msg = CMSSignedData.writeDERObj2Bytes(contentInfo.getContent());
            }
            return this.msg;
        }
        if (this.msg != null) {
            return this.msg;
        }
        return this.msg;
    }

    public boolean verify(byte[] sourcedata, X509Cert cert, SignerInfo signerInfo) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            return this.verifySignerInfo(sourcedata, cert, signerInfo, true);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean verify(X509Cert[] certs) {
        return this.verify(null, certs);
    }

    public boolean verify(byte[] sourcedata, X509Cert[] certs) {
        return this.verifySignerInfo(sourcedata, certs);
    }

    public boolean verify(byte[] sourcedata) {
        ArrayList CertList = new ArrayList();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        CertificateFactory cf = null;
        ASN1Set setCerts = this.signedData.getCertificates();
        X509Cert[] certs = new X509Cert[setCerts.size()];
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            if (setCerts != null) {
                Enumeration e = setCerts.getObjects();
                int index = 0;
                while (e.hasMoreElements()) {
                    aOut.writeObject(e.nextElement());
                    certs[index++] = new X509Cert(bOut.toByteArray());
                    bOut.reset();
                }
            }
            aOut.flush();
            aOut.close();
            bOut.flush();
            bOut.close();
        }
        catch (IOException ex4) {
            return false;
        }
        catch (CertificateException ex2) {
            return false;
        }
        catch (PKIException ex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
        return this.verifySignerInfo(sourcedata, certs);
    }

    public boolean verify() {
        return this.verify((byte[])null);
    }

    public boolean verify(byte[] sourceData, Map subjectKeyMap, Map issuerAndSNMap, boolean isCheckTime) {
        ASN1Set SignerInfoset = this.signedData.getSignerInfos();
        boolean TF = true;
        int i = 0;
        while (i < SignerInfoset.size()) {
            X509Cert cert = null;
            SignerInfo signerInfo = SignerInfo.getInstance(SignerInfoset.getObjectAt(i));
            SignerIdentifier signerid = signerInfo.getSID();
            if (signerid.isTagged()) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(signerid.getId());
                byte[] temp = subjectKeyIdentifier.getKeyIdentifier();
                byte[] tempBase64 = Base64.encode(temp);
                String tmepSubjectKey = new String(tempBase64);
                cert = (X509Cert)issuerAndSNMap.get((String)subjectKeyMap.get(tmepSubjectKey));
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(signerid.getId());
                String tmepIssuerAndSN = String.valueOf(iAnds.getName().toString()) + iAnds.getSerialNumber().getValue().toString();
                cert = (X509Cert)issuerAndSNMap.get(tmepIssuerAndSN);
            }
            Object certificate = null;
            if (cert == null) {
                TF = false;
                break;
            }
            try {
                if (!this.verifySignerInfo(sourceData, cert, signerInfo, isCheckTime)) {
                    TF = false;
                    break;
                }
            }
            catch (PKIException e) {
                return false;
            }
            ++i;
        }
        return TF;
    }

    private boolean verifySignerInfo(byte[] sourceData, X509Cert[] certs) {
        ASN1Set SignerInfoset = this.signedData.getSignerInfos();
        Object certCollection = null;
        boolean TF = true;
        int i = 0;
        while (i < SignerInfoset.size()) {
            SignerInfo signerInfo = SignerInfo.getInstance(SignerInfoset.getObjectAt(i));
            SignerId sid = new SignerId();
            SignerIdentifier signerid = signerInfo.getSID();
            if (signerid.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(signerid.getId());
                sid.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(signerid.getId());
                ByteArrayOutputStream sidbOut = new ByteArrayOutputStream();
                ASN1OutputStream sidaOut = new ASN1OutputStream(sidbOut);
                try {
                    sidaOut.writeObject(iAnds.getName());
                    sid.setIssuer(sidbOut.toByteArray());
                    sidaOut.flush();
                    sidaOut.close();
                    sidbOut.flush();
                    sidbOut.close();
                }
                catch (IOException ex3) {
                    TF = false;
                    break;
                }
                sid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
            try {
                if (!this.verifySignerInfo(sourceData, certs[i], signerInfo, true)) {
                    TF = false;
                }
            }
            catch (PKIException e) {
                TF = false;
            }
            ++i;
        }
        return TF;
    }

    private boolean verifySignerInfo(byte[] sourceData, X509Cert cert, SignerInfo signerInfo, boolean isCheckTime) throws PKIException {
        Time time;
        Attribute t;
        AttributeTable attr = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        if (isCheckTime && attr != null && (t = attr.get(CMSAttributes.signingTime)) != null && !cert.checkValidity((time = Time.getInstance(t.getAttrValues().getObjectAt(0).getDERObject())).getDate())) {
            return false;
        }
        return this.doVerify(cert.getPublicKey(), attr, this.GetSignMechanism(signerInfo), signerInfo.getAuthenticatedAttributes(), sourceData, signerInfo.getEncryptedDigest().getOctets());
    }

    private Mechanism GetSignMechanism(SignerInfo signerInfo) {
        String DigestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.5")) {
            return new Mechanism("SHA1withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.11")) {
            return new Mechanism("SHA256withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.12")) {
            return new Mechanism("SHA384withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.13")) {
            return new Mechanism("SHA512withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.4")) {
            return new Mechanism("MD5withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.113549.1.1.2")) {
            return new Mechanism("MD2withRSAEncryption");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.10045.4.1")) {
            return new Mechanism("SHA1withECDSA");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.10045.4.3.1")) {
            return new Mechanism("SHA224withECDSA");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.10045.4.3.2")) {
            return new Mechanism("SHA256withECDSA");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.840.10040.4.3")) {
            return new Mechanism("SHA1withDSA");
        }
        if (DigestEncryptionAlgorithm.equals("2.16.840.1.101.3.4.3.1")) {
            return new Mechanism("SHA224withDSA");
        }
        if (DigestEncryptionAlgorithm.equals("2.16.840.1.101.3.4.3.2")) {
            return new Mechanism("SHA256withDSA");
        }
        if (DigestEncryptionAlgorithm.equals("1.2.156.10197.1.301.1")) {
            return new Mechanism("SM3withSM2Encryption");
        }
        String strDig = signerInfo.getDigestAlgorithm().getObjectId().getId();
        if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
            return new Mechanism("SHA1withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
            return new Mechanism("SHA224withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
            return new Mechanism("SHA256withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
            return new Mechanism("SHA384withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
            return new Mechanism("SHA512withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
            return new Mechanism("MD2withRSAEncryption");
        }
        if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
            return new Mechanism("MD5withRSAEncryption");
        }
        return null;
    }

    private String GetDigestTypeName(Mechanism signmechanism) throws PKIException {
        String digestTypeName = null;
        if (signmechanism.getMechanismType().equals("MD2withRSAEncryption")) {
            digestTypeName = "MD2";
        } else if (signmechanism.getMechanismType().equals("MD5withRSAEncryption")) {
            digestTypeName = "MD5";
        } else if (signmechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
            digestTypeName = "SHA1";
        } else if (signmechanism.getMechanismType().equals("SHA1withDSA")) {
            digestTypeName = "SHA1";
        } else if (signmechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
            digestTypeName = "SHA256";
        } else if (signmechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
            digestTypeName = "SHA384";
        } else if (signmechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
            digestTypeName = "SHA512";
        } else if (signmechanism.getMechanismType().equals("SHA1withECDSA")) {
            digestTypeName = "SHA1";
        } else if (signmechanism.getMechanismType().equals("SHA224withECDSA")) {
            digestTypeName = "SHA224";
        } else if (signmechanism.getMechanismType().equals("SHA256withECDSA")) {
            digestTypeName = "SHA256";
        } else if (signmechanism.getMechanismType().equals("SHA1withDSA")) {
            digestTypeName = "SHA1";
        } else if (signmechanism.getMechanismType().equals("SHA224withDSA")) {
            digestTypeName = "SHA224";
        } else if (signmechanism.getMechanismType().equals("SHA256withDSA")) {
            digestTypeName = "SHA256";
        } else if (signmechanism.getMechanismType().equals("SM3withSM2Encryption")) {
            digestTypeName = "SM3";
        } else {
            StringBuffer error = new StringBuffer();
            error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
            error.append(" ");
            error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
            error.append(" ");
            error.append(signmechanism.getMechanismType());
            throw new PKIException("8125", error.toString());
        }
        return digestTypeName;
    }

    private boolean doVerify(JKey key, AttributeTable signedAttrTable, Mechanism signmechanism, ASN1Set signedAttributes, byte[] sourceData, byte[] signdata) throws PKIException {
        block16: {
            Attribute type;
            Attribute dig;
            block15: {
                block14: {
                    if (sourceData == null) {
                        if (this.msg != null) {
                            sourceData = this.msg;
                        } else {
                            try {
                                sourceData = this.getContent();
                            }
                            catch (PKIException ex1) {
                                return false;
                            }
                        }
                        if (sourceData == null) {
                            return false;
                        }
                    }
                    if (signmechanism == null) {
                        return false;
                    }
                    if (signedAttrTable == null) {
                        return this.session.verifySign(signmechanism, key, sourceData, signdata);
                    }
                    byte[] hash = this.session.digest(new Mechanism(this.GetDigestTypeName(signmechanism)), sourceData);
                    dig = signedAttrTable.get(CMSAttributes.messageDigest);
                    type = signedAttrTable.get(CMSAttributes.contentType);
                    if (dig != null) break block14;
                    return false;
                }
                if (type != null) break block15;
                return false;
            }
            byte[] signedHash = ((ASN1OctetString)dig.getAttrValues().getObjectAt(0)).getOctets();
            DERObjectIdentifier typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0);
            if (typeOID.equals(this.signedData.getEncapContentInfo().getContentType())) break block16;
            return false;
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(signedAttributes);
            byte[] bytedata = bOut.toByteArray();
            dOut.flush();
            dOut.close();
            bOut.flush();
            bOut.close();
            return this.session.verifySign(signmechanism, key, bytedata, signdata);
        }
        catch (PKIException ex) {
            return false;
        }
        catch (IOException ex1) {
            return false;
        }
    }

    private static byte[] writeDERObj2Bytes(DEREncodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            byte[] byteData = bos.toByteArray();
            dos.flush();
            dos.close();
            bos.flush();
            bos.close();
            return byteData;
        }
        catch (Exception ex) {
            throw new PKIException("8136", "\u83b7\u53d6DER\u5bf9\u8c61byte\u7f16\u7801\u5931\u8d25", ex);
        }
    }

    public static void main(String[] args) throws Exception {
        JCrypto jcrypto = JCrypto.getInstance();
        jcrypto.initialize("JSJY05B_LIB", null);
        Session session = jcrypto.openSession("JSJY05B_LIB");
        CMSSignedData cmsSignedData = new CMSSignedData(session);
        X509Certificate cert = null;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        FileInputStream fis = new FileInputStream("d:\\sm2.cer");
        cert = (X509Certificate)certFactory.generateCertificate(fis);
        fis.close();
        X509Cert x509 = new X509Cert(cert.getEncoded());
        Mechanism mech = new Mechanism("SM2");
        JKeyPair hardKeyPair = session.generateKeyPair(mech, 256);
        cmsSignedData.AddSigner(hardKeyPair.getPrivateKey(), x509, new Mechanism("SM3withSM2Encryption"));
        cmsSignedData.Generate("hello word".getBytes(), true, true);
        cmsSignedData.GetSignedDataForFile("d:/signeddatanotcert.bin");
    }

    private class Signer {
        JKey privateKey = null;
        X509Cert cert = null;
        Mechanism sign_Mechanism = null;
        AttributeTable sAttr = null;
        AttributeTable unsAttr = null;
        Session session = null;

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
        }

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
        }

        AttributeTable getSignedAttributes() {
            return this.sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this.unsAttr;
        }

        JKey getKey() {
            return this.privateKey;
        }

        X509Cert getCertificate() {
            return this.cert;
        }

        Mechanism getSignMechanism() {
            return this.sign_Mechanism;
        }

        String GetDigestTypeName() throws PKIException {
            String digestTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeName = "MD2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeName = "MD5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                digestTypeName = "SHA256";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                digestTypeName = "SHA384";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                digestTypeName = "SHA512";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                digestTypeName = "SHA224";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                digestTypeName = "SHA256";
            } else if (this.sign_Mechanism.getMechanismType().equals("SM3withSM2Encryption")) {
                digestTypeName = "SM3";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8195", error.toString());
            }
            return digestTypeName;
        }

        String GetEncTypeName() throws PKIException {
            String EncTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                EncTypeName = "DSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                EncTypeName = "ECDSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SM3withSM2Encryption")) {
                EncTypeName = "SM2";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return EncTypeName;
        }

        private String GetSignatureAlgTypeOID() {
            String SignatureAlgorithm = this.sign_Mechanism.getMechanismType();
            if (SignatureAlgorithm.equals("SHA1withRSAEncryption")) {
                return "1.2.840.113549.1.1.5";
            }
            if (SignatureAlgorithm.equals("SHA256withRSAEncryption")) {
                return "1.2.840.113549.1.1.11";
            }
            if (SignatureAlgorithm.equals("SHA384withRSAEncryption")) {
                return "1.2.840.113549.1.1.12";
            }
            if (SignatureAlgorithm.equals("SHA512withRSAEncryption")) {
                return "1.2.840.113549.1.1.13";
            }
            if (SignatureAlgorithm.equals("MD5withRSAEncryption")) {
                return "1.2.840.113549.1.1.4";
            }
            if (SignatureAlgorithm.equals("MD2withRSAEncryption")) {
                return "1.2.840.113549.1.1.2";
            }
            if (SignatureAlgorithm.equals("SHA1withECDSA")) {
                return "1.2.840.10045.4.1";
            }
            if (SignatureAlgorithm.equals("SHA224withECDSA")) {
                return "1.2.840.10045.4.3.1";
            }
            if (SignatureAlgorithm.equals("SHA256withECDSA")) {
                return "1.2.840.10045.4.3.2";
            }
            if (SignatureAlgorithm.equals("SHA1withDSA")) {
                return "1.2.840.10040.4.3";
            }
            if (SignatureAlgorithm.equals("SHA224withDSA")) {
                return "2.16.840.1.101.3.4.3.1";
            }
            if (SignatureAlgorithm.equals("SHA256withDSA")) {
                return "2.16.840.1.101.3.4.3.2";
            }
            if (SignatureAlgorithm.equals("SM3withSM2Encryption")) {
                return "1.2.156.10197.1.501";
            }
            return null;
        }

        String GetDigestTypeOID() throws PKIException {
            String digestTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.4";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.4";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                digestTypeOID = "2.16.840.1.101.3.4.2.1";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return digestTypeOID;
        }

        String GetEncTypeOID() throws PKIException {
            String EncTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeOID = "1.2.840.10040.4.3";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA384withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA512withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.3.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withECDSA")) {
                EncTypeOID = "1.2.840.10045.4.3.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA224withDSA")) {
                EncTypeOID = "2.16.840.1.101.3.4.3.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA256withDSA")) {
                EncTypeOID = "2.16.840.1.101.3.4.3.2";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("8125", error.toString());
            }
            return EncTypeOID;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, byte[] content, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
            ASN1EncodableVector v;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.GetDigestTypeOID()), new DERNull());
            AlgorithmIdentifier encAlgId = this.GetEncTypeOID().equals("1.2.840.10040.4.3") ? new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID()), new DERNull());
            AlgorithmIdentifier digEncAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.GetSignatureAlgTypeOID()), new DERNull());
            DERSet signedAttr = null;
            DERSet unsignedAttr = null;
            Object sig = null;
            Object dig = null;
            byte[] hash = this.session.digest(new Mechanism(this.GetDigestTypeName()), content);
            AttributeTable attr = this.getSignedAttributes();
            if (attr != null) {
                v = new ASN1EncodableVector();
                if (attr.get(CMSAttributes.contentType) == null) {
                    v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                } else {
                    v.add(attr.get(CMSAttributes.contentType));
                }
                if (attr.get(CMSAttributes.signingTime) == null) {
                    v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))));
                } else {
                    v.add(attr.get(CMSAttributes.signingTime));
                }
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                Hashtable ats = attr.toHashtable();
                ats.remove(CMSAttributes.contentType);
                ats.remove(CMSAttributes.signingTime);
                ats.remove(CMSAttributes.messageDigest);
                Iterator it = ats.values().iterator();
                while (it.hasNext()) {
                    v.add(Attribute.getInstance(it.next()));
                }
                signedAttr = new DERSet(v);
            } else if (addDefaultAttributes) {
                v = new ASN1EncodableVector();
                v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new DERUTCTime(new Date()))));
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                signedAttr = new DERSet(v);
            }
            attr = this.getUnsignedAttributes();
            if (attr != null) {
                Hashtable ats = attr.toHashtable();
                Iterator it = ats.values().iterator();
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                while (it.hasNext()) {
                    v2.add(Attribute.getInstance(it.next()));
                }
                unsignedAttr = new DERSet(v2);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
                dOut.flush();
                dOut.close();
            } else {
                bOut.write(content);
            }
            DEROctetString encDigest = new DEROctetString(this.session.sign(this.sign_Mechanism, this.privateKey, bOut.toByteArray()));
            ByteArrayInputStream bIn = new ByteArrayInputStream(this.cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            SignerInfo signerInfo = null;
            if (setIssuerAndSN) {
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, digEncAlgId, encDigest, unsignedAttr);
            } else {
                X509CertificateStructure certificateStructure = this.cert.getCertStructure();
                SubjectPublicKeyInfo subjectKeyInfo = certificateStructure.getSubjectPublicKeyInfo();
                SubjectKeyIdentifier sujectKeyIdentifer = new SubjectKeyIdentifier(subjectKeyInfo);
                ASN1OctetString encSid = (ASN1OctetString)sujectKeyIdentifer.getDERObject();
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
            }
            bOut.flush();
            bOut.close();
            aIn.close();
            bIn.close();
            return signerInfo;
        }
    }

    private class SignerId
    extends X509CertSelector {
        private SignerId() {
        }

        public int hashCode() {
            byte[] subjectId;
            int code = 0;
            if (this.getSerialNumber() != null) {
                code ^= this.getSerialNumber().hashCode();
            }
            if (this.getIssuerAsString() != null) {
                code ^= this.getIssuerAsString().hashCode();
            }
            if ((subjectId = this.getSubjectKeyIdentifier()) != null) {
                int i = 0;
                while (i != subjectId.length) {
                    code ^= (subjectId[i] & 0xFF) << i % 4;
                    ++i;
                }
            }
            return code;
        }

        public boolean equals(Object o) {
            byte[] otherId;
            if (!(o instanceof SignerId)) {
                return false;
            }
            SignerId id = (SignerId)o;
            if (id.getSerialNumber() != null && !id.getSerialNumber().equals(this.getSerialNumber())) {
                return false;
            }
            if (id.getIssuerAsString() != null && !id.getIssuerAsString().equals(this.getIssuerAsString())) {
                return false;
            }
            byte[] subjectId = this.getSubjectKeyIdentifier();
            return subjectId == null || (otherId = id.getSubjectKeyIdentifier()) != null && Arrays.equals(subjectId, otherId);
        }
    }
}

