/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.softsm;

import cn.com.jit.ida.util.pki.ECDSAParser;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2Result;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class Util {
    public static byte[] byteconvert32(BigInteger b) {
        byte[] tmpd = null;
        if (b == null) {
            return null;
        }
        if (b.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(b.toByteArray(), 1, tmpd, 0, 32);
        } else if (b.toByteArray().length == 32) {
            tmpd = b.toByteArray();
        } else {
            tmpd = new byte[32];
            int i = 0;
            while (i < 32 - b.toByteArray().length) {
                tmpd[i] = 0;
                ++i;
            }
            System.arraycopy(b.toByteArray(), 0, tmpd, 32 - b.toByteArray().length, b.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteconvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static byte[] hardKey2SoftPubKey(JKey pubKey) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(pubKey.getKey());
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)derObj);
        byte[] pubKeyData = spki.getPublicKeyData().getBytes();
        return pubKeyData;
    }

    public static BigInteger hardKey2SoftPrivKey(JKey privKey) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(privKey.getKey());
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        DEROctetString prv = (DEROctetString)((ASN1Sequence)derObj).getObjectAt(1);
        byte[] retbyte = prv.getOctets();
        BigInteger ret = Util.byteconvertInteger(retbyte);
        return ret;
    }

    public static byte[] soft2HardSignData(BigInteger r, BigInteger s) throws Exception {
        DERInteger d_r = new DERInteger(r);
        DERInteger d_s = new DERInteger(s);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)d_r);
        v.add((DEREncodable)d_s);
        org.bouncycastle.asn1.DERSequence sign = new org.bouncycastle.asn1.DERSequence((DEREncodableVector)v);
        byte[] signdata = sign.getDEREncoded();
        return signdata;
    }

    public static SM2Result Hard2softSignData(byte[] signdata) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(signdata);
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        Enumeration e = ((ASN1Sequence)derObj).getObjects();
        BigInteger r = ((DERInteger)e.nextElement()).getValue();
        BigInteger s = ((DERInteger)e.nextElement()).getValue();
        SM2Result sm2result = new SM2Result();
        sm2result.r = r;
        sm2result.s = s;
        return sm2result;
    }

    public static JKeyPair getSM2Key(ECPublicKeyParameters pubparam, ECPrivateKeyParameters priparam) throws Exception {
        if (pubparam == null && priparam == null) {
            return null;
        }
        Object keyPair = null;
        ECPoint userKey = null;
        BigInteger userD = null;
        byte[] tmpq = null;
        byte[] tmpd = null;
        JKey publicKey = null;
        JKey privateKey = null;
        if (pubparam != null) {
            userKey = pubparam.getQ();
            tmpq = new byte[userKey.getEncoded().length - 1];
            System.arraycopy(userKey.getEncoded(), 1, tmpq, 0, userKey.getEncoded().length - 1);
            publicKey = new JKey("SM2_Public", ECDSAParser.customData2SoftPublicKey(tmpq, null));
        }
        if (priparam != null) {
            userD = priparam.getD();
            tmpd = Util.byteconvert32(userD);
            if (tmpq != null) {
                privateKey = new JKey("SM2_Private", ECDSAParser.customData2SoftECPrivKey(tmpq, tmpd));
            }
        }
        return new JKeyPair(publicKey, privateKey);
    }

    public static byte[] encedDataEncode(ECPoint pubQ, byte[] dig, byte[] enc) throws Exception {
        cn.com.jit.ida.util.pki.asn1.DERInteger x = new cn.com.jit.ida.util.pki.asn1.DERInteger(pubQ.getX().toBigInteger());
        cn.com.jit.ida.util.pki.asn1.DERInteger y = new cn.com.jit.ida.util.pki.asn1.DERInteger(pubQ.getY().toBigInteger());
        cn.com.jit.ida.util.pki.asn1.DEROctetString derDig = new cn.com.jit.ida.util.pki.asn1.DEROctetString(dig);
        cn.com.jit.ida.util.pki.asn1.DEROctetString derEnc = new cn.com.jit.ida.util.pki.asn1.DEROctetString(enc);
        cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector v = new cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector();
        v.add(x);
        v.add(y);
        v.add(derDig);
        v.add(derEnc);
        DERSequence seq = new DERSequence(v);
        return Parser.writeDERObj2Bytes(seq);
    }

    public static List getXY(byte[] encedData) throws Exception {
        DERSequence der = (DERSequence)Parser.writeBytes2DERObj(encedData);
        cn.com.jit.ida.util.pki.asn1.DERInteger x = (cn.com.jit.ida.util.pki.asn1.DERInteger)der.getObjectAt(0);
        cn.com.jit.ida.util.pki.asn1.DERInteger y = (cn.com.jit.ida.util.pki.asn1.DERInteger)der.getObjectAt(1);
        ArrayList<BigInteger> ls = new ArrayList<BigInteger>();
        ls.add(x.getValue());
        ls.add(y.getValue());
        return ls;
    }

    public static byte[] getEnc(byte[] encedData) throws Exception {
        DERSequence der = (DERSequence)Parser.writeBytes2DERObj(encedData);
        cn.com.jit.ida.util.pki.asn1.DEROctetString data = (cn.com.jit.ida.util.pki.asn1.DEROctetString)der.getObjectAt(3);
        return data.getOctets();
    }

    public static BigInteger getPrivKeyD(JKey privKey) throws Exception {
        DERSequence der = (DERSequence)Parser.writeBytes2DERObj(privKey.getKey());
        byte[] data = ((cn.com.jit.ida.util.pki.asn1.DEROctetString)der.getObjectAt(1)).getOctets();
        return Util.byteconvertInteger(data);
    }

    public static JKey getPrvKey(byte[] data) throws Exception {
        BigInteger sftd = Util.byteconvertInteger(data);
        SM2 sm2 = SM2.Instance();
        ECPoint ecpub = null;
        ecpub = sm2.ecc_point_g.multiply(sftd);
        byte[] tmpq = new byte[ecpub.getEncoded().length - 1];
        System.arraycopy(ecpub.getEncoded(), 1, tmpq, 0, ecpub.getEncoded().length - 1);
        JKey privateKey = new JKey("SM2_Private", ECDSAParser.customData2SoftECPrivKey(tmpq, data));
        return privateKey;
    }
}

