/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.softsm;

import cn.com.jit.ida.util.pki.cipher.softsm.GeneralDigest;
import cn.com.jit.ida.util.pki.cipher.softsm.SupportClass;
import org.bouncycastle.util.encoders.Hex;

public class SM3Digest
extends GeneralDigest {
    private int DIGEST_LENGTH = 32;
    private static final int[] v0 = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private int[] v = new int[8];
    private int[] v_ = new int[8];
    private static final int[] X0 = new int[16];
    private int[] X = new int[68];
    private int xOff;
    private int T_00_15 = 2043430169;
    private int T_16_63 = 2055708042;

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return this.DIGEST_LENGTH;
    }

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest t) {
        super(t);
        System.arraycopy(t.X, 0, this.X, 0, t.X.length);
        this.xOff = t.xOff;
        System.arraycopy(t.v, 0, this.v, 0, t.v.length);
    }

    public void reset() {
        super.reset();
        System.arraycopy(v0, 0, this.v, 0, v0.length);
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    public void ProcessBlock() {
        int TT2;
        int TT1;
        int SS2;
        int SS1;
        int aaa;
        int[] ww = this.X;
        int[] ww_ = new int[64];
        int i = 16;
        while (i < 68) {
            ww[i] = this.P1(ww[i - 16] ^ ww[i - 9] ^ this.ROTATE(ww[i - 3], 15)) ^ this.ROTATE(ww[i - 13], 7) ^ ww[i - 6];
            ++i;
        }
        i = 0;
        while (i < 64) {
            ww_[i] = ww[i] ^ ww[i + 4];
            ++i;
        }
        int[] vv = this.v;
        int[] vv_ = this.v_;
        System.arraycopy(vv, 0, vv_, 0, v0.length);
        i = 0;
        while (i < 16) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_00_15, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_00_15(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_00_15(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
            ++i;
        }
        i = 16;
        while (i < 64) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_16_63, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_16_63(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_16_63(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
            ++i;
        }
        i = 0;
        while (i < 8) {
            int n = i;
            vv[n] = vv[n] ^ vv_[i];
            ++i;
        }
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    public void ProcessWord(byte[] in_Renamed, int inOff) {
        int n = in_Renamed[inOff] << 24;
        n |= (in_Renamed[++inOff] & 0xFF) << 16;
        n |= (in_Renamed[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in_Renamed[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.ProcessBlock();
        }
    }

    public void ProcessLength(long bitLength) {
        if (this.xOff > 14) {
            this.ProcessBlock();
        }
        this.X[14] = (int)SupportClass.URShift(bitLength, 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    public static void IntToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)SupportClass.URShift(n, 24);
        bs[++off] = (byte)SupportClass.URShift(n, 16);
        bs[++off] = (byte)SupportClass.URShift(n, 8);
        bs[++off] = (byte)n;
    }

    public int doFinal(byte[] out_Renamed, int outOff) {
        this.Finish();
        int i = 0;
        while (i < 8) {
            SM3Digest.IntToBigEndian(this.v[i], out_Renamed, outOff + i * 4);
            ++i;
        }
        this.reset();
        return this.DIGEST_LENGTH;
    }

    private int ROTATE(int x, int n) {
        return x << n | SupportClass.URShift(x, 32 - n);
    }

    private int P0(int X) {
        return X ^ this.ROTATE(X, 9) ^ this.ROTATE(X, 17);
    }

    private int P1(int X) {
        return X ^ this.ROTATE(X, 15) ^ this.ROTATE(X, 23);
    }

    private int FF_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int FF_16_63(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private int GG_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int GG_16_63(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    public static void main(String[] args) {
        byte[] msg1 = "abc".getBytes();
        byte[] msg2 = "abcd".getBytes();
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.BlockUpdate(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        System.out.println(s);
        SM3Digest sm31 = new SM3Digest();
        byte[] md1 = new byte[32];
        int i = 0;
        while (i < 16) {
            sm31.BlockUpdate(msg2, 0, msg2.length);
            ++i;
        }
        sm31.doFinal(md1, 0);
        String s1 = new String(Hex.encode((byte[])md1));
        System.out.println(s1);
        SM3Digest sm3_ = new SM3Digest();
        sm3_.BlockUpdate(msg2, 0, msg2.length);
        sm3 = new SM3Digest(sm3_);
        int i2 = 1;
        while (i2 < 16) {
            sm3.BlockUpdate(msg2, 0, msg2.length);
            ++i2;
        }
        sm3.doFinal(md, 0);
        String s2 = new String(Hex.encode((byte[])md));
        System.out.println(s2);
    }

    public void update(byte[] in, int inOff, int len) {
    }
}

