/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.softsm;

import cn.com.jit.ida.util.pki.cipher.softsm.SM2;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2Result;
import cn.com.jit.ida.util.pki.cipher.softsm.SM3Digest;
import cn.com.jit.ida.util.pki.cipher.softsm.Util;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class KeyExchange {
    private SM2 sm2;
    private BigInteger userD;
    private ECPoint userKey;
    private BigInteger rD;
    private ECPoint rKey;
    private BigInteger _2w;
    private BigInteger _2w_1;
    private int ct = 1;
    private SM3Digest sm3keybase = null;
    private int keyOff = 0;
    private byte[] key = null;

    public void Init(SM2 sm2, BigInteger userD, ECPoint userKey) {
        this.sm2 = sm2;
        this.userD = userD;
        this.userKey = userKey;
        AsymmetricCipherKeyPair keypair = null;
        keypair = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
        this.rD = ecpriv.getD();
        this.rKey = ecpub.getQ();
        int w = sm2.ecc_n.bitLength();
        w = w / 2 - 1;
        this._2w = BigInteger.ONE.shiftLeft(w);
        this._2w_1 = this._2w.subtract(BigInteger.ONE);
    }

    public void Init_test_a(SM2 sm2, BigInteger userD, ECPoint userKey) {
        this.Init(sm2, userD, userKey);
        this.rD = new BigInteger("83A2C9C8B96E5AF70BD480B472409A9A327257F1EBB73F5B073354B248668563", 16);
        this.rKey = sm2.ecc_point_g.multiply(this.rD);
    }

    public void Init_test_b(SM2 sm2, BigInteger userD, ECPoint userKey) {
        this.Init(sm2, userD, userKey);
        this.rD = new BigInteger("33FE21940342161C55619C4A0C060293D543C80AF19748CE176D83477DE71C80", 16);
        this.rKey = sm2.ecc_point_g.multiply(this.rD);
    }

    public void DoA_1_3(SM2Result sm2Ret) {
        sm2Ret.keyra = this.rKey;
    }

    public void DoB_1_10(byte[] ida, byte[] idb, ECPoint keyusera, ECPoint keyra, SM2Result sm2Ret) {
        sm2Ret.keyrb = this.rKey;
        sm2Ret.sb = null;
        sm2Ret.s2 = null;
        byte[] za = null;
        byte[] zb = null;
        if (ida != null) {
            za = this.sm2.Sm2GetZ(ida, keyusera);
        }
        if (idb != null) {
            zb = this.sm2.Sm2GetZ(idb, this.userKey);
        }
        BigInteger x2_ = this._2w.add(this.rKey.getX().toBigInteger().and(this._2w_1));
        System.out.println("x2_ = \n" + x2_.toString(16));
        BigInteger tb = this.userD.add(this.rD.multiply(x2_)).mod(this.sm2.ecc_n);
        System.out.println("tb = \n" + tb.toString(16));
        BigInteger x1_ = this._2w.add(keyra.getX().toBigInteger().and(this._2w_1));
        System.out.println("x1_ = \n" + x1_.toString(16));
        ECPoint pa0 = keyra.multiply(x1_);
        System.out.println("pa0 (x,y) = ");
        System.out.println(pa0.getX().toBigInteger().toString(16));
        System.out.println(pa0.getY().toBigInteger().toString(16));
        ECPoint pa1 = keyusera.add(pa0);
        System.out.println("pa1 (x,y) = ");
        System.out.println(pa1.getX().toBigInteger().toString(16));
        System.out.println(pa1.getY().toBigInteger().toString(16));
        ECPoint pv = pa1.multiply(tb.multiply(this.sm2.ecc_bc_spec.getH()));
        System.out.println("pv (x,y) = ");
        System.out.println(pv.getX().toBigInteger().toString(16));
        System.out.println(pv.getY().toBigInteger().toString(16));
        if (pv.isInfinity()) {
            return;
        }
        this.sm3keybase = new SM3Digest();
        byte[] p = Util.byteconvert32(pv.getX().toBigInteger());
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(pv.getY().toBigInteger());
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = za;
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = zb;
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        this.ct = 1;
        this.key = new byte[32];
        this.keyOff = 0;
        this.NextKey();
        byte[] mdb = new byte[32];
        byte[] mdsb = new byte[32];
        byte[] mds2 = new byte[32];
        SM3Digest hashb = new SM3Digest();
        p = Util.byteconvert32(pv.getX().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        if (za != null) {
            hashb.BlockUpdate(za, 0, za.length);
        }
        if (zb != null) {
            hashb.BlockUpdate(zb, 0, zb.length);
        }
        p = Util.byteconvert32(keyra.getX().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(keyra.getY().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(this.rKey.getX().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(this.rKey.getY().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        hashb.doFinal(mdb, 0);
        String smd = new String(Hex.encode((byte[])mdb));
        System.out.println("hash1 = \n" + smd);
        hashb.reset();
        hashb.update((byte)2);
        p = Util.byteconvert32(pv.getY().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        p = mdb;
        hashb.BlockUpdate(p, 0, p.length);
        hashb.doFinal(mdsb, 0);
        String smdsb = new String(Hex.encode((byte[])mdsb));
        System.out.println("sb = \n" + smdsb);
        hashb.reset();
        hashb.update((byte)3);
        p = Util.byteconvert32(pv.getY().toBigInteger());
        hashb.BlockUpdate(p, 0, p.length);
        p = mdb;
        hashb.BlockUpdate(p, 0, p.length);
        hashb.doFinal(mds2, 0);
        String smds2 = new String(Hex.encode((byte[])mds2));
        System.out.println("s2 = \n" + smds2);
        sm2Ret.s2 = mds2;
        sm2Ret.sb = mdsb;
    }

    public void DoA_4_10(byte[] ida, byte[] idb, ECPoint keyuserb, ECPoint keyrb, SM2Result sm2Ret) {
        sm2Ret.keyra = this.rKey;
        sm2Ret.sa = null;
        sm2Ret.s1 = null;
        byte[] za = null;
        byte[] zb = null;
        if (ida != null) {
            za = this.sm2.Sm2GetZ(ida, this.userKey);
        }
        if (idb != null) {
            zb = this.sm2.Sm2GetZ(idb, keyuserb);
        }
        BigInteger x1_a = this._2w.add(this.rKey.getX().toBigInteger().and(this._2w_1));
        System.out.println("x1_a = \n" + x1_a.toString(16));
        BigInteger x2_a = this._2w.add(keyrb.getX().toBigInteger().and(this._2w_1));
        System.out.println("x2_a = \n" + x2_a.toString(16));
        BigInteger ta = this.userD.add(this.rD.multiply(x1_a)).mod(this.sm2.ecc_n);
        System.out.println("ta = \n" + ta.toString(16));
        ECPoint pb0 = keyrb.multiply(x2_a);
        System.out.println("pb0 (x,y) = ");
        System.out.println(pb0.getX().toBigInteger().toString(16));
        System.out.println(pb0.getY().toBigInteger().toString(16));
        ECPoint pb1 = keyuserb.add(pb0);
        System.out.println("pb1 (x,y) = ");
        System.out.println(pb1.getX().toBigInteger().toString(16));
        System.out.println(pb1.getY().toBigInteger().toString(16));
        ECPoint pu = pb1.multiply(ta.multiply(this.sm2.ecc_bc_spec.getH()));
        System.out.println("pu (x,y) = ");
        System.out.println(pu.getX().toBigInteger().toString(16));
        System.out.println(pu.getY().toBigInteger().toString(16));
        if (pu.isInfinity()) {
            return;
        }
        SM3Digest sm3keybase1 = new SM3Digest();
        byte[] p1 = Util.byteconvert32(pu.getX().toBigInteger());
        sm3keybase1.BlockUpdate(p1, 0, p1.length);
        p1 = Util.byteconvert32(pu.getY().toBigInteger());
        sm3keybase1.BlockUpdate(p1, 0, p1.length);
        p1 = za;
        sm3keybase1.BlockUpdate(p1, 0, p1.length);
        p1 = zb;
        sm3keybase1.BlockUpdate(p1, 0, p1.length);
        this.sm3keybase = new SM3Digest();
        byte[] p = Util.byteconvert32(pu.getX().toBigInteger());
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(pu.getY().toBigInteger());
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = za;
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        p = zb;
        this.sm3keybase.BlockUpdate(p, 0, p.length);
        this.ct = 1;
        this.key = new byte[32];
        this.keyOff = 0;
        this.NextKey();
        byte[] mda = new byte[32];
        byte[] mdsa = new byte[32];
        byte[] mds1 = new byte[32];
        SM3Digest hasha = new SM3Digest();
        p = Util.byteconvert32(pu.getX().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        if (za != null) {
            hasha.BlockUpdate(za, 0, za.length);
        }
        if (zb != null) {
            hasha.BlockUpdate(zb, 0, zb.length);
        }
        p = Util.byteconvert32(this.rKey.getX().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(this.rKey.getY().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(keyrb.getX().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        p = Util.byteconvert32(keyrb.getY().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        hasha.doFinal(mda, 0);
        String smd1 = new String(Hex.encode((byte[])mda));
        System.out.println("hash1 = \n" + smd1);
        hasha.reset();
        hasha.update((byte)3);
        p = Util.byteconvert32(pu.getY().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        p = mda;
        hasha.BlockUpdate(p, 0, p.length);
        hasha.doFinal(mdsa, 0);
        String smdsa = new String(Hex.encode((byte[])mdsa));
        System.out.println("sa = \n" + smdsa);
        hasha.reset();
        hasha.update((byte)2);
        p = Util.byteconvert32(pu.getY().toBigInteger());
        hasha.BlockUpdate(p, 0, p.length);
        p = mda;
        hasha.BlockUpdate(p, 0, p.length);
        hasha.doFinal(mds1, 0);
        String smds1 = new String(Hex.encode((byte[])mds1));
        System.out.println("s1 = \n" + smds1);
        sm2Ret.s1 = mds1;
        sm2Ret.sa = mdsa;
    }

    public void GetKey(byte[] keybuf) {
        int i = 0;
        while (i < keybuf.length) {
            if (this.keyOff == this.key.length) {
                this.NextKey();
            }
            keybuf[i] = this.key[this.keyOff++];
            ++i;
        }
    }

    private void NextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3keybase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }
}

