/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.softsm;

import org.bouncycastle.crypto.Digest;

public abstract class GeneralDigest
implements Digest {
    private int BYTE_LENGTH = 64;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;

    public GeneralDigest() {
        this.xBuf = new byte[4];
    }

    public GeneralDigest(GeneralDigest t) {
        this.xBuf = new byte[t.xBuf.length];
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        this.xBufOff = t.xBufOff;
        this.byteCount = t.byteCount;
    }

    public void update(byte input) {
        this.xBuf[this.xBufOff++] = input;
        if (this.xBufOff == this.xBuf.length) {
            this.ProcessWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void BlockUpdate(byte[] input, int inOff, int length) {
        while (this.xBufOff != 0 && length > 0) {
            this.update(input[inOff]);
            ++inOff;
            --length;
        }
        while (length > this.xBuf.length) {
            this.ProcessWord(input, inOff);
            inOff += this.xBuf.length;
            length -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (length > 0) {
            this.update(input[inOff]);
            ++inOff;
            --length;
        }
    }

    public void Finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.ProcessLength(bitLength);
        this.ProcessBlock();
    }

    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        int i = 0;
        while (i < this.xBuf.length) {
            this.xBuf[i] = 0;
            ++i;
        }
    }

    public int GetByteLength() {
        return this.BYTE_LENGTH;
    }

    public abstract void ProcessWord(byte[] var1, int var2);

    public abstract void ProcessLength(long var1);

    public abstract void ProcessBlock();

    public abstract String getAlgorithmName();

    public abstract int getDigestSize();

    public abstract int doFinal(byte[] var1, int var2);

    public abstract void update(byte[] var1, int var2, int var3);
}

