/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.param;

import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.param.p7CertInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7digInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7recInfo;
import cn.com.jit.ida.util.pki.cipher.param.p7signInfo;
import cn.com.jit.ida.util.pki.crl.X509CRL;
import cn.com.jit.ida.util.pki.tsp.TSTInfo;

public class P7Param {
    private JKey prvKey = null;
    private JKey sysKey = null;
    private Mechanism encMech = null;
    private Mechanism signMech = null;
    private Mechanism[] envMech = null;
    private X509Cert[] signCerts = null;
    private X509Cert[] encCerts = null;
    private X509CRL[] crls = null;
    private DERObject[] authData = null;
    private DERObject[] unauthData = null;
    private byte[] data = null;
    private byte[] encedData = null;
    private p7signInfo[] signInfos = null;
    private p7digInfo digInfo = null;
    private p7recInfo[] recInfos = null;
    private TSTInfo tstInfo = null;
    private p7CertInfo[] signCertInfos = null;
    private p7CertInfo[] encCertInfos = null;

    public void P7Param() {
    }

    public void SetSignParam(JKey prvKey, Mechanism signMech, X509Cert[] signCerts, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData) {
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.signCerts = signCerts;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        this.signCertInfos = new p7CertInfo[signCerts.length];
        int i = 0;
        while (i < signCerts.length) {
            this.signCertInfos[i] = new p7CertInfo(signCerts[i]);
            ++i;
        }
    }

    public void SetSignParam(JKey prvKey, Mechanism signMech, p7CertInfo[] signCertInfos, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData) {
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.signCertInfos = signCertInfos;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        if (signCertInfos != null) {
            int certCount = 0;
            int i = 0;
            while (i < signCertInfos.length) {
                if (signCertInfos[i].getCert() != null) {
                    ++certCount;
                }
                ++i;
            }
            this.signCerts = new X509Cert[certCount];
            i = 0;
            while (i < signCertInfos.length) {
                if (signCertInfos[i].getCert() != null) {
                    this.signCerts[i] = signCertInfos[i].getCert();
                }
                ++i;
            }
        }
    }

    public void SetEnvParam(JKey encKey, Mechanism encMech, X509Cert[] encCerts, Mechanism[] envMech) {
        this.sysKey = encKey;
        this.encMech = encMech;
        this.encCerts = encCerts;
        this.envMech = envMech;
        this.encCertInfos = new p7CertInfo[encCerts.length];
        int i = 0;
        while (i < encCerts.length) {
            this.encCertInfos[i] = new p7CertInfo(encCerts[i]);
            ++i;
        }
    }

    public void SetEnvParam(JKey encKey, Mechanism encMech, p7CertInfo[] encCertInfos, Mechanism[] envMech) {
        this.sysKey = encKey;
        this.encMech = encMech;
        this.encCertInfos = encCertInfos;
        this.envMech = envMech;
        if (encCertInfos != null) {
            int certCount = 0;
            int i = 0;
            while (i < encCertInfos.length) {
                if (encCertInfos[i].getCert() != null) {
                    ++certCount;
                }
                ++i;
            }
            this.encCerts = new X509Cert[certCount];
            i = 0;
            while (i < encCertInfos.length) {
                if (encCertInfos[i].getCert() != null) {
                    this.encCerts[i] = encCertInfos[i].getCert();
                }
                ++i;
            }
        }
    }

    public void SetSignEnvParam(JKey prvKey, Mechanism signMech, X509Cert[] encCerts, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData, JKey encKey, Mechanism encMech, Mechanism envMech) {
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.encCerts = encCerts;
        this.signCerts = encCerts;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        this.sysKey = encKey;
        this.encMech = encMech;
        Mechanism[] tmp = new Mechanism[]{envMech};
        this.envMech = tmp;
        this.signCertInfos = new p7CertInfo[encCerts.length];
        this.encCertInfos = new p7CertInfo[encCerts.length];
        int i = 0;
        while (i < encCerts.length) {
            this.signCertInfos[i] = new p7CertInfo(encCerts[i]);
            this.encCertInfos[i] = new p7CertInfo(encCerts[i]);
            ++i;
        }
    }

    public void SetSignEnvParam(JKey prvKey, Mechanism signMech, p7CertInfo[] encCertInfos, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData, JKey encKey, Mechanism encMech, Mechanism envMech) {
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.encCertInfos = encCertInfos;
        this.signCertInfos = encCertInfos;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        this.sysKey = encKey;
        this.encMech = encMech;
        Mechanism[] tmp = new Mechanism[]{envMech};
        this.envMech = tmp;
        if (this.signCertInfos != null) {
            int certCount = 0;
            int i = 0;
            while (i < this.signCertInfos.length) {
                if (this.signCertInfos[i].getCert() != null) {
                    ++certCount;
                }
                ++i;
            }
            this.signCerts = new X509Cert[certCount];
            i = 0;
            while (i < this.signCertInfos.length) {
                if (this.signCertInfos[i].getCert() != null) {
                    this.signCerts[i] = this.signCertInfos[i].getCert();
                }
                ++i;
            }
        }
    }

    public void SetSignEnvParam(JKey prvKey, Mechanism signMech, X509Cert[] encCerts, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData, JKey encKey, Mechanism encMech, Mechanism envMech, X509Cert[] signCerts) {
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.signCerts = signCerts;
        this.encCerts = encCerts;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        this.sysKey = encKey;
        this.encMech = encMech;
        Mechanism[] tmp = new Mechanism[]{envMech};
        this.envMech = tmp;
        this.signCertInfos = new p7CertInfo[signCerts.length];
        int i = 0;
        while (i < signCerts.length) {
            this.signCertInfos[i] = new p7CertInfo(signCerts[i]);
            ++i;
        }
        this.encCertInfos = new p7CertInfo[encCerts.length];
        i = 0;
        while (i < encCerts.length) {
            this.encCertInfos[i] = new p7CertInfo(encCerts[i]);
            ++i;
        }
    }

    public void SetSignEnvParam(JKey prvKey, Mechanism signMech, p7CertInfo[] encCertInfos, X509CRL[] crls, DERObject[] authData, DERObject[] unauthData, JKey encKey, Mechanism encMech, Mechanism envMech, p7CertInfo[] signCertInfos) {
        int i;
        int certCount;
        this.prvKey = prvKey;
        this.signMech = signMech;
        this.signCertInfos = signCertInfos;
        this.encCertInfos = encCertInfos;
        this.crls = crls;
        this.authData = authData;
        this.unauthData = unauthData;
        this.sysKey = encKey;
        this.encMech = encMech;
        Mechanism[] tmp = new Mechanism[]{envMech};
        this.envMech = tmp;
        if (signCertInfos != null) {
            certCount = 0;
            i = 0;
            while (i < signCertInfos.length) {
                if (signCertInfos[i].getCert() != null) {
                    ++certCount;
                }
                ++i;
            }
            this.signCerts = new X509Cert[certCount];
            i = 0;
            while (i < signCertInfos.length) {
                if (signCertInfos[i].getCert() != null) {
                    this.signCerts[i] = signCertInfos[i].getCert();
                }
                ++i;
            }
        }
        if (encCertInfos != null) {
            certCount = 0;
            i = 0;
            while (i < encCertInfos.length) {
                if (encCertInfos[i].getCert() != null) {
                    ++certCount;
                }
                ++i;
            }
            this.encCerts = new X509Cert[certCount];
            i = 0;
            while (i < encCertInfos.length) {
                if (encCertInfos[i].getCert() != null) {
                    this.encCerts[i] = encCertInfos[i].getCert();
                }
                ++i;
            }
        }
    }

    public byte[] GetSource() {
        return this.data;
    }

    public X509Cert[] GetCerts() {
        if (this.signCerts != null) {
            return this.signCerts;
        }
        return this.encCerts;
    }

    public X509Cert[] GetSignCerts() {
        return this.signCerts;
    }

    public X509Cert[] GetEncCerts() {
        return this.encCerts;
    }

    public X509CRL[] GetCrls() {
        return this.crls;
    }

    public p7signInfo[] GetSignInfos() {
        return this.signInfos;
    }

    public p7digInfo GetdigInfo() {
        return this.digInfo;
    }

    public byte[] GetEncedData() {
        return this.encedData;
    }

    public Mechanism GetEncMech() {
        return this.encMech;
    }

    public p7recInfo[] GetRecInfos() {
        return this.recInfos;
    }

    public Mechanism[] GetEnvMech() {
        return this.envMech;
    }

    public void SetRecInfos(p7recInfo[] rec) {
        this.recInfos = rec;
    }

    public void SetEncMech(Mechanism mech) {
        this.encMech = mech;
    }

    public void SetEncedData(byte[] enc) {
        this.encedData = enc;
    }

    public void SetDigInfo(p7digInfo info) {
        this.digInfo = info;
    }

    public void SetSignInfos(p7signInfo[] info) {
        this.signInfos = info;
    }

    public void SetSource(byte[] data) {
        this.data = data;
    }

    public void SetCerts(X509Cert[] certs) {
        this.encCerts = certs;
        this.signCerts = certs;
    }

    public void SetSignCerts(X509Cert[] certs) {
        this.signCerts = certs;
    }

    public void SetEncCerts(X509Cert[] certs) {
        this.encCerts = certs;
    }

    public void SetCrls(X509CRL[] crls) {
        this.crls = crls;
    }

    public JKey GetPrvKey() {
        return this.prvKey;
    }

    public Mechanism GetSignMech() {
        return this.signMech;
    }

    public void SetSignMech(Mechanism mech) {
        this.signMech = mech;
    }

    public DERObject[] GetAuthData() {
        return this.authData;
    }

    public DERObject[] GetunAuthData() {
        return this.unauthData;
    }

    public JKey GetEncKey() {
        return this.sysKey;
    }

    public TSTInfo getTstInfo() {
        return this.tstInfo;
    }

    public void setTstInfo(TSTInfo tstInfo) {
        this.tstInfo = tstInfo;
    }

    public p7CertInfo[] getSignCertInfos() {
        return this.signCertInfos;
    }

    public void setSignCertInfos(p7CertInfo[] signCertInfos) {
        this.signCertInfos = signCertInfos;
    }

    public p7CertInfo[] getEncCertInfos() {
        return this.encCertInfos;
    }

    public void setEncCertInfos(p7CertInfo[] encCertInfos) {
        this.encCertInfos = encCertInfos;
    }
}

