/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.lib;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.PKIToolConfig;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.BERSequence;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JHandle;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.CBCParam;
import cn.com.jit.ida.util.pki.cipher.param.PBEParam;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2Result;
import cn.com.jit.ida.util.pki.cipher.softsm.SM3Digest;
import cn.com.jit.ida.util.pki.cipher.softsm.SM4;
import cn.com.jit.ida.util.pki.cipher.softsm.Sm4_Context;
import cn.com.jit.ida.util.pki.cipher.softsm.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.math.ec.ECPoint;

public class JSoftLib
implements Session {
    public static final String PROVIDER = "BC";
    private PKIToolConfig CfgTag = null;
    private String tag = "JSOFT_LIB";

    public JSoftLib() {
        long err = 0L;
        if (err != 0L) {
            System.out.println("FATAL ERROR : Failed to load native Cavium Driver ");
        }
    }

    public byte[] digest(Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isDigestabled() && !mType.equals("SM3")) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        if (mType.equals("SM3")) {
            SM3Digest sm3 = new SM3Digest();
            byte[] md1 = new byte[32];
            JKey key = (JKey)mechanism.getParam();
            if (key != null) {
                SM2 sm2 = SM2.Instance();
                try {
                    byte[] eccsfpubk = Util.hardKey2SoftPubKey(key);
                    ECPoint test_p = sm2.ecc_curve.decodePoint(eccsfpubk);
                    byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                    sm3.BlockUpdate(z, 0, z.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sm3.BlockUpdate(sourceData, 0, sourceData.length);
            sm3.doFinal(md1, 0);
            return md1;
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            m.update(sourceData);
            byte[] digest = m.digest();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            mac.update(sourceData);
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, byte[] sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled() && !mType.equals("SM3withSM2Encryption")) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        if (mType.equals("RSA/ECB/PKCS1PADDING")) {
            try {
                signData = this.doCipher(mechanism, prvKey, true, sourceData);
            }
            catch (Exception ex) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM3withSM2Encryption")) {
            SM2 sm2 = SM2.Instance();
            Mechanism digMech = new Mechanism("SM3");
            BigInteger test_d = null;
            ECPoint test_p = null;
            try {
                test_d = Util.hardKey2SoftPrivKey(prvKey);
                test_p = sm2.ecc_point_g.multiply(test_d);
                byte[] md = this.getDigforSign(sourceData, test_p);
                SM2Result sm2Ret = new SM2Result();
                sm2.Sm2Sign(md, test_d, test_p, sm2Ret);
                signData = Util.soft2HardSignData(sm2Ret.r, sm2Ret.s);
            }
            catch (Exception e) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            signature.update(sourceData);
            signData = signature.sign();
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return signData;
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled() && !mType.equals("SM3withSM2Encryption")) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        if (mType.equals("RSA/ECB/PKCS1PADDING")) {
            try {
                byte[] decData = this.doCipher(mechanism, pubKey, false, signData);
                return this.isEqualArray(decData, sourceData);
            }
            catch (Exception ex) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM3withSM2Encryption")) {
            try {
                SM2 sm2 = SM2.Instance();
                byte[] eccsfpubk = Util.hardKey2SoftPubKey(pubKey);
                ECPoint softpub = sm2.ecc_curve.decodePoint(eccsfpubk);
                Mechanism digMech = new Mechanism("SM3");
                digMech.setParam(pubKey);
                byte[] md = this.digest(digMech, sourceData);
                SM2Result sm2Ret = Util.Hard2softSignData(signData);
                sm2.Sm2Verify(md, softpub, sm2Ret.r, sm2Ret.s, sm2Ret);
                return sm2Ret.r.equals(sm2Ret.R);
            }
            catch (Exception ex) {
                throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(pubKey));
            signature.update(sourceData);
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW")) {
            byte[] source = new byte[sourceData.length];
            System.arraycopy(sourceData, 0, source, 0, sourceData.length);
            if (!enKey.getKeyType().equals("SM2_Public")) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
            }
            try {
                cn.com.jit.ida.util.pki.cipher.softsm.Cipher cipher = new cn.com.jit.ida.util.pki.cipher.softsm.Cipher();
                SM2 sm2 = SM2.Instance();
                byte[] eccsfpubk = Util.hardKey2SoftPubKey(enKey);
                ECPoint softpub = sm2.ecc_curve.decodePoint(eccsfpubk);
                ECPoint c1 = cipher.Init_enc(sm2, softpub);
                byte[] bc1 = c1.getEncoded();
                cipher.Encrypt(source);
                byte[] c3 = new byte[32];
                cipher.Dofinal(c3);
                return Util.encedDataEncode(c1, c3, source);
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            Sm4_Context ctx = new Sm4_Context();
            SM4 sm4 = new SM4();
            ctx.isPadding = mechanism.isPad();
            byte[] output = null;
            try {
                sm4.sm4_setkey_enc(ctx, enKey.getKey());
                if (mType.equals("SM4_ECB")) {
                    output = sm4.sm4_crypt_ecb(ctx, sourceData);
                } else {
                    byte[] iv = null;
                    CBCParam cbc = (CBCParam)mechanism.getParam();
                    if (cbc != null) {
                        iv = cbc.getIv();
                    }
                    output = sm4.sm4_crypt_cbc(ctx, iv, sourceData);
                }
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
            return output;
        }
        try {
            return this.doCipher(mechanism, enKey, true, sourceData);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, byte[] encryptedData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW")) {
            if (!deKey.getKeyType().equals("SM2_Private")) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
            }
            try {
                byte[] enc = new byte[encryptedData.length];
                System.arraycopy(encryptedData, 0, enc, 0, encryptedData.length);
                cn.com.jit.ida.util.pki.cipher.softsm.Cipher cipher = new cn.com.jit.ida.util.pki.cipher.softsm.Cipher();
                SM2 sm2 = SM2.Instance();
                BigInteger prv = Util.getPrivKeyD(deKey);
                List ls = Util.getXY(enc);
                ECPoint c1 = sm2.ecc_curve.createPoint((BigInteger)ls.get(0), (BigInteger)ls.get(1), true);
                cipher.Init_dec(prv, c1);
                enc = Util.getEnc(enc);
                cipher.Decrypt(enc);
                byte[] c3_ = new byte[32];
                cipher.Dofinal(c3_);
                return enc;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            Sm4_Context ctx = new Sm4_Context();
            SM4 sm4 = new SM4();
            ctx.isPadding = mechanism.isPad();
            byte[] output = null;
            try {
                sm4.sm4_setkey_dec(ctx, deKey.getKey());
                if (mType.equals("SM4_ECB")) {
                    output = sm4.sm4_crypt_ecb(ctx, encryptedData);
                } else {
                    byte[] iv = null;
                    CBCParam cbc = (CBCParam)mechanism.getParam();
                    if (cbc != null) {
                        iv = cbc.getIv();
                    }
                    output = sm4.sm4_crypt_cbc(ctx, iv, encryptedData);
                }
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
            return output;
        }
        try {
            return this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKey generateKey(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("DES") || mType.equals("DESede") || mType.equals("RC2") || mType.equals("RC4") || mType.equals("CAST5") || mType.equals("IDEA") || mType.equals("SM4") || mType.equals("AES"))) {
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if (mType.equals("SM4")) {
                byte[] data = this.generateRandom(new Mechanism("Random"), 16);
                return new JKey("SM4", data);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(mechanism.getMechanismType(), PROVIDER);
            keyGen.init(keyLength);
            SecretKey key = keyGen.generateKey();
            return new JKey(key.getAlgorithm(), key.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isGenerateKeyPairabled() && !mType.equals("SM2")) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        KeyPair keyPair = null;
        PublicKey pubKey = null;
        PrivateKey prvKey = null;
        JKey jPubKey = null;
        JKey jPrvKey = null;
        try {
            if (mType.equals("SM2")) {
                SM2 sm2 = SM2.Instance();
                AsymmetricCipherKeyPair keypair = null;
                keypair = sm2.ecc_key_pair_generator.generateKeyPair();
                ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
                ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
                return Util.getSM2Key(ecpub, ecpriv);
            }
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, PROVIDER);
            keyPairGen.initialize(keyLength, new SecureRandom());
            keyPair = keyPairGen.generateKeyPair();
            pubKey = keyPair.getPublic();
            prvKey = keyPair.getPrivate();
            byte[] pubKeyEncoded = pubKey.getEncoded();
            byte[] prvKeyEncoded = prvKey.getEncoded();
            if (mechanism.getMechanismType().equals("RSA")) {
                jPubKey = new JKey("RSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("RSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("DSA")) {
                jPubKey = new JKey("DSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("DSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("ECDSA")) {
                jPubKey = new JKey("ECDSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("ECDSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("ECIES")) {
                jPubKey = new JKey("ECIES_Public", pubKeyEncoded);
                jPrvKey = new JKey("ECIES_Private", prvKeyEncoded);
            }
            return new JKeyPair(jPubKey, jPrvKey);
        }
        catch (Exception ex) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", ex);
        }
    }

    public boolean DestroyKeyPair(Mechanism mechanism) throws PKIException {
        throw new UnsupportedOperationException("Method DestroyKeyPair() not yet implemented in JSOFT_LIB.");
    }

    public JKey generatePBEKey(Mechanism mechanism, char[] password) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("PBEWithMD5AndDES") || mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC") || mType.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC"))) {
            if (mType.equalsIgnoreCase("PBE/PKCS5")) {
                mType = "PBEWithMD5AndDES";
            } else {
                throw new PKIException("8112", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
        }
        try {
            byte[] keyData = new String(password).getBytes();
            if (mType.equals("PBEWithMD5AndDES")) {
                return new JKey("PBEWithMD5AndDES", keyData);
            }
            if (mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC")) {
                return new JKey("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", keyData);
            }
            return new JKey("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", keyData);
        }
        catch (Exception ex) {
            throw new PKIException("8112", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25", ex);
        }
    }

    public byte[] generateRandom(Mechanism mechanism, int length) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.getMechanismType().equals("Random")) {
            throw new PKIException("8113", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        SecureRandom sRandom = new SecureRandom();
        byte[] data = new byte[length];
        sRandom.nextBytes(data);
        return data;
    }

    private byte[] doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                return this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, data);
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        byte[] res = cipher.doFinal(data);
        return res;
    }

    public static void main(String[] args) {
        System.out.println("OK");
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism keyGen = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
            Mechanism mechanism = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", new PBEParam());
            JKey key = session.generatePBEKey(keyGen, "HELLO".toCharArray());
            byte[] src = "JIT\u516c\u53f8\u6d4b\u8bd5".getBytes();
            byte[] enData = session.encrypt(mechanism, key, src);
            System.out.println(new String(enData));
            byte[] deData = session.decrypt(mechanism, key, enData);
            System.out.println(new String(deData));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    private byte[] doCipher_RSA_ext(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        RSAEngine eng = new RSAEngine();
        RSAKeyParameters keyParams = null;
        if (jkey.getKeyType().equals("RSA_Public")) {
            JCERSAPublicKey pubKey = (JCERSAPublicKey)Parser.convertPublicKey(jkey);
            keyParams = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        } else {
            JCERSAPrivateCrtKey prvKey = (JCERSAPrivateCrtKey)Parser.convertPrivateKey(jkey);
            keyParams = new RSAPrivateCrtKeyParameters(prvKey.getModulus(), prvKey.getPublicExponent(), prvKey.getPrivateExponent(), prvKey.getPrimeP(), prvKey.getPrimeQ(), prvKey.getPrimeExponentP(), prvKey.getPrimeExponentQ(), prvKey.getCrtCoefficient());
        }
        eng.init(isEncrypt, (CipherParameters)keyParams);
        byte[] res = eng.processBlock(data, 0, data.length);
        return res;
    }

    public byte[] digest(Mechanism mechanism, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isDigestabled()) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        if (mType.equals("SM3")) {
            try {
                SM3Digest sm3 = new SM3Digest();
                byte[] md1 = new byte[32];
                byte[] buffer = new byte[1024];
                int i = 0;
                JKey key = (JKey)mechanism.getParam();
                if (key != null) {
                    SM2 sm2 = SM2.Instance();
                    byte[] eccsfpubk = Util.hardKey2SoftPubKey(key);
                    ECPoint test_p = sm2.ecc_curve.decodePoint(eccsfpubk);
                    byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                    sm3.BlockUpdate(z, 0, z.length);
                }
                while ((i = sourceData.read(buffer)) > 0) {
                    sm3.BlockUpdate(buffer, 0, i);
                }
                sm3.doFinal(md1, 0);
                return md1;
            }
            catch (Exception ex) {
                throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                m.update(buffer, 0, i);
            }
            byte[] digest = m.digest();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                mac.update(buffer, 0, i);
            }
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, InputStream sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        if (mType.equals("SM3withSM2Encryption")) {
            SM2 sm2 = SM2.Instance();
            Mechanism digMech = new Mechanism("SM3");
            BigInteger test_d = null;
            ECPoint test_p = null;
            try {
                BigInteger sftd;
                test_d = sftd = Util.hardKey2SoftPrivKey(prvKey);
                test_p = sm2.ecc_point_g.multiply(sftd);
                SM3Digest sm3 = new SM3Digest();
                byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                sm3.BlockUpdate(z, 0, z.length);
                byte[] buffer = new byte[1024];
                int i = 0;
                while ((i = sourceData.read(buffer)) > 0) {
                    sm3.BlockUpdate(buffer, 0, i);
                }
                byte[] md = new byte[32];
                sm3.doFinal(md, 0);
                SM2Result sm2Ret = new SM2Result();
                sm2.Sm2Sign(md, test_d, test_p, sm2Ret);
                signData = Util.soft2HardSignData(sm2Ret.r, sm2Ret.s);
                return signData;
            }
            catch (Exception e) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            signData = signature.sign();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, InputStream sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        if (mType.equals("SM3withSM2Encryption")) {
            try {
                SM2 sm2 = SM2.Instance();
                byte[] eccsfpubk = Util.hardKey2SoftPubKey(pubKey);
                ECPoint softpub = sm2.ecc_curve.decodePoint(eccsfpubk);
                Mechanism digMech = new Mechanism("SM3");
                digMech.setParam(pubKey);
                byte[] md = this.digest(digMech, sourceData);
                SM2Result sm2Ret = Util.Hard2softSignData(signData);
                sm2.Sm2Verify(md, softpub, sm2Ret.r, sm2Ret.s, sm2Ret);
                return sm2Ret.r.equals(sm2Ret.R);
            }
            catch (Exception ex) {
                throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(pubKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                int len = sourceData.available();
                byte[] data = new byte[len];
                sourceData.read(data);
                return this.encrypt(mechanism, enKey, data);
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            return this.doCipher(mechanism, enKey, true, sourceData);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                int len = encryptedData.available();
                byte[] data = new byte[len];
                encryptedData.read(data);
                return this.decrypt(mechanism, deKey, data);
            }
            catch (Exception ex) {
                throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            return this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public long encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData, OutputStream out) throws PKIException {
        int len = 0;
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                int i = 0;
                byte[] buffer = new byte[1024];
                while ((i = sourceData.read(buffer)) > 0) {
                    byte[] data = new byte[i];
                    System.arraycopy(buffer, 0, data, 0, i);
                    byte[] enc = this.encrypt(mechanism, enKey, data);
                    out.write(enc);
                    len += enc.length;
                }
                return len;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            len = this.doCipher(mechanism, enKey, true, sourceData, out);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return len;
    }

    public long decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData, OutputStream out) throws PKIException {
        int len = 0;
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM2_RAW") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                int i = 0;
                byte[] buffer = new byte[1024];
                while ((i = encryptedData.read(buffer)) > 0) {
                    byte[] data = new byte[i];
                    System.arraycopy(buffer, 0, data, 0, i);
                    byte[] dec = this.decrypt(mechanism, deKey, data);
                    out.write(dec);
                    len += dec.length;
                }
                return len;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            len = this.doCipher(mechanism, deKey, false, encryptedData, out);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return len;
    }

    private byte[] doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, InputStream data) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                byte[] bs = new byte[data.available()];
                data.read(bs);
                data.close();
                return this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, bs);
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        ByteArrayOutputStream bin = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = data.read(buffer)) > 0) {
            byte[] temp = cipher.update(buffer, 0, i);
            bin.write(temp);
        }
        byte[] res = cipher.doFinal();
        bin.write(res);
        return bin.toByteArray();
    }

    private int doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, InputStream data, OutputStream out) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                byte[] bs = new byte[data.available()];
                data.read(bs);
                data.close();
                byte[] temp = this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, bs);
                out.write(temp);
                return temp.length;
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        byte[] buffer = new byte[1024];
        int i = 0;
        int datalen = 0;
        while ((i = data.read(buffer)) > 0) {
            byte[] aa = cipher.update(buffer, 0, i);
            out.write(aa);
            datalen += aa.length;
        }
        byte[] last = cipher.doFinal();
        out.write(last);
        return datalen += last.length;
    }

    public byte[] decryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                byte[] out;
                SM4 sm4 = handle.getSm4();
                Sm4_Context ctx = handle.getCtx();
                if (sourceData.length % 16 != 0) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25sourceData lens error.");
                }
                if (mType.equals("SM4_ECB")) {
                    out = sm4.sm4_crypt_ecb(ctx, sourceData);
                } else {
                    CBCParam cbcParam = (CBCParam)mechanism.getParam();
                    if (cbcParam == null) {
                        throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                    }
                    out = sm4.sm4_crypt_cbc(ctx, cbcParam.getIv(), sourceData);
                }
                return out;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM2_RAW")) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
        }
        try {
            byte[] res = handle.getSoftLibHandle().doFinal(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle decryptInit(Mechanism mechanism, JKey deKey) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
                try {
                    Sm4_Context ctx = new Sm4_Context();
                    SM4 sm4 = new SM4();
                    ctx.isPadding = mechanism.isPad();
                    sm4.sm4_setkey_dec(ctx, deKey.getKey());
                    JHandle hd = new JHandle();
                    hd.setSm4(sm4);
                    hd.setMech(mechanism);
                    hd.setCtx(ctx);
                    return hd;
                }
                catch (Exception ex) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
                }
            }
            if (mType.equals("SM2_RAW")) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
            }
            Cipher largeDataCipher = Cipher.getInstance(mType, PROVIDER);
            int cipherMode = 0;
            cipherMode = 2;
            if (mType.indexOf("PBE") != -1) {
                PBEParam pbeParam = (PBEParam)mechanism.getParam();
                if (pbeParam == null) {
                    throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
                }
                PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey), pbeSpec);
            } else if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey), iv);
            } else {
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey));
            }
            JHandle handle = new JHandle(0L, largeDataCipher);
            return handle;
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                byte[] out;
                if (sourceData.length % 16 != 0) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25sourceData lens error.");
                }
                SM4 sm4 = handle.getSm4();
                Sm4_Context ctx = handle.getCtx();
                boolean isPadding = ctx.isPadding;
                ctx.isPadding = false;
                if (mType.equals("SM4_ECB")) {
                    out = sm4.sm4_crypt_ecb(ctx, sourceData);
                } else {
                    CBCParam cbcParam = (CBCParam)mechanism.getParam();
                    if (cbcParam == null) {
                        throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                    }
                    out = sm4.sm4_crypt_cbc(ctx, cbcParam.getIv(), sourceData);
                }
                ctx.isPadding = isPadding;
                return out;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM2_RAW")) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
        }
        try {
            byte[] res = handle.getSoftLibHandle().update(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                byte[] out;
                SM4 sm4 = handle.getSm4();
                Sm4_Context ctx = handle.getCtx();
                if (sourceData.length % 16 != 0 && !ctx.isPadding) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25sourceData lens error.");
                }
                if (mType.equals("SM4_ECB")) {
                    out = sm4.sm4_crypt_ecb(ctx, sourceData);
                } else {
                    CBCParam cbcParam = (CBCParam)mechanism.getParam();
                    if (cbcParam == null) {
                        throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                    }
                    out = sm4.sm4_crypt_cbc(ctx, cbcParam.getIv(), sourceData);
                }
                return out;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM2_RAW")) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
        }
        try {
            byte[] res = handle.getSoftLibHandle().doFinal(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle encryptInit(Mechanism mechanism, JKey enKey) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
                try {
                    Sm4_Context ctx = new Sm4_Context();
                    SM4 sm4 = new SM4();
                    ctx.isPadding = mechanism.isPad();
                    sm4.sm4_setkey_enc(ctx, enKey.getKey());
                    JHandle hd = new JHandle();
                    hd.setSm4(sm4);
                    hd.setMech(mechanism);
                    hd.setCtx(ctx);
                    return hd;
                }
                catch (Exception ex) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
                }
            }
            if (mType.equals("SM2_RAW")) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
            }
            Cipher largeDataCipher = Cipher.getInstance(mType, PROVIDER);
            int cipherMode = 0;
            cipherMode = 1;
            if (mType.indexOf("PBE") != -1) {
                PBEParam pbeParam = (PBEParam)mechanism.getParam();
                if (pbeParam == null) {
                    throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
                }
                PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey), pbeSpec);
            } else if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey), iv);
            } else {
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey));
            }
            JHandle handle = new JHandle(0L, largeDataCipher);
            handle.setMech(mechanism);
            return handle;
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            try {
                byte[] out;
                if (sourceData.length % 16 != 0) {
                    throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25sourceData lens error.");
                }
                SM4 sm4 = handle.getSm4();
                Sm4_Context ctx = handle.getCtx();
                boolean isPadding = ctx.isPadding;
                ctx.isPadding = false;
                if (mType.equals("SM4_ECB")) {
                    out = sm4.sm4_crypt_ecb(ctx, sourceData);
                } else {
                    CBCParam cbcParam = (CBCParam)mechanism.getParam();
                    if (cbcParam == null) {
                        throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                    }
                    out = sm4.sm4_crypt_cbc(ctx, cbcParam.getIv(), sourceData);
                }
                ctx.isPadding = isPadding;
                return out;
            }
            catch (Exception ex) {
                throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        if (mType.equals("SM2_RAW")) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25unsupport sm2 init");
        }
        try {
            byte[] res = handle.getSoftLibHandle().update(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean updateKeyPair(Mechanism mechanism, JKey pubKey, JKey prvKey, int hardPos) throws PKIException {
        throw new PKIException("8128195", "PKIERRORNO updateKeyPair() JSoftLib didn't support Stream-Operation yet. ");
    }

    private boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getCfgTagName() throws PKIException {
        return this.tag;
    }

    public void setCfgTag(PKIToolConfig cfg) throws PKIException {
        this.CfgTag = cfg;
    }

    public PKIToolConfig getCfgTag() throws PKIException {
        return this.CfgTag;
    }

    public boolean createCertObject(byte[] dn, byte[] certData, byte[] keyId) throws PKIException {
        return false;
    }

    public boolean destroyCertObject(byte[] dn, byte[] keyId) throws PKIException {
        return false;
    }

    public byte[] getCertObject(byte[] keyId) throws PKIException {
        return null;
    }

    public List WrapKeyEnc(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, byte[] data) throws PKIException {
        String pubEncType = pubEncMech.getMechanismType();
        String sysEnctype = sysEncMech.getMechanismType();
        if (!(sysEnctype.equals("DES/CBC/PKCS7Padding") || sysEnctype.equals("DES/ECB/PKCS7Padding") || sysEnctype.equals("DESede/ECB/PKCS7Padding") || sysEnctype.equals("DESede/CBC/PKCS7Padding") || sysEnctype.equals("AES/ECB/PKCS7Padding") || sysEnctype.equals("AES/CBC/PKCS7Padding") || sysEnctype.equals("SM4_CBC") || sysEnctype.equals("SM4_ECB"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + sysEnctype);
        }
        if (!pubEncType.equals("RSA/ECB/PKCS1PADDING") && !pubEncType.equals("SM2_RAW")) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + pubEncType);
        }
        CBCParam cbcParam = (CBCParam)sysEncMech.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        if (sysKey == null) {
            Mechanism mech = this.encMech2genMech(sysEncMech);
            int sysKeyLen = this.getSysKeyLen(sysEncMech);
            sysKey = this.generateKey(mech, sysKeyLen);
        }
        byte[] encData = this.encrypt(sysEncMech, sysKey, data);
        byte[] encedKey = this.encrypt(pubEncMech, pubKey, sysKey.getKey());
        ArrayList<byte[]> ls = new ArrayList<byte[]>();
        ls.add(encData);
        ls.add(encedKey);
        return ls;
    }

    private byte[] getDigforSign(byte[] source, ECPoint pub) throws PKIException {
        SM3Digest sm3 = new SM3Digest();
        SM2 sm2 = SM2.Instance();
        byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), pub);
        sm3.BlockUpdate(z, 0, z.length);
        sm3.BlockUpdate(source, 0, source.length);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
        return md;
    }

    public Mechanism encMech2genMech(Mechanism encMech) throws PKIException {
        if (encMech == null) {
            return null;
        }
        String mech = encMech.getMechanismType();
        if (mech.equals("SF33_ECB") || mech.equals("SF33_CBC")) {
            return new Mechanism("SF33");
        }
        if (mech.equals("DES/ECB/PKCS7Padding") || mech.equals("DES/CBC/PKCS7Padding")) {
            return new Mechanism("DES");
        }
        if (mech.equals("DESede/ECB/PKCS7Padding") || mech.equals("DESede/CBC/PKCS7Padding")) {
            return new Mechanism("DESede");
        }
        if (mech.equals("AES/ECB/PKCS7Padding") || mech.equals("AES/CBC/PKCS7Padding")) {
            return new Mechanism("AES");
        }
        if (mech.equals("SCB2_ECB") || mech.equals("SCB2_CBC")) {
            return new Mechanism("SCB2");
        }
        if (mech.equals("SM4_ECB") || mech.equals("SM4_CBC")) {
            return new Mechanism("SM4");
        }
        if (mech.equals("RSA/ECB/PKCS1PADDING")) {
            return new Mechanism("RSA");
        }
        if (mech.equals("SM2_RAW")) {
            return new Mechanism("SM2");
        }
        return null;
    }

    private int getSysKeyLen(Mechanism encMech) throws PKIException {
        if (encMech == null) {
            return 0;
        }
        String mech = encMech.getMechanismType();
        if (mech.equals("SF33_ECB") || mech.equals("SF33_CBC")) {
            return 128;
        }
        if (mech.equals("DES/ECB/PKCS7Padding") || mech.equals("DES/CBC/PKCS7Padding")) {
            return 64;
        }
        if (mech.equals("DESede/ECB/PKCS7Padding") || mech.equals("DESede/CBC/PKCS7Padding")) {
            return 192;
        }
        if (mech.equals("AES/ECB/PKCS7Padding") || mech.equals("AES/CBC/PKCS7Padding")) {
            return 128;
        }
        if (mech.equals("SCB2_ECB") || mech.equals("SCB2_CBC")) {
            return 128;
        }
        if (mech.equals("SM4_ECB") || mech.equals("SM4_CBC")) {
            return 128;
        }
        return 0;
    }

    private byte[] getSM2EnvedKey(Mechanism sysEncMech, byte[] encedSysKey, byte[] pubkey, byte[] encedPriKey) throws PKIException {
        DERObjectIdentifier oid = null;
        if (!sysEncMech.getMechanismType().equals("SM4_ECB")) {
            return null;
        }
        oid = PKCSObjectIdentifiers.gm_SM4;
        AlgorithmIdentifier algo = new AlgorithmIdentifier(oid, new DERNull());
        ByteArrayInputStream bis = new ByteArrayInputStream(encedSysKey);
        ASN1InputStream ais = new ASN1InputStream(bis);
        ASN1EncodableVector v = null;
        try {
            ASN1Sequence sysKey = (ASN1Sequence)ais.readObject();
            DERBitString bitPriKey = new DERBitString(encedPriKey);
            DERBitString bitPubKey = new DERBitString(pubkey);
            v = new ASN1EncodableVector();
            v.add(algo);
            v.add(sysKey);
            v.add(bitPubKey);
            v.add(bitPriKey);
        }
        catch (IOException e) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        return Parser.writeDERObj2Bytes(new BERSequence(v));
    }

    public byte[] WrapPriKey(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, JKey priKey) throws PKIException {
        BigInteger sftd;
        try {
            byte[] eccsfpubk = Util.hardKey2SoftPubKey(pubKey);
            sftd = Util.hardKey2SoftPrivKey(priKey);
        }
        catch (Exception ex) {
            throw new PKIException("8190", ex.getMessage());
        }
        byte[] priData = Util.byteconvert32(sftd);
        byte[] data = new byte[32 + priData.length];
        int i = 0;
        while (i < 32) {
            data[i] = 0;
            ++i;
        }
        System.arraycopy(priData, 0, data, 32, 32);
        sysEncMech.setPad(false);
        List ls = this.WrapKeyEnc(pubKey, sysKey, pubEncMech, sysEncMech, data);
        byte[] encedPriKey = (byte[])ls.get(0);
        byte[] encedSysKey = (byte[])ls.get(1);
        SM2 sm2 = SM2.Instance();
        ECPoint ecpub = null;
        ecpub = sm2.ecc_point_g.multiply(sftd);
        return this.getSM2EnvedKey(sysEncMech, encedSysKey, ecpub.getEncoded(), encedPriKey);
    }

    public JHandle SignInit(Mechanism mechanism, JKey prvKey) throws PKIException {
        if (mechanism == null || prvKey == null) {
            throw new PKIException("8125", "null == mechanism || null == prvKey");
        }
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        JHandle hd = new JHandle();
        hd.setKey(prvKey);
        hd.setMech(mechanism);
        if (mType.equals("SM3withSM2Encryption")) {
            SM2 sm2 = SM2.Instance();
            ECPoint test_p = null;
            try {
                BigInteger sftd = Util.hardKey2SoftPrivKey(prvKey);
                test_p = sm2.ecc_point_g.multiply(sftd);
                SM3Digest sm3 = new SM3Digest();
                byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                sm3.BlockUpdate(z, 0, z.length);
                hd.setSm3(sm3);
                return hd;
            }
            catch (Exception e) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            hd.setSignature(signature);
            return hd;
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void SignUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8125", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3withSM2Encryption")) {
            SM3Digest sm3 = handle.getSm3();
            if (sm3 == null) {
                throw new PKIException("8125", "null == sm3");
            }
            sm3.BlockUpdate(sourceData, 0, sourceData.length);
        } else {
            try {
                Signature signature = handle.getSignature();
                signature.update(sourceData, 0, sourceData.length);
            }
            catch (Exception ex) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
    }

    public byte[] SignFinal(JHandle handle) throws PKIException {
        return this.SignFinal(handle, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] SignFinal(JHandle handle, int signDataLen) throws PKIException {
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8125", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3withSM2Encryption")) {
            SM3Digest sm3 = handle.getSm3();
            JKey prvKey = handle.getKey();
            if (sm3 == null) throw new PKIException("8125", "null == sm3 || null == prvKey");
            if (prvKey == null) {
                throw new PKIException("8125", "null == sm3 || null == prvKey");
            }
            try {
                BigInteger sftd;
                byte[] md = new byte[32];
                sm3.doFinal(md, 0);
                BigInteger test_d = sftd = Util.hardKey2SoftPrivKey(prvKey);
                ECPoint test_p = null;
                test_d = sftd;
                SM2 sm2 = SM2.Instance();
                test_p = sm2.ecc_point_g.multiply(sftd);
                SM2Result sm2Ret = new SM2Result();
                sm2.Sm2Sign(md, test_d, test_p, sm2Ret);
                byte[] signData = Util.soft2HardSignData(sm2Ret.r, sm2Ret.s);
                if (signDataLen > 72) return signData;
                if (signDataLen < 70) return signData;
                if (signDataLen == signData.length) {
                    return signData;
                }
                while (true) {
                    if (signDataLen == signData.length) {
                        return signData;
                    }
                    sm2Ret = new SM2Result();
                    sm2.Sm2Sign(md, test_d, test_p, sm2Ret);
                    signData = Util.soft2HardSignData(sm2Ret.r, sm2Ret.s);
                }
            }
            catch (Exception e) {
                throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = handle.getSignature();
            if (signature != null) return signature.sign();
            throw new PKIException("8125", "null == signature");
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle VerifyInit(Mechanism mechanism, JKey key) throws PKIException {
        if (mechanism == null || key == null) {
            throw new PKIException("8126", "null == mechanism || null == prvKey");
        }
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        JHandle hd = new JHandle();
        hd.setKey(key);
        hd.setMech(mechanism);
        if (mType.equals("SM3withSM2Encryption")) {
            try {
                SM2 sm2 = SM2.Instance();
                byte[] eccsfpubk = Util.hardKey2SoftPubKey(key);
                ECPoint test_p = sm2.ecc_curve.decodePoint(eccsfpubk);
                SM3Digest sm3 = new SM3Digest();
                byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                sm3.BlockUpdate(z, 0, z.length);
                hd.setSm3(sm3);
                return hd;
            }
            catch (Exception e) {
                throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(key));
            hd.setSignature(signature);
            return hd;
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void VerifyUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8126", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3withSM2Encryption")) {
            SM3Digest sm3 = handle.getSm3();
            if (sm3 == null) {
                throw new PKIException("8126", "null == sm3");
            }
            sm3.BlockUpdate(sourceData, 0, sourceData.length);
        } else {
            try {
                Signature signature = handle.getSignature();
                signature.update(sourceData, 0, sourceData.length);
            }
            catch (Exception ex) {
                throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
    }

    public boolean VerifyFinal(JHandle handle, byte[] signData) throws PKIException {
        if (handle == null || signData == null) {
            throw new PKIException("8126", "null == handle || null == signData");
        }
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8126", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3withSM2Encryption")) {
            SM3Digest sm3 = handle.getSm3();
            JKey pubKey = handle.getKey();
            if (sm3 == null || pubKey == null) {
                throw new PKIException("8126", "null == sm3 || null == pubKey");
            }
            try {
                SM2 sm2 = SM2.Instance();
                byte[] eccsfpubk = Util.hardKey2SoftPubKey(pubKey);
                ECPoint softpub = sm2.ecc_curve.decodePoint(eccsfpubk);
                Mechanism digMech = new Mechanism("SM3");
                SM2Result sm2Ret = Util.Hard2softSignData(signData);
                byte[] md = new byte[32];
                sm3.doFinal(md, 0);
                sm2.Sm2Verify(md, softpub, sm2Ret.r, sm2Ret.s, sm2Ret);
                return sm2Ret.r.equals(sm2Ret.R);
            }
            catch (Exception e) {
                throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        try {
            Signature signature = handle.getSignature();
            if (signature == null) {
                throw new PKIException("8126", "null == signature");
            }
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle DigestInit(Mechanism mechanism) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isDigestabled()) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        JHandle hd = new JHandle();
        hd.setMech(mechanism);
        if (mType.equals("SM3")) {
            try {
                SM3Digest sm3 = new SM3Digest();
                JKey key = (JKey)mechanism.getParam();
                if (key != null) {
                    SM2 sm2 = SM2.Instance();
                    byte[] eccsfpubk = Util.hardKey2SoftPubKey(key);
                    ECPoint test_p = sm2.ecc_curve.decodePoint(eccsfpubk);
                    byte[] z = sm2.Sm2GetZ("1234567812345678".getBytes(), test_p);
                    sm3.BlockUpdate(z, 0, z.length);
                }
                hd.setSm3(sm3);
                return hd;
            }
            catch (Exception ex) {
                throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            hd.setDig(m);
            return hd;
        }
        catch (Exception ex) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void DigestUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8126", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3")) {
            SM3Digest sm3 = handle.getSm3();
            if (sm3 == null) {
                throw new PKIException("8126", "null == sm3");
            }
            sm3.BlockUpdate(sourceData, 0, sourceData.length);
        } else {
            try {
                MessageDigest m = handle.getDig();
                if (m == null) {
                    throw new PKIException("8126", "null == m");
                }
                m.update(sourceData, 0, sourceData.length);
            }
            catch (Exception ex) {
                throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
            }
        }
    }

    public byte[] DigestFinal(JHandle handle) throws PKIException {
        Mechanism mechanism = handle.getMech();
        if (mechanism == null) {
            throw new PKIException("8126", "null == mechanism");
        }
        String mType = mechanism.getMechanismType();
        if (mType.equals("SM3")) {
            SM3Digest sm3 = handle.getSm3();
            if (sm3 == null) {
                throw new PKIException("8126", "null == sm3");
            }
            byte[] md = new byte[32];
            sm3.doFinal(md, 0);
            return md;
        }
        try {
            MessageDigest m = handle.getDig();
            if (m == null) {
                throw new PKIException("8126", "null == m");
            }
            return m.digest();
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }
}

