/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.lib;

import cn.com.jit.ida.util.pki.ECDSAParser;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.PKIToolConfig;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.BERSequence;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.cipher.JHandle;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.CBCParam;
import cn.com.jit.ida.util.pki.cipher.param.GenKeyAttribute;
import cn.com.jit.ida.util.pki.cipher.softsm.SM2;
import cn.com.jit.ida.util.pki.cipher.softsm.Util;
import cn.com.jit.ida.util.pki.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bouncycastle.math.ec.ECPoint;

public class JHARDLib
implements Session {
    private static final String JIT_CKR_OK = "0";
    private static final String JIT_CKR_HOST_MEMORY = "2";
    private static final String JIT_CKR_SLOT_ID_INVALID = "3";
    private static final String JIT_CKR_GENERAL_ERROR = "5";
    private static final String JIT_CKR_FUNCTION_FAILED = "6";
    private static final String JIT_CKR_ARGUMENTS_BAD = "7";
    private static final String JIT_CKR_NO_EVENT = "8";
    private static final String JIT_CKR_NEED_TO_CREATE_THREADS = "9";
    private static final String JIT_CKR_CANT_LOCK = "10";
    private static final String JIT_CKR_ATTRIBUTE_READ_ONLY = "16";
    private static final String JIT_CKR_ATTRIBUTE_SENSITIVE = "17";
    private static final String JIT_CKR_ATTRIBUTE_TYPE_INVALID = "18";
    private static final String JIT_CKR_ATTRIBUTE_VALUE_INVALID = "19";
    private static final String JIT_CKR_DATA_INVALID = "32";
    private static final String JIT_CKR_DATA_LEN_RANGE = "33";
    private static final String JIT_CKR_DEVICE_ERROR = "48";
    private static final String JIT_CKR_DEVICE_MEMORY = "49";
    private static final String JIT_CKR_DEVICE_REMOVED = "50";
    private static final String JIT_CKR_ENCRYPTED_DATA_INVALID = "64";
    private static final String JIT_CKR_ENCRYPTED_DATA_LEN_RANGE = "65";
    private static final String JIT_CKR_FUNCTION_CANCELED = "80";
    private static final String JIT_CKR_FUNCTION_NOT_PARALLEL = "81";
    private static final String JIT_CKR_FUNCTION_NOT_SUPPORTED = "84";
    private static final String JIT_CKR_KEY_HANDLE_INVALID = "96";
    private static final String JIT_CKR_KEY_SIZE_RANGE = "98";
    private static final String JIT_CKR_KEY_TYPE_INCONSISTENT = "99";
    private static final String JIT_CKR_KEY_NOT_NEEDED = "100";
    private static final String JIT_CKR_KEY_CHANGED = "101";
    private static final String JIT_CKR_KEY_NEEDED = "102";
    private static final String JIT_CKR_KEY_INDIGESTIBLE = "103";
    private static final String JIT_CKR_KEY_FUNCTION_NOT_PERMITTED = " 104";
    private static final String JIT_CKR_KEY_NOT_WRAPPABLE = "105";
    private static final String JIT_CKR_KEY_UNEXTRACTABLE = "106";
    private static final String JIT_CKR_MECHANISM_INVALID = "112";
    private static final String JIT_CKR_MECHANISM_PARAM_INVALID = "113";
    private static final String JIT_CKR_OBJECT_HANDLE_INVALID = "130";
    private static final String JIT_CKR_OPERATION_ACTIVE = "144";
    private static final String JIT_CKR_OPERATION_NOT_INITIALIZED = "145";
    private static final String JIT_CKR_PIN_INCORRECT = "160";
    private static final String JIT_CKR_PIN_INVALID = "161";
    private static final String JIT_CKR_PIN_LEN_RANGE = "162";
    private static final String JIT_CKR_PIN_EXPIRED = "163";
    private static final String JIT_CKR_PIN_LOCKED = "164";
    private static final String JIT_CKR_SESSION_CLOSED = "176";
    private static final String JIT_CKR_SESSION_COUNT = "177";
    private static final String JIT_CKR_SESSION_HANDLE_INVALID = "179";
    private static final String JIT_CKR_SESSION_PARALLEL_NOT_SUPPORTED = "180";
    private static final String JIT_CKR_SESSION_READ_ONLY = "181";
    private static final String JIT_CKR_SESSION_EXISTS = "182";
    private static final String JIT_CKR_SESSION_READ_ONLY_EXISTS = "183";
    private static final String JIT_CKR_SESSION_READ_WRITE_SO_EXISTS = "184";
    private static final String JIT_CKR_SIGNATURE_INVALID = "192";
    private static final String JIT_CKR_SIGNATURE_LEN_RANGE = "193";
    private static final String JIT_CKR_TEMPLATE_INCOMPLETE = "208";
    private static final String JIT_CKR_TEMPLATE_INCONSISTENT = "209";
    private static final String JIT_CKR_TOKEN_NOT_PRESENT = "224";
    private static final String JIT_CKR_TOKEN_NOT_RECOGNIZED = "225";
    private static final String JIT_CKR_TOKEN_WRITE_PROTECTED = "226";
    private static final String JIT_CKR_UNWRAPPING_KEY_HANDLE_INVALID = "240";
    private static final String JIT_CKR_UNWRAPPING_KEY_SIZE_RANGE = "241";
    private static final String JIT_CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT = "242";
    private static final String JIT_CKR_USER_ALREADY_LOGGED_IN = "256";
    private static final String JIT_CKR_USER_NOT_LOGGED_IN = "257";
    private static final String JIT_CKR_USER_PIN_NOT_INITIALIZED = "258";
    private static final String JIT_CKR_USER_TYPE_INVALID = "259";
    private static final String JIT_CKR_USER_ANOTHER_ALREADY_LOGGED_IN = " 260";
    private static final String JIT_CKR_USER_TOO_MANY_TYPES = "261";
    private static final String JIT_CKR_WRAPPED_KEY_INVALID = "272";
    private static final String JIT_CKR_WRAPPED_KEY_LEN_RANGE = "274";
    private static final String JIT_CKR_WRAPPING_KEY_HANDLE_INVALID = "275";
    private static final String JIT_CKR_WRAPPING_KEY_SIZE_RANGE = "276";
    private static final String JIT_CKR_WRAPPING_KEY_TYPE_INCONSISTENT = "277";
    private static final String JIT_CKR_RANDOM_SEED_NOT_SUPPORTED = "288";
    private static final String JIT_CKR_RANDOM_NO_RNG = "289";
    private static final String JIT_CKR_DOMAIN_PARAMS_INVALID = "304";
    private static final String JIT_CKR_BUFFER_TOO_SMALL = "336";
    private static final String JIT_CKR_SAVED_STATE_INVALID = "352";
    private static final String JIT_CKR_INFORMATION_SENSITIVE = "368";
    private static final String JIT_CKR_STATE_UNSAVEABLE = "384";
    private static final String JIT_CKR_CRYPTOKI_NOT_INITIALIZED = "400";
    private static final String JIT_CKR_CRYPTOKI_ALREADY_INITIALIZED = "401";
    private static final String JIT_CKR_MUTEX_BAD = "416";
    private static final String JIT_CKR_MUTEX_NOT_LOCKED = "417";
    private static final String JIT_PARSE_FAIL = "4096";
    private static final String JIT_CKR_OUTOFMEMORY = "4097";
    private static final String JIT_CKR_MEMORYNOTNULL = "4098";
    private static final String JIT_CKR_NOTSUPPORT = "4099";
    private static final String JIT_LOADLIBRARY_FAIL = "4353";
    private static final String JIT_GEFUNCTIONLIST_FAIL = "4354";
    private static final String JIT_HANDLE_NULL = "4609";
    private static final String JIT_FUNCTIONLISTPTR_NULL = "4610";
    private static final String JIT_ENCRYPTLENGTH_NULL = "4611";
    private static final String JIT_DECRYPTLENGTH_NULL = "4612";
    private static final String JIT_CUSTOM_PRIVATEKEY_ERR = "4865";
    private static final String JIT_CUSTOM_PUBLICKEY_ERR = "4866";
    private static final String JIT_CUSTOM_LENGTH_INVALID = "5121";
    private static final String JIT_KEYTYPE_INVALID = "5122";
    private static final String JIT_KEYLENGTHE_INVALID = "5123";
    private static final String JIT_MECHANISM_INVALID = "5124";
    private static final String JIT_GETUNEXPORTPUBLICKEY_FAIL = "5377";
    private static final String JIT_GETUNEXPORTPRIVATEKEY_FAIL = "5378";
    private static final String JIT_GETMASTERKEY_FAIL = "5379";
    private static final String JIT_GETKEYLENGTH_FAIL = "5380";
    private static final String JIT_GETKEY_FAIL = "5381";
    private static final String JIT_GETPUBLICKEY_FAIL = "5382";
    private static final String JIT_GETPRIVATEKEY_FAIL = "5383";
    private static final String JIT_GETCERT_FAIL = "5384";
    private static final String JIT_CREATEPRIVATEKEY_FAIL = "5385";
    private static final String JIT_ENCRYPTINIT_FAIL = "5386";
    private static final String JIT_ENCRYPTUPDATE_FAIL = "5403";
    private static final String JIT_ENCRYPTFINAL_FAIL = "5404";
    private static final String JIT_DECRYPTINIT_FAIL = "5405";
    private static final String JIT_DECRYPTUPDATE_FAIL = "5406";
    private static final String JIT_DECRYPTFINAL_FAIL = "5407";
    private static final String CKC_KEYTYPE_SYMMETRY = "145";
    private static final String CKC_KEYTYPE_RSA_PUBLICKEY = "1";
    private static final String CKC_KEYTYPE_RSA_PRIVATEKEY = "2";
    private static final String CKC_KEYTYPE_RSA_PUBLICKEYID = "16";
    private static final String CKC_KEYTYPE_RSA_PRIVATEKEYID = "32";
    private static final String CKC_KEYTYPE_ECDSA_PUBLICKEY = "256";
    private static final String CKC_KEYTYPE_ECDSA_PRIVATEKEY = "257";
    private static final String CKC_KEYTYPE_ECDSA_PUBLICKEYID = "258";
    private static final String CKC_KEYTYPE_ECDSA_PRIVATEKEYID = "259";
    private static final String CKC_KEYTYPE_DSA_PUBLICKEY = "4";
    private static final String CKC_KEYTYPE_DSA_PRIVATEKEY = "8";
    private static final String CKC_KEYTYPE_DSA_PUBLICKEYID = "64";
    private static final String CKC_KEYTYPE_DSA_PRIVATEKEYID = "128";
    private static final String CKC_KEYTYPE_MASTERKEYID = "153";
    private static final String[][] hardException = new String[][]{{"0", "\u6210\u529f"}, {"2", "\u5185\u5b58\u9519\u8bef"}, {"3", "SLOTID\u65e0\u6548"}, {"5", "\u4e00\u822c\u7684\u9519\u8bef"}, {"6", "\u51fd\u6570\u9519\u8bef"}, {"7", "\u53c2\u6570\u9519\u8bef"}, {"8", "\u6ca1\u6709\u4e8b\u4ef6"}, {"9", "\u9700\u8981\u521b\u5efa\u7ebf\u7a0b"}, {"10", "\u503e\u659c\u9501\u5b9a"}, {"16", "\u5c5e\u6027\u53ea\u8bfb"}, {"17", "\u5c5e\u6027\u654f\u611f"}, {"18", "\u5c5e\u6027\u7c7b\u578b\u975e\u6cd5"}, {"19", "\u5c5e\u6027\u503c\u65e0\u6548"}, {"32", "\u6570\u636e\u65e0\u6548"}, {"33", "\u6570\u636e\u957f\u5ea6\u9519\u8bef"}, {"48", "\u8bbe\u5907\u9519\u8bef"}, {"49", "\u8bbe\u5907\u5185\u5b58\u51fa\u9519"}, {"50", "\u8bbe\u5907\u5df2\u5220\u9664"}, {"64", "\u52a0\u5bc6\u7684\u6570\u636e\u65e0\u6548"}, {"65", "\u52a0\u5bc6\u7684\u6570\u636e\u957f\u5ea6\u9519\u8bef"}, {"80", "\u63a5\u53e3\u5df2\u53d6\u6d88"}, {"81", "\u63a5\u53e3\u4e0d\u80fd\u5e76\u884c"}, {"84", "\u4e0d\u652f\u6301\u6b64\u63a5\u53e3"}, {"96", "\u975e\u6cd5\u7684\u5bc6\u94a5\u53e5\u67c4"}, {"98", "\u5bc6\u94a5\u7684\u957f\u5ea6\u9519\u8bef"}, {"99", " \u5bc6\u94a5\u7c7b\u578b\u77db\u76fe"}, {"100", "\u4e0d\u9700\u8981\u9644\u52a0\u7684\u5bc6\u94a5"}, {"101", "\u5bc6\u94a5\u5df2\u66f4\u6539"}, {"102", "\u9700\u8981\u9644\u52a0\u5bc6\u94a5"}, {"103", "\u5bc6\u94a5\u4e0d\u80fd\u88ab\u89e3\u6790"}, {" 104", "\u63a5\u53e3\u4e0d\u5141\u8bb8"}, {"105", "\u5bc6\u94a5\u4e0d\u80fd\u6253\u5305"}, {"106", "\u6307\u5b9a\u7684\u79c1\u6709\u6216\u4fdd\u5bc6\u5bc6\u94a5\u4e0d\u80fd\u88ab\u6253\u5305"}, {"112", "\u65e0\u6548\u7684\u673a\u5236"}, {"113", "\u65e0\u6548\u7684\u673a\u5236\u53c2\u6570"}, {"130", "\u975e\u6cd5\u7684\u5bf9\u8c61\u53e5\u67c4"}, {"144", "\u64cd\u4f5c\u5df2\u6fc0\u6d3b"}, {"145", "\u64cd\u4f5c\u6ca1\u6709\u521d\u59cb\u5316"}, {"160", "\u9519\u8bef\u7684PIN\u7801"}, {"161", "\u65e0\u6548\u7684PIN"}, {"162", "\u65e0\u6548\u7684PIN\u7684\u957f\u5ea6"}, {"163", "PIN\u7801\u5df2\u7ecf\u8fc7\u671f"}, {"164", "PIN\u7801\u88ab\u9501\u5b9a"}, {"176", "\u4f1a\u8bdd\u5df2\u7ecf\u5173\u95ed"}, {"177", "\u4f1a\u8bdd\u8d85\u51fa\u603b\u6570"}, {"179", "\u65e0\u6548\u7684\u4f1a\u8bdd\u53e5\u67c4"}, {"180", "\u4e0d\u652f\u6301\u5e76\u884c"}, {"181", "\u4f1a\u8bdd\u53ea\u8bfb"}, {"182", "\u4f1a\u8bdd\u5df2\u7ecf\u5b58\u5728"}, {"183", "\u4f1a\u8bdd\u5df2\u7ecf\u53ea\u8bfb"}, {"184", "\u4f1a\u8bdd\u5df2\u7ecf\u652f\u6301\u8bfb\u5199"}, {"192", "\u7b7e\u540d\u65e0\u6548"}, {"193", "\u7b7e\u540d\u957f\u5ea6\u65e0\u6548"}, {"208", "\u6a21\u677f\u672a\u5b8c\u6210"}, {"209", "\u6a21\u677f\u4e0d\u4e00\u81f4"}, {"224", "TOKEN\u4e0d\u5b58\u5728"}, {"225", "TOKEN\u672a\u8bc6\u522b"}, {"226", "TOKEN\u5199\u4fdd\u62a4"}, {"240", "\u65e0\u6548\u7684\u89e3\u5305\u5bc6\u94a5\u53e5\u67c4"}, {"241", "\u63a5\u9a73\u963f\u5bc6\u94a5\u5c3a\u5bf8\u8fc7\u5927"}, {"242", "\u89e3\u5305\u5bc6\u94a5\u7c7b\u578b\u4e0d\u4e00\u81f4"}, {"256", "\u7528\u6237\u5df2\u767b\u9646"}, {"257", "\u7528\u6237\u672a\u767b\u9646"}, {"258", "\u7528\u6237PIN\u7801\u672a\u521d\u59cb\u5316"}, {"259", "\u7528\u6237\u7c7b\u578b\u975e\u6cd5"}, {" 260", "\u53e6\u5916\u7528\u6237\u5df2\u767b\u9646"}, {"261", "\u7528\u6237\u7c7b\u578b\u592a\u591a"}, {"272", "\u6253\u5305\u5bc6\u94a5\u65e0\u6548"}, {"274", "\u6253\u5305\u5bc6\u94a5\u8fc7\u957f"}, {"275", "\u6253\u5305\u5bc6\u94a5\u7684\u53e5\u67c4\u65e0\u6548"}, {"276", "\u6253\u5305\u5bc6\u94a5\u5c3a\u5bf8\u8fc7\u5927"}, {"277", "\u6253\u5305\u5bc6\u94a5\u7c7b\u578b\u4e0d\u4e00\u81f4"}, {"288", "\u4e0d\u652f\u6301\u968f\u673a\u79cd\u5b50"}, {"289", "\u6ca1\u6709\u968f\u673a\u6570\u5b57\u4ea7\u751f\u5668"}, {"304", "DOMAIN\u53c2\u6570\u65e0\u6548"}, {"336", "\u5206\u914d\u7684\u7a7a\u95f4\u5c0f"}, {"352", "\u4fdd\u5b58\u7684\u72b6\u6001\u65e0\u6548"}, {"368", "\u4fe1\u606f\u654f\u611f"}, {"384", "\u72b6\u6001\u4e0d\u80fd\u4fdd\u5b58"}, {"400", "\u52a0\u5bc6\u5e93\u672a\u521d\u59cb\u5316"}, {"401", "\u52a0\u5bc6\u5e93\u5df2\u7ecf\u521d\u59cb\u5316"}, {"416", "\u4e92\u65a5\u4f53\u574f"}, {"417", "\u4e92\u65a5\u4f53\u672a\u9501\u5b9a"}, {"4096", "\u89e3\u6790\u52a0\u5bc6\u673a\u8fd4\u56de\u6570\u636e\u5931\u8d25"}, {"4097", "\u5185\u5b58\u4e0d\u8db3"}, {"4098", "\u4f20\u5165\u5185\u5b58\u53c2\u6570\u4e0d\u4e3a\u7a7a"}, {"4099", "\u5f53\u524d\u7248\u672c\u6ca1\u6709\u652f\u6301"}, {"4353", "\u52a0\u8f7dP11\u5e93\u5931\u8d25"}, {"4354", "\u83b7\u53d6\u52a8\u6001\u5e93\u51fd\u6570\u5217\u8868\u5931\u8d25"}, {"4609", "\u53e5\u67c4\u53c2\u6570\u4e3a\u7a7a"}, {"4610", "P11\u51fd\u6570\u5217\u8868\u6307\u9488\u4e3a\u7a7a"}, {"4611", "\u52a0\u5bc6\u540e\u957f\u5ea6\u4e3a\u96f6"}, {"4612", "\u89e3\u5bc6\u540e\u957f\u5ea6\u4e3a\u96f6"}, {"4865", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u79c1\u94a5\u4fe1\u606f\u9519\u8bef"}, {"4866", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u516c\u94a5\u4fe1\u606f\u9519\u8bef"}, {"5121", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u6570\u636e\u957f\u5ea6\u975e\u6cd5"}, {"5122", "\u5bc6\u94a5\u7c7b\u578b\u4e0d\u652f\u6301"}, {"5123", "\u5bc6\u94a5\u957f\u5ea6\u4e0d\u652f\u6301"}, {"5124", "\u7b97\u6cd5\u4e0d\u652f\u6301"}, {"5377", "\u6ca1\u6709\u627e\u5230\u4e0d\u53ef\u5bfc\u51fa\u5bc6\u94a5\u5bf9\u4e2d\u7684\u516c\u94a5"}, {"5378", "\u6ca1\u6709\u627e\u5230\u4e0d\u53ef\u5bfc\u51fa\u5bc6\u94a5\u5bf9\u4e2d\u7684\u79c1\u94a5"}, {"5379", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u957f\u5ea6\u5931\u8d25"}, {"5380", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u957f\u5ea6\u5931\u8d25"}, {"5381", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5382", "\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5383", "\u83b7\u53d6\u79c1\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5384", "\u83b7\u53d6\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25"}, {"5385", "\u5efa\u7acb\u79c1\u94a5\u5bf9\u8c61\u5931\u8d25"}, {"5386", "\u52a0\u5bc6\u64cd\u4f5c\u521d\u59cb\u5316\u5931\u8d25"}, {"5403", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25"}, {"5404", "\u52a0\u5bc6\u64cd\u4f5c\u7ed3\u675f\u5931\u8d25"}, {"5405", "\u89e3\u5bc6\u64cd\u4f5c\u521d\u59cb\u5316\u5931\u8d25"}, {"5406", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25"}, {"5407", "\u89e3\u5bc6\u64cd\u4f5c\u7ed3\u675f\u5931\u8d25"}};
    private static final long RSA = 0L;
    private static final long RSA_PKCS = 1L;
    private static final long CKM_RSA_RAW = -2130706431L;
    private static final long MD5_RSA_PKCS = 5L;
    private static final long SHA1_RSA_PKCS = 6L;
    private static final long ECDSA = 4160L;
    private static final long ECDSA_SHA1 = 4162L;
    private static final long ECDSA_SHA224 = 4163L;
    private static final long ECDSA_SHA256 = 4164L;
    private static final long DSA = 16L;
    private static final long DSA_SHA1 = 18L;
    private static final long DSA_SHA224 = 19L;
    private static final long DSA_SHA256 = 20L;
    private static final long SHA224_RSA_PKCS = 70L;
    private static final long SHA256_RSA_PKCS = 64L;
    private static final long SHA384_RSA_PKCS = 65L;
    private static final long SHA512_RSA_PKCS = 66L;
    private static final long DES_KEY = 288L;
    private static final long DES_ECB = 289L;
    private static final long DES_CBC = 290L;
    private static final long MD2 = 512L;
    private static final long MD2_HMAC = 513L;
    private static final long MD5 = 528L;
    private static final long MD5_HMAC = 529L;
    private static final long SHA1 = 544L;
    private static final long SHA1_HMAC = 545L;
    private static final long SHA256 = 592L;
    private static final long SHA384 = 608L;
    private static final long SHA512 = 624L;
    private static final long SHA224 = 597L;
    private static final long RC2_KEY = 256L;
    private static final long RC2_ECB = 257L;
    private static final long RC2_CBC = 258L;
    private static final long RC4_KEY = 272L;
    private static final long RC4 = 273L;
    private static final long DES3_KEY = 305L;
    private static final long DES3_ECB = 306L;
    private static final long DES3_CBC = 307L;
    private static final long SF33_KEY_GEN = -2147483600L;
    private static final long CKM_SF33_ECB = -2147483599L;
    private static final long CKM_SF33_CBC = -2147483598L;
    private static final long AES_KEY_GEN = 4224L;
    private static final long CKM_AES_ECB = 4225L;
    private static final long CKM_AES_CBC = 4226L;
    private static final long SCB2_KEY_GEN = -2147483633L;
    private static final long SCB2_ECB = -2147483632L;
    private static final long SCB2_CBC = -2147483631L;
    public static final String PROVIDER = "HARDLIB";
    private static final long SW_SM2 = -2147450879L;
    private static final long SW_SM3_SM2 = -2147450624L;
    private static final long SW_SM2_RAW = -2147450368L;
    private static final String CKC_KEYTYPE_SM2_PUBLICKEY = "-2147483392";
    private static final String CKC_KEYTYPE_SM2_PRIVATEKEY = "-2147483391";
    private static final String CKC_KEYTYPE_SM2_PUBLICKEYID = "-2147483390";
    private static final String CKC_KEYTYPE_SM2_PRIVATEKEYID = "-2147483389";
    private static final long SW_SM3 = -2147483643L;
    private boolean isInit = false;
    private PKIToolConfig CfgTag = null;
    private String tag = "PKITOOL";
    private static final long SW_SM4_KEY_GEN = -2147483385L;
    private static final long SW_SM4_ECB = -2147483384L;
    private static final long SW_SM4_CBC = -2147483383L;

    public JHARDLib() {
        try {
            System.loadLibrary("SessionDll");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void Initialize() throws PKIException {
        this.Initialize("PKITOOL");
    }

    public void Initialize(String cfg) throws PKIException {
        int errnum;
        this.tag = cfg;
        if (this.CfgTag == null) {
            this.CfgTag = new PKIToolConfig();
            this.CfgTag.LoadOpt(cfg);
        }
        byte[] libPath = new String(this.CfgTag.getP11File()).getBytes();
        int slot = 0;
        if (this.CfgTag.getSlot() != null) {
            slot = Integer.valueOf(this.CfgTag.getSlot());
        }
        if ((errnum = this.p11Initialize(libPath, this.tag.getBytes(), slot)) != 0) {
            PKIException ex = new PKIException(Integer.toString(errnum), JHARDLib.errorDesc(Integer.toString(errnum)));
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void Finalize() throws PKIException {
        int errnum = this.p11Finalize(this.tag.getBytes());
        if (errnum != 0) {
            PKIException ex = new PKIException(Integer.toString(errnum), JHARDLib.errorDesc(Integer.toString(errnum)));
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKey generateKey(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("DES") || mType.equals("SF33") || mType.equals("DESede") || mType.equals("RC2") || mType.equals("RC4") || mType.equals("AES") || mType.equals("SM4") || mType.equals("SCB2"))) {
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] keyData = this.generateKey(mechType, keyLength, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        String lType = recvData.getProperty("lType");
        String pKey = recvData.getProperty("pKey");
        if (pKey == null || !error.equals(JIT_CKR_OK)) {
            PKIException ex = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
        Hex hex = new Hex();
        JKey key = new JKey(this.JNIToJavaKeyType(lType), Hex.decode(pKey));
        return key;
    }

    public boolean updateKeyPair(Mechanism mechanism, JKey pubKey, JKey prvKey, int hardPos) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mType.equals("RSA") || !mType.equals("SM2")) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] returnData = this.updateKeyPair(mechType, Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey()), Parser.softKey2HardCustomKey(prvKey.getKeyType(), prvKey.getKey()), hardPos, this.CfgTag.getNoExportRSAPubKeyValue().getBytes(), this.CfgTag.getNoExportRSAPriKeyValue().getBytes(), this.CfgTag.getNoExportRSAKeyValue().getBytes(), this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(returnData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            return true;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
    }

    public JKeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String pubKeyID;
        Properties recvData;
        byte[] pubKeyValue;
        GenKeyAttribute keyAtt;
        Object ob;
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("RSA") || mType.equals("ECDSA") || mType.equals("SM2") || mType.equals("DSA"))) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        boolean isExport = true;
        int keyNum = 0;
        boolean isNotExportGenKey = false;
        Object keyPair = null;
        JKey publicKey = null;
        JKey privateKey = null;
        byte[] keyData = null;
        if (mechanism.getParam() != null) {
            ob = mechanism.getParam();
            keyAtt = (GenKeyAttribute)ob;
            isExport = keyAtt.getIsExport();
            keyNum = keyAtt.getKeyNum();
            isNotExportGenKey = keyAtt.getIsNotExportGenKey();
        }
        if (isExport) {
            if (keyLength == 0) {
                keyLength = 1024;
            }
            keyData = this.generateKeyPair(mechType, keyLength, this.tag.getBytes());
        } else if (mType.equals("RSA")) {
            int keyType = Integer.parseInt(this.CfgTag.getNoExportRSAKeyType());
            pubKeyValue = (String.valueOf(this.CfgTag.getNoExportRSAPubKeyValue()) + String.valueOf(keyNum)).getBytes();
            byte[] priKeyValue = (String.valueOf(this.CfgTag.getNoExportRSAPriKeyValue()) + String.valueOf(keyNum)).getBytes();
            keyData = this.findKeyPair(mechType, keyType, pubKeyValue, priKeyValue, this.tag.getBytes());
        } else if (mType.equals("ECDSA")) {
            int keyType = Integer.parseInt(this.CfgTag.getNoExportECCKeyType());
            pubKeyValue = (String.valueOf(this.CfgTag.getNoExportECDSAPubKeyValue()) + String.valueOf(keyNum)).getBytes();
            byte[] priKeyValue = (String.valueOf(this.CfgTag.getNoExportECDSAPriKeyValue()) + String.valueOf(keyNum)).getBytes();
            keyData = this.findKeyPair(mechType, keyType, pubKeyValue, priKeyValue, this.tag.getBytes());
        } else if (mType.equals("SM2")) {
            byte[] priKeyValue;
            byte[] pubKeyValue2;
            ob = mechanism.getParam();
            keyAtt = (GenKeyAttribute)ob;
            int isSign = keyAtt.getIsSign();
            int keyType = Integer.parseInt(this.CfgTag.getNoExportECCKeyType());
            if (isSign == 1) {
                pubKeyValue2 = (String.valueOf(this.CfgTag.getNoExportECDSAPubKeyValue()) + String.valueOf(keyNum)).getBytes();
                priKeyValue = (String.valueOf(this.CfgTag.getNoExportECDSAPriKeyValue()) + String.valueOf(keyNum)).getBytes();
            } else {
                pubKeyValue2 = (String.valueOf(this.CfgTag.getNoExportECDSAEncPubKeyValue()) + String.valueOf(keyNum)).getBytes();
                priKeyValue = (String.valueOf(this.CfgTag.getNoExportECDSAEncPriKeyValue()) + String.valueOf(keyNum)).getBytes();
            }
            keyData = this.findKeyPair(mechType, keyType, pubKeyValue2, priKeyValue, this.tag.getBytes());
        } else if (mType.equals("DSA")) {
            int keyType = Integer.parseInt(this.CfgTag.getNoExportDSAKeyType());
            pubKeyValue = (String.valueOf(this.CfgTag.getNoExportDSAPubKeyValue()) + String.valueOf(keyNum)).getBytes();
            byte[] priKeyValue = (String.valueOf(this.CfgTag.getNoExportDSAPriKeyValue()) + String.valueOf(keyNum)).getBytes();
            keyData = this.findKeyPair(mechType, keyType, pubKeyValue, priKeyValue, this.tag.getBytes());
        }
        if (mType.equals("RSA")) {
            ByteArrayInputStream in = new ByteArrayInputStream(keyData);
            recvData = new Properties();
            try {
                recvData.load(in);
            }
            catch (Exception ex) {
                PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String error = recvData.getProperty("Error");
            String pubType = recvData.getProperty("pubType");
            pubKeyID = recvData.getProperty("pubKeyID");
            String pubModulus = recvData.getProperty("Pub_Modulus");
            String pubExponent = recvData.getProperty("Pub_Exponent");
            if (pubKeyID == null && pubModulus == null && pubExponent == null || !error.equals(JIT_CKR_OK)) {
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String priType = recvData.getProperty("priType");
            String priKeyID = recvData.getProperty("priKeyID");
            String modulus = recvData.getProperty("Modulus");
            String privateExponent = recvData.getProperty("PrivateExponent");
            String publicExponent = recvData.getProperty("PublicExponent");
            String prime1 = recvData.getProperty("Prime1");
            String prime2 = recvData.getProperty("Prime2");
            String exponent1 = recvData.getProperty("Exponent1");
            String exponent2 = recvData.getProperty("Exponent2");
            String coefficient = recvData.getProperty("Coefficient");
            if (priKeyID == null && modulus == null && privateExponent == null && publicExponent == null && prime1 == null && prime2 == null && exponent1 == null && exponent2 == null && coefficient == null) {
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25");
            }
            if (mType.equals("RSA")) {
                Hex hex;
                if (pubKeyID == null) {
                    hex = new Hex();
                    publicKey = new JKey(this.JNIToJavaKeyType(pubType), Parser.customData2SoftPublicKey(this.JNIToJavaKeyType(pubType), Hex.decode(pubModulus), Hex.decode(pubExponent)));
                } else {
                    publicKey = new JKey(this.JNIToJavaKeyType(pubType), Long.parseLong(pubKeyID));
                }
                if (priKeyID == null) {
                    hex = new Hex();
                    privateKey = new JKey(this.JNIToJavaKeyType(priType), Parser.customData2SoftPrivateKey(this.JNIToJavaKeyType(priType), Hex.decode(modulus), Hex.decode(privateExponent), Hex.decode(publicExponent), Hex.decode(prime1), Hex.decode(prime2), Hex.decode(exponent1), Hex.decode(exponent2), Hex.decode(coefficient)));
                } else {
                    privateKey = new JKey(this.JNIToJavaKeyType(priType), Long.parseLong(priKeyID));
                }
            }
        } else if (mType.equals("ECDSA") || mType.equals("SM2")) {
            ByteArrayInputStream in = new ByteArrayInputStream(keyData);
            recvData = new Properties();
            try {
                recvData.load(in);
            }
            catch (Exception ex) {
                PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String error = recvData.getProperty("Error");
            String pubType = recvData.getProperty("pubType");
            pubKeyID = recvData.getProperty("pubKeyID");
            String pubEcPoint = recvData.getProperty("Pub_ecPoint");
            String pubECParameters = recvData.getProperty("Pub_ecParma");
            if (pubKeyID == null && pubEcPoint == null || !error.equals(JIT_CKR_OK)) {
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String priType = recvData.getProperty("priType");
            String priKeyID = recvData.getProperty("PriKeyID");
            String modulus = recvData.getProperty("pri_ecValue");
            if (priKeyID == null && modulus == null) {
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25");
            }
            if (mType.equals("ECDSA") || mType.equals("SM2")) {
                Hex hex;
                if (pubKeyID == null) {
                    hex = new Hex();
                    publicKey = mType.equals("ECDSA") ? new JKey(this.JNIToJavaKeyType(pubType), Parser.customData2SoftPublicKey(Hex.decode(pubEcPoint), Hex.decode(pubECParameters))) : new JKey(this.JNIToJavaKeyType(pubType), Parser.customData2SoftPublicKey(Hex.decode(pubEcPoint), null));
                } else {
                    publicKey = new JKey(this.JNIToJavaKeyType(pubType), Long.parseLong(pubKeyID));
                }
                if (priKeyID == null) {
                    hex = new Hex();
                    privateKey = new JKey(this.JNIToJavaKeyType(priType), ECDSAParser.customData2SoftECPrivKey(Hex.decode(pubEcPoint), Hex.decode(modulus)));
                } else {
                    privateKey = new JKey(this.JNIToJavaKeyType(priType), Long.parseLong(priKeyID));
                }
            }
        } else if (mType.equals("DSA")) {
            ByteArrayInputStream in = new ByteArrayInputStream(keyData);
            recvData = new Properties();
            try {
                recvData.load(in);
            }
            catch (Exception ex) {
                PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String error = recvData.getProperty("Error");
            String pubType = recvData.getProperty("pubType");
            pubKeyID = recvData.getProperty("pubKeyID");
            String DSA_P = recvData.getProperty("DSA_P");
            String DSA_Q = recvData.getProperty("DSA_Q");
            String DSA_G = recvData.getProperty("DSA_G");
            String pubEcPoint = recvData.getProperty("Pub_ecPoint");
            if (pubKeyID == null && pubEcPoint == null || !error.equals(JIT_CKR_OK)) {
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
            String priType = recvData.getProperty("priType");
            String priKeyID = recvData.getProperty("PriKeyID");
            String modulus = recvData.getProperty("pri_ecValue");
            if (priKeyID == null && modulus == null) {
                throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25");
            }
            if (mType.equals("DSA")) {
                if (pubKeyID == null) {
                    Hex hex = new Hex();
                    publicKey = new JKey(this.JNIToJavaKeyType(pubType), Parser.customData2SoftPublicKey(this.JNIToJavaKeyType(pubType), Hex.decode(DSA_P), Hex.decode(DSA_Q), Hex.decode(DSA_G), Hex.decode(pubEcPoint)));
                }
                if (priKeyID != null) {
                    privateKey = new JKey(this.JNIToJavaKeyType(priType), Long.parseLong(priKeyID));
                }
            }
        }
        return new JKeyPair(publicKey, privateKey);
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] signData = null;
        signData = prvKey.getKey() != null ? this.sign(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), Parser.softKey2HardCustomKey(prvKey.getKeyType(), prvKey.getKey()), sourceData, this.tag.getBytes()) : this.sign(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), Long.toString(prvKey.getKeyID()).getBytes(), sourceData, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(signData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvSign = recvData.getProperty("SignData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvSign != null) {
            Hex hex = new Hex();
            byte[] sign = Hex.decode(recvSign);
            return sign;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] keyData = this.verifySign(mechType, this.JavaToJNIKeyType(pubKey.getKeyType()), Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey()), sourceData, signData, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            return true;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        CBCParam cbcParam = (CBCParam)mechanism.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        byte[] encData = null;
        if (mechanism.isPad()) {
            sourceData = this.getPaddingData(mechanism, sourceData);
        }
        if (mechType == 1L) {
            encData = enKey.getKey() == null ? this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Long.toString(enKey.getKeyID()).getBytes(), sourceData, cbcIv, this.tag.getBytes()) : this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Parser.softKey2HardCustomKey(enKey.getKeyType(), enKey.getKey()), sourceData, cbcIv, this.tag.getBytes());
        } else if (-2147450368L == mechType) {
            encData = enKey.getKey() == null ? this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Long.toString(enKey.getKeyID()).getBytes(), sourceData, cbcIv, this.tag.getBytes()) : this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Parser.softKey2HardCustomKey(enKey.getKeyType(), enKey.getKey()), sourceData, cbcIv, this.tag.getBytes());
        } else if (enKey.getKeyType().equalsIgnoreCase("MASTERKEY")) {
            long encmec = Long.parseLong(this.CfgTag.getMasterKeyEnc());
            encData = this.masterEncrypt(Long.parseLong(this.CfgTag.getMasterKeyEnc()), Integer.parseInt(this.CfgTag.getMasterKeyType()), this.CfgTag.getMasterKeyValue().getBytes(), sourceData, cbcIv, this.tag.getBytes());
        } else {
            encData = this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), enKey.getKey(), sourceData, cbcIv, this.tag.getBytes());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(encData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvEnc = recvData.getProperty("EncData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvEnc != null) {
            Hex hex = new Hex();
            byte[] enc = Hex.decode(recvEnc);
            return enc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, byte[] encryptedData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        CBCParam cbcParam = (CBCParam)mechanism.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        byte[] decData = null;
        if (mechType == 1L && deKey.getKey() == null) {
            decData = this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Long.toString(deKey.getKeyID()).getBytes(), encryptedData, cbcIv, this.tag.getBytes());
        } else if (mechType == 1L && deKey.getKey() != null) {
            decData = this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), encryptedData, cbcIv, this.tag.getBytes());
        } else if (deKey.getKeyType().equalsIgnoreCase("MASTERKEY")) {
            long encmec = Long.parseLong(this.CfgTag.getMasterKeyEnc());
            decData = this.masterDecrypt(Long.parseLong(this.CfgTag.getMasterKeyEnc()), Integer.parseInt(this.CfgTag.getMasterKeyType()), this.CfgTag.getMasterKeyValue().getBytes(), encryptedData, cbcIv, this.tag.getBytes());
        } else {
            decData = mechType == -2130706431L && deKey.getKey() != null ? this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), encryptedData, cbcIv, this.tag.getBytes()) : (mechType == -2147450368L && deKey.getKey() == null ? this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Long.toString(deKey.getKeyID()).getBytes(), encryptedData, cbcIv, this.tag.getBytes()) : (mechType == -2147450368L && deKey.getKey() != null ? this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), encryptedData, cbcIv, this.tag.getBytes()) : this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), deKey.getKey(), encryptedData, cbcIv, this.tag.getBytes())));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(decData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDec = recvData.getProperty("DecData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvDec != null) {
            Hex hex = new Hex();
            byte[] dec = Hex.decode(recvDec);
            if (mechanism.isPad()) {
                dec = this.paddingDrop(mechanism, dec);
            }
            return dec;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public boolean createCertObject(byte[] dn, byte[] certData, byte[] keyId) throws PKIException {
        byte[] keyData = this.importCert(dn, certData, keyId, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8198190", "\u88c5\u8f7d\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            return true;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8198191", "\u521b\u5efa\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public boolean destroyCertObject(byte[] dn, byte[] keyId) throws PKIException {
        byte[] keyData = null;
        keyData = dn == null ? this.destroyCerts(keyId, this.tag.getBytes()) : this.destroyCert(dn, keyId, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8198192", "\u88c5\u8f7d\u8981\u5220\u9664\u7684\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            return true;
        }
        if (error.equals(JIT_GETCERT_FAIL)) {
            return false;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8198193", "\u5220\u9664\u7684\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public byte[] getMrtdVision(byte[] fileName) throws PKIException {
        byte[] version = null;
        version = this.getMRTDVision(fileName, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(version);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException pKIException = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
        }
        String error = recvData.getProperty("Error");
        String recvVersion = recvData.getProperty("Mrtd_version");
        if (error.equals(JIT_CKR_OK)) {
            Hex hex = new Hex();
            return Hex.decode(recvVersion);
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("819", e);
    }

    public byte[] getCertObject(byte[] keyId) throws PKIException {
        byte[] keyData = this.getCert(keyId, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8198194", "\u5f97\u5230\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        String certObject = recvData.getProperty("certObject");
        if (error.equals(JIT_CKR_OK) && certObject != null) {
            Hex hex = new Hex();
            byte[] enc = Hex.decode(certObject);
            return enc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8198194", "\u5f97\u5230\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public byte[] digest(Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SM3") || mType.equals("SHA1") || mType.equals("SHA224") || mType.equals("SHA256") || mType.equals("SHA384") || mType.equals("SHA512"))) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] digestData = this.digest(mechType, sourceData, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(digestData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
        String recvEnc = recvData.getProperty("DigestData");
        String error = recvData.getProperty("Error");
        if (!error.equals(JIT_CKR_OK) || recvEnc == null) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25");
        }
        Hex hex = new Hex();
        digestData = Hex.decode(recvEnc);
        return digestData;
    }

    public byte[] mac(Mechanism mechanism, JKey key, byte[] sourceData) throws PKIException {
        throw new UnsupportedOperationException("Method mac() not yet implemented.");
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, byte[] sourceData, byte[] macData) throws PKIException {
        throw new UnsupportedOperationException("Method verifyMac() not yet implemented.");
    }

    public JKey generatePBEKey(Mechanism mechanism, char[] password) throws PKIException {
        throw new UnsupportedOperationException("Method generatePBEKey() not yet implemented.");
    }

    public byte[] generateRandom(Mechanism mechanism, int length) throws PKIException {
        if (!mechanism.getMechanismType().equals("Random")) {
            throw new PKIException("8113", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b Random");
        }
        byte[] randomData = this.generateRandom(length, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(randomData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("8193", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25", ex);
        }
        String recvEnc = recvData.getProperty("RandomData");
        String error = recvData.getProperty("Error");
        if (!error.equals(JIT_CKR_OK) || recvEnc == null) {
            throw new PKIException("8193", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25");
        }
        Hex hex = new Hex();
        randomData = Hex.decode(recvEnc);
        return randomData;
    }

    private static String errorDesc(String errCode) {
        String code = new String();
        int i = 0;
        while (i < hardException.length) {
            if (hardException[i][0].equals(errCode)) {
                code = hardException[i][1];
                break;
            }
            ++i;
        }
        if (code == null) {
            code = "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef!!!";
        }
        return code;
    }

    private boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String JNIToJavaKeyType(String keyType) throws PKIException {
        if (keyType.equalsIgnoreCase("145")) {
            return new String("SYMMETRY");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_RSA_PUBLICKEY)) {
            return new String("RSA_Public");
        }
        if (keyType.equalsIgnoreCase("2")) {
            return new String("RSA_Private");
        }
        if (keyType.equalsIgnoreCase("16")) {
            return new String("RSA_PublicID");
        }
        if (keyType.equalsIgnoreCase("32")) {
            return new String("RSA_PrivateID");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_MASTERKEYID)) {
            return new String("MASTERKEY");
        }
        if (keyType.equalsIgnoreCase("256")) {
            return new String("ECDSA_Public");
        }
        if (keyType.equalsIgnoreCase("258")) {
            return new String("ECDSA_PublicID");
        }
        if (keyType.equalsIgnoreCase("257")) {
            return new String("ECDSA_Private");
        }
        if (keyType.equalsIgnoreCase("259")) {
            return new String("ECDSA_PrivateID");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_DSA_PUBLICKEY)) {
            return new String("DSA_Public");
        }
        if (keyType.equalsIgnoreCase("64")) {
            return new String("DSA_PublicID");
        }
        if (keyType.equalsIgnoreCase("8")) {
            return new String("DSA_Private");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_DSA_PRIVATEKEYID)) {
            return new String("DSA_PrivateID");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_SM2_PUBLICKEY)) {
            return new String("SM2_Public");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_SM2_PUBLICKEYID)) {
            return new String("SM2_PublicID");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_SM2_PRIVATEKEY)) {
            return new String("SM2_Private");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_SM2_PRIVATEKEYID)) {
            return new String("SM2_PrivateID");
        }
        throw new PKIException("8190", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private int JavaToJNIKeyType(String keyType) throws PKIException {
        if (keyType.equalsIgnoreCase("SYMMETRY")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("DES")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("DESede")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("SCB2")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("SF33")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("SM4")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("RSA_Public")) {
            return Integer.parseInt(CKC_KEYTYPE_RSA_PUBLICKEY);
        }
        if (keyType.equalsIgnoreCase("RSA_Private")) {
            return Integer.parseInt("2");
        }
        if (keyType.equalsIgnoreCase("RSA_PublicID")) {
            return Integer.parseInt("16");
        }
        if (keyType.equalsIgnoreCase("RSA_PrivateID")) {
            return Integer.parseInt("32");
        }
        if (keyType.equalsIgnoreCase("MASTERKEY")) {
            return Integer.parseInt(CKC_KEYTYPE_MASTERKEYID);
        }
        if (keyType.equalsIgnoreCase("ECDSA_Private")) {
            return Integer.parseInt("257");
        }
        if (keyType.equalsIgnoreCase("ECDSA_PrivateID")) {
            return Integer.parseInt("259");
        }
        if (keyType.equalsIgnoreCase("ECDSA_Public")) {
            return Integer.parseInt("256");
        }
        if (keyType.equalsIgnoreCase("ECDSA_PublicID")) {
            return Integer.parseInt("258");
        }
        if (keyType.equalsIgnoreCase("DSA_Private")) {
            return Integer.parseInt("8");
        }
        if (keyType.equalsIgnoreCase("DSA_PrivateID")) {
            return Integer.parseInt(CKC_KEYTYPE_DSA_PRIVATEKEYID);
        }
        if (keyType.equalsIgnoreCase("DSA_Public")) {
            return Integer.parseInt(CKC_KEYTYPE_DSA_PUBLICKEY);
        }
        if (keyType.equalsIgnoreCase("DSA_PublicID")) {
            return Integer.parseInt("64");
        }
        if (keyType.equalsIgnoreCase("SM2_Private")) {
            return Integer.parseInt(CKC_KEYTYPE_SM2_PRIVATEKEY);
        }
        if (keyType.equalsIgnoreCase("SM2_PrivateID")) {
            return Integer.parseInt(CKC_KEYTYPE_SM2_PRIVATEKEYID);
        }
        if (keyType.equalsIgnoreCase("SM2_Public")) {
            return Integer.parseInt(CKC_KEYTYPE_SM2_PUBLICKEY);
        }
        if (keyType.equalsIgnoreCase("SM2_PublicID")) {
            return Integer.parseInt(CKC_KEYTYPE_SM2_PUBLICKEYID);
        }
        throw new PKIException("8190", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private long JavaToJNIMechanismType(String mechanismType) throws PKIException {
        if (mechanismType.equals("RSA")) {
            return 0L;
        }
        if (mechanismType.equals("RSA/ECB/PKCS1PADDING")) {
            return 1L;
        }
        if (mechanismType.equals("ECDSA")) {
            return 4160L;
        }
        if (mechanismType.equals("SHA1withECDSA")) {
            return 4162L;
        }
        if (mechanismType.equalsIgnoreCase("DSA")) {
            return 16L;
        }
        if (mechanismType.equals("MD2")) {
            return 512L;
        }
        if (mechanismType.equals("MD5")) {
            return 528L;
        }
        if (mechanismType.equals("MD5withRSAEncryption")) {
            return 5L;
        }
        if (mechanismType.equals("SHA1")) {
            return 544L;
        }
        if (mechanismType.equals("SHA1withRSAEncryption")) {
            return 6L;
        }
        if (mechanismType.equals("DES")) {
            return 288L;
        }
        if (mechanismType.equals("DES/ECB/PKCS7Padding")) {
            return 289L;
        }
        if (mechanismType.equals("DES/CBC/PKCS7Padding")) {
            return 290L;
        }
        if (mechanismType.equals("DESede")) {
            return 305L;
        }
        if (mechanismType.equals("DESede/ECB/PKCS7Padding")) {
            return 306L;
        }
        if (mechanismType.equals("DESede/CBC/PKCS7Padding")) {
            return 307L;
        }
        if (mechanismType.equals("RC2")) {
            return 256L;
        }
        if (mechanismType.equals("RC2/ECB/PKCS7Padding")) {
            return 257L;
        }
        if (mechanismType.equals("RC2/CBC/PKCS7Padding")) {
            return 258L;
        }
        if (mechanismType.equals("RC4")) {
            return 272L;
        }
        if (mechanismType.equals("RC4")) {
            return 273L;
        }
        if (mechanismType.equals("SF33")) {
            return -2147483600L;
        }
        if (mechanismType.equals("SF33_ECB")) {
            return -2147483599L;
        }
        if (mechanismType.equals("SCB2")) {
            return -2147483633L;
        }
        if (mechanismType.equals("SCB2_CBC")) {
            return -2147483631L;
        }
        if (mechanismType.equals("SCB2_ECB")) {
            return -2147483632L;
        }
        if (mechanismType.equals("CKM_RSA_RAW")) {
            return -2130706431L;
        }
        if (mechanismType.equals("SHA224")) {
            return 597L;
        }
        if (mechanismType.equals("SHA256")) {
            return 592L;
        }
        if (mechanismType.equals("SHA384")) {
            return 608L;
        }
        if (mechanismType.equals("SHA512")) {
            return 624L;
        }
        if (mechanismType.equals("SHA224withRSAEncryption")) {
            return 70L;
        }
        if (mechanismType.equals("SHA256withRSAEncryption")) {
            return 64L;
        }
        if (mechanismType.equals("SHA384withRSAEncryption")) {
            return 65L;
        }
        if (mechanismType.equals("SHA512withRSAEncryption")) {
            return 66L;
        }
        if (mechanismType.equals("SHA1withDSA")) {
            return 18L;
        }
        if (mechanismType.equals("SHA224withDSA")) {
            return 19L;
        }
        if (mechanismType.equals("SHA256withDSA")) {
            return 20L;
        }
        if (mechanismType.equals("SHA224withECDSA")) {
            return 4163L;
        }
        if (mechanismType.equals("SHA256withECDSA")) {
            return 4164L;
        }
        if (mechanismType.equals("SM2")) {
            return -2147450879L;
        }
        if (mechanismType.equals("SM2_RAW")) {
            return -2147450368L;
        }
        if (mechanismType.equals("SM3withSM2Encryption")) {
            return -2147450624L;
        }
        if (mechanismType.equals("SM3")) {
            return -2147483643L;
        }
        if (mechanismType.equals("AES")) {
            return 4224L;
        }
        if (mechanismType.equals("SF33_CBC")) {
            return -2147483598L;
        }
        if (mechanismType.equals("AES/ECB/PKCS7Padding")) {
            return 4225L;
        }
        if (mechanismType.equals("AES/CBC/PKCS7Padding")) {
            return 4226L;
        }
        if (mechanismType.equals("SM4")) {
            return -2147483385L;
        }
        if (mechanismType.equals("SM4_ECB")) {
            return -2147483384L;
        }
        if (mechanismType.equals("SM4_CBC")) {
            return -2147483383L;
        }
        throw new PKIException("8190", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    public boolean DestroyKeyPair(Mechanism mechanism) throws PKIException {
        byte[] priKeyValue;
        byte[] pubKeyValue;
        int keyType;
        String mType = mechanism.getMechanismType();
        if (!mType.equals("RSA")) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        int keyNum = 0;
        if (mechanism.getParam() != null) {
            Object ob = mechanism.getParam();
            GenKeyAttribute keyAtt = (GenKeyAttribute)ob;
            keyNum = keyAtt.getKeyNum();
        }
        return this.DestroyKeyPair(mechType, keyType = Integer.parseInt(this.CfgTag.getNoExportRSAKeyType()), pubKeyValue = (String.valueOf(this.CfgTag.getNoExportRSAPubKeyValue()) + String.valueOf(keyNum)).getBytes(), priKeyValue = (String.valueOf(this.CfgTag.getNoExportRSAPriKeyValue()) + String.valueOf(keyNum)).getBytes(), this.tag.getBytes()) == 0;
    }

    public String Version() throws PKIException {
        byte[] Version2 = this.getVersion();
        ByteArrayInputStream in = new ByteArrayInputStream(Version2);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("8193", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25", ex);
        }
        return recvData.getProperty("Version");
    }

    private native byte[] getVersion();

    private native int p11Initialize(byte[] var1, byte[] var2, int var3);

    private native byte[] generateKey(long var1, int var3, byte[] var4);

    private native byte[] generateKeyPair(long var1, int var3, byte[] var4);

    private native byte[] findKeyPair(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] updateKeyPair(long var1, byte[] var3, byte[] var4, int var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    private native int DestroyKeyPair(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] sign(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] verifySign(long var1, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private native byte[] encrypt(long var1, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private native byte[] wrapKeyEnc(byte[] var1, byte[] var2, long var3, long var5, byte[] var7, byte[] var8, byte[] var9);

    private native byte[] masterEncrypt(long var1, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private native byte[] masterDecrypt(long var1, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private native byte[] decrypt(long var1, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    private native byte[] importCert(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private native byte[] getCert(byte[] var1, byte[] var2);

    private native byte[] destroyCert(byte[] var1, byte[] var2, byte[] var3);

    private native byte[] destroyCerts(byte[] var1, byte[] var2);

    private native int p11Finalize(byte[] var1);

    private native byte[] digest(long var1, byte[] var3, byte[] var4);

    private native byte[] generateRandom(int var1, byte[] var2);

    private native byte[] encryptInit(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] encryptUpdate(long var1, byte[] var3, byte[] var4);

    private native byte[] encryptFinal(long var1, byte[] var3);

    private native byte[] decryptInit(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] decryptUpdate(long var1, byte[] var3, byte[] var4);

    private native byte[] decryptFinal(long var1, byte[] var3);

    private native byte[] SignInit(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native int SignUpdate(long var1, byte[] var3, byte[] var4);

    private native byte[] SignFinal(long var1, byte[] var3);

    private native byte[] VerifyInit(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native int VerifyUpdate(long var1, byte[] var3, byte[] var4);

    private native int VerifyFinal(long var1, byte[] var3, byte[] var4);

    private native byte[] DigestInit(long var1, byte[] var3, byte[] var4);

    private native int DigestUpdate(long var1, byte[] var3, byte[] var4);

    private native byte[] DigestFinal(long var1, byte[] var3);

    private native byte[] updateKeyPair(byte[] var1, byte[] var2, long var3, long var5, byte[] var7, byte[] var8, byte[] var9);

    private native byte[] getMRTDVision(byte[] var1, byte[] var2);

    public static void main(String[] args) {
        try {
            Object instance = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte[] digest(Mechanism mechanism, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SM3") || mType.equals("SHA1") || mType.equals("SHA224") || mType.equals("SHA256") || mType.equals("SHA384") || mType.equals("SHA512"))) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] digest = null;
        byte[] sessionInfo = null;
        sessionInfo = this.DigestInit(mechType, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (!error.equals(JIT_CKR_OK) || info == null) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
        }
        hSess = Integer.parseInt(info);
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                byte[] data = new byte[i];
                System.arraycopy(buffer, 0, data, 0, i);
                int rv = this.DigestUpdate(hSess, data, this.tag.getBytes());
                if (rv == 0) continue;
                error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
        digest = this.DigestFinal(hSess, this.tag.getBytes());
        in = new ByteArrayInputStream(digest);
        recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDig = recvData.getProperty("DigestData");
        error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvDig != null) {
            Hex hex = new Hex();
            byte[] dig = Hex.decode(recvDig);
            return dig;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] mac(Mechanism mechanism, JKey key, InputStream sourceData) throws PKIException {
        throw new PKIException("8193", "MAC\u64cd\u4f5c\u5931\u8d25 mac() JHardLib didn't support Stream-Operation yet. ");
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, InputStream sourceData, byte[] macData) throws PKIException {
        throw new PKIException("8194", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 verifyMac() JHardLib didn't support Stream-Operation yet. ");
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] signData = null;
        byte[] sessionInfo = null;
        byte[] key = null;
        key = prvKey.getKey() != null ? Parser.softKey2HardCustomKey(prvKey.getKeyType(), prvKey.getKey()) : Long.toString(prvKey.getKeyID()).getBytes();
        sessionInfo = this.SignInit(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), key, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (!error.equals(JIT_CKR_OK) || info == null) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        hSess = Integer.parseInt(info);
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                byte[] data = new byte[i];
                System.arraycopy(buffer, 0, data, 0, i);
                int rv = this.SignUpdate(hSess, data, this.tag.getBytes());
                if (rv == 0) continue;
                error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        signData = this.SignFinal(hSess, this.tag.getBytes());
        in = new ByteArrayInputStream(signData);
        recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvSign = recvData.getProperty("SignData");
        error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvSign != null) {
            Hex hex = new Hex();
            byte[] sign = Hex.decode(recvSign);
            return sign;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, InputStream sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] sessionInfo = null;
        byte[] key = null;
        key = Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey());
        sessionInfo = this.VerifyInit(mechType, this.JavaToJNIKeyType(pubKey.getKeyType()), key, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (!error.equals(JIT_CKR_OK) || info == null) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        hSess = Integer.parseInt(info);
        int rv = 0;
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                byte[] data = new byte[i];
                System.arraycopy(buffer, 0, data, 0, i);
                rv = this.VerifyUpdate(hSess, data, this.tag.getBytes());
                if (rv == 0) continue;
                error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        rv = this.VerifyFinal(hSess, signData, this.tag.getBytes());
        if (rv == 0) {
            return true;
        }
        if (192 == rv) {
            return false;
        }
        error = String.valueOf(rv);
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData) throws PKIException {
        try {
            int len = sourceData.available();
            byte[] data = new byte[len];
            sourceData.read(data);
            return this.encrypt(mechanism, enKey, data);
        }
        catch (Exception ex) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData) throws PKIException {
        try {
            int len = encryptedData.available();
            byte[] data = new byte[len];
            encryptedData.read(data);
            return this.decrypt(mechanism, deKey, data);
        }
        catch (Exception ex) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public long encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData, OutputStream out) throws PKIException {
        JHandle hd = this.encryptInit(mechanism, enKey);
        int encLen = 0;
        try {
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] enc = null;
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                data = new byte[i];
                System.arraycopy(buffer, 0, data, 0, i);
                if (1024 != data.length) break;
                enc = this.encryptUpdate(hd, mechanism, data);
                if (enc == null) {
                    throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
                }
                encLen += enc.length;
                out.write(enc);
            }
            if ((enc = this.encryptFinal(hd, mechanism, data)) == null) {
                throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
            }
            out.write(enc);
            return encLen += enc.length;
        }
        catch (Exception ex) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public long decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData, OutputStream out) throws PKIException {
        JHandle hd = this.decryptInit(mechanism, deKey);
        long decLen = 0L;
        int i = 0;
        try {
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] dec = null;
            while ((i = encryptedData.read(buffer)) > 0) {
                data = new byte[i];
                System.arraycopy(buffer, 0, data, 0, i);
                if (1024 != data.length) break;
                dec = this.decryptUpdate(hd, mechanism, data);
                if (dec == null) {
                    throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25");
                }
                decLen += (long)dec.length;
                out.write(dec);
            }
            if ((dec = this.decryptFinal(hd, mechanism, data)) == null) {
                throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25");
            }
            out.write(dec);
            return decLen += (long)dec.length;
        }
        catch (Exception ex) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] decData = null;
        byte[] tmpdec = null;
        if (sourceData != null && (tmpdec = this.decryptUpdate(handle, mechanism, sourceData)) == null) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25");
        }
        decData = this.decryptFinal(handle.getHardLibHandle(), this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(decData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            if (mechanism.isPad()) {
                tmpdec = this.paddingDrop(mechanism, tmpdec);
            }
            return tmpdec;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public JHandle decryptInit(Mechanism mechanism, JKey deKey) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        CBCParam cbcParam = (CBCParam)mechanism.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        JHandle encHandle = null;
        byte[] decInit = null;
        decInit = mechType == 1L && deKey.getKey() == null ? this.decryptInit(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Long.toString(deKey.getKeyID()).getBytes(), cbcIv, this.tag.getBytes()) : (mechType == 1L && deKey.getKey() != null ? this.decryptInit(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), cbcIv, this.tag.getBytes()) : (mechType == -2130706431L && deKey.getKey() != null ? this.decryptInit(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), cbcIv, this.tag.getBytes()) : (mechType == -2147450368L && deKey.getKey() != null ? this.decryptInit(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), cbcIv, this.tag.getBytes()) : this.decryptInit(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), deKey.getKey(), cbcIv, this.tag.getBytes()))));
        ByteArrayInputStream in = new ByteArrayInputStream(decInit);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDecInit = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvDecInit != null) {
            encHandle = new JHandle(Long.parseLong(recvDecInit), null);
            return encHandle;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] decryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] decData = null;
        decData = this.decryptUpdate(handle.getHardLibHandle(), sourceData, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(decData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDec = recvData.getProperty("DecData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvDec != null) {
            Hex hex = new Hex();
            byte[] dec = Hex.decode(recvDec);
            return dec;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8191", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] encryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] encData = null;
        if (mechanism.isPad()) {
            sourceData = this.getPaddingData(mechanism, sourceData);
        }
        byte[] tmpenc = null;
        if (sourceData != null && (tmpenc = this.encryptUpdate(handle, mechanism, sourceData)) == null) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
        }
        encData = this.encryptFinal(handle.getHardLibHandle(), this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(encData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK)) {
            return tmpenc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public JHandle encryptInit(Mechanism mechanism, JKey enKey) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        JHandle encHandle = null;
        byte[] encInit = null;
        CBCParam cbcParam = (CBCParam)mechanism.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        encInit = mechType == 1L ? this.encryptInit(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Parser.softKey2HardCustomKey(enKey.getKeyType(), enKey.getKey()), cbcIv, this.tag.getBytes()) : (mechType == -2147450368L ? this.encryptInit(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Parser.softKey2HardCustomKey(enKey.getKeyType(), enKey.getKey()), cbcIv, this.tag.getBytes()) : this.encryptInit(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), enKey.getKey(), cbcIv, this.tag.getBytes()));
        ByteArrayInputStream in = new ByteArrayInputStream(encInit);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvEncInit = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvEncInit != null) {
            encHandle = new JHandle(Long.parseLong(recvEncInit), null);
            return encHandle;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] encryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SF33_ECB") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM2_RAW") || mType.equals("SF33_CBC") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") || mType.equals("SCB2_CBC") || mType.equals("SCB2_ECB") || mType.equals("CKM_RSA_RAW"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        if (!this.isDataEnough(mechanism, sourceData)) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 source need padding enough");
        }
        byte[] encData = null;
        encData = this.encryptUpdate(handle.getHardLibHandle(), sourceData, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(encData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvEnc = recvData.getProperty("EncData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvEnc != null) {
            Hex hex = new Hex();
            byte[] enc = Hex.decode(recvEnc);
            return enc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public String getCfgTagName() throws PKIException {
        return this.tag;
    }

    public void setCfgTag(PKIToolConfig cfg) throws PKIException {
        this.CfgTag = cfg;
        this.tag = cfg.getTagName();
    }

    public PKIToolConfig getCfgTag() throws PKIException {
        return this.CfgTag;
    }

    private Mechanism encMech2genMech(Mechanism encMech) throws PKIException {
        if (encMech == null) {
            return null;
        }
        String mech = encMech.getMechanismType();
        if (mech.equals("SF33_ECB") || mech.equals("SF33_CBC")) {
            return new Mechanism("SF33");
        }
        if (mech.equals("DES/ECB/PKCS7Padding") || mech.equals("DES/CBC/PKCS7Padding")) {
            return new Mechanism("DES");
        }
        if (mech.equals("DESede/ECB/PKCS7Padding") || mech.equals("DESede/CBC/PKCS7Padding")) {
            return new Mechanism("DESede");
        }
        if (mech.equals("AES/ECB/PKCS7Padding") || mech.equals("AES/CBC/PKCS7Padding")) {
            return new Mechanism("AES");
        }
        if (mech.equals("SCB2_ECB") || mech.equals("SCB2_CBC")) {
            return new Mechanism("SCB2");
        }
        if (mech.equals("RSA/ECB/PKCS1PADDING")) {
            return new Mechanism("RSA");
        }
        if (mech.equals("SM2_RAW")) {
            return new Mechanism("SM2");
        }
        if (mech.equals("SM4_ECB") || mech.equals("SM4_CBC")) {
            return new Mechanism("SM4");
        }
        return null;
    }

    private String encMech2KeyType(Mechanism encMech) throws PKIException {
        if (encMech == null) {
            return null;
        }
        String mech = encMech.getMechanismType();
        if (mech.equals("SF33_ECB") || mech.equals("SF33_CBC")) {
            return "SF33";
        }
        if (mech.equals("DES/ECB/PKCS7Padding") || mech.equals("DES/CBC/PKCS7Padding")) {
            return "DES";
        }
        if (mech.equals("DESede/ECB/PKCS7Padding") || mech.equals("DESede/CBC/PKCS7Padding")) {
            return "DESede";
        }
        if (mech.equals("AES/ECB/PKCS7Padding") || mech.equals("AES/CBC/PKCS7Padding")) {
            return "AES";
        }
        if (mech.equals("SCB2_ECB") || mech.equals("SCB2_CBC")) {
            return "SCB2";
        }
        if (mech.equals("SM4_ECB") || mech.equals("SM4_CBC")) {
            return "SM4";
        }
        return null;
    }

    public List WrapKeyEnc(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, byte[] data) throws PKIException {
        String pubEncType = pubEncMech.getMechanismType();
        String sysEnctype = sysEncMech.getMechanismType();
        if (!(sysEnctype.equals("SF33_ECB") || sysEnctype.equals("DES/CBC/PKCS7Padding") || sysEnctype.equals("DES/ECB/PKCS7Padding") || sysEnctype.equals("DESede/ECB/PKCS7Padding") || sysEnctype.equals("AES/ECB/PKCS7Padding") || sysEnctype.equals("AES/CBC/PKCS7Padding") || sysEnctype.equals("DESede/CBC/PKCS7Padding") || sysEnctype.equals("SCB2_CBC") || sysEnctype.equals("SCB2_ECB") || sysEnctype.equals("SM4_CBC") || sysEnctype.equals("SM4_ECB"))) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + sysEnctype);
        }
        if (!pubEncType.equals("RSA/ECB/PKCS1PADDING") && !pubEncType.equals("SM2_RAW")) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + pubEncType);
        }
        CBCParam cbcParam = (CBCParam)sysEncMech.getParam();
        byte[] cbcIv = null;
        if (cbcParam != null) {
            cbcIv = cbcParam.getIv();
        }
        if (sysEncMech.isPad()) {
            data = this.getPaddingData(sysEncMech, data);
        }
        byte[] encData = null;
        long lpubEncType = this.JavaToJNIMechanismType(pubEncType);
        long lsysEncType = this.JavaToJNIMechanismType(sysEnctype);
        encData = sysKey == null ? this.wrapKeyEnc(Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey()), null, lpubEncType, lsysEncType, data, cbcIv, this.tag.getBytes()) : this.wrapKeyEnc(Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey()), sysKey.getKey(), lpubEncType, lsysEncType, data, cbcIv, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(encData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvEnc = recvData.getProperty("EncData");
        String error = recvData.getProperty("Error");
        String outKey = recvData.getProperty("WrapedSysKey");
        ArrayList<byte[]> ls = new ArrayList<byte[]>();
        if (error.equals(JIT_CKR_OK) && recvEnc != null) {
            Hex hex = new Hex();
            ls.add(Hex.decode(recvEnc));
            ls.add(Hex.decode(outKey));
            return ls;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    private byte[] getPaddingData(Mechanism mech, byte[] data) throws PKIException {
        if (data == null) {
            return null;
        }
        String mType = mech.getMechanismType();
        if (mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SM2_RAW") || mType.equals("RC4")) {
            return data;
        }
        byte[] ret = null;
        int pad = 0;
        pad = mType.equals("SF33_ECB") || mType.equals("SF33_CBC") || mType.equals("SCB2_ECB") || mType.equals("SCB2_CBC") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC") ? (data.length % 16 == 0 ? 16 : 16 - data.length % 16) : (data.length % 8 == 0 ? 8 : 8 - data.length % 8);
        ret = new byte[data.length + pad];
        System.arraycopy(data, 0, ret, 0, data.length);
        int i = 0;
        while (i < pad) {
            ret[data.length + i] = (byte)pad;
            ++i;
        }
        return ret;
    }

    private boolean isDataEnough(Mechanism mech, byte[] data) throws PKIException {
        if (data == null) {
            return false;
        }
        String mType = mech.getMechanismType();
        if (mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SM2_RAW") || mType.equals("RC4")) {
            return true;
        }
        if (mType.equals("SF33_ECB") || mType.equals("SF33_CBC") || mType.equals("SCB2_ECB") || mType.equals("SCB2_CBC") || mType.equals("AES/ECB/PKCS7Padding") || mType.equals("AES/CBC/PKCS7Padding") || mType.equals("SM4_ECB") || mType.equals("SM4_CBC")) {
            return data.length % 16 == 0;
        }
        return data.length % 8 == 0;
    }

    private byte[] paddingDrop(Mechanism mech, byte[] data) throws PKIException {
        String mType = mech.getMechanismType();
        if (mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SM2_RAW") || mType.equals("RC4")) {
            return data;
        }
        byte pad = data[data.length - 1];
        if (pad < 1 || pad > data.length) {
            throw new PKIException("drop padding error...");
        }
        byte[] ret = new byte[data.length - pad];
        System.arraycopy(data, 0, ret, 0, data.length - pad);
        return ret;
    }

    public String getSessVersion() throws PKIException {
        byte[] version = null;
        version = this.getMRTDVision(null, null);
        ByteArrayInputStream in = new ByteArrayInputStream(version);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException pKIException = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
        }
        String error = recvData.getProperty("Error");
        String recvVersion = recvData.getProperty("version");
        if (error.equals(JIT_CKR_OK)) {
            return recvVersion;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("819", e);
    }

    private byte[] getSM2EnvedKey(Mechanism sysEncMech, byte[] encedSysKey, byte[] pubkey, byte[] encedPriKey) throws PKIException {
        DERObjectIdentifier oid = null;
        if (sysEncMech.getMechanismType().equals("SM4_ECB")) {
            oid = PKCSObjectIdentifiers.gm_SM4;
        } else if (sysEncMech.getMechanismType().equals("SCB2_ECB")) {
            oid = PKCSObjectIdentifiers.gm_SM1;
        } else if (sysEncMech.getMechanismType().equals("SF33_ECB")) {
            oid = PKCSObjectIdentifiers.gm_SSF33;
        } else if (sysEncMech.getMechanismType().equals("SM4_ECB")) {
            oid = PKCSObjectIdentifiers.gm_SM4;
        } else {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + sysEncMech.getMechanismType());
        }
        AlgorithmIdentifier algo = new AlgorithmIdentifier(oid, new DERNull());
        ByteArrayInputStream bis = new ByteArrayInputStream(encedSysKey);
        ASN1InputStream ais = new ASN1InputStream(bis);
        ASN1EncodableVector v = null;
        try {
            ASN1Sequence sysKey = (ASN1Sequence)ais.readObject();
            DERBitString bitPriKey = new DERBitString(encedPriKey);
            DERBitString bitPubKey = new DERBitString(pubkey);
            v = new ASN1EncodableVector();
            v.add(algo);
            v.add(sysKey);
            v.add(bitPubKey);
            v.add(bitPriKey);
        }
        catch (IOException e) {
            throw new PKIException("8190", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25");
        }
        return Parser.writeDERObj2Bytes(new BERSequence(v));
    }

    public byte[] WrapPriKey(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, JKey priKey) throws PKIException {
        BigInteger sftd;
        try {
            byte[] eccsfpubk = Util.hardKey2SoftPubKey(pubKey);
            sftd = Util.hardKey2SoftPrivKey(priKey);
        }
        catch (Exception ex) {
            throw new PKIException("8190", ex.getMessage());
        }
        if (sftd == null) {
            throw new PKIException("8190hardKey2SoftPrivKey error");
        }
        byte[] priData = Util.byteconvert32(sftd);
        if (priData == null) {
            throw new PKIException("8190data convert error");
        }
        byte[] data = new byte[32 + priData.length];
        int i = 0;
        while (i < 32) {
            data[i] = 0;
            ++i;
        }
        System.arraycopy(priData, 0, data, 32, 32);
        sysEncMech.setPad(false);
        List ls = this.WrapKeyEnc(pubKey, sysKey, pubEncMech, sysEncMech, data);
        byte[] encedPriKey = (byte[])ls.get(0);
        byte[] encedSysKey = (byte[])ls.get(1);
        SM2 sm2 = SM2.Instance();
        ECPoint ecpub = null;
        ecpub = sm2.ecc_point_g.multiply(sftd);
        return this.getSM2EnvedKey(sysEncMech, encedSysKey, ecpub.getEncoded(), encedPriKey);
    }

    public boolean updateKeyPairEx(JKey pubKey, byte[] encedPrvkey, String PrvkeyType, Mechanism prvEncMech, byte[] encedSyskey, Mechanism sysEncMech, JKey decPrvkey, int hardPos, boolean isSignKey) throws PKIException {
        byte[] pubEcPoint;
        byte[] id;
        byte[] prvLabel;
        byte[] pubLabel;
        byte[] prvData;
        byte[] pubData;
        byte[] decedSyskey;
        if (pubKey == null || encedPrvkey == null || encedSyskey == null) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 \u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (!PrvkeyType.equals("RSA_Private") && !PrvkeyType.equals("SM2_Private")) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + PrvkeyType);
        }
        if (decPrvkey == null) {
            GenKeyAttribute attr = new GenKeyAttribute();
            attr.setIsExport(false);
            attr.setKeyNum(hardPos);
            attr.setIsSign(1);
            Mechanism mech = PrvkeyType.equals("RSA_Private") ? new Mechanism("RSA") : new Mechanism("SM2");
            mech.setParam(attr);
            JKeyPair hardKeyPair = this.generateKeyPair(mech, 0);
            decPrvkey = hardKeyPair.getPrivateKey();
        }
        if ((decedSyskey = this.decrypt(prvEncMech, decPrvkey, encedSyskey)) == null) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 decrypt syskey error.");
        }
        String sysType = this.encMech2KeyType(sysEncMech);
        if (sysType == null) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 unkown syskey type.");
        }
        JKey sysKey = new JKey(sysType, decedSyskey);
        long mechType = PrvkeyType.equals("RSA_Private") ? 0L : -2147450879L;
        sysEncMech.setPad(false);
        byte[] decedPrvkey = this.decrypt(sysEncMech, sysKey, encedPrvkey);
        if (PrvkeyType.equals("RSA_Private")) {
            pubData = Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey());
            prvData = Parser.softKey2HardCustomKey("RSA_Private", decedPrvkey);
            pubLabel = this.CfgTag.getNoExportRSAPubKeyValue().getBytes();
            prvLabel = this.CfgTag.getNoExportRSAPriKeyValue().getBytes();
            id = this.CfgTag.getNoExportRSAKeyValue().getBytes();
        } else {
            pubData = Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey());
            prvData = new byte[32];
            System.arraycopy(decedPrvkey, 32, prvData, 0, decedPrvkey.length - 32);
            pubLabel = this.CfgTag.getNoExportECDSAEncPubKeyValue().getBytes();
            prvLabel = this.CfgTag.getNoExportECDSAEncPriKeyValue().getBytes();
            id = this.CfgTag.getNoExportRSAKeyValue().getBytes();
        }
        try {
            byte[] tmp = Util.hardKey2SoftPubKey(pubKey);
            pubEcPoint = new byte[tmp.length - 1];
            System.arraycopy(tmp, 1, pubEcPoint, 0, tmp.length - 1);
        }
        catch (Exception e) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 get ecpoint error", e);
        }
        byte[] prvKey = ECDSAParser.customData2SoftECPrivKey(pubEcPoint, prvData);
        prvKey = Parser.softKey2HardCustomKey("SM2_Private", prvKey);
        byte[] returnData = this.updateKeyPair(mechType, pubData, prvKey, hardPos, pubLabel, prvLabel, id, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(returnData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (!error.equals(JIT_CKR_OK)) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        return true;
    }

    public boolean updateKeyPairEx_sm2wraped(JKey pubKey, byte[] wrapedData, int hardPos, boolean isSignKey) throws PKIException {
        Mechanism sysEnc;
        if (wrapedData == null) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 \u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        ASN1Sequence seq = DERSequence.getInstance(Parser.writeBytes2DERObj(wrapedData));
        if (seq.size() != 4) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 unkown wrapedData");
        }
        AlgorithmIdentifier algo = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        String oid = algo.getObjectId().getId();
        JKey sysKey1 = new JKey();
        if (oid.equals(PKCSObjectIdentifiers.gm_SM4.getId())) {
            sysEnc = new Mechanism("SM4_ECB");
            sysKey1.setKeyType("SM4");
        } else if (oid.equals(PKCSObjectIdentifiers.gm_SM1.getId())) {
            sysEnc = new Mechanism("SCB2_ECB");
            sysKey1.setKeyType("SCB2");
        } else if (oid.equals(PKCSObjectIdentifiers.gm_SSF33.getId())) {
            sysEnc = new Mechanism("SF33_ECB");
            sysKey1.setKeyType("SF33");
        } else {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 unsupported sys encrypt mech");
        }
        byte[] encedSysKey = Parser.writeDERObj2Bytes(seq.getObjectAt(1));
        byte[] encedPriKey = ((DERBitString)seq.getObjectAt(3)).getBytes();
        if (encedSysKey == null || encedPriKey == null) {
            throw new PKIException("8198195", "\u66ff\u6362\u5bc6\u94a5\u5bf9\u5931\u8d25 unkown wrapedData");
        }
        Mechanism encMech = new Mechanism("SM2_RAW");
        return this.updateKeyPairEx(pubKey, encedPriKey, "SM2_Private", encMech, encedSysKey, sysEnc, null, hardPos, isSignKey);
    }

    public JHandle SignInit(Mechanism mechanism, JKey prvKey) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] signData = null;
        byte[] sessionInfo = null;
        byte[] key = null;
        key = prvKey.getKey() != null ? Parser.softKey2HardCustomKey(prvKey.getKeyType(), prvKey.getKey()) : Long.toString(prvKey.getKeyID()).getBytes();
        sessionInfo = this.SignInit(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), key, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (error.equals(JIT_CKR_OK) && info != null) {
            hSess = Integer.parseInt(info);
            JHandle hd = new JHandle();
            hd.setHardLibHandle(hSess);
            return hd;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public void SignUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8195", "invalid handle");
        }
        try {
            int rv = this.SignUpdate(hSess, sourceData, this.tag.getBytes());
            if (rv != 0) {
                String error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] SignFinal(JHandle handle) throws PKIException {
        return this.SignFinal(handle, 0);
    }

    public byte[] SignFinal(JHandle handle, int signDataLen) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8195", "invalid handle");
        }
        byte[] signData = this.SignFinal(hSess, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(signData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvSign = recvData.getProperty("SignData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvSign != null) {
            Hex hex = new Hex();
            byte[] sign = Hex.decode(recvSign);
            return sign;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8195", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public JHandle VerifyInit(Mechanism mechanism, JKey pubKey) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withECDSA") || mType.equals("SHA224withECDSA") || mType.equals("SHA256withECDSA") || mType.equals("SHA1withDSA") || mType.equals("SHA224withDSA") || mType.equals("SHA256withDSA") || mType.equals("SM3withSM2Encryption") || mType.equals("SHA224withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA384withRSAEncryption") || mType.equals("SHA512withRSAEncryption"))) {
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] sessionInfo = null;
        byte[] key = null;
        key = Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey());
        sessionInfo = this.VerifyInit(mechType, this.JavaToJNIKeyType(pubKey.getKeyType()), key, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (error.equals(JIT_CKR_OK) && info != null) {
            hSess = Integer.parseInt(info);
            JHandle hd = new JHandle();
            hd.setHardLibHandle(hSess);
            return hd;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public void VerifyUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8196", "invalid handle");
        }
        try {
            int rv = this.VerifyUpdate(hSess, sourceData, this.tag.getBytes());
            if (rv != 0) {
                String error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8196", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8196", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean VerifyFinal(JHandle handle, byte[] signData) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8196", "invalid handle");
        }
        int rv = this.VerifyFinal(hSess, signData, this.tag.getBytes());
        if (rv == 0) {
            return true;
        }
        if (192 == rv) {
            return false;
        }
        String error = String.valueOf(rv);
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8196", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public JHandle DigestInit(Mechanism mechanism) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SM3") || mType.equals("SHA1") || mType.equals("SHA224") || mType.equals("SHA256") || mType.equals("SHA384") || mType.equals("SHA512"))) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] digest = null;
        byte[] sessionInfo = null;
        sessionInfo = this.DigestInit(mechType, null, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(sessionInfo);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
        String info = recvData.getProperty("SessInfo");
        String error = recvData.getProperty("Error");
        long hSess = 0L;
        if (error.equals(JIT_CKR_OK) && info != null) {
            hSess = Integer.parseInt(info);
            JHandle hd = new JHandle();
            hd.setHardLibHandle(hSess);
            return hd;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
    }

    public void DigestUpdate(JHandle handle, byte[] sourceData) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8192", "invalid handle");
        }
        try {
            int rv = this.DigestUpdate(hSess, sourceData, this.tag.getBytes());
            if (rv != 0) {
                String error = String.valueOf(rv);
                PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
                throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (Exception ex) {
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] DigestFinal(JHandle handle) throws PKIException {
        long hSess = handle.getHardLibHandle();
        if (hSess < 1L) {
            throw new PKIException("8192", "invalid handle");
        }
        byte[] digest = this.DigestFinal(hSess, this.tag.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(digest);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(JIT_PARSE_FAIL, JHARDLib.errorDesc(JIT_PARSE_FAIL));
            throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDig = recvData.getProperty("DigestData");
        String error = recvData.getProperty("Error");
        if (error.equals(JIT_CKR_OK) && recvDig != null) {
            Hex hex = new Hex();
            byte[] dig = Hex.decode(recvDig);
            return dig;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("8192", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
    }
}

