/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher.lib;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.PKIToolConfig;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.JHandle;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.JKeyPair;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.param.CBCParam;
import cn.com.jit.ida.util.pki.cipher.param.PBEParam;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;

public class JCaviumLib
implements Session {
    public static final String PROVIDER = "BC";
    private PKIToolConfig CfgTag = null;
    private String tag = "PKITOOL";

    public JCaviumLib() {
        long err = 0L;
        System.loadLibrary("cavium_native");
        err = this.nativeInitDriver();
        if (err != 0L) {
            System.out.println("FATAL ERROR : Failed to load native Cavium Driver ");
        }
    }

    public void finalize() {
        System.out.println("Deactivating Cavium Driver.");
        this.deactivateDriver();
    }

    public byte[] digest(Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isDigestabled()) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            m.update(sourceData);
            byte[] digest = m.digest();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            mac.update(sourceData);
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, byte[] sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        int type = 0;
        if (mType.equals("MD5withRSAEncryption")) {
            type = 1;
        } else if (mType.equals("SHA1withRSAEncryption")) {
            type = 2;
        } else if (mType.equals("RSA/ECB/PKCS1PADDING")) {
            type = 6;
        } else {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            PrivateKey priv = Parser.convertPrivateKey(prvKey);
            RSAPrivateKey prv = (RSAPrivateKey)priv;
            byte[] out = new byte[prv.getModulus().bitLength() / 8];
            int[] outsize = new int[1];
            long error = JCaviumLib.nativeRSASign(type, JCaviumLib.roundup8(prv.getPrivateExponent()), prv.getPrivateExponent().bitLength(), JCaviumLib.roundup8(prv.getModulus()), prv.getModulus().bitLength(), sourceData, sourceData.length, out, outsize);
            if (error == 0L) {
                if (out.length == outsize[0]) {
                    return out;
                }
                byte[] result = new byte[outsize[0]];
                System.arraycopy(out, 0, result, 0, outsize[0]);
                return result;
            }
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        block12: {
            long error;
            block11: {
                String mType = mechanism.getMechanismType();
                if (!mechanism.isSignabled()) {
                    throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
                }
                int type = 0;
                if (mType.equals("MD5withRSAEncryption")) {
                    type = 1;
                } else if (mType.equals("SHA1withRSAEncryption")) {
                    type = 2;
                } else if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                    type = 6;
                } else {
                    throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
                }
                try {
                    PublicKey pub = Parser.convertPublicKey(pubKey);
                    RSAPublicKey publicKey = (RSAPublicKey)pub;
                    error = JCaviumLib.nativeRSAVerify(type, JCaviumLib.roundup8(publicKey.getPublicExponent()), publicKey.getPublicExponent().bitLength(), JCaviumLib.roundup8(publicKey.getModulus()), publicKey.getModulus().bitLength(), signData, signData.length, sourceData, sourceData.length);
                    if (error != 1L) break block11;
                    return true;
                }
                catch (Exception ex) {
                    throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
                }
            }
            if (error != 0L) break block12;
            return false;
        }
        throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, byte[] sourceData) throws PKIException {
        try {
            return this.doCipher(mechanism, enKey, true, sourceData);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, byte[] encryptedData) throws PKIException {
        try {
            return this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKey generateKey(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("DES") || mType.equals("DESede") || mType.equals("RC2") || mType.equals("RC4") || mType.equals("CAST5") || mType.equals("IDEA") || mType.equals("AES"))) {
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(mechanism.getMechanismType(), PROVIDER);
            keyGen.init(keyLength);
            SecretKey key = keyGen.generateKey();
            return new JKey(key.getAlgorithm(), key.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("8110", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isGenerateKeyPairabled()) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        KeyPair keyPair = null;
        PublicKey pubKey = null;
        PrivateKey prvKey = null;
        JKey jPubKey = null;
        JKey jPrvKey = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, PROVIDER);
            keyPairGen.initialize(keyLength, new SecureRandom());
            keyPair = keyPairGen.generateKeyPair();
            pubKey = keyPair.getPublic();
            prvKey = keyPair.getPrivate();
            byte[] pubKeyEncoded = pubKey.getEncoded();
            byte[] prvKeyEncoded = prvKey.getEncoded();
            if (mechanism.getMechanismType().equals("RSA")) {
                jPubKey = new JKey("RSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("RSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("DSA")) {
                jPubKey = new JKey("DSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("DSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("ECDSA")) {
                jPubKey = new JKey("ECDSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("ECDSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("ECIES")) {
                jPubKey = new JKey("ECIES_Public", pubKeyEncoded);
                jPrvKey = new JKey("ECIES_Private", prvKeyEncoded);
            }
            return new JKeyPair(jPubKey, jPrvKey);
        }
        catch (Exception ex) {
            throw new PKIException("8111", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", ex);
        }
    }

    public boolean DestroyKeyPair(Mechanism mechanism) throws PKIException {
        throw new UnsupportedOperationException("Method DestroyKeyPair() not yet implemented in JSOFT_LIB.");
    }

    public JKey generatePBEKey(Mechanism mechanism, char[] password) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("PBEWithMD5AndDES") || mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC") || mType.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC"))) {
            if (mType.equalsIgnoreCase("PBE/PKCS5")) {
                mType = "PBEWithMD5AndDES";
            } else {
                throw new PKIException("8112", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
        }
        try {
            byte[] keyData = new String(password).getBytes();
            if (mType.equals("PBEWithMD5AndDES")) {
                return new JKey("PBEWithMD5AndDES", keyData);
            }
            if (mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC")) {
                return new JKey("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", keyData);
            }
            return new JKey("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", keyData);
        }
        catch (Exception ex) {
            throw new PKIException("8112", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25", ex);
        }
    }

    public byte[] generateRandom(Mechanism mechanism, int length) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.getMechanismType().equals("Random")) {
            throw new PKIException("8113", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        SecureRandom sRandom = new SecureRandom();
        byte[] data = new byte[length];
        sRandom.nextBytes(data);
        return data;
    }

    private byte[] doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                return this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, data);
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        byte[] res = cipher.doFinal(data);
        return res;
    }

    public static void main(String[] args) {
        System.out.println("OK");
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism keyGen = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
            Mechanism mechanism = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", new PBEParam());
            JKey key = session.generatePBEKey(keyGen, "HELLO".toCharArray());
            byte[] src = "JIT\u516c\u53f8\u6d4b\u8bd5".getBytes();
            byte[] enData = session.encrypt(mechanism, key, src);
            System.out.println(new String(enData));
            byte[] deData = session.decrypt(mechanism, key, enData);
            System.out.println(new String(deData));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    private byte[] doCipher_RSA_ext(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        RSAEngine eng = new RSAEngine();
        RSAKeyParameters keyParams = null;
        if (jkey.getKeyType().equals("RSA_Public")) {
            JCERSAPublicKey pubKey = (JCERSAPublicKey)Parser.convertPublicKey(jkey);
            keyParams = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        } else {
            JCERSAPrivateCrtKey prvKey = (JCERSAPrivateCrtKey)Parser.convertPrivateKey(jkey);
            keyParams = new RSAPrivateCrtKeyParameters(prvKey.getModulus(), prvKey.getPublicExponent(), prvKey.getPrivateExponent(), prvKey.getPrimeP(), prvKey.getPrimeQ(), prvKey.getPrimeExponentP(), prvKey.getPrimeExponentQ(), prvKey.getCrtCoefficient());
        }
        eng.init(isEncrypt, (CipherParameters)keyParams);
        byte[] res = eng.processBlock(data, 0, data.length);
        return res;
    }

    public byte[] digest(Mechanism mechanism, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isDigestabled()) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                m.update(buffer, 0, i);
            }
            byte[] digest = m.digest();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("8122", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                mac.update(buffer, 0, i);
            }
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("8123", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, InputStream sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("8124", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            signData = signature.sign();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException("8125", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, InputStream sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.isSignabled()) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(pubKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("8126", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData) throws PKIException {
        try {
            return this.doCipher(mechanism, enKey, true, sourceData);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData) throws PKIException {
        try {
            return this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    private byte[] doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, InputStream data) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                byte[] bs = new byte[data.available()];
                data.read(bs);
                data.close();
                return this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, bs);
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        ByteArrayOutputStream bin = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = data.read(buffer)) > 0) {
            byte[] temp = cipher.update(buffer, 0, i);
            bin.write(temp);
        }
        byte[] res = cipher.doFinal();
        bin.write(res);
        return bin.toByteArray();
    }

    public byte[] decryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        try {
            byte[] res = handle.getSoftLibHandle().doFinal(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle decryptInit(Mechanism mechanism, JKey deKey) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            Cipher largeDataCipher = Cipher.getInstance(mType, PROVIDER);
            int cipherMode = 0;
            cipherMode = 2;
            if (mType.indexOf("PBE") != -1) {
                PBEParam pbeParam = (PBEParam)mechanism.getParam();
                if (pbeParam == null) {
                    throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
                }
                PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey), pbeSpec);
            } else if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey), iv);
            } else {
                largeDataCipher.init(cipherMode, Parser.convertKey(deKey));
            }
            JHandle handle = new JHandle(0L, largeDataCipher);
            return handle;
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        try {
            byte[] res = handle.getSoftLibHandle().update(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encryptFinal(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        try {
            byte[] res = handle.getSoftLibHandle().doFinal(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JHandle encryptInit(Mechanism mechanism, JKey enKey) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            Cipher largeDataCipher = Cipher.getInstance(mType, PROVIDER);
            int cipherMode = 0;
            cipherMode = 1;
            if (mType.indexOf("PBE") != -1) {
                PBEParam pbeParam = (PBEParam)mechanism.getParam();
                if (pbeParam == null) {
                    throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
                }
                PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey), pbeSpec);
            } else if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey), iv);
            } else {
                largeDataCipher.init(cipherMode, Parser.convertKey(enKey));
            }
            JHandle handle = new JHandle(0L, largeDataCipher);
            return handle;
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encryptUpdate(JHandle handle, Mechanism mechanism, byte[] sourceData) throws PKIException {
        try {
            byte[] res = handle.getSoftLibHandle().update(sourceData);
            return res;
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean updateKeyPair(Mechanism mechanism, JKey pubKey, JKey prvKey, int hardPos) throws PKIException {
        throw new PKIException("8128195", "PKIERRORNO updateKeyPair() JSoftLib didn't support Stream-Operation yet. ");
    }

    public native long nativeInitDriver();

    public native long deactivateDriver();

    public static native double nativeAllocContext();

    public static native long nativeFreeContext(double var0);

    public static native long nativeRSASign(int var0, byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int[] var8);

    public static native long nativeRSAVerify(int var0, byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    public native long nativeDigestProcess(byte[] var1, int var2, byte[] var3, int[] var4, int var5);

    public static byte[] roundup8(BigInteger bigInt) {
        int bits = bigInt.bitLength();
        int bytes = (bits + 7) / 8;
        byte[] out = new byte[bytes];
        System.arraycopy(bigInt.toByteArray(), bigInt.toByteArray().length - bytes, out, 0, bytes);
        return out;
    }

    public long encrypt(Mechanism mechanism, JKey enKey, InputStream sourceData, OutputStream out) throws PKIException {
        byte[] enc;
        try {
            enc = this.doCipher(mechanism, enKey, true, sourceData);
            out.write(enc);
        }
        catch (Exception ex) {
            throw new PKIException("8120", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return enc.length;
    }

    public long decrypt(Mechanism mechanism, JKey deKey, InputStream encryptedData, OutputStream out) throws PKIException {
        byte[] dec;
        try {
            dec = this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("8121", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return dec.length;
    }

    public String getCfgTagName() throws PKIException {
        return this.tag;
    }

    public void setCfgTag(PKIToolConfig cfg) throws PKIException {
        this.CfgTag = cfg;
    }

    public PKIToolConfig getCfgTag() throws PKIException {
        return this.CfgTag;
    }

    public boolean createCertObject(byte[] dn, byte[] certData, byte[] keyId) throws PKIException {
        return false;
    }

    public boolean destroyCertObject(byte[] dn, byte[] keyId) throws PKIException {
        return false;
    }

    public byte[] getCertObject(byte[] keyId) throws PKIException {
        return null;
    }

    public List WrapKeyEnc(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, byte[] data) throws PKIException {
        return null;
    }

    public byte[] WrapPriKey(JKey pubKey, JKey sysKey, Mechanism pubEncMech, Mechanism sysEncMech, JKey priKey) throws PKIException {
        return null;
    }

    public JHandle SignInit(Mechanism mechanism, JKey prvKey) throws PKIException {
        return null;
    }

    public void SignUpdate(JHandle handle, byte[] sourceData) throws PKIException {
    }

    public byte[] SignFinal(JHandle handle) throws PKIException {
        return null;
    }

    public byte[] SignFinal(JHandle handle, int signDataLen) throws PKIException {
        return null;
    }

    public JHandle VerifyInit(Mechanism mechanism, JKey key) throws PKIException {
        return null;
    }

    public void VerifyUpdate(JHandle handle, byte[] sourceData) throws PKIException {
    }

    public boolean VerifyFinal(JHandle handle, byte[] signData) throws PKIException {
        return false;
    }

    public JHandle DigestInit(Mechanism mechanism) throws PKIException {
        return null;
    }

    public void DigestUpdate(JHandle handle, byte[] sourceData) throws PKIException {
    }

    public byte[] DigestFinal(JHandle handle) throws PKIException {
        return null;
    }
}

