/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.cipher.JCrypto;
import cn.com.jit.ida.util.pki.cipher.lib.JHARDLib;
import java.net.URLDecoder;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Version {
    public static String getVersion() {
        Attributes attr;
        block7: {
            Manifest mani;
            block6: {
                String path;
                block5: {
                    try {
                        path = Version.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                        path = URLDecoder.decode(path, "UTF-8");
                        if (path != null) break block5;
                        return "";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return "";
                    }
                }
                JarFile file = new JarFile(path);
                mani = file.getManifest();
                if (mani != null) break block6;
                return "";
            }
            attr = mani.getAttributes("JIT");
            if (attr != null) break block7;
            return "";
        }
        return attr.getValue(new Attributes.Name("JIT-Version"));
    }

    private static String parse(String path) throws Exception {
        boolean needToChange = false;
        int numChars = path.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        while (i < numChars) {
            char c = path.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    break;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = path.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, "UTF-8"));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    break;
                }
                default: {
                    sb.append(c);
                    ++i;
                }
            }
        }
        return needToChange ? sb.toString() : path;
    }

    public static void main(String[] args) {
        System.out.println("PKITOOL version: " + Version.getVersion());
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSJY05B_LIB", null);
            JHARDLib sess = (JHARDLib)jcrypto.openSession("JSJY05B_LIB", "PKITOOL");
            System.out.println("SessionDll version: " + sess.getSessVersion());
            jcrypto.finalize("JSJY05B_LIB", null);
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
    }
}

