/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;

public class Mechanism {
    public static final String RSA = "RSA";
    public static final String RSA_PKCS = "RSA/ECB/PKCS1PADDING";
    public static final String DSA = "DSA";
    public static final String ECIES = "ECIES";
    public static final String ECDSA = "ECDSA";
    public static final String DES_KEY = "DES";
    public static final String DES_ECB = "DES/ECB/PKCS7Padding";
    public static final String DES_ECB_NOPADDING = "DES/ECB/NOPADDING";
    public static final String DES_CBC = "DES/CBC/PKCS7Padding";
    public static final String RC2_KEY = "RC2";
    public static final String RC2_ECB = "RC2/ECB/PKCS7Padding";
    public static final String RC2_CBC = "RC2/CBC/PKCS7Padding";
    public static final String RC4_KEY = "RC4";
    public static final String RC4 = "RC4";
    public static final String DES3_KEY = "DESede";
    public static final String DES3_ECB = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC = "DESede/CBC/PKCS7Padding";
    public static final String CAST5_KEY = "CAST5";
    public static final String CAST5_ECB = "CAST5/ECB/PKCS7Padding";
    public static final String CAST5_CBC = "CAST5/CBC/PKCS7Padding";
    public static final String IDEA_KEY = "IDEA";
    public static final String IDEA_ECB = "IDEA/ECB/PKCS7Padding";
    public static final String IDEA_CBC = "IDEA/CBC/PKCS7Padding";
    public static final String AES_KEY = "AES";
    public static final String AES_ECB = "AES/ECB/PKCS7Padding";
    public static final String AES_CBC = "AES/CBC/PKCS7Padding";
    public static final String PBE_KEY = "PBEWithMD5AndDES";
    public static final String PBE_2KEY = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_3KEY = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_MD5_DES = "PBEWithMD5AndDES";
    public static final String PBE_MD5_RC2 = "PBEWithMD5AndRC2";
    public static final String PBE_SHA1_DES = "PBEWithSHA1AndDES";
    public static final String PBE_SHA1_2DES = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_3DES = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_RC2 = "PBEWithSHA1AndRC2";
    public static final String SF33_KEY = "SF33";
    public static final String SF33_ECB = "SF33_ECB";
    public static final String SF33_CBC = "SF33_CBC";
    public static final String SCB2_KEY = "SCB2";
    public static final String SCB2_ECB = "SCB2_ECB";
    public static final String SCB2_CBC = "SCB2_CBC";
    public static final String SYMMETRY_KEY = "SYMMETRY";
    public static final String MASTER_KEY = "MASTERKEY";
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA256";
    public static final String SHA384 = "SHA384";
    public static final String SHA512 = "SHA512";
    public static final String SHA224 = "SHA224";
    public static final String MD2_RSA = "MD2withRSAEncryption";
    public static final String MD5_RSA = "MD5withRSAEncryption";
    public static final String SHA1_RSA = "SHA1withRSAEncryption";
    public static final String SHA1_DSA = "SHA1withDSA";
    public static final String SHA224_DSA = "SHA224withDSA";
    public static final String SHA256_DSA = "SHA256withDSA";
    public static final String SHA1_EC_DSA = "SHA1withECDSA";
    public static final String SHA224_EC_DSA = "SHA224withECDSA";
    public static final String SHA256_EC_DSA = "SHA256withECDSA";
    public static final String SHA224_RSA = "SHA224withRSAEncryption";
    public static final String SHA256_RSA = "SHA256withRSAEncryption";
    public static final String SHA384_RSA = "SHA384withRSAEncryption";
    public static final String SHA512_RSA = "SHA512withRSAEncryption";
    public static final String SM3 = "SM3";
    public static final String SM2 = "SM2";
    public static final String SM2_RAW = "SM2_RAW";
    public static final String SM3_SM2 = "SM3withSM2Encryption";
    public static final String SM4 = "SM4";
    public static final String SM4_ECB = "SM4_ECB";
    public static final String SM4_CBC = "SM4_CBC";
    public static final String HMAC_MD2 = "HMac-MD2";
    public static final String HMAC_MD5 = "HMac-MD5";
    public static final String HMAC_SHA1 = "HMac-SHA1";
    public static final String RAW = "CKM_RSA_RAW";
    public static final String RANDOM = "Random";
    private String mechanismType;
    private Object param;
    private boolean isPad = true;

    public Mechanism(String mechanismType, Object param) {
        this.mechanismType = mechanismType;
        this.param = param;
    }

    public Mechanism(String mechanismType) {
        this.mechanismType = mechanismType;
        this.param = null;
    }

    public String getMechanismType() {
        return this.mechanismType;
    }

    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public void setMechanismType(String mechanismType) {
        this.mechanismType = mechanismType;
    }

    public boolean isDigestabled() {
        boolean suport = false;
        if (MD2.equals(this.mechanismType) || MD5.equals(this.mechanismType) || SHA1.equals(this.mechanismType) || SHA224.equals(this.mechanismType) || SHA256.equals(this.mechanismType) || SHA384.equals(this.mechanismType) || SHA512.equals(this.mechanismType) || SM3.equals(this.mechanismType)) {
            suport = true;
        }
        return suport;
    }

    public boolean isSignabled() {
        boolean suport = false;
        if (MD2_RSA.equals(this.mechanismType) || MD5_RSA.equals(this.mechanismType) || SHA1_RSA.equals(this.mechanismType) || SHA1_DSA.equals(this.mechanismType) || SHA1_EC_DSA.equals(this.mechanismType) || SHA224_DSA.equals(this.mechanismType) || SHA256_DSA.equals(this.mechanismType) || SHA224_EC_DSA.equals(this.mechanismType) || SHA256_EC_DSA.equals(this.mechanismType) || SHA224_RSA.equals(this.mechanismType) || SHA256_RSA.equals(this.mechanismType) || SHA384_RSA.equals(this.mechanismType) || SHA512_RSA.equals(this.mechanismType) || SM3_SM2.equals(this.mechanismType) || RSA_PKCS.equals(this.mechanismType)) {
            suport = true;
        }
        return suport;
    }

    public boolean isGenerateKeyPairabled() {
        boolean suport = false;
        if (RSA.equals(this.mechanismType) || DSA.equals(this.mechanismType) || ECIES.equals(this.mechanismType) || ECDSA.equals(this.mechanismType)) {
            suport = true;
        }
        return suport;
    }

    public String toString() {
        return "Mechanism [isPad=" + this.isPad + ", mechanismType=" + this.mechanismType + ", param=" + this.param + "]";
    }

    public boolean isPad() {
        return this.isPad;
    }

    public void setPad(boolean isPad) {
        this.isPad = isPad;
    }

    public static Mechanism signMech2DigMech(Mechanism signMech) throws PKIException {
        if (signMech == null) {
            return null;
        }
        String mech = signMech.getMechanismType().toString();
        if (mech.equals(SHA1_RSA) || mech.equals(SHA1_DSA) || mech.equals(SHA1_EC_DSA)) {
            return new Mechanism(SHA1);
        }
        if (mech.equals(SHA224_RSA) || mech.equals(SHA224_DSA) || mech.equals(SHA224_EC_DSA)) {
            return new Mechanism(SHA224);
        }
        if (mech.equals(SHA256_RSA) || mech.equals(SHA256_DSA) || mech.equals(SHA256_EC_DSA)) {
            return new Mechanism(SHA256);
        }
        if (mech.equals(SHA384_RSA)) {
            return new Mechanism(SHA384);
        }
        if (mech.equals(SHA512_RSA)) {
            return new Mechanism(SHA512);
        }
        if (mech.equals(MD2_RSA)) {
            return new Mechanism(MD2);
        }
        if (mech.equals(MD5_RSA)) {
            return new Mechanism(MD5);
        }
        if (mech.equals(SM3_SM2)) {
            return new Mechanism(SM3);
        }
        throw new PKIException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + signMech);
    }

    public static Mechanism GetDigMech(AlgorithmIdentifier dig) throws PKIException {
        if (dig == null) {
            return null;
        }
        String strDig = dig.getObjectId().getId();
        if (strDig.equals(PKCSObjectIdentifiers.sha1.getId())) {
            return new Mechanism(SHA1);
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha224.getId())) {
            return new Mechanism(SHA224);
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha256.getId())) {
            return new Mechanism(SHA256);
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha384.getId())) {
            return new Mechanism(SHA384);
        }
        if (strDig.equals(PKCSObjectIdentifiers.sha512.getId())) {
            return new Mechanism(SHA512);
        }
        if (strDig.equals(PKCSObjectIdentifiers.SM3.getId())) {
            return new Mechanism(SM3);
        }
        if (strDig.equals(PKCSObjectIdentifiers.md2.getId())) {
            return new Mechanism(MD2);
        }
        if (strDig.equals(PKCSObjectIdentifiers.md5.getId())) {
            return new Mechanism(MD5);
        }
        throw new PKIException("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    public static DERObjectIdentifier getSignOid(Mechanism signMech) throws PKIException {
        if (signMech == null) {
            return null;
        }
        String mech = signMech.getMechanismType().toString();
        if (mech.equals(MD2_RSA)) {
            return PKCSObjectIdentifiers.md2WithRSAEncryption;
        }
        if (mech.equals(MD5_RSA)) {
            return PKCSObjectIdentifiers.md5WithRSAEncryption;
        }
        if (mech.equals(SHA1_RSA)) {
            return PKCSObjectIdentifiers.sha1WithRSAEncryption;
        }
        if (mech.equals(SHA224_RSA)) {
            return PKCSObjectIdentifiers.sha224WithRSAEncryption;
        }
        if (mech.equals(SHA256_RSA)) {
            return PKCSObjectIdentifiers.sha256WithRSAEncryption;
        }
        if (mech.equals(SHA384_RSA)) {
            return PKCSObjectIdentifiers.sha384WithRSAEncryption;
        }
        if (mech.equals(SHA512_RSA)) {
            return PKCSObjectIdentifiers.sha512WithRSAEncryption;
        }
        if (mech.equals(SHA1_DSA)) {
            return PKCSObjectIdentifiers.sha1WithDSA;
        }
        if (mech.equals(SHA1_EC_DSA)) {
            return PKCSObjectIdentifiers.ecEncryption;
        }
        if (mech.equals(SM3_SM2)) {
            return PKCSObjectIdentifiers.sm2_with_sm3;
        }
        throw new PKIException("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    public static DERObjectIdentifier Sign2DigOid(Mechanism signMech) throws PKIException {
        if (signMech == null) {
            return null;
        }
        String mech = signMech.getMechanismType().toString();
        if (mech.equals(SHA1_RSA) || mech.equals(SHA1_DSA) || mech.equals(SHA1_EC_DSA)) {
            return PKCSObjectIdentifiers.sha1;
        }
        if (mech.equals(SHA224_RSA) || mech.equals(SHA224_DSA) || mech.equals(SHA224_EC_DSA)) {
            return PKCSObjectIdentifiers.sha224;
        }
        if (mech.equals(SHA256_RSA) || mech.equals(SHA256_DSA) || mech.equals(SHA256_EC_DSA)) {
            return PKCSObjectIdentifiers.sha256;
        }
        if (mech.equals(SHA384_RSA)) {
            return PKCSObjectIdentifiers.sha384;
        }
        if (mech.equals(SHA512_RSA)) {
            return PKCSObjectIdentifiers.sha512;
        }
        if (mech.equals(MD2_RSA)) {
            return PKCSObjectIdentifiers.md2;
        }
        if (mech.equals(MD5_RSA)) {
            return PKCSObjectIdentifiers.md5;
        }
        if (mech.equals(SM3_SM2)) {
            return PKCSObjectIdentifiers.SM3;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    public static DERObjectIdentifier GetDigOid(Mechanism digMech) throws PKIException {
        if (digMech == null) {
            return null;
        }
        if (digMech.getMechanismType().equals(MD2)) {
            return PKCSObjectIdentifiers.md2;
        }
        if (digMech.getMechanismType().equals(MD5)) {
            return PKCSObjectIdentifiers.md5;
        }
        if (digMech.getMechanismType().equals(SM3)) {
            return PKCSObjectIdentifiers.SM3;
        }
        if (digMech.getMechanismType().equals(SHA1)) {
            return PKCSObjectIdentifiers.sha1;
        }
        if (digMech.getMechanismType().equals(SHA224)) {
            return PKCSObjectIdentifiers.sha224;
        }
        if (digMech.getMechanismType().equals(SHA256)) {
            return PKCSObjectIdentifiers.sha256;
        }
        if (digMech.getMechanismType().equals(SHA384)) {
            return PKCSObjectIdentifiers.sha384;
        }
        throw new PKIException("2", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + digMech);
    }

    public static DERObjectIdentifier GetEncOid(Mechanism EncMech) throws PKIException {
        if (EncMech == null) {
            return null;
        }
        String mech = EncMech.getMechanismType().toString();
        if (mech.equals(RSA_PKCS)) {
            return PKCSObjectIdentifiers.rsaEncryption;
        }
        if (mech.equals(SM2_RAW)) {
            return PKCSObjectIdentifiers.SM2_ENC;
        }
        if (mech.equals(DES3_ECB)) {
            return PKCSObjectIdentifiers.des3Encryption;
        }
        if (mech.equals(DES3_CBC)) {
            return PKCSObjectIdentifiers.des3CBCEncryption;
        }
        if (mech.equals(DES_CBC)) {
            return PKCSObjectIdentifiers.desCBCEncryption;
        }
        if (mech.equals(DES_ECB)) {
            return PKCSObjectIdentifiers.desEncryption;
        }
        if (mech.equals(SCB2_ECB)) {
            return PKCSObjectIdentifiers.scb2Encryption;
        }
        if (mech.equals(RC2_CBC)) {
            return PKCSObjectIdentifiers.rc2CBCEncryption;
        }
        if (mech.equals(RC2_ECB)) {
            return PKCSObjectIdentifiers.rc2Encryption;
        }
        if (mech.equals(SM4_ECB)) {
            return PKCSObjectIdentifiers.gm_SM4_ECB;
        }
        if (mech.equals(SF33_CBC)) {
            return PKCSObjectIdentifiers.gm_SSF33_CBC;
        }
        if (mech.equals(SF33_ECB)) {
            return PKCSObjectIdentifiers.gm_SSF33_ECB;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    public static DERObjectIdentifier Sign2EncOid(Mechanism signMech) throws PKIException {
        String mech = signMech.getMechanismType().toString();
        if (mech.equals(SHA1_RSA) || mech.equals(SHA224_RSA) || mech.equals(SHA256_RSA) || mech.equals(SHA384_RSA) || mech.equals(SHA512_RSA) || mech.equals(MD2_RSA) || mech.equals(MD5_RSA)) {
            return PKCSObjectIdentifiers.rsaEncryption;
        }
        if (mech.equals(SM3_SM2)) {
            return PKCSObjectIdentifiers.SM2_SIGN;
        }
        throw new PKIException("8215", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mech);
    }

    public static Mechanism GetOid2Mech(DERObjectIdentifier oid) throws PKIException {
        if (oid.equals(PKCSObjectIdentifiers.sha1)) {
            return new Mechanism(SHA1);
        }
        if (oid.equals(PKCSObjectIdentifiers.sha224)) {
            return new Mechanism(SHA224);
        }
        if (oid.equals(PKCSObjectIdentifiers.sha256)) {
            return new Mechanism(SHA256);
        }
        if (oid.equals(PKCSObjectIdentifiers.sha384)) {
            return new Mechanism(SHA384);
        }
        if (oid.equals(PKCSObjectIdentifiers.sha512)) {
            return new Mechanism(SHA512);
        }
        if (oid.equals(PKCSObjectIdentifiers.SM3)) {
            return new Mechanism(SM3);
        }
        return null;
    }
}

