/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cipher;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.PKIToolConfig;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.cipher.lib.JCaviumLib;
import cn.com.jit.ida.util.pki.cipher.lib.JHARDLib;
import cn.com.jit.ida.util.pki.cipher.lib.JSoftLib;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JCrypto {
    public static final int CKC_ID_SOFTCRY = 1;
    public static final int CKC_ID_SJY05PC = 2;
    public static final int CKC_ID_SJY03Card = 3;
    public static final int CKC_ID_TIMECOS = 4;
    public static final int CKC_ID_30 = 5;
    public static final int CKC_ID_56 = 6;
    public static final int CKC_ID_MIKEY = 7;
    public static final int CKC_ID_EKEY = 8;
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JSJY05B_LIB = "JSJY05B_LIB";
    public static final String JHARD_ANDROID = "JHARD_ANDROID";
    private static JCrypto jCrypto = null;
    private Hashtable htable = new Hashtable();

    private JCrypto() {
    }

    public static synchronized JCrypto getInstance() {
        if (jCrypto == null) {
            jCrypto = new JCrypto();
            return jCrypto;
        }
        return jCrypto;
    }

    public synchronized boolean initialize(String deviceName, Object param) throws PKIException {
        String hash;
        block22: {
            try {
                if (param == null || !(param instanceof String)) {
                    param = "PKITOOL";
                }
                if (!this.htable.containsKey(hash = String.valueOf(deviceName) + param.toString())) break block22;
                return true;
            }
            catch (Exception ex) {
                throw new PKIException("8100", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
            }
        }
        if (deviceName.equals(JSOFT_LIB)) {
            String vmVender = System.getProperty("java.vm.vendor");
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVender.toUpperCase().indexOf("IBM") != -1 || vmVersion.indexOf("1.5") != -1) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            } else {
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
            }
            Provider bcProvider = Security.getProvider("BC");
            bcProvider.remove("Alg.Alias.KeyFactory." + X9ObjectIdentifiers.id_ecPublicKey);
            PKIToolConfig CfgTag = new PKIToolConfig();
            CfgTag.LoadOpt("PKITOOL");
            JSoftLib soft = new JSoftLib();
            soft.setCfgTag(CfgTag);
            this.htable.put(hash, soft);
        } else if (deviceName.equals(JSJY05B_LIB)) {
            PKIToolConfig CfgTag = new PKIToolConfig();
            if (param == null) {
                CfgTag.LoadOpt("PKITOOL");
            } else {
                CfgTag.LoadOpt(param.toString());
            }
            if (new String(CfgTag.getJniUse()).equals("JNI8")) {
                String vmVender = System.getProperty("java.vm.vendor");
                String vmVersion = System.getProperty("java.vm.version");
                if (vmVender.toUpperCase().indexOf("IBM") != -1 || vmVersion.indexOf("1.5") != -1) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                } else {
                    Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
                }
                this.htable.put(deviceName, new JCaviumLib());
            } else {
                JHARDLib lib = new JHARDLib();
                lib.setCfgTag(CfgTag);
                if (param == null) {
                    lib.Initialize("PKITOOL");
                    this.htable.put(hash, lib);
                } else {
                    lib.Initialize(param.toString());
                    this.htable.put(hash, lib);
                }
            }
        } else if (deviceName.equals(JHARD_ANDROID)) {
            PKIToolConfig CfgTag = new PKIToolConfig();
            if (param == null) {
                CfgTag.LoadOpt("PKITOOL");
            } else {
                CfgTag.LoadOpt(param.toString());
            }
            Class<?> cardLibClass = Class.forName("cn.com.jit.android.ida.util.pki.cipher.lib.JExtCardLib");
            Object cardLib = cardLibClass.newInstance();
            Method setCfgMethod = cardLibClass.getMethod("setCfgTag", PKIToolConfig.class);
            setCfgMethod.invoke(cardLib, CfgTag);
            if (param == null) {
                param = new String("PKITOOL");
            }
            Method initMethod = cardLibClass.getMethod("Initialize", String.class);
            initMethod.invoke(cardLib, param.toString());
            this.htable.put(hash, cardLib);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (param == null) {
                param = "PKITOOL";
            }
            String hash = String.valueOf(deviceName) + param.toString();
            if (!deviceName.equals(JSOFT_LIB)) {
                if (deviceName.equals(JSJY05B_LIB)) {
                    JHARDLib sjyLib = param == null ? (JHARDLib)this.htable.get(hash) : (JHARDLib)this.htable.get(hash);
                    if (sjyLib == null) {
                        return true;
                    }
                    sjyLib.Finalize();
                } else if (deviceName.equals(JHARD_ANDROID)) {
                    Object cardLib = this.htable.get(hash);
                    if (cardLib == null) {
                        return true;
                    }
                    Class<?> cardLibClass = Class.forName("cn.com.jit.android.ida.util.pki.cipher.lib.JExtCardLib");
                    Method finMethod = cardLibClass.getMethod("Finalize", new Class[0]);
                    finMethod.invoke(cardLib, new Object[0]);
                }
            }
            this.htable.remove(hash);
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("8101", "\u5378\u8f7d\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
        }
    }

    public Session openSession(String deviceName) throws PKIException {
        return this.openSession(deviceName, null);
    }

    public Session openSession(String deviceName, String CfgName) throws PKIException {
        if (CfgName == null) {
            CfgName = "PKITOOL";
        }
        String hash = String.valueOf(deviceName) + CfgName;
        Session session = deviceName.equals(JSOFT_LIB) ? (Session)this.htable.get(hash) : (Session)this.htable.get(hash);
        if (session == null) {
            throw new PKIException("8102", "\u52a0\u5bc6\u4f1a\u8bdd\u672a\u8fdb\u884c\u521d\u59cb\u5316 " + deviceName);
        }
        return session;
    }

    public static void main(String[] args) throws Exception {
        JCrypto cry = JCrypto.getInstance();
        cry.initialize(JSJY05B_LIB, null);
        System.out.println("success...");
    }
}

