/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cert.dn;

import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class DNTool {
    private X509Name x509 = null;
    private HashMap dnrules = null;

    public DNTool() {
    }

    public DNTool(String dn) {
        String newdn = dn.trim();
        this.x509 = new X509Name(newdn);
        if (this.dnrules != null) {
            this.x509.setRules(this.dnrules);
        }
    }

    public void setRules(Map rules) {
        this.dnrules = (HashMap)rules;
    }

    public boolean dnCheck(String dn) throws Exception {
        try {
            X509Name name = new X509Name(dn.trim());
            if (this.dnrules != null) {
                name.setRules(this.dnrules);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public List getDNInfo(String dnName) {
        if (this.x509 == null) {
            return null;
        }
        index = 0;
        list = new ArrayList<String>();
        tmp = dnName.toUpperCase();
        if (this.dnrules != null) {
            this.x509.setRules(this.dnrules);
        }
        values = this.x509.getValues();
        oids = this.x509.getOIDs();
        names = X509Name.DefaultLookUp;
        oid = names.get(dnName.toLowerCase());
        if (oid != null) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            if (oid.equals(oids.get(index))) {
                list.add((String)values.elementAt(index));
            }
            ++index;
lbl18:
            // 2 sources

            ** while (index != oids.size())
        }
lbl19:
        // 1 sources

        return list;
    }

    public String dnSort(String dn) throws Exception {
        return this.DNConvert(dn);
    }

    public String DNConvert(String dn) throws Exception {
        X509Name name;
        this.x509 = name = new X509Name(dn.trim());
        if (this.dnrules != null) {
            name.setRules(this.dnrules);
            this.x509.setRules(this.dnrules);
        }
        return name.toString().trim();
    }

    public boolean equals(Object dn) {
        if (this == dn) {
            return true;
        }
        if (!(dn instanceof DNTool)) {
            return false;
        }
        return this.equals(dn.toString());
    }

    public boolean equals(String dn) {
        String tmp = null;
        try {
            tmp = this.DNConvert(dn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmp.equals(this.x509.toString().trim());
    }

    public String tostring() {
        if (this.x509 == null) {
            return null;
        }
        if (this.dnrules != null) {
            this.x509.setRules(this.dnrules);
        }
        return this.x509.toString().trim();
    }

    public String convertSun(String dn) throws Exception {
        X509Name name;
        this.x509 = name = new X509Name(dn.trim());
        if (this.dnrules != null) {
            name.setRules(this.dnrules);
            this.x509.setRules(this.dnrules);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(name.getDERObject());
        byte[] dnb = bOut.toByteArray();
        dOut.close();
        X500Principal sundn = new X500Principal(dnb);
        return sundn.toString().trim();
    }

    public static void main(String[] args) throws Exception {
        String aa2 = "cn=\u738b\u7389\u798f,o=\u5409\u5927\u6b63\u5143,ou=kdk,e=wyf@jit.com.cn,c=cn";
        String aa3 = "CN=ABC, O=JIT ,C=CN,OU=123";
        String aa4 = "ou=#123\\,,c=cn,o=jit,cn=abc";
        String aa5 = "s=123,e=cn,t=jit,c=cn,s=qqq";
        String aa1 = "CN=\u738b\u7389\u798f, O=\u5409\u5927\u6b63\u5143, OU=kdk, E=wyf@jit.com.cn, S=ddd, 1.7.7=dddd, C=cn";
        String aa6 = "CN=\\\",O=JIT,C=CN,OU=123";
        HashMap<String, String> regRuleClass = new HashMap<String, String>();
        regRuleClass.put("O", "UTF8String");
        regRuleClass.put("OU", "IA5String");
        regRuleClass.put("CN", "PrintableString");
        DNTool tool = new DNTool();
        aa4 = "O=\"EcGuard Co.,Ltd.\",C=CN";
        DNTool dn = new DNTool();
        System.out.println("source dn:");
        System.out.println(aa6);
        System.out.println("dn.DNConvert:");
        System.out.println(dn.DNConvert(aa6));
        System.out.println("dn.convertSun:");
        System.out.println(dn.convertSun(aa6));
        System.out.println(dn.DNConvert("sn=A,O=JIT,C=CN"));
    }
}

