/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cert;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.Time;
import cn.com.jit.ida.util.pki.asn1.x509.V3TBSCertificateGenerator;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extension;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.extension.Extension;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class X509CertGenerator {
    private Mechanism mechanism = null;
    private String deviceName = null;
    private V3TBSCertificateGenerator tbsCertGen = null;
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private JKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificateStructure tbsCert = null;
    private Hashtable extensionSet = null;
    private HashMap dnrules = null;
    private Vector ordering = new Vector();

    public X509CertGenerator() {
        this.tbsCertGen = new V3TBSCertificateGenerator();
        this.extensionSet = new Hashtable();
    }

    public void setSerialNumber(String strSerialNumber) throws PKIException {
        if (strSerialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = new BigInteger(strSerialNumber, 16);
        this.tbsCertGen.setSerialNumber(new DERInteger(this.serialNumber));
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setSubject(String subject) throws PKIException {
        if (subject == null || subject.trim().length() == 0) {
            throw new PKIException("8151", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subject = subject;
        X509Name x509Sub = new X509Name(subject);
        if (this.dnrules != null) {
            x509Sub.setRules(this.dnrules);
        }
        this.tbsCertGen.setSubject(x509Sub);
    }

    public void setSubject(X509Name x509SubjectName) throws PKIException {
        if (x509SubjectName == null) {
            throw new PKIException("8151", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subject = x509SubjectName.toString();
        if (this.subject.trim().length() == 0) {
            throw new PKIException("8151", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.tbsCertGen.setSubject(x509SubjectName);
    }

    public void setIssuer(String issuer) throws PKIException {
        if (issuer == null || issuer.trim().length() == 0) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.issuer = issuer;
        X509Name x509Issuer = new X509Name(issuer);
        if (this.dnrules != null) {
            x509Issuer.setRules(this.dnrules);
        }
        this.tbsCertGen.setIssuer(x509Issuer);
    }

    public void setIssuer(X509Name x509IssuerName) throws PKIException {
        if (x509IssuerName == null) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.issuer = x509IssuerName.toString();
        if (this.issuer.trim().length() == 0) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.tbsCertGen.setIssuer(x509IssuerName);
    }

    public void setNotBefore(Date notBefore) throws PKIException {
        if (notBefore == null) {
            throw new PKIException("8156", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
    }

    public void setNotAfter(Date notAfter) throws PKIException {
        if (notAfter == null) {
            throw new PKIException("8155", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
    }

    public void setPublicKey(JKey pubKey) throws PKIException {
        if (pubKey == null) {
            throw new PKIException("8157", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pubKey = pubKey;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = Parser.key2SPKI(pubKey);
        }
        catch (Exception ex) {
            throw new PKIException("8134", "\u516c\u94a5\u8f6c\u6362\u4e3a\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u5931\u8d25", ex);
        }
        this.tbsCertGen.setSubjectPublicKeyInfo(spki);
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("8154", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (signatureAlgorithm.equals("MD2withRSAEncryption")) {
            this.mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signatureAlgorithm.equals("MD5withRSAEncryption")) {
            this.mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA1withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (signatureAlgorithm.endsWith("SHA1withECDSA")) {
            this.mechanism = new Mechanism("SHA1withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withDSA")) {
            this.mechanism = new Mechanism("SHA1withDSA");
        } else if (signatureAlgorithm.equals("SHA224withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA224withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA256withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA256withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA384withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA384withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA512withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA512withRSAEncryption");
        } else if (signatureAlgorithm.endsWith("SHA224withECDSA")) {
            this.mechanism = new Mechanism("SHA224withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA256withECDSA")) {
            this.mechanism = new Mechanism("SHA256withECDSA");
        } else if (signatureAlgorithm.endsWith("SM3withSM2Encryption")) {
            this.mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        DERObjectIdentifier oid = signatureAlgorithm.endsWith("SM3withSM2Encryption") ? new DERObjectIdentifier("1.2.156.10197.1.501") : (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid, new DERNull());
        this.tbsCertGen.setSignature(this.sigAlg);
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
    }

    public void addExtensiond(Extension extension) throws PKIException {
        DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
        boolean critical = extension.getCritical();
        byte[] extensionValue = null;
        try {
            extensionValue = extension.encode();
        }
        catch (PKIException ex) {
            throw new PKIException("8160", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
        }
        DEROctetString derOctet = new DEROctetString(extensionValue);
        this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
        this.ordering.add(derOID);
    }

    public void setExtensiond(Vector extensions) throws PKIException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            Extension extension = (Extension)extensions.get(i);
            DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
            boolean critical = extension.getCritical();
            byte[] extensionValue = null;
            try {
                extensionValue = extension.encode();
            }
            catch (PKIException ex) {
                throw new PKIException("8160", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
            }
            DEROctetString derOctet = new DEROctetString(extensionValue);
            this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
            this.ordering.add(derOID);
            ++i;
        }
    }

    public void addExtension(String oid, boolean critical, byte[] derValue) throws PKIException {
        DERObjectIdentifier derOID = new DERObjectIdentifier(oid);
        DEROctetString derOctet = new DEROctetString(derValue);
        this.extensionSet.put(derOID, new X509Extension(critical, (ASN1OctetString)derOctet));
        this.ordering.add(derOID);
    }

    public byte[] generateX509Cert(JKey priKey, Session session) throws PKIException {
        if (this.issuer == null || this.issuer.trim().length() == 0) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.subject == null || this.subject.trim().length() == 0) {
            throw new PKIException("8151", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.pubKey == null) {
            throw new PKIException("8157", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sigAlg == null) {
            throw new PKIException("8154", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.serialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notBefore == null) {
            throw new PKIException("8156", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notAfter == null) {
            throw new PKIException("8155", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateSignature(priKey, session);
        return this.constructCertificate();
    }

    private void generateSignature(JKey priKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCertGen.setExtensions(new X509Extensions(this.ordering, this.extensionSet));
        }
        this.tbsCert = this.tbsCertGen.generateTBSCertificate();
        byte[] bTBSCert = null;
        try {
            bTBSCert = Parser.writeDERObj2Bytes(this.tbsCert.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8159", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCert);
        }
        catch (Exception ex) {
            throw new PKIException("5", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCertificate() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCert);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = Parser.writeDERObj2Bytes(derSeq.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8158", "\u8bc1\u4e66\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return certData;
    }

    public void SetDnRules(Map rules) {
        this.dnrules = (HashMap)rules;
    }
}

