/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cert;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.TBSCertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.Time;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extension;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.asn1.x9.X9ObjectIdentifiers;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import cn.com.jit.ida.util.pki.encoders.Base64;
import cn.com.jit.ida.util.pki.extension.AuthorityInformationAccessExt;
import cn.com.jit.ida.util.pki.extension.AuthorityKeyIdentifierExt;
import cn.com.jit.ida.util.pki.extension.BasicConstraintsExt;
import cn.com.jit.ida.util.pki.extension.CRLDistributionPointsExt;
import cn.com.jit.ida.util.pki.extension.CertificatePoliciesExt;
import cn.com.jit.ida.util.pki.extension.ExtendedKeyUsageExt;
import cn.com.jit.ida.util.pki.extension.ICRegistrationNumberExt;
import cn.com.jit.ida.util.pki.extension.IdentifyCodeExt;
import cn.com.jit.ida.util.pki.extension.InsuranceNumberExt;
import cn.com.jit.ida.util.pki.extension.IssuerAlternativeNamesExt;
import cn.com.jit.ida.util.pki.extension.KeyUsageExt;
import cn.com.jit.ida.util.pki.extension.NameConstraintsExt;
import cn.com.jit.ida.util.pki.extension.OrganizationCodeExt;
import cn.com.jit.ida.util.pki.extension.PolicyConstraintsExt;
import cn.com.jit.ida.util.pki.extension.PolicyMappingsExt;
import cn.com.jit.ida.util.pki.extension.SelfDefExtension;
import cn.com.jit.ida.util.pki.extension.SubjectAltNameExt;
import cn.com.jit.ida.util.pki.extension.SubjectKeyIdentifierExt;
import cn.com.jit.ida.util.pki.extension.TaxationNumberExt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;

public class X509Cert {
    private final String head = "-----BEGIN CERTIFICATE-----";
    private final String end = "-----END CERTIFICATE-----";
    private X509CertificateStructure cert = null;

    public X509Cert(byte[] certData) throws PKIException {
        byte[] derData = this.parseCertData(certData);
        this.initCert(derData);
    }

    public X509Cert(InputStream is) throws PKIException {
        byte[] certIS = null;
        try {
            int length = is.available();
            certIS = new byte[length];
            int readLen = is.read(certIS);
            while (readLen < length) {
                byte[] temp = new byte[length - readLen];
                int i = is.read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
                readLen += i;
            }
            is.close();
        }
        catch (IOException ex) {
            throw new PKIException("8161", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        byte[] derData = this.parseCertData(certIS);
        this.initCert(derData);
    }

    private byte[] parseCertData(byte[] certData) throws PKIException {
        try {
            byte[] tempHead = new byte["-----BEGIN CERTIFICATE-----".length()];
            System.arraycopy(certData, 0, tempHead, 0, tempHead.length);
            if (Parser.isBase64Encode(certData)) {
                certData = Parser.convertBase64(certData);
                return Base64.decode(certData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN CERTIFICATE-----".getBytes())) {
                String cert = new String(certData);
                cert = cert.trim();
                String[] tmp = cert.split("-----BEGIN CERTIFICATE-----");
                cert = tmp[tmp.length - 1];
                tmp = cert.split("-----END CERTIFICATE-----");
                cert = tmp[0];
                byte[] withoutEnter = Parser.convertBase64(cert.getBytes());
                return Base64.decode(withoutEnter);
            }
            return certData;
        }
        catch (Exception ex) {
            throw new PKIException("8161", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("8161", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
    }

    private void initCert(byte[] certData) throws PKIException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certData);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.cert = new X509CertificateStructure(seq);
        }
        catch (Exception ex) {
            throw new PKIException("8161", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("8161", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public X509Cert(X509CertificateStructure certStructure) {
        this.cert = certStructure;
    }

    public X509CertificateStructure getCertStructure() {
        return this.cert;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = Parser.writeDERObj2Bytes(this.cert);
        }
        catch (Exception ex) {
            throw new PKIException("8162", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public int getVersion() {
        return this.cert.getVersion();
    }

    public String getIssuer() {
        X509Name x509IssuerName = this.cert.getIssuer();
        return x509IssuerName.toString().trim();
    }

    public X509Name getX509NameIssuer() {
        X509Name x509IssuerName = this.cert.getIssuer();
        return x509IssuerName;
    }

    public String getSubject() {
        X509Name x509SubjectName = this.cert.getSubject();
        return x509SubjectName.toString().trim();
    }

    public X509Name getX509NameSubject() {
        X509Name x509SubjectName = this.cert.getSubject();
        return x509SubjectName;
    }

    public Date getNotBefore() {
        Time startTime = this.cert.getStartDate();
        return startTime.getDate();
    }

    public Date getNotAfter() {
        Time endTime = this.cert.getEndDate();
        return endTime.getDate();
    }

    public BigInteger getSerialNumber() {
        DERInteger derSN = this.cert.getSerialNumber();
        return derSN.getValue();
    }

    public String getStringSerialNumber() {
        DERInteger derSN = this.cert.getSerialNumber();
        return derSN.getValue().toString(16).toUpperCase();
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public JKey getPublicKey() throws PKIException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        JKey pubKey = null;
        try {
            pubKey = Parser.SPKI2Key(spki);
        }
        catch (Exception ex) {
            throw new PKIException("5", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
        return pubKey;
    }

    public byte[] getTBSCertificate() throws PKIException {
        TBSCertificateStructure tbsCert = this.cert.getTBSCertificate();
        byte[] tbsCertData = null;
        try {
            tbsCertData = Parser.writeDERObj2Bytes(tbsCert.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8159", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        return tbsCertData;
    }

    public byte[] getSignature() {
        DERBitString signature = this.cert.getSignature();
        return signature.getBytes();
    }

    public byte[] getSubjectUniqueId() {
        DERBitString subjectUniqueId = this.cert.getSubjectUniqueId();
        if (subjectUniqueId != null) {
            return subjectUniqueId.getBytes();
        }
        return null;
    }

    public byte[] getIssuerUniqueId() {
        DERBitString issuerUniqueId = this.cert.getSubjectUniqueId();
        if (issuerUniqueId != null) {
            return issuerUniqueId.getBytes();
        }
        return null;
    }

    public boolean verify(JKey pubKey, Session session) throws PKIException {
        DERObjectIdentifier oid = this.cert.getSignatureAlgorithm().getObjectId();
        Mechanism mechanism = null;
        if (oid.equals(PKCSObjectIdentifiers.md2WithRSAEncryption)) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption_v1)) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithECEncryption)) {
            mechanism = new Mechanism("SHA1withECDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithDSA)) {
            mechanism = new Mechanism("SHA1withDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sha224WithRSAEncryption)) {
            mechanism = new Mechanism("SHA224withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            mechanism = new Mechanism("SHA256withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha384WithRSAEncryption)) {
            mechanism = new Mechanism("SHA384withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            mechanism = new Mechanism("SHA512withRSAEncryption");
        } else if (oid.equals(X9ObjectIdentifiers.ecdsa_with_SHA224)) {
            mechanism = new Mechanism("SHA224withECDSA");
        } else if (oid.equals(X9ObjectIdentifiers.ecdsa_with_SHA256)) {
            mechanism = new Mechanism("SHA256withECDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sm2_with_sm3)) {
            mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        byte[] tbsData = this.getTBSCertificate();
        boolean verify = false;
        try {
            verify = session.verifySign(mechanism, pubKey, tbsData, this.getSignature());
        }
        catch (Exception ex) {
            throw new PKIException("6", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return verify;
    }

    public KeyUsageExt getKeyUsage() throws PKIException {
        DERBitString derBitStr = null;
        try {
            derBitStr = (DERBitString)this.getExtensionData(X509Extensions.KeyUsage);
        }
        catch (Exception e) {
            throw new PKIException("8510", "\u6784\u9020\u5bc6\u94a5\u7528\u6cd5\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (derBitStr == null) {
            return null;
        }
        return new KeyUsageExt(derBitStr);
    }

    public InsuranceNumberExt getInsuranceNumber() throws PKIException {
        DERPrintableString derPrtStr = null;
        try {
            derPrtStr = (DERPrintableString)this.getExtensionData(X509Extensions.JIT_InsuranceNumber);
        }
        catch (Exception e) {
            throw new PKIException("8511", "\u6784\u9020\u4e2a\u4eba\u793e\u4f1a\u4fdd\u9669\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (derPrtStr == null) {
            return null;
        }
        return new InsuranceNumberExt(derPrtStr);
    }

    public ICRegistrationNumberExt getICRegistrationNumber() throws PKIException {
        DERPrintableString derPrtStr = null;
        try {
            derPrtStr = (DERPrintableString)this.getExtensionData(X509Extensions.JIT_ICRegistrationNumber);
        }
        catch (Exception e) {
            throw new PKIException("8512", "\u6784\u9020\u4f01\u4e1a\u5de5\u5546\u6ce8\u518c\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (derPrtStr == null) {
            return null;
        }
        return new ICRegistrationNumberExt(derPrtStr);
    }

    public TaxationNumberExt getTaxationNumber() throws PKIException {
        DERPrintableString derPrtStr = null;
        try {
            derPrtStr = (DERPrintableString)this.getExtensionData(X509Extensions.JIT_TaxationNumber);
        }
        catch (Exception e) {
            throw new PKIException("8514", "\u6784\u9020\u4f01\u4e1a\u7a0e\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (derPrtStr == null) {
            return null;
        }
        return new TaxationNumberExt(derPrtStr);
    }

    public OrganizationCodeExt getOrganizationCode() throws PKIException {
        DERPrintableString derPrtStr = null;
        try {
            derPrtStr = (DERPrintableString)this.getExtensionData(X509Extensions.JIT_OrganizationCode);
        }
        catch (Exception e) {
            throw new PKIException("8513", "\u6784\u9020\u4f01\u4e1a\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (derPrtStr == null) {
            return null;
        }
        return new OrganizationCodeExt(derPrtStr);
    }

    public IdentifyCodeExt getIdentifyCode() throws PKIException {
        ASN1Set asnSet = null;
        try {
            asnSet = (ASN1Set)this.getExtensionData(X509Extensions.JIT_IdentifyCode);
        }
        catch (Exception e) {
            throw new PKIException("8515", "\u6784\u9020\u4e2a\u4eba\u8eab\u4efd\u6807\u8bc6\u7801\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asnSet == null) {
            return null;
        }
        return new IdentifyCodeExt(asnSet);
    }

    public SelfDefExtension getSelfDefExtension(String oid) throws PKIException {
        DERObject asnSet = null;
        DERObjectType derobjtype = new DERObjectType();
        try {
            asnSet = this.getSelfDefExtensionData(new DERObjectIdentifier(oid), derobjtype);
        }
        catch (Exception e) {
            throw new PKIException("8516", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asnSet == null) {
            return null;
        }
        return new SelfDefExtension(asnSet, derobjtype.GetType());
    }

    public SubjectKeyIdentifierExt getSubjectKeyIdentifier() throws PKIException {
        DEROctetString asnSet = null;
        try {
            asnSet = (DEROctetString)this.getExtensionData(X509Extensions.SubjectKeyIdentifier);
        }
        catch (Exception e) {
            throw new PKIException("8517", "\u6784\u9020\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asnSet == null) {
            return null;
        }
        return new SubjectKeyIdentifierExt(asnSet);
    }

    public AuthorityKeyIdentifierExt getAuthorityKeyIdentifier() throws PKIException {
        ASN1Sequence asnSet = null;
        try {
            asnSet = (ASN1Sequence)this.getExtensionData(X509Extensions.AuthorityKeyIdentifier);
        }
        catch (Exception e) {
            throw new PKIException("8517", "\u6784\u9020\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asnSet == null) {
            return null;
        }
        return new AuthorityKeyIdentifierExt(asnSet);
    }

    public BasicConstraintsExt getBasicConstraints() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.BasicConstraints);
        }
        catch (Exception e) {
            throw new PKIException("8519", "\u6784\u9020\u57fa\u672c\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new BasicConstraintsExt(asn1Sequence);
    }

    public PolicyConstraintsExt getPolicyConstraints() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.PolicyConstraints);
        }
        catch (Exception e) {
            throw new PKIException("8520", "\u6784\u9020\u7b56\u7565\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new PolicyConstraintsExt(asn1Sequence);
    }

    public CertificatePoliciesExt getCertificatePolicies() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.CertificatePolicies);
        }
        catch (Exception e) {
            throw new PKIException("8518", "\u6784\u9020\u8bc1\u4e66\u7b56\u7565\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new CertificatePoliciesExt(asn1Sequence);
    }

    public PolicyMappingsExt getPolicyMappings() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.PolicyMappings);
        }
        catch (Exception e) {
            throw new PKIException("8521", "\u6784\u9020\u7b56\u7565\u6620\u5c04\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new PolicyMappingsExt(asn1Sequence);
    }

    public ExtendedKeyUsageExt getExtendedKeyUsage() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.ExtendedKeyUsage);
        }
        catch (Exception e) {
            throw new PKIException("8522", "\u6784\u9020\u589e\u5f3a\u5bc6\u94a5\u7528\u6cd5\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new ExtendedKeyUsageExt(asn1Sequence);
    }

    public NameConstraintsExt getNameConstraints() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.NameConstraints);
        }
        catch (Exception e) {
            throw new PKIException("8523", "\u6784\u9020\u540d\u79f0\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new NameConstraintsExt(asn1Sequence);
    }

    public IssuerAlternativeNamesExt getIssuerAlternativeNames() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.IssuerAlternativeName);
        }
        catch (Exception e) {
            throw new PKIException("8526", "\u6784\u9020\u9881\u53d1\u8005\u5907\u7528\u540d\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new IssuerAlternativeNamesExt(asn1Sequence);
    }

    public SubjectAltNameExt getSubjectAltName() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.SubjectAlternativeName);
        }
        catch (Exception e) {
            throw new PKIException("8525", "\u6784\u9020\u4e3b\u9898\u66ff\u6362\u540d\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new SubjectAltNameExt(asn1Sequence);
    }

    public CRLDistributionPointsExt getCRLDistributionPoints() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.CRLDistributionPoints);
        }
        catch (Exception e) {
            throw new PKIException("8524", "\u6784\u9020CRL\u5206\u5e03\u70b9\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new CRLDistributionPointsExt(asn1Sequence);
    }

    public AuthorityInformationAccessExt getAuthorityInfoAccess() throws PKIException {
        ASN1Sequence asn1Sequence = null;
        try {
            asn1Sequence = (ASN1Sequence)this.getExtensionData(X509Extensions.AuthorityInfoAccess);
        }
        catch (Exception e) {
            throw new PKIException("8524", "\u6784\u9020CRL\u5206\u5e03\u70b9\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        if (asn1Sequence == null) {
            return null;
        }
        return new AuthorityInformationAccessExt(asn1Sequence);
    }

    public boolean checkValidity(Date date) throws PKIException {
        if (date.before(this.getNotBefore())) {
            return false;
        }
        return !date.after(this.getNotAfter());
    }

    private DERObject getExtensionData(DERObjectIdentifier oid) throws Exception {
        return this.ByteToDERObject(this.getExtensionByteData(oid));
    }

    private DERObject ByteToDERObject(byte[] Data) throws Exception {
        if (Data == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(Data);
        ASN1InputStream derIns = new ASN1InputStream(bis);
        return derIns.readObject();
    }

    private DERObject getSelfDefExtensionData(DERObjectIdentifier oid, DERObjectType type) throws Exception {
        byte[] data = this.getExtensionByteData(oid);
        if (data == null) {
            return null;
        }
        DERObject derobj = null;
        switch (data[0]) {
            case 1: {
                type.SetType("Boolean");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 22: {
                type.SetType("IA5 String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 2: {
                type.SetType("Integer");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 19: {
                type.SetType("Printable String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 12: {
                type.SetType("UTF-8 String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            default: {
                type.SetType("User Defined");
                derobj = new DEROctetString(data);
            }
        }
        return derobj;
    }

    private byte[] getExtensionByteData(DERObjectIdentifier oid) throws Exception {
        TBSCertificateStructure tbsCert = this.cert.getTBSCertificate();
        X509Extensions extensions = tbsCert.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension extension = extensions.getExtension(oid);
        if (extension == null) {
            return null;
        }
        return extension.getValue().getOctets();
    }

    public static void main(String[] args) {
    }

    private class DERObjectType {
        private String Type = null;

        private DERObjectType() {
        }

        public void SetType(String value) {
            this.Type = value;
        }

        public String GetType() {
            return this.Type;
        }
    }
}

