/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cert;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERGeneralizedTime;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.x509.AttCertIssuer;
import cn.com.jit.ida.util.pki.asn1.x509.Attribute;
import cn.com.jit.ida.util.pki.asn1.x509.AttributeCertificateInfo;
import cn.com.jit.ida.util.pki.asn1.x509.ClearanceAttribute;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.GroupAttribute;
import cn.com.jit.ida.util.pki.asn1.x509.Holder;
import cn.com.jit.ida.util.pki.asn1.x509.RoleAttribute;
import cn.com.jit.ida.util.pki.asn1.x509.RoleSyntax;
import cn.com.jit.ida.util.pki.asn1.x509.V2X509AttCertGenerator;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Session;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class X509AttCertGenerator
extends V2X509AttCertGenerator {
    public void setHolder(String holder) throws PKIException {
        if (holder == null) {
            throw new PKIException("8169", "\u5c5e\u6027\u8bc1\u4e66\u6301\u6709\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Holder h = Holder.getInstance(holder);
        this.getV2AttCert().setHolder(h);
    }

    public void setIssuer(String issuer) throws PKIException {
        if (issuer == null) {
            throw new PKIException("8153", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AttCertIssuer name = AttCertIssuer.getInstance(issuer);
        this.getV2AttCert().setIssuer(name);
    }

    public void setSerialNumber(String strSerialNumber) throws PKIException {
        if (strSerialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigInteger serialNumber = new BigInteger(strSerialNumber, 16);
        DERInteger in = new DERInteger(serialNumber);
        this.getV2AttCert().setSerialNumber(in);
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigInteger serialBit = serialNumber;
        DERInteger in = new DERInteger(serialBit);
        this.getV2AttCert().setSerialNumber(in);
    }

    public void setNotbefore(Date notBefore) throws PKIException {
        if (notBefore == null) {
            throw new PKIException("8156", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DERGeneralizedTime startDate = new DERGeneralizedTime(notBefore);
        this.getV2AttCert().setStartDate(startDate);
    }

    public void setNotafter(Date notafter) throws PKIException {
        if (notafter == null) {
            throw new PKIException("8155", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DERGeneralizedTime endDate = new DERGeneralizedTime(notafter);
        this.getV2AttCert().setEndDate(endDate);
    }

    public void setRoleAttribute(String roleAuthority, String roleName) throws PKIException {
        if (roleAuthority == null) {
            throw new PKIException("8550", "\u5c5e\u6027\u8bc1\u4e66\u89d2\u8272\u6743\u5a01\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (roleName == null) {
            throw new PKIException("8551", "\u5c5e\u6027\u8bc1\u4e66\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GeneralNames ra = this.createAuthority(roleAuthority);
        GeneralName rn = this.createRoleName(roleName);
        RoleSyntax role = new RoleSyntax(ra, rn);
        DEREncodableVector vector = new DEREncodableVector();
        vector.add(role);
        DERSet set = new DERSet(vector);
        DERObjectIdentifier id = new DERObjectIdentifier("2.5.4.72");
        Attribute att = new Attribute(id, set);
        this.addAttribute(att);
    }

    public RoleAttribute createRoleAttribute() {
        RoleAttribute att = new RoleAttribute();
        return att;
    }

    public GroupAttribute createGroupAttribute() {
        GroupAttribute att = new GroupAttribute();
        return att;
    }

    public ClearanceAttribute createClearanceAttribute() {
        ClearanceAttribute att = new ClearanceAttribute();
        return att;
    }

    public void addAttribute(Attribute att) {
        this.getV2AttCert().addAttribute(att);
    }

    public List generateX509AttCerts(JKey priKey, Session session, Document requestDoc) throws PKIException {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        Document resultDoc = this.translate(requestDoc);
        Element resultRoot = resultDoc.getDocumentElement();
        NodeList resultInfo = resultRoot.getElementsByTagName("AttributeCertificateInfo");
        int i = 0;
        while (i < resultInfo.getLength()) {
            Element resultNode = (Element)resultInfo.item(i);
            String serialNumber = this.getSerialNumber();
            this.addSerialNumber(resultNode, serialNumber, resultDoc);
            this.setAttCertInfo(new AttributeCertificateInfo(resultNode));
            this.setSignatureAlg(V2X509AttCertGenerator.generateMechanisNameByOID(this.getAttCertInfo().getSignature().getObjectId().getId()));
            this.signCertInfo(priKey, session);
            byte[] cert = this.constructAttCertificate();
            certs.add(cert);
            ++i;
        }
        return certs;
    }

    private String getSerialNumber() {
        String tmp = null;
        Random tRnd = new Random();
        long tLong1 = tRnd.nextLong();
        long tLong2 = tRnd.nextLong();
        String n1 = Long.toHexString(tLong1);
        String n2 = Long.toHexString(tLong2);
        tmp = (String.valueOf(n1) + n2).toUpperCase();
        return tmp;
    }

    private void addSerialNumber(Element root, String serialNumber, Document resultDoc) {
        NodeList sn = root.getElementsByTagName("serialNumber");
        Element snInfo = (Element)sn.item(0);
        Text serialText = resultDoc.createTextNode("serialNumberText");
        serialText.setData(serialNumber);
        snInfo.appendChild(serialText);
    }

    private Document translate(Document requestXML) throws PKIException {
        Document doc = null;
        DOMSource xmlSoure = new DOMSource(requestXML);
        StreamSource xslSoure = new StreamSource(new File("Template/TransRequest.xsl"));
        DOMResult domResult = new DOMResult();
        TransformerFactory tranformfact = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = tranformfact.newTransformer(xslSoure);
        }
        catch (TransformerConfigurationException ex) {
            throw new PKIException("\u8bfb\u53d6\u8f6c\u6362\u6587\u4ef6xsl\u65f6\u51fa\u73b0\u9519\u8bef", ex);
        }
        trans.setOutputProperty("encoding", "gb2312");
        trans.setOutputProperty("indent", "yes");
        try {
            trans.transform(xmlSoure, domResult);
        }
        catch (TransformerException ex) {
            throw new PKIException("\u8f6c\u6362XML\u6587\u6863\u65f6\u51fa\u73b0\u9519\u8bef", ex);
        }
        doc = (Document)domResult.getNode();
        return doc;
    }

    private GeneralNames createAuthority(String name) {
        DERUTF8String a = new DERUTF8String(name);
        DERObjectIdentifier id = new DERObjectIdentifier("1.2.156.1995.1999.2");
        DERTaggedObject b = new DERTaggedObject(true, 0, a);
        DEREncodableVector vector = new DEREncodableVector();
        vector.add(id);
        vector.add(b);
        DERSequence c = new DERSequence(vector);
        DERTaggedObject gname = new DERTaggedObject(true, 0, c);
        DEREncodableVector vector2 = new DEREncodableVector();
        vector2.add(gname);
        GeneralNames ns = GeneralNames.getInstance(new DERSequence(vector2));
        return ns;
    }

    private GeneralName createRoleName(String name) {
        DERUTF8String a = new DERUTF8String(name);
        DERObjectIdentifier id = new DERObjectIdentifier("1.2.156.1995.1999.2");
        DERTaggedObject b = new DERTaggedObject(0, a);
        DEREncodableVector vector = new DEREncodableVector();
        vector.add(id);
        vector.add(b);
        DERSequence c = new DERSequence(vector);
        GeneralNames ns = GeneralNames.getInstance(new DERSequence(c));
        DERTaggedObject gnam = new DERTaggedObject(true, 0, ns);
        GeneralName gname = GeneralName.getInstance(gnam);
        return gname;
    }
}

