/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.cert;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.AttCertIssuer;
import cn.com.jit.ida.util.pki.asn1.x509.Attribute;
import cn.com.jit.ida.util.pki.asn1.x509.AttributeCertificate;
import cn.com.jit.ida.util.pki.asn1.x509.Attributes;
import cn.com.jit.ida.util.pki.asn1.x509.Holder;
import cn.com.jit.ida.util.pki.asn1.x509.RoleSyntax;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;

public class X509AttCert {
    private AttributeCertificate attcert = null;
    private String[] roleAuthorityAndRoleName = null;
    private RoleSyntax role = null;
    private Attributes atts = null;
    private String[] AttributeType = null;

    public X509AttCert(String FileName) throws FileNotFoundException, IOException, PKIException {
        File file = new File(FileName);
        FileInputStream fin = new FileInputStream(file);
        byte[] data = new byte[fin.available()];
        fin.read(data);
        this.attcert = new AttributeCertificate(data);
    }

    public X509AttCert(byte[] data) throws PKIException {
        this.attcert = new AttributeCertificate(data);
    }

    public boolean verify(JKey pubKey, Session session) throws PKIException {
        return this.attcert.verify(pubKey, session);
    }

    public String getHolder() {
        Holder holder = this.attcert.getAcinfo().getHolder();
        return holder.toString();
    }

    public String getIssuer() {
        AttCertIssuer issuer = this.attcert.getAcinfo().getIssuer();
        return issuer.toString();
    }

    public Date getNotBefore() throws PKIException {
        try {
            return this.attcert.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate();
        }
        catch (ParseException e) {
            throw new PKIException("8554", "\u5c5e\u6027\u8bc1\u4e66\u751f\u6548\u65e5\u671f\u89e3\u6790\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public Date getNotAfter() throws PKIException {
        try {
            return this.attcert.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime().getDate();
        }
        catch (ParseException e) {
            throw new PKIException("8555", "\u5c5e\u6027\u8bc1\u4e66\u5931\u6548\u65e5\u671f\u89e3\u6790\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public int getVersion() {
        return this.attcert.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.attcert.getSerialNumber();
    }

    public String getStringSerialNumber() {
        return this.getSerialNumber().toString(16).toUpperCase();
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.attcert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.attcert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public byte[] getSignature() {
        return this.attcert.getSignature();
    }

    public byte[] getIssuerUniqueId() {
        DERBitString issuerUniqueId = this.attcert.getAcinfo().getIssuerUniqueID();
        if (issuerUniqueId != null) {
            return issuerUniqueId.getBytes();
        }
        return null;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = Parser.writeDERObj2Bytes(this.attcert);
        }
        catch (Exception ex) {
            throw new PKIException("8162", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public String getRoleAuthority() {
        this.getRoleAuthority_Name();
        if (this.roleAuthorityAndRoleName == null) {
            return null;
        }
        return this.roleAuthorityAndRoleName[0];
    }

    public String getRoleName() {
        this.getRoleAuthority_Name();
        if (this.roleAuthorityAndRoleName == null) {
            return null;
        }
        return this.roleAuthorityAndRoleName[1];
    }

    private void getRoleAuthority_Name() {
        if (this.roleAuthorityAndRoleName != null) {
            return;
        }
        String[] re = new String[2];
        Attributes attributes = this.getAttributes();
        int i = 0;
        while (i < attributes.getSize()) {
            Attribute att = attributes.getAttributeAt(i);
            if (att.getAttrType().getId().equals("2.5.4.72")) {
                ASN1Set set = att.getAttrValuesSet();
                int j = 0;
                while (j < set.size()) {
                    DEREncodable objat = set.getObjectAt(j);
                    RoleSyntax role = new RoleSyntax((DERSequence)objat);
                    String[] ra = role.getRoleAuthorityAsString();
                    if (ra != null && ra.length > 0) {
                        re[0] = role.getRoleAuthorityAsString()[0];
                    }
                    re[1] = role.getRoleNameAsString();
                    ++j;
                }
            }
            ++i;
        }
        this.roleAuthorityAndRoleName = re;
    }

    public Attributes getAttributes() {
        if (this.atts == null) {
            this.atts = this.attcert.getAcinfo().getAttributes();
        }
        return this.atts;
    }

    public int getAttributeCount() {
        Attributes atts = this.getAttributes();
        return atts.getSize();
    }

    public Attribute getAttributeAt(int i) {
        Attributes atts = this.getAttributes();
        return atts.getAttributeAt(i);
    }

    public String getAttributeTypeAt(int j) {
        if (this.AttributeType == null) {
            Attributes atts = this.getAttributes();
            this.AttributeType = new String[atts.getSize()];
            int i = 0;
            while (i < atts.getSize()) {
                this.AttributeType[i] = atts.getAttributeAt(i).getAttrType().getId();
                ++i;
            }
        }
        return this.AttributeType[j];
    }
}

