/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.ACRLDPExtension;
import cn.com.jit.ida.util.pki.asn1.x509.ACTargetingExtension;
import cn.com.jit.ida.util.pki.asn1.x509.AuditIdentity;
import cn.com.jit.ida.util.pki.asn1.x509.NoRevocationExtension;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extension;
import cn.com.jit.ida.util.pki.extension.AuthorityInformationAccessExt;
import cn.com.jit.ida.util.pki.extension.AuthorityKeyIdentifierExt;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509Extensions
implements DEREncodable {
    public static final DERObjectIdentifier CERTIFICATE_TEMPLATE = new DERObjectIdentifier("1.3.6.1.4.1.311.20.2");
    public static final DERObjectIdentifier JIT_IdentifyCode = new DERObjectIdentifier("1.2.156.10260.4.1.1");
    public static final DERObjectIdentifier JIT_InsuranceNumber = new DERObjectIdentifier("1.2.156.10260.4.1.2");
    public static final DERObjectIdentifier JIT_OrganizationCode = new DERObjectIdentifier("1.2.156.10260.4.1.4");
    public static final DERObjectIdentifier JIT_ICRegistrationNumber = new DERObjectIdentifier("1.2.156.10260.4.1.3");
    public static final DERObjectIdentifier JIT_TaxationNumber = new DERObjectIdentifier("1.2.156.10260.4.1.5");
    public static final DERObjectIdentifier JIT_IdentifyCodeOld = new DERObjectIdentifier("1.2.86.11.7.1");
    public static final DERObjectIdentifier JIT_InsuranceNumberOld = new DERObjectIdentifier("1.2.86.11.7.2");
    public static final DERObjectIdentifier JIT_OrganizationCodeOld = new DERObjectIdentifier("1.2.86.11.7.3");
    public static final DERObjectIdentifier JIT_ICRegistrationNumberOld = new DERObjectIdentifier("1.2.86.11.7.4");
    public static final DERObjectIdentifier JIT_TaxationNumberOld = new DERObjectIdentifier("1.2.86.11.7.5");
    public static final DERObjectIdentifier JIT_StationCode = new DERObjectIdentifier("1.2.156.10260.4.1.6");
    public static final DERObjectIdentifier JIT_CasteCode = new DERObjectIdentifier("1.2.156.10260.4.1.7");
    public static final DERObjectIdentifier SubjectDirectoryAttributes = new DERObjectIdentifier("2.5.29.9");
    public static final DERObjectIdentifier AuthorityInformationAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    public static final DERObjectIdentifier NetscapeCertType = new DERObjectIdentifier("2.16.840.1.113730.1.1");
    public static final DERObjectIdentifier SubjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
    public static final DERObjectIdentifier KeyUsage = new DERObjectIdentifier("2.5.29.15");
    public static final DERObjectIdentifier PrivateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
    public static final DERObjectIdentifier SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
    public static final DERObjectIdentifier IssuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
    public static final DERObjectIdentifier BasicConstraints = new DERObjectIdentifier("2.5.29.19");
    public static final DERObjectIdentifier CRLNumber = new DERObjectIdentifier("2.5.29.20");
    public static final DERObjectIdentifier ReasonCode = new DERObjectIdentifier("2.5.29.21");
    public static final DERObjectIdentifier InstructionCode = new DERObjectIdentifier("2.5.29.23");
    public static final DERObjectIdentifier InvalidityDate = new DERObjectIdentifier("2.5.29.24");
    public static final DERObjectIdentifier DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
    public static final DERObjectIdentifier IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
    public static final DERObjectIdentifier CertificateIssuer = new DERObjectIdentifier("2.5.29.29");
    public static final DERObjectIdentifier NameConstraints = new DERObjectIdentifier("2.5.29.30");
    public static final DERObjectIdentifier CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
    public static final DERObjectIdentifier CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
    public static final DERObjectIdentifier PolicyMappings = new DERObjectIdentifier("2.5.29.33");
    public static final DERObjectIdentifier AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
    public static final DERObjectIdentifier PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
    public static final DERObjectIdentifier ExtendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
    public static final DERObjectIdentifier InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
    public static final DERObjectIdentifier AuthorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    public static final DERObjectIdentifier AuditIdentity = new DERObjectIdentifier("1.3.6.1.5.5.7.1.4");
    public static final DERObjectIdentifier ACTargeting = new DERObjectIdentifier("2.5.29.55");
    public static final DERObjectIdentifier ACRLDPExtension = new DERObjectIdentifier("2.5.29.31");
    public static final DERObjectIdentifier NoRevocation = new DERObjectIdentifier("2.5.29.56");
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static X509Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509Extensions getInstance(Object obj) {
        if (obj == null || obj instanceof X509Extensions) {
            return (X509Extensions)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Extensions((ASN1Sequence)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            return X509Extensions.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public X509Extensions(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            if (s.size() == 3) {
                this.extensions.put(s.getObjectAt(0), new X509Extension((DERBoolean)s.getObjectAt(1), (ASN1OctetString)s.getObjectAt(2)));
            } else {
                this.extensions.put(s.getObjectAt(0), new X509Extension(false, (ASN1OctetString)s.getObjectAt(1)));
            }
            this.ordering.addElement(s.getObjectAt(0));
        }
    }

    public X509Extensions(Hashtable extensions) {
        this(null, extensions);
    }

    public X509Extensions(Vector ordering, Hashtable extensions) {
        Enumeration<Object> e = ordering == null ? extensions.keys() : ordering.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)extensions.get(oid);
            this.extensions.put(oid, ext);
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public X509Extension getExtension(DERObjectIdentifier oid) {
        return (X509Extension)this.extensions.get(oid);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)this.extensions.get(oid);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(oid);
            if (ext.isCritical()) {
                v.add(new DERBoolean(true));
            }
            v.add(ext.getValue());
            vec.add(new DERSequence(v));
        }
        return new DERSequence(vec);
    }

    public int hashCode() {
        Enumeration e = this.extensions.keys();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            hashCode ^= o.hashCode();
            hashCode ^= this.extensions.get(o).hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof X509Extensions)) {
            return false;
        }
        X509Extensions other = (X509Extensions)o;
        Enumeration e1 = this.extensions.keys();
        Enumeration e2 = other.extensions.keys();
        while (e1.hasMoreElements() && e2.hasMoreElements()) {
            Object o2;
            Object o1 = e1.nextElement();
            if (o1.equals(o2 = e2.nextElement())) continue;
            return false;
        }
        return !e1.hasMoreElements() && !e2.hasMoreElements();
    }

    public X509Extensions(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,X509Extensions.X509Extensions(Node nl),Extensions\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            DERObjectIdentifier identifier;
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("AuthorityInfoAccess")) {
                identifier = new DERObjectIdentifier(AuthorityInfoAccess.getId());
                this.ordering.add(identifier);
                AuthorityInformationAccessExt authinfoaccess = new AuthorityInformationAccessExt(cnode);
                this.extensions.put(identifier, authinfoaccess);
            }
            if (sname.equals("AuthorityKeyIdentifierExtension")) {
                identifier = new DERObjectIdentifier(AuthorityKeyIdentifier.getId());
                AuthorityKeyIdentifierExt authkeyID = new AuthorityKeyIdentifierExt(cnode);
                this.extensions.put(identifier, authkeyID);
            }
            if (sname.equals("ACTargetingExtension")) {
                identifier = new DERObjectIdentifier(ACTargeting.getId());
                ACTargetingExtension actargeting = new ACTargetingExtension(cnode);
                this.extensions.put(identifier, actargeting);
            }
            if (sname.equals("AuditIdentity")) {
                identifier = new DERObjectIdentifier(AuditIdentity.getId());
                AuditIdentity audit = new AuditIdentity(cnode);
                this.extensions.put(identifier, audit);
            }
            if (sname.equals("ACRLDPExtension")) {
                identifier = new DERObjectIdentifier(ACRLDPExtension.getId());
                ACRLDPExtension acrldp = new ACRLDPExtension(cnode);
                this.extensions.put(identifier, acrldp);
            }
            if (sname.equals("NoRevocationExtension")) {
                identifier = new DERObjectIdentifier(NoRevocation.getId());
                NoRevocationExtension norev = new NoRevocationExtension(cnode);
                this.extensions.put(identifier, norev);
            }
            ++i;
        }
    }
}

