/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIConstant;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Encodable;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DERGeneralizedTime;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERNull;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.AttCertIssuer;
import cn.com.jit.ida.util.pki.asn1.x509.Attribute;
import cn.com.jit.ida.util.pki.asn1.x509.AttributeCertificateInfo;
import cn.com.jit.ida.util.pki.asn1.x509.Holder;
import cn.com.jit.ida.util.pki.asn1.x509.V2AttributeCertificateInfoGenerator;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.cipher.Mechanism;
import cn.com.jit.ida.util.pki.cipher.Session;
import org.w3c.dom.Element;

public class V2X509AttCertGenerator {
    private V2AttributeCertificateInfoGenerator v2AttCert = new V2AttributeCertificateInfoGenerator();
    private AttributeCertificateInfo attCertInfo = null;
    private Mechanism mechanism = null;
    private String deviceName = null;
    private AlgorithmIdentifier sigAlg = null;
    private JKey pubKey = null;
    private DERBitString signature = null;

    public void setHolder(Holder holder) {
        this.v2AttCert.setHolder(holder);
    }

    public void addAttribute(String oid, ASN1Encodable value) {
        this.v2AttCert.addAttribute(new Attribute(new DERObjectIdentifier(oid), new DERSet(value)));
    }

    public void addAttribute(Attribute attribute) {
        this.v2AttCert.addAttribute(attribute);
    }

    public void setSerialNumber(DERInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException("8152", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.v2AttCert.setSerialNumber(serialNumber);
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("8154", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (signatureAlgorithm.equals("MD2withRSAEncryption")) {
            this.mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signatureAlgorithm.equals("MD5withRSAEncryption")) {
            this.mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA1withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (signatureAlgorithm.endsWith("SHA1withECDSA")) {
            this.mechanism = new Mechanism("SHA1withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withDSA")) {
            this.mechanism = new Mechanism("SHA1withDSA");
        } else if (signatureAlgorithm.endsWith("SM3withSM2Encryption")) {
            this.mechanism = new Mechanism("SM3withSM2Encryption");
        } else {
            throw new PKIException("8150", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid, new DERNull());
        this.v2AttCert.setSignature(this.sigAlg);
    }

    public void setIssuer(AttCertIssuer issuer) {
        this.v2AttCert.setIssuer(issuer);
    }

    public void setStartDate(DERGeneralizedTime startDate) {
        this.v2AttCert.setStartDate(startDate);
    }

    public void setEndDate(DERGeneralizedTime endDate) {
        this.v2AttCert.setEndDate(endDate);
    }

    public void setIssuerUniqueID(DERBitString issuerUniqueID) {
        this.v2AttCert.setIssuerUniqueID(issuerUniqueID);
    }

    public void setExtensions(X509Extensions extensions) {
        this.v2AttCert.setExtensions(extensions);
    }

    public byte[] generateX509AttCert(JKey priKey, Session session) throws PKIException {
        this.generateSignature(priKey, session);
        return this.constructAttCertificate();
    }

    public byte[] generateX509AttCert(JKey priKey, Session session, Element xmlnode) throws PKIException {
        this.attCertInfo = new AttributeCertificateInfo(xmlnode);
        this.setSignatureAlg(V2X509AttCertGenerator.generateMechanisNameByOID(this.attCertInfo.getSignature().getObjectId().getId()));
        this.signCertInfo(priKey, session);
        return this.constructAttCertificate();
    }

    public static String generateMechanisNameByOID(String oid) {
        if ("1.2.840.113549.1.1.5".equals(oid)) {
            return "SHA1withRSAEncryption";
        }
        return null;
    }

    private void generateSignature(JKey priKey, Session session) throws PKIException {
        try {
            this.attCertInfo = this.v2AttCert.generateAttributeCertificateInfo();
        }
        catch (Exception e) {
            throw new PKIException("8552", "\u5c5e\u6027\u8bc1\u4e66\u4ea7\u751f\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        this.signCertInfo(priKey, session);
    }

    public void signCertInfo(JKey priKey, Session session) throws PKIException {
        byte[] attcert = null;
        try {
            attcert = Parser.writeDERObj2Bytes(this.attCertInfo.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8159", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, attcert);
        }
        catch (Exception ex) {
            throw new PKIException("5", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    protected byte[] constructAttCertificate() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.attCertInfo);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] attCertData = null;
        try {
            attCertData = Parser.writeDERObj2Bytes(derSeq.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("8158", "\u8bc1\u4e66\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return attCertData;
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (issuerUniqueID != null) {
            this.v2AttCert.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
    }

    public AttributeCertificateInfo getAttCertInfo() {
        return this.attCertInfo;
    }

    public void setAttCertInfo(AttributeCertificateInfo attCertInfo) {
        this.attCertInfo = attCertInfo;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Mechanism getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(Mechanism mechanism) {
        this.mechanism = mechanism;
    }

    public JKey getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(JKey pubKey) {
        this.pubKey = pubKey;
    }

    public AlgorithmIdentifier getSigAlg() {
        return this.sigAlg;
    }

    public void setSigAlg(AlgorithmIdentifier sigAlg) {
        this.sigAlg = sigAlg;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    public void setSignature(DERBitString signature) {
        this.signature = signature;
    }

    public V2AttributeCertificateInfoGenerator getV2AttCert() {
        return this.v2AttCert;
    }

    public void setV2AttCert(V2AttributeCertificateInfoGenerator attCert) {
        this.v2AttCert = attCert;
    }
}

