/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.IssuerSerial;
import cn.com.jit.ida.util.pki.asn1.x509.ObjectDigestInfo;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class V2Form
implements DEREncodable {
    GeneralNames issuerName;
    IssuerSerial baseCertificateID;
    ObjectDigestInfo objectDigestInfo;

    public static V2Form getInstance(ASN1TaggedObject obj, boolean explicit) {
        return V2Form.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static V2Form getInstance(Object obj) {
        if (obj == null || obj instanceof V2Form) {
            return (V2Form)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new V2Form((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public V2Form() {
    }

    public V2Form(GeneralNames gns) {
        this.issuerName = gns;
    }

    public V2Form(ASN1Sequence seq) {
        int index = 0;
        if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
            ++index;
            this.issuerName = GeneralNames.getInstance(seq.getObjectAt(0));
        }
        int i = index;
        while (i != seq.size()) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(i);
            if (o.getTagNo() == 0) {
                this.baseCertificateID = IssuerSerial.getInstance(o, false);
            } else if (o.getTagNo() == 1) {
                this.objectDigestInfo = ObjectDigestInfo.getInstance(o, false);
            }
            ++i;
        }
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.issuerName != null) {
            v.add(this.issuerName.getDERObject());
        }
        if (this.baseCertificateID != null) {
            v.add(this.baseCertificateID);
        }
        if (this.objectDigestInfo != null) {
            v.add(this.objectDigestInfo);
        }
        return new DERSequence(v);
    }

    public void setIssuerName(GeneralNames issuerName) {
        this.issuerName = issuerName;
    }

    public V2Form(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,V2Form.V2Form(),V2Form\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        this.issuerName = new GeneralNames();
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String nodename = cnode.getNodeName();
            if (nodename.equals("issuerName")) {
                NodeList nodelist1 = cnode.getChildNodes();
                if (nodelist1.getLength() == 0) {
                    throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,V2Form.V2Form(),issuerName\u6ca1\u6709\u5b50\u8282\u70b9");
                }
                Node cnode1 = null;
                int j = 0;
                while (j < nodelist1.getLength()) {
                    cnode1 = nodelist1.item(j);
                    String snode1 = cnode1.getNodeName();
                    NamedNodeMap attributes = null;
                    if (snode1.equals("GeneralName")) {
                        attributes = cnode1.getAttributes();
                        String type = attributes.item(0).getNodeValue();
                        try {
                            String sname;
                            Text txt;
                            if (type.equals("4")) {
                                txt = (Text)cnode1.getFirstChild();
                                sname = txt.getData();
                                this.issuerName.addDirectoryName(sname);
                            }
                            if (type.equals("7")) {
                                txt = (Text)cnode1.getFirstChild();
                                sname = txt.getData();
                                this.issuerName.addIPAddress(sname);
                            }
                            if (type.equals("2")) {
                                txt = (Text)cnode1.getFirstChild();
                                sname = txt.getData();
                                this.issuerName.addDNSName(sname);
                            }
                            if (type.equals("6")) {
                                txt = (Text)cnode1.getFirstChild();
                                sname = txt.getData();
                                this.issuerName.addUniformResourceIdentifier(sname);
                            }
                            if (type.equals("0")) {
                                txt = (Text)cnode1.getFirstChild();
                                String srolename = txt.getData();
                                String sutf8 = srolename.trim();
                                this.issuerName.addOtherName_UPN(sutf8);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            throw new PKIException("IllegalArgumentException,V2Form.V2Form(),\u6784\u9020issuerName\u65f6\u51fa\u9519", e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

