/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;

public class SubjectKeyIdentifier
implements DEREncodable {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(obj, explicit));
    }

    public static SubjectKeyIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)obj;
        }
        if (obj instanceof SubjectPublicKeyInfo) {
            return new SubjectKeyIdentifier((SubjectPublicKeyInfo)obj);
        }
        if (obj instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)obj);
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + obj.getClass().getName());
    }

    public SubjectKeyIdentifier(byte[] keyid) {
        this.keyidentifier = keyid;
    }

    public SubjectKeyIdentifier(ASN1OctetString keyid) {
        this.keyidentifier = keyid.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        this.keyidentifier = resBuf;
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    public DERObject getDERObject() {
        return new DEROctetString(this.keyidentifier);
    }

    public static interface Digest {
        public String getAlgorithmName();

        public int getDigestSize();

        public void update(byte var1);

        public void update(byte[] var1, int var2, int var3);

        public int doFinal(byte[] var1, int var2);

        public void reset();
    }

    public abstract class GeneralDigest
    implements Digest {
        private byte[] xBuf;
        private int xBufOff;
        private long byteCount;

        protected GeneralDigest() {
            this.xBuf = new byte[4];
            this.xBufOff = 0;
        }

        protected GeneralDigest(GeneralDigest t) {
            this.xBuf = new byte[t.xBuf.length];
            System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
            this.xBufOff = t.xBufOff;
            this.byteCount = t.byteCount;
        }

        public void update(byte in) {
            this.xBuf[this.xBufOff++] = in;
            if (this.xBufOff == this.xBuf.length) {
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
            }
            ++this.byteCount;
        }

        public void update(byte[] in, int inOff, int len) {
            while (this.xBufOff != 0 && len > 0) {
                this.update(in[inOff]);
                ++inOff;
                --len;
            }
            while (len > this.xBuf.length) {
                this.processWord(in, inOff);
                inOff += this.xBuf.length;
                len -= this.xBuf.length;
                this.byteCount += (long)this.xBuf.length;
            }
            while (len > 0) {
                this.update(in[inOff]);
                ++inOff;
                --len;
            }
        }

        public void finish() {
            long bitLength = this.byteCount << 3;
            this.update((byte)-128);
            while (this.xBufOff != 0) {
                this.update((byte)0);
            }
            this.processLength(bitLength);
            this.processBlock();
        }

        public void reset() {
            this.byteCount = 0L;
            this.xBufOff = 0;
            int i = 0;
            while (i < this.xBuf.length) {
                this.xBuf[i] = 0;
                ++i;
            }
        }

        protected abstract void processWord(byte[] var1, int var2);

        protected abstract void processLength(long var1);

        protected abstract void processBlock();
    }

    public class SHA1Digest
    extends GeneralDigest {
        private static final int DIGEST_LENGTH = 20;
        private int H1;
        private int H2;
        private int H3;
        private int H4;
        private int H5;
        private int[] X;
        private int xOff;
        private static final int Y1 = 1518500249;
        private static final int Y2 = 1859775393;
        private static final int Y3 = -1894007588;
        private static final int Y4 = -899497514;

        public SHA1Digest() {
            this.X = new int[80];
            this.reset();
        }

        public SHA1Digest(SHA1Digest t) {
            super(t);
            this.X = new int[80];
            this.H1 = t.H1;
            this.H2 = t.H2;
            this.H3 = t.H3;
            this.H4 = t.H4;
            this.H5 = t.H5;
            System.arraycopy(t.X, 0, this.X, 0, t.X.length);
            this.xOff = t.xOff;
        }

        public String getAlgorithmName() {
            return "SHA-1";
        }

        public int getDigestSize() {
            return 20;
        }

        protected void processWord(byte[] in, int inOff) {
            this.X[this.xOff++] = (in[inOff] & 0xFF) << 24 | (in[inOff + 1] & 0xFF) << 16 | (in[inOff + 2] & 0xFF) << 8 | in[inOff + 3] & 0xFF;
            if (this.xOff == 16) {
                this.processBlock();
            }
        }

        private void unpackWord(int word, byte[] out, int outOff) {
            out[outOff] = (byte)(word >>> 24);
            out[outOff + 1] = (byte)(word >>> 16);
            out[outOff + 2] = (byte)(word >>> 8);
            out[outOff + 3] = (byte)word;
        }

        protected void processLength(long bitLength) {
            if (this.xOff > 14) {
                this.processBlock();
            }
            this.X[14] = (int)(bitLength >>> 32);
            this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        }

        public int doFinal(byte[] out, int outOff) {
            this.finish();
            this.unpackWord(this.H1, out, outOff);
            this.unpackWord(this.H2, out, outOff + 4);
            this.unpackWord(this.H3, out, outOff + 8);
            this.unpackWord(this.H4, out, outOff + 12);
            this.unpackWord(this.H5, out, outOff + 16);
            this.reset();
            return 20;
        }

        public void reset() {
            super.reset();
            this.H1 = 1732584193;
            this.H2 = -271733879;
            this.H3 = -1732584194;
            this.H4 = 271733878;
            this.H5 = -1009589776;
            this.xOff = 0;
            int i = 0;
            while (i != this.X.length) {
                this.X[i] = 0;
                ++i;
            }
        }

        private int f(int u, int v, int w) {
            return u & v | ~u & w;
        }

        private int h(int u, int v, int w) {
            return u ^ v ^ w;
        }

        private int g(int u, int v, int w) {
            return u & v | u & w | v & w;
        }

        private int rotateLeft(int x, int n) {
            return x << n | x >>> 32 - n;
        }

        protected void processBlock() {
            int t;
            int i = 16;
            while (i <= 79) {
                this.X[i] = this.rotateLeft(this.X[i - 3] ^ this.X[i - 8] ^ this.X[i - 14] ^ this.X[i - 16], 1);
                ++i;
            }
            int A = this.H1;
            int B = this.H2;
            int C = this.H3;
            int D = this.H4;
            int E = this.H5;
            int j = 0;
            while (j <= 19) {
                t = this.rotateLeft(A, 5) + this.f(B, C, D) + E + this.X[j] + 1518500249;
                E = D;
                D = C;
                C = this.rotateLeft(B, 30);
                B = A;
                A = t;
                ++j;
            }
            j = 20;
            while (j <= 39) {
                t = this.rotateLeft(A, 5) + this.h(B, C, D) + E + this.X[j] + 1859775393;
                E = D;
                D = C;
                C = this.rotateLeft(B, 30);
                B = A;
                A = t;
                ++j;
            }
            j = 40;
            while (j <= 59) {
                t = this.rotateLeft(A, 5) + this.g(B, C, D) + E + this.X[j] + -1894007588;
                E = D;
                D = C;
                C = this.rotateLeft(B, 30);
                B = A;
                A = t;
                ++j;
            }
            j = 60;
            while (j <= 79) {
                t = this.rotateLeft(A, 5) + this.h(B, C, D) + E + this.X[j] + -899497514;
                E = D;
                D = C;
                C = this.rotateLeft(B, 30);
                B = A;
                A = t;
                ++j;
            }
            this.H1 += A;
            this.H2 += B;
            this.H3 += C;
            this.H4 += D;
            this.H5 += E;
            this.xOff = 0;
            int i2 = 0;
            while (i2 != this.X.length) {
                this.X[i2] = 0;
                ++i2;
            }
        }
    }
}

