/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.x509.SecurityCategory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityCategories {
    private DEREncodableVector set = null;

    public SecurityCategories() {
        this.set = new DEREncodableVector();
    }

    public static SecurityCategories getInstance(Object obj) {
        if (obj == null || obj instanceof SecurityCategories) {
            return (SecurityCategories)obj;
        }
        if (obj instanceof DERSet) {
            return new SecurityCategories((DERSet)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public SecurityCategories(DERSet derset) {
        this.set = new DEREncodableVector(derset);
    }

    public SecurityCategories(DEREncodableVector vec) {
        this.set = vec;
    }

    public static SecurityCategories getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SecurityCategories.getInstance(obj.getObject());
    }

    public DERObject getDERObject() {
        return new DERSet(this.set);
    }

    public int getSize() {
        return this.set.size();
    }

    public SecurityCategory getSecurityCategoryAt(int i) {
        return (SecurityCategory)this.set.get(i);
    }

    public SecurityCategory creatSecurityCategory() {
        SecurityCategory a = new SecurityCategory();
        this.addSecurityCategory(a);
        return a;
    }

    public void addSecurityCategory(SecurityCategory sec) {
        if (this.set == null) {
            this.set = new DEREncodableVector();
        }
        this.set.add(sec.getDERObject());
    }

    public SecurityCategories(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,SecurityCategories.SecurityCategories(),SecurityCategories\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        SecurityCategory seccat = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("SecurityCategory")) {
                seccat = new SecurityCategory(cnode);
                this.set.add(seccat);
            }
            ++i;
        }
    }
}

