/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Encodable;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RoleSyntax
extends ASN1Encodable {
    private GeneralNames roleAuthority;
    private GeneralName roleName;
    public static final String JIT_ROLE_OTHER_NAME_ID = "1.2.156.1995.1999.2";

    public RoleSyntax() {
    }

    public static RoleSyntax getInstance(Object obj) {
        if (obj == null || obj instanceof RoleSyntax) {
            return (RoleSyntax)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RoleSyntax((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in RoleSyntax factory.");
    }

    public RoleSyntax(GeneralNames roleAuthority, GeneralName roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException("the role name MUST be non empty and MUST use the URI option of GeneralName");
        }
        this.roleAuthority = roleAuthority;
        this.roleName = roleName;
    }

    public RoleSyntax(GeneralName roleName) {
        this(null, roleName);
    }

    public RoleSyntax(String roleName) {
        this(new GeneralName(new DERUTF8String(roleName == null ? "" : roleName).getDERObject(), 6));
    }

    public RoleSyntax(ASN1Sequence seq) {
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject taggedObject = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (taggedObject.getTagNo()) {
                case 0: {
                    this.roleAuthority = GeneralNames.getInstance(taggedObject.getObject());
                    break;
                }
                case 1: {
                    this.roleName = GeneralName.getInstance(taggedObject, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag in RoleSyntax");
                }
            }
            ++i;
        }
    }

    public GeneralNames getRoleAuthority() {
        return this.roleAuthority;
    }

    public GeneralName getRoleName() {
        return this.roleName;
    }

    public String getRoleNameAsString() {
        return GeneralName.GeneralNameToString((ASN1TaggedObject)this.roleName.getDERObject());
    }

    public String[] getRoleAuthorityAsString() {
        if (this.roleAuthority == null) {
            return new String[0];
        }
        int count = this.roleAuthority.getNames().length;
        String[] namesString = new String[count];
        int i = 0;
        while (i < count) {
            namesString[i] = this.roleAuthority.getNames()[i].toString();
            ++i;
        }
        return namesString;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.roleAuthority != null) {
            v.add(new DERTaggedObject(true, 0, this.roleAuthority.getDERObject()));
        }
        v.add(new DERTaggedObject(true, 1, this.roleName));
        return new DERSequence(v);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Name: " + this.getRoleNameAsString() + " - Auth: ");
        if (this.roleAuthority == null || this.roleAuthority.getNames().length == 0) {
            buff.append("N/A");
        } else {
            String[] names = this.getRoleAuthorityAsString();
            buff.append("[" + names[0]);
            int i = 1;
            while (i < names.length) {
                buff.append(", " + names[i]);
                ++i;
            }
            buff.append("]");
        }
        return buff.toString();
    }

    public void setRoleAuthority(GeneralNames roleAuthority) {
        this.roleAuthority = roleAuthority;
    }

    public void setRoleName(GeneralName roleName) {
        this.roleName = roleName;
    }

    public RoleSyntax(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,RoleAttribute.RoleAttribute(),RoleAttribute\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("RoleAuthority")) {
                this.roleAuthority = new GeneralNames(cnode);
            }
            if (sname.equals("roleName")) {
                this.roleName = new GeneralName(cnode);
            }
            ++i;
        }
    }
}

