/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREnumerated;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ObjectDigestInfo
implements DEREncodable {
    DEREnumerated digestedObjectType;
    DERObjectIdentifier otherObjectTypeID;
    AlgorithmIdentifier digestAlgorithm;
    DERBitString objectDigest;

    public static ObjectDigestInfo getInstance(Object obj) {
        if (obj == null || obj instanceof ObjectDigestInfo) {
            return (ObjectDigestInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ObjectDigestInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ObjectDigestInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ObjectDigestInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public ObjectDigestInfo(ASN1Sequence seq) {
        this.digestedObjectType = DEREnumerated.getInstance(seq.getObjectAt(0));
        int offset = 0;
        if (seq.size() == 4) {
            this.otherObjectTypeID = DERObjectIdentifier.getInstance(seq.getObjectAt(1));
            ++offset;
        }
        this.digestAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1 + offset));
        this.objectDigest = new DERBitString(seq.getObjectAt(2 + offset));
    }

    public DEREnumerated getDigestedObjectType() {
        return this.digestedObjectType;
    }

    public DERObjectIdentifier getOtherObjectTypeID() {
        return this.otherObjectTypeID;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DERBitString getObjectDigest() {
        return this.objectDigest;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.digestedObjectType);
        if (this.otherObjectTypeID != null) {
            v.add(this.otherObjectTypeID);
        }
        v.add(this.digestAlgorithm);
        v.add(this.objectDigest);
        return new DERSequence(v);
    }

    public ObjectDigestInfo(Node nl) throws PKIException {
        this.otherObjectTypeID = null;
        this.digestAlgorithm = null;
        this.objectDigest = null;
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ObjectDigestInfo.ObjectDigestInfo(),ObjectDigestInfo\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            Object snode;
            Text txt;
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("otherObjectTypeID")) {
                txt = (Text)cnode.getFirstChild();
                snode = txt.getData();
                this.otherObjectTypeID = new DERObjectIdentifier(((String)snode).trim());
            }
            if (sname.equals("digestAlgorithm")) {
                NodeList nodelist1 = cnode.getChildNodes();
                if (nodelist1.getLength() == 0) {
                    throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ObjectDigestInfo.ObjectDigestInfo(),digestAlgorithm\u6ca1\u6709\u5b50\u8282\u70b9");
                }
                snode = null;
                DERObjectIdentifier oid = null;
                String nameoid = null;
                int j = 0;
                while (j < nodelist1.getLength()) {
                    Text txt2;
                    snode = nodelist1.item(j);
                    String snodename = snode.getNodeName();
                    if (snodename.equals("OID")) {
                        txt2 = (Text)snode.getFirstChild();
                        String soid = txt2.getData();
                        oid = new DERObjectIdentifier(soid.trim());
                    }
                    if (snodename.equals("name")) {
                        txt2 = (Text)snode.getFirstChild();
                        String str = txt2.getData();
                        nameoid = str.trim();
                    }
                    ++j;
                }
                byte[] arry = nameoid.getBytes();
                DEROctetString octstr = new DEROctetString(arry);
                this.digestAlgorithm = new AlgorithmIdentifier(oid, octstr);
            }
            if (sname.equals("objectDigest")) {
                txt = (Text)cnode.getFirstChild();
                String sbit = txt.getData();
                byte[] arr = sbit.getBytes();
                this.objectDigest = new DERBitString(arr);
            }
            ++i;
        }
    }
}

