/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.extension.GeneralNamesExt;
import java.math.BigInteger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IssuerSerial
implements DEREncodable {
    GeneralNamesExt issuer;
    DERInteger serial;
    DERBitString issuerUID;

    public IssuerSerial(ASN1Sequence seq) {
        this.issuer = new GeneralNamesExt((DERSequence)seq.getObjectAt(0));
        this.serial = (DERInteger)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.issuerUID = (DERBitString)seq.getObjectAt(2);
        }
    }

    public IssuerSerial(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931IssuerSerial", this.getClass().toString());
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("IssuerSerial")) {
                this.iniByXml(cnode);
            }
            ++i;
        }
    }

    private void iniByXml(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931IssuerSerial\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            Text txt;
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("issuer")) {
                NodeList nodelist1 = cnode.getChildNodes();
                if (nodelist.getLength() == 0) {
                    throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931Issuer\u6ca1\u6709\u5b50\u8282\u70b9");
                }
                Node cnode1 = null;
                this.issuer = new GeneralNamesExt();
                NamedNodeMap attributes = null;
                int j = 0;
                while (j < nodelist1.getLength()) {
                    cnode1 = nodelist1.item(j);
                    String nodename = cnode1.getNodeName();
                    if (nodename.equals("GeneralName")) {
                        attributes = cnode1.getAttributes();
                        String type = attributes.item(0).getNodeValue();
                        try {
                            String sname1;
                            Text txt2;
                            if (type.equals("4")) {
                                txt2 = (Text)cnode1.getFirstChild();
                                sname1 = txt2.getData();
                                this.issuer.addDirectoryName(sname1);
                            }
                            if (type.equals("7")) {
                                txt2 = (Text)cnode1.getFirstChild();
                                sname1 = txt2.getData();
                                this.issuer.addIPAddress(sname1);
                            }
                            if (type.equals("2")) {
                                txt2 = (Text)cnode1.getFirstChild();
                                sname1 = txt2.getData();
                                this.issuer.addDNSName(sname1);
                            }
                            if (type.equals("6")) {
                                txt2 = (Text)cnode1.getFirstChild();
                                sname1 = txt2.getData();
                                this.issuer.addUniformResourceIdentifier(sname1);
                            }
                            if (type.equals("0")) {
                                txt2 = (Text)cnode1.getFirstChild();
                                String srolename = txt2.getData();
                                String sutf8 = srolename.trim();
                                this.issuer.addOtherName_UPN(sutf8);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            throw new PKIException("IllegalArgumentException,IssuerSerial.IssuerSerial()", e);
                        }
                    }
                    ++j;
                }
            }
            if (sname.equals("serial")) {
                try {
                    txt = (Text)cnode.getFirstChild();
                    String sbigint = txt.getData();
                    BigInteger bigint = new BigInteger(sbigint.trim(), 16);
                    this.serial = new DERInteger(bigint);
                }
                catch (NumberFormatException e) {
                    throw new PKIException("NumberFormatException,IssuerSerial.IssuerSerial()", e);
                }
            }
            if (sname.equals("issuerUID")) {
                txt = (Text)cnode.getFirstChild();
                String sbit = txt.getData();
                String strim = sbit.trim();
                byte[] arr = strim.getBytes();
                this.issuerUID = new DERBitString(arr);
            }
            ++i;
        }
    }

    public static IssuerSerial getInstance(ASN1TaggedObject obj, boolean explicit) {
        return IssuerSerial.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static IssuerSerial getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (IssuerSerial)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuerSerial((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public GeneralNamesExt getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer.getASN1Object());
        v.add(this.serial);
        if (this.issuerUID != null) {
            v.add(this.issuerUID);
        }
        return new DERSequence(v);
    }
}

