/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.encoders.Hex;
import java.util.Enumeration;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IetfAttrSyntax
implements DEREncodable {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    DEREncodableVector values = new DEREncodableVector();
    int valueChoice = -1;

    public IetfAttrSyntax() {
    }

    public IetfAttrSyntax(ASN1Sequence seq) {
        int i = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance(seq.getObjectAt(0).getDERObject());
            ++i;
        } else if (seq.size() == 2) {
            this.policyAuthority = GeneralNames.getInstance(seq.getObjectAt(0));
            ++i;
        }
        if (!(seq.getObjectAt(i) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        seq = (ASN1Sequence)seq.getObjectAt(i);
        this.iniValues(seq);
    }

    private void iniValues(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            DERObject obj = (DERObject)e.nextElement();
            this.addValue(obj);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public Object[] getValues() {
        if (this.getValueType() == 1) {
            Object[] tmp = new ASN1OctetString[this.values.size()];
            int i = 0;
            while (i != tmp.length) {
                tmp[i] = (ASN1OctetString)this.values.get(i);
                ++i;
            }
            return tmp;
        }
        if (this.getValueType() == 2) {
            Object[] tmp = new DERObjectIdentifier[this.values.size()];
            int i = 0;
            while (i != tmp.length) {
                tmp[i] = (DERObjectIdentifier)this.values.get(i);
                ++i;
            }
            return tmp;
        }
        Object[] tmp = new DERUTF8String[this.values.size()];
        int i = 0;
        while (i != tmp.length) {
            tmp[i] = (DERUTF8String)this.values.get(i);
            ++i;
        }
        return tmp;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            v.add(new DERTaggedObject(0, this.policyAuthority.getDERObject()));
        }
        v.add(new DERSequence(this.values));
        return new DERSequence(v);
    }

    public IetfAttrSyntax(GeneralNames policyAuthority, ASN1Sequence values) {
        this.policyAuthority = policyAuthority;
        this.iniValues(values);
    }

    public IetfAttrSyntax(GeneralNames policyAuthority, ASN1EncodableVector values) {
        this.policyAuthority = policyAuthority;
        this.values = values;
    }

    public void setPolicyAuthority(GeneralNames policyAuthority) {
        this.policyAuthority = policyAuthority;
    }

    public void setValues(DEREncodableVector values) {
        this.values = values;
    }

    public void addValue(DERObject obj) {
        int type;
        if (obj instanceof DERObjectIdentifier) {
            type = 2;
        } else if (obj instanceof DERUTF8String) {
            type = 3;
        } else if (obj instanceof DEROctetString) {
            type = 1;
        } else {
            throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
        }
        if (this.valueChoice < 0) {
            this.valueChoice = type;
        }
        if (type != this.valueChoice) {
            throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
        }
        this.values.add(obj);
    }

    public void addUTF8String(String str) {
        if (this.valueChoice < 0) {
            this.valueChoice = 3;
        }
        if (this.valueChoice != 3) {
            throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
        }
        this.values.add(new DERUTF8String(str));
    }

    public void addOIDString(String str) {
        if (this.valueChoice < 0) {
            this.valueChoice = 2;
        }
        if (this.valueChoice != 2) {
            throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
        }
        this.values.add(new DERObjectIdentifier(str));
    }

    public void addOctectString(byte[] octect) {
        if (this.valueChoice < 0) {
            this.valueChoice = 1;
        }
        if (this.valueChoice != 1) {
            throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
        }
        this.values.add(new DEROctetString(octect));
    }

    public void addOctectString(String octectstr) {
        if (this.valueChoice < 0) {
            this.valueChoice = 1;
        }
        if (this.valueChoice != 1) {
            throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
        }
        this.values.add(new DEROctetString(Hex.decode(octectstr)));
    }

    public IetfAttrSyntax(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,IetfAttrSyntax.IetfAttrSyntax(),GroupAttribute\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("PolicyAuthority")) {
                this.policyAuthority = new GeneralNames(cnode);
            }
            if (sname.equals("IetfValue")) {
                this.valueChoice = this.generalIetfValue(cnode, this.values);
            }
            ++i;
        }
    }

    public int generalIetfValue(Node nl, DEREncodableVector values) throws PKIException {
        String svalue;
        Text txt;
        String sname;
        int i;
        int choice = -1;
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,IetfAttrSyntax.generalIetfValue(),IetfValue\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        NamedNodeMap attributes = nl.getAttributes();
        String type = attributes.item(0).getNodeValue();
        if (type.equals("1")) {
            choice = 1;
        }
        if (type.equals("2")) {
            choice = 2;
        }
        if (type.equals("3")) {
            choice = 3;
        }
        if (choice == 1) {
            DEROctetString oct = null;
            i = 0;
            while (i < nodelist.getLength()) {
                cnode = nodelist.item(i);
                sname = cnode.getNodeName();
                if (sname.equals("value")) {
                    txt = (Text)cnode.getFirstChild();
                    svalue = txt.getData();
                    String strim = svalue.trim();
                    byte[] arr = strim.getBytes();
                    oct = new DEROctetString(arr);
                    values.add(oct);
                }
                ++i;
            }
        }
        if (choice == 2) {
            DERObjectIdentifier oid = null;
            i = 0;
            while (i < nodelist.getLength()) {
                cnode = nodelist.item(i);
                sname = cnode.getNodeName();
                if (sname.equals("value")) {
                    txt = (Text)cnode.getFirstChild();
                    svalue = txt.getData();
                    oid = new DERObjectIdentifier(svalue.trim());
                    values.add(oid);
                }
                ++i;
            }
        }
        if (choice == 3) {
            DERUTF8String utf8 = null;
            i = 0;
            while (i < nodelist.getLength()) {
                cnode = nodelist.item(i);
                sname = cnode.getNodeName();
                if (sname.equals("value")) {
                    txt = (Text)cnode.getFirstChild();
                    svalue = txt.getData();
                    utf8 = new DERUTF8String(svalue.trim());
                    values.add(utf8);
                }
                ++i;
            }
        }
        return choice;
    }
}

