/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.IssuerSerial;
import cn.com.jit.ida.util.pki.asn1.x509.ObjectDigestInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Holder
implements DEREncodable {
    IssuerSerial baseCertificateID;
    GeneralNames entityName;
    ObjectDigestInfo objectDigestInfo;

    public static Holder getInstance(Object obj) {
        if (obj instanceof Holder) {
            return (Holder)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Holder((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public Holder() {
    }

    public Holder(Node node) throws PKIException {
        NodeList nodelist = node.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931", "Holder\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("BasecertificateID")) {
                this.baseCertificateID = new IssuerSerial(cnode);
            }
            if (sname.equals("EntityName")) {
                this.entityName = new GeneralNames(cnode);
            }
            if (sname.equals("Objectdigestinfo")) {
                this.objectDigestInfo = new ObjectDigestInfo(cnode);
            }
            ++i;
        }
    }

    public Holder(ASN1Sequence seq) {
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (tObj.getTagNo()) {
                case 0: {
                    this.baseCertificateID = IssuerSerial.getInstance(tObj, false);
                    break;
                }
                case 1: {
                    this.entityName = GeneralNames.getInstance(tObj.getObject());
                    break;
                }
                case 2: {
                    this.objectDigestInfo = ObjectDigestInfo.getInstance(tObj, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in Holder");
                }
            }
            ++i;
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.baseCertificateID != null) {
            v.add(new DERTaggedObject(false, 0, this.baseCertificateID));
        }
        if (this.entityName != null) {
            v.add(new DERTaggedObject(true, 1, this.entityName.getDERObject()));
        }
        if (this.objectDigestInfo != null) {
            v.add(new DERTaggedObject(false, 2, this.objectDigestInfo));
        }
        return new DERSequence(v);
    }

    public static Holder getInstance(String holder) throws PKIException {
        DEREncodableVector ve = new DEREncodableVector();
        X509Name name = new X509Name(holder);
        GeneralName gn = new GeneralName(name);
        ve.add(gn.getDERObject());
        DERSequence seq = new DERSequence(ve);
        DERTaggedObject entityName = new DERTaggedObject(true, 1, seq);
        DERSequence holderseq = new DERSequence(entityName.getDERObject());
        return new Holder(holderseq);
    }

    public String toString() {
        if (this.entityName != null) {
            String[] a = this.toStringArr();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(a[i]);
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public String[] toStringArr() {
        if (this.entityName == null) {
            return null;
        }
        String[] names = new String[this.entityName.getNames().length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.entityName.getNames()[i].toString();
            ++i;
        }
        return names;
    }

    public GeneralNames getEntityName() {
        return this.entityName;
    }

    public void setEntityName(GeneralNames entityName) {
        this.entityName = entityName;
    }
}

