/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBMPString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERPrintableString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERT61String;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.DERUniversalString;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.OtherName;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.encoders.Hex;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeneralNames
implements DEREncodable {
    DEREncodableVector seq = new DEREncodableVector();
    boolean isInsideImplicit = false;
    public static final int TYPE_NONE = -1;
    public static final int RFC822NAME = 1;
    public static final int DNSNAME = 2;
    public static final int X400ADDRESS = 3;
    public static final int DIRECTORYNAME = 4;
    public static final int EDIPARTYNAME = 5;
    public static final int UNIFORMRESOURCEIDENTIFIER = 6;
    public static final int IPADDRESS = 7;
    public static final int REGISTEREDID = 8;
    public static final int OTHERNAME_UPN = 100;
    public static final String OTHER_NAME_UPN_OID = "1.3.6.1.4.1.311.20.2.3";
    public static final int OTHERNAME_GUID = 101;
    public static final String OTHER_NAME_GUID_OID = "1.23.456.789";
    public static final int EDIPARTYNAME_TELETEXSTRING = 200;
    public static final int EDIPARTYNAME_PRINTABLESTRING = 201;
    public static final int EDIPARTYNAME_UNIVERSALSTRING = 202;
    public static final int EDIPARTYNAME_UTF8STRING = 203;
    public static final int EDIPARTYNAME_BMPSTRING = 204;

    public GeneralNames() {
    }

    public GeneralNames(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,GeneralNames.GeneralNames(Node node)");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Node cnode = nodelist.item(i);
            String nodename = cnode.getNodeName();
            if (nodename.equals("GeneralName")) {
                cnode = nodelist.item(i);
                GeneralName gname = new GeneralName(cnode);
                this.seq.add(gname.getDERObject());
            }
            ++i;
        }
    }

    public static GeneralNames getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public GeneralNames(ASN1Sequence seq) {
        this.seq = new DEREncodableVector(seq);
    }

    public void markInsideImplicit(boolean isInsideImplicit) {
        this.isInsideImplicit = isInsideImplicit;
    }

    public DERObject getDERObject() {
        return new DERSequence(this.seq);
    }

    public GeneralName[] getNames() {
        GeneralName[] names = new GeneralName[this.seq.size()];
        int i = 0;
        while (i != this.seq.size()) {
            names[i] = GeneralName.getInstance(this.seq.get(i));
            ++i;
        }
        return names;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.seq != null) {
            GeneralName[] names = this.getNames();
            int i = 0;
            while (i < names.length) {
                GeneralName name = names[i];
                if (buffer != null && buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(GeneralName.GeneralNameToString((DERTaggedObject)name.getDERObject()));
                ++i;
            }
        }
        return buffer.toString();
    }

    public void addRFC822Name(String value) throws PKIException {
        this.addGeneralName(1, value);
    }

    public void addDNSName(String value) throws PKIException {
        this.addGeneralName(2, value);
    }

    public void addDirectoryName(String value) throws PKIException {
        this.addGeneralName(4, value);
    }

    public void addUniformResourceIdentifier(String value) throws PKIException {
        this.addGeneralName(6, value);
    }

    public void addIPAddress(String value) throws PKIException {
        this.addGeneralName(7, value);
    }

    public void addRegisteredID(String value) throws PKIException {
        this.addGeneralName(8, value);
    }

    public void addOtherName_UPN(String value) throws PKIException {
        this.addGeneralName(100, value);
    }

    public void addOtherName_GUID(String value) throws PKIException {
        this.addGeneralName(101, value);
    }

    public void addEDIPartyName(int partyNameType, String partyName, int nameAssignerType, String nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.seq.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, byte[] partyName, int nameAssignerType, byte[] nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.seq.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, String partyName, int nameAssignerType, byte[] nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.seq.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addEDIPartyName(int partyNameType, byte[] partyName, int nameAssignerType, String nameAssigner) throws PKIException {
        if (partyName == null) {
            throw new PKIException("8183", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        DEREncodableVector v = new DEREncodableVector();
        if (nameAssigner != null) {
            v.add(new DERTaggedObject(0, this.TypeToDEREncodable(nameAssignerType, nameAssigner)));
        }
        v.add(new DERTaggedObject(1, this.TypeToDEREncodable(partyNameType, partyName)));
        this.seq.add(new GeneralName(new DERSequence(v), 5));
    }

    public void addGeneralName(int dataType, String value) throws PKIException {
        if (this.seq == null) {
            this.seq = new ASN1EncodableVector();
        }
        if (dataType == 100 || dataType == 101) {
            this.seq.add(new GeneralName(this.TypeConversion(dataType, value), 0));
        } else {
            this.seq.add(new GeneralName(this.TypeConversion(dataType, value), dataType));
        }
    }

    private DEREncodable TypeToDEREncodable(int valueType, String value) throws PKIException {
        DERObject derencodable = null;
        switch (valueType) {
            case 200: {
                derencodable = new DERT61String(value);
                break;
            }
            case 201: {
                derencodable = new DERPrintableString(value);
                break;
            }
            case 203: {
                derencodable = new DERUTF8String(value);
                break;
            }
            case 204: {
                derencodable = new DERBMPString(value);
                break;
            }
            case 202: {
                throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
        }
        return derencodable;
    }

    private DEREncodable TypeToDEREncodable(int valueType, byte[] value) throws PKIException {
        DERObject derencodable = null;
        switch (valueType) {
            case 200: {
                derencodable = new DERT61String(value);
                break;
            }
            case 201: {
                derencodable = new DERPrintableString(value);
                break;
            }
            case 203: {
                derencodable = new DERUTF8String(new String(value));
                break;
            }
            case 204: {
                derencodable = new DERBMPString(value);
                break;
            }
            case 202: {
                derencodable = new DERUniversalString(value);
            }
        }
        return derencodable;
    }

    private DERObject TypeConversion(int valueType, String value) throws PKIException {
        DERObject derencodable = null;
        try {
            derencodable = null;
            switch (valueType) {
                case 1: 
                case 2: 
                case 6: {
                    derencodable = new DERIA5String(value).getDERObject();
                    break;
                }
                case 7: {
                    derencodable = new DEROctetString(this.IP4Address(value)).getDERObject();
                    break;
                }
                case 3: {
                    throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
                }
                case 4: {
                    derencodable = new X509Name(value).getDERObject();
                    break;
                }
                case 8: {
                    derencodable = new DERObjectIdentifier(value).getDERObject();
                    break;
                }
                case 100: {
                    derencodable = new OtherName(new DERObjectIdentifier(OTHER_NAME_UPN_OID), new DERTaggedObject(true, 0, new DERUTF8String(value))).getDERObject();
                    break;
                }
                case 101: {
                    derencodable = new OtherName(new DERObjectIdentifier(OTHER_NAME_GUID_OID), new DERTaggedObject(true, 0, new DEROctetString(Hex.decode(value)))).getDERObject();
                }
            }
            if (derencodable == null) {
                throw new PKIException("8184", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
            }
        }
        catch (Exception ex) {
            throw new PKIException("8185", "GeneralNames\u7f16\u7801\u65f6\u51fa\u9519", ex);
        }
        return derencodable;
    }

    private byte[] IP4Address(String value) {
        String[] allip = value.split("/");
        byte[] ip4_byte = null;
        if (allip.length == 2) {
            ip4_byte = new byte[8];
            this.GenIP4Address(ip4_byte, allip[0]);
            byte[] ip4_mask = new byte[4];
            this.GenIP4Address(ip4_mask, allip[1]);
            System.arraycopy(ip4_mask, 0, ip4_byte, 4, 4);
        } else if (allip.length == 1) {
            ip4_byte = new byte[4];
            this.GenIP4Address(ip4_byte, value);
        }
        return ip4_byte;
    }

    private void GenIP4Address(byte[] ip4_byte, String value) {
        int pos = 0;
        int i = 0;
        while (i < 4) {
            pos = value.indexOf(".");
            ip4_byte[i] = pos == -1 ? Integer.valueOf(value).byteValue() : Integer.valueOf(value.substring(0, pos)).byteValue();
            value = value.substring(pos + 1, value.length());
            ++i;
        }
    }
}

