/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERIA5String;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERUTF8String;
import cn.com.jit.ida.util.pki.asn1.x509.OtherName;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import cn.com.jit.ida.util.pki.encoders.Hex;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GeneralName
implements DEREncodable {
    public static final String OTHER_NAME_UPN_OID = "1.3.6.1.4.1.311.20.2.3";
    public static final int uniformResourceIdentifier = 6;
    DEREncodable obj;
    int tag;
    boolean isInsideImplicit = false;

    public GeneralName(X509Name directoryName) {
        this.obj = directoryName;
        this.tag = 4;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 5: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(tagObj, false), tag);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(tagObj, false), tag);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, explicit));
    }

    public void markInsideImplicit(boolean isInsideImplicit) {
        this.isInsideImplicit = isInsideImplicit;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public String toString() {
        return GeneralName.GeneralNameToString((DERTaggedObject)this.getDERObject());
    }

    public static String GeneralNameToString(ASN1TaggedObject tempGeneralName) {
        String retString = null;
        switch (tempGeneralName.getTagNo()) {
            case 0: {
                if (OTHER_NAME_UPN_OID.equals(OtherName.getInstance(tempGeneralName.getObject()).getTypeID().getId()) || "1.2.156.1995.1999.2".equals(OtherName.getInstance(tempGeneralName.getObject()).getTypeID().getId())) {
                    retString = ((DERUTF8String)OtherName.getInstance(tempGeneralName.getObject()).getValue()).getString();
                    break;
                }
                retString = new String(Hex.encode(((DEROctetString)OtherName.getInstance(tempGeneralName.getObject()).getValue().getDERObject()).getOctets()));
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                retString = DERIA5String.getInstance(tempGeneralName.getObject()).getString();
                break;
            }
            case 7: {
                StringBuffer tempSB = new StringBuffer();
                byte[] tempByte = ((DEROctetString)tempGeneralName.getObject()).getOctets();
                int tempInt = 0;
                int i = 0;
                while (i < 4) {
                    tempInt = tempByte[i];
                    if (tempInt < 0) {
                        tempInt += 256;
                    }
                    tempSB.append(String.valueOf(tempInt));
                    if (i < 3) {
                        tempSB.append(".");
                    }
                    ++i;
                }
                if (tempByte.length > 4) {
                    tempSB.append("/");
                    i = 4;
                    while (i < tempByte.length) {
                        tempInt = tempByte[i];
                        if (tempInt < 0) {
                            tempInt += 256;
                        }
                        tempSB.append(String.valueOf(tempInt));
                        if (i < tempByte.length - 1) {
                            tempSB.append(".");
                        }
                        ++i;
                    }
                }
                retString = tempSB.toString();
                break;
            }
            case 8: {
                retString = DERObjectIdentifier.getInstance(tempGeneralName.getObject()).getId();
                break;
            }
            case 4: {
                retString = X509Name.getInstance(tempGeneralName.getObject()).toString();
            }
        }
        return retString;
    }

    public DERObject getDERObject() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }

    public GeneralName(Node cnode) throws PKIException {
        NamedNodeMap attributes = cnode.getAttributes();
        String type = attributes.item(0).getNodeValue();
        try {
            DERIA5String ia5;
            String sname;
            Text txt;
            if (type.equals("4")) {
                txt = (Text)cnode.getFirstChild();
                sname = txt.getData();
                X509Name xname = new X509Name(sname);
                this.obj = xname.getDERObject();
                this.tag = 4;
            }
            if (type.equals("7")) {
                txt = (Text)cnode.getFirstChild();
                sname = txt.getData();
                DEROctetString octet = new DEROctetString(sname.getBytes());
                this.obj = octet.getDERObject();
                this.tag = 7;
            }
            if (type.equals("6")) {
                txt = (Text)cnode.getFirstChild();
                sname = txt.getData();
                ia5 = new DERIA5String(sname);
                this.obj = ia5.getDERObject();
                this.tag = 6;
            }
            if (type.equals("2")) {
                txt = (Text)cnode.getFirstChild();
                sname = txt.getData();
                ia5 = new DERIA5String(sname);
                this.obj = ia5.getDERObject();
                this.tag = 2;
            }
            if (type.equals("0")) {
                txt = (Text)cnode.getFirstChild();
                String srolename = txt.getData();
                String sutf8 = srolename.trim();
                this.obj = new OtherName(new DERObjectIdentifier(OTHER_NAME_UPN_OID), new DERTaggedObject(true, 0, new DERUTF8String(sutf8))).getDERObject();
                this.tag = 0;
            }
        }
        catch (Exception e) {
            throw new PKIException("GeneralName\u6784\u9020\u51fd\u6570\u9519\u8bef", e);
        }
    }
}

