/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.x509.SecurityCategories;
import cn.com.jit.ida.util.pki.asn1.x509.SecurityCategory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClearanceSyntax
implements DEREncodable {
    private DERObjectIdentifier policyID;
    private DERBitString classlist;
    private SecurityCategories seccat;

    public ClearanceSyntax() {
        this.seccat = new SecurityCategories();
    }

    public ClearanceSyntax(ASN1Sequence seq) {
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject taggedObject = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (taggedObject.getTagNo()) {
                case 0: {
                    this.policyID = DERObjectIdentifier.getInstance(taggedObject, true);
                    break;
                }
                case 1: {
                    this.classlist = DERBitString.getInstance(taggedObject, true);
                    break;
                }
                case 2: {
                    this.seccat = SecurityCategories.getInstance(taggedObject, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag in RoleSyntax");
                }
            }
            ++i;
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERTaggedObject(true, 0, this.policyID));
        v.add(new DERTaggedObject(true, 1, this.classlist));
        v.add(new DERTaggedObject(true, 2, this.seccat.getDERObject()));
        return new DERSequence(v);
    }

    public ClearanceSyntax(DERObjectIdentifier policyID, DERBitString classlist, SecurityCategories seccat) {
        this.policyID = policyID;
        this.classlist = classlist;
        this.seccat = seccat;
    }

    public DERBitString getClasslist() {
        return this.classlist;
    }

    public void setClasslist(DERBitString classlist) {
        this.classlist = classlist;
    }

    public DERObjectIdentifier getPolicyID() {
        return this.policyID;
    }

    public void setPolicyID(DERObjectIdentifier policyID) {
        this.policyID = policyID;
    }

    public SecurityCategories getSeccat() {
        return this.seccat;
    }

    public void setSeccat(SecurityCategories seccat) {
        this.seccat = seccat;
    }

    public SecurityCategory createSecurityCategory() {
        SecurityCategory category = this.seccat.creatSecurityCategory();
        return category;
    }

    public void addSecurityCategory(SecurityCategory sec) {
        this.seccat.addSecurityCategory(sec);
    }

    public ClearanceSyntax(Node nl) throws PKIException {
        this.policyID = null;
        this.classlist = null;
        this.seccat = null;
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ClearanceSyntax.ClearanceSyntax(),ClearanceAttribute\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            Text txt;
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("PolicyId")) {
                txt = (Text)cnode.getFirstChild();
                String policyid = txt.getData();
                this.policyID = new DERObjectIdentifier(policyid.trim());
            }
            if (sname.equals("ClassList")) {
                txt = (Text)cnode.getFirstChild();
                String str = txt.getData();
                int intstr1 = Integer.parseInt(str.trim());
                int intstr = 2 ^ intstr1;
                StringBuffer stringbuffer = new StringBuffer(Integer.toBinaryString(intstr));
                stringbuffer.reverse();
                this.classlist = new DERBitString(stringbuffer.toString().getBytes());
            }
            if (sname.equals("SecurityCategories")) {
                this.seccat = new SecurityCategories(cnode);
            }
            ++i;
        }
    }
}

