/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.x509.Time;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;

public class CRLEntry
implements DEREncodable {
    ASN1Sequence seq;
    DERInteger userCertificate;
    Time revocationDate;
    X509Extensions crlEntryExtensions;

    public CRLEntry(ASN1Sequence seq) {
        this.seq = seq;
        this.userCertificate = (DERInteger)seq.getObjectAt(0);
        this.revocationDate = Time.getInstance(seq.getObjectAt(1));
        if (seq.size() == 3) {
            this.crlEntryExtensions = X509Extensions.getInstance(seq.getObjectAt(2));
        }
    }

    public DERInteger getUserCertificate() {
        return this.userCertificate;
    }

    public Time getRevocationDate() {
        return this.revocationDate;
    }

    public X509Extensions getExtensions() {
        return this.crlEntryExtensions;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

